/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.duckdb.model.data;

import java.sql.Struct;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCompositeMap;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCStructValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.BeanUtils;

public class DuckDBStructValueHandler
extends JDBCStructValueHandler {
    public static final DuckDBStructValueHandler INSTANCE = new DuckDBStructValueHandler();
    private static final Log log = Log.getLog(DuckDBStructValueHandler.class);

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object instanceof Struct) {
            try {
                Map<String, Object> map = this.getMap(object);
                return new JDBCCompositeMap(session, null, map);
            }
            catch (DBCException e) {
                log.warn((Object)e);
            }
        } else {
            log.warn((Object)("Incorrect use of handler: " + ((Object)((Object)this)).getClass().getSimpleName()));
        }
        return super.getValueFromObject(session, type, object, copy, validateValue);
    }

    private Map<String, Object> getMap(@NotNull Object object) throws DBCException {
        try {
            return (Map)BeanUtils.invokeObjectDeclaredMethod((Object)object, (String)"getMap", (Class[])new Class[0], (Object[])new Object[0]);
        }
        catch (Throwable e) {
            throw new DBCException("Can't get structure as map", e);
        }
    }
}

