/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.filter;

import aQute.bnd.exceptions.Exceptions;
import aQute.lib.filter.Get;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;

public class Filter {
    static final MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
    static final MethodType stringConstructor = MethodType.methodType(Void.TYPE, String.class);
    static final String GARBAGE = "Trailing garbage";
    static final String MALFORMED = "Malformed query";
    static final String EMPTY = "Empty list";
    static final String SUBEXPR = "No subexpression";
    static final String OPERATOR = "Undefined operator";
    static final String TRUNCATED = "Truncated expression";
    static final String EQUALITY = "Only equality supported";
    static final char WILDCARD = '\uffff';
    static final int EQ = 0;
    static final int LE = 1;
    static final int GE = 2;
    static final int NEQ = 100;
    static final int LT = 101;
    static final int GT = 102;
    static final int APPROX = 3;
    final String filter;
    final boolean extended;
    final Node node;
    final Exception parseException;
    private String tail;

    void error(String m) throws IllegalArgumentException {
        throw new IllegalArgumentException(m + " " + this.tail);
    }

    boolean compare(Object obj, int op, String s) {
        if (obj == null) {
            return false;
        }
        if (op == 0 && s.length() == 1 && s.charAt(0) == '\uffff') {
            return true;
        }
        try {
            Class<?> numClass = obj.getClass();
            if (numClass == String.class) {
                return this.compareString((String)obj, op, s);
            }
            if (numClass == Character.class) {
                return this.compareString(obj.toString(), op, s);
            }
            if (numClass == Long.class) {
                return this.compareSign(op, Long.valueOf(s).compareTo((Long)obj));
            }
            if (numClass == Integer.class) {
                return this.compareSign(op, Integer.valueOf(s).compareTo((Integer)obj));
            }
            if (numClass == Short.class) {
                return this.compareSign(op, Short.valueOf(s).compareTo((Short)obj));
            }
            if (numClass == Byte.class) {
                return this.compareSign(op, Byte.valueOf(s).compareTo((Byte)obj));
            }
            if (numClass == Double.class) {
                return this.compareSign(op, Double.valueOf(s).compareTo((Double)obj));
            }
            if (numClass == Float.class) {
                return this.compareSign(op, Float.valueOf(s).compareTo((Float)obj));
            }
            if (numClass == Boolean.class) {
                switch (op) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        return (Boolean)obj == Boolean.parseBoolean(s);
                    }
                    case 100: {
                        return (Boolean)obj != Boolean.parseBoolean(s);
                    }
                }
                return false;
            }
            if (numClass == BigInteger.class) {
                return this.compareSign(op, new BigInteger(s).compareTo((BigInteger)obj));
            }
            if (numClass == BigDecimal.class) {
                return this.compareSign(op, new BigDecimal(s).compareTo((BigDecimal)obj));
            }
            if (obj instanceof Collection) {
                for (Object x : (Collection)obj) {
                    if (!this.compare(x, op, s)) continue;
                    return true;
                }
                return false;
            }
            if (numClass.isArray()) {
                int len = Array.getLength(obj);
                for (int i = 0; i < len; ++i) {
                    if (!this.compare(Array.get(obj, i), op, s)) continue;
                    return true;
                }
                return false;
            }
            if (obj instanceof Comparable) {
                Object source = Filter.valueOf(numClass, s);
                Comparable a = (Comparable)source;
                return this.compareSign(op, a.compareTo(obj));
            }
            Object source = Filter.valueOf(numClass, s);
            switch (op) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    return source.equals(obj);
                }
                case 100: {
                    return !source.equals(obj);
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static Object valueOf(Class<?> numClass, String s) throws Exception {
        MethodHandle mh;
        try {
            mh = publicLookup.findStatic(numClass, "valueOf", MethodType.methodType(numClass, String.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            mh = publicLookup.findConstructor(numClass, stringConstructor);
        }
        try {
            return mh.invoke(s);
        }
        catch (Throwable e) {
            throw Exceptions.duck(e);
        }
    }

    public Filter(String filter, boolean extended) throws IllegalArgumentException {
        this.filter = filter;
        this.extended = extended;
        this.tail = filter;
        if (filter == null || filter.length() == 0) {
            throw new IllegalArgumentException("Null query");
        }
        Node node = null;
        Exception parseException = null;
        try {
            node = new Query().doQuery();
            if (this.tail.length() > 0) {
                this.error(GARBAGE);
            }
        }
        catch (Exception e) {
            parseException = e;
        }
        this.node = node;
        this.parseException = parseException;
    }

    public Filter(String filter) throws IllegalArgumentException {
        this(filter, false);
    }

    public boolean match(Dictionary<?, ?> dict) throws Exception {
        try {
            if (this.parseException != null) {
                throw this.parseException;
            }
            return this.node.match(new DictQuery(dict));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean matchMap(Map<?, ?> dict) throws Exception {
        try {
            if (this.parseException != null) {
                throw this.parseException;
            }
            return this.node.match(new MapQuery(dict));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean match(Get get) throws Exception {
        try {
            if (this.parseException != null) {
                throw this.parseException;
            }
            return this.node.match(new GetQuery(get));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public String verify() throws Exception {
        if (this.parseException != null) {
            return this.parseException.getMessage();
        }
        return null;
    }

    public String toString() {
        return this.filter;
    }

    public boolean equals(Object obj) {
        return obj instanceof Filter && this.filter.equals(((Filter)obj).filter);
    }

    public int hashCode() {
        return this.filter.hashCode();
    }

    boolean compareString(String s1, int op, String s2) {
        switch (op) {
            case 0: {
                return this.patSubstr(s1, s2);
            }
            case 3: {
                return this.fixupString(s2).equals(this.fixupString(s1));
            }
        }
        return this.compareSign(op, s2.compareTo(s1));
    }

    boolean compareSign(int op, int cmp) {
        switch (op) {
            case 1: {
                return cmp >= 0;
            }
            case 2: {
                return cmp <= 0;
            }
            case 0: {
                return cmp == 0;
            }
            case 100: {
                return cmp != 0;
            }
            case 101: {
                return cmp > 0;
            }
            case 102: {
                return cmp < 0;
            }
        }
        return cmp == 0;
    }

    String fixupString(String s) {
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        boolean isStart = true;
        boolean isWhite = false;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) {
                isWhite = true;
                continue;
            }
            if (!isStart && isWhite) {
                sb.append(' ');
            }
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            }
            sb.append(c);
            isStart = false;
            isWhite = false;
        }
        return sb.toString();
    }

    boolean patSubstr(String s, String pat) {
        if (s == null) {
            return false;
        }
        if (pat.length() == 0) {
            return s.length() == 0;
        }
        if (pat.charAt(0) == '\uffff') {
            pat = pat.substring(1);
            while (true) {
                if (this.patSubstr(s, pat)) {
                    return true;
                }
                if (s.length() == 0) {
                    return false;
                }
                s = s.substring(1);
            }
        }
        if (s.length() == 0 || s.charAt(0) != pat.charAt(0)) {
            return false;
        }
        return this.patSubstr(s.substring(1), pat.substring(1));
    }

    class Query {
        Query() {
        }

        private Node doQuery() throws Exception {
            Node val;
            if (Filter.this.tail.length() < 3 || !this.prefix("(")) {
                Filter.this.error(Filter.MALFORMED);
            }
            switch (Filter.this.tail.charAt(0)) {
                case '&': {
                    val = this.doAnd();
                    break;
                }
                case '|': {
                    val = this.doOr();
                    break;
                }
                case '!': {
                    val = this.doNot();
                    break;
                }
                default: {
                    val = this.doSimple();
                }
            }
            if (!this.prefix(")")) {
                Filter.this.error(Filter.MALFORMED);
            }
            return val;
        }

        private Node doAnd() throws Exception {
            Filter.this.tail = this.skip(1);
            boolean val = true;
            if (!Filter.this.tail.startsWith("(")) {
                Filter.this.error(Filter.EMPTY);
            }
            And and = new And();
            do {
                and.children.add(this.doQuery());
            } while (Filter.this.tail.startsWith("("));
            return and;
        }

        String skip(int skip) {
            String a = Filter.this.tail;
            do {
                a = a.substring(skip);
                skip = 1;
            } while (a.length() > 0 && Character.isWhitespace(a.charAt(0)));
            return a;
        }

        private Node doOr() throws Exception {
            Filter.this.tail = this.skip(1);
            boolean val = false;
            if (!Filter.this.tail.startsWith("(")) {
                Filter.this.error(Filter.EMPTY);
            }
            Or or = new Or();
            do {
                or.children.add(this.doQuery());
            } while (Filter.this.tail.startsWith("("));
            return or;
        }

        private Node doNot() throws Exception {
            Filter.this.tail = this.skip(1);
            if (!Filter.this.tail.startsWith("(")) {
                Filter.this.error(Filter.SUBEXPR);
            }
            return new Not(this.doQuery());
        }

        Node doSimple() throws Exception {
            int op = 0;
            String key = this.getKey();
            if (this.prefix("=")) {
                op = 0;
            } else if (this.prefix("<=")) {
                op = 1;
            } else if (this.prefix(">=")) {
                op = 2;
            } else if (this.prefix("~=")) {
                op = 3;
            } else if (Filter.this.extended && this.prefix("!=")) {
                op = 100;
            } else if (Filter.this.extended && this.prefix(">")) {
                op = 102;
            } else if (Filter.this.extended && this.prefix("<")) {
                op = 101;
            } else {
                Filter.this.error(Filter.OPERATOR);
            }
            return new Simple(key, op, this.getValue());
        }

        boolean prefix(String pre) {
            if (!Filter.this.tail.startsWith(pre)) {
                return false;
            }
            Filter.this.tail = this.skip(pre.length());
            return true;
        }

        String getKey() throws Exception {
            int ix;
            int len = Filter.this.tail.length();
            block4: for (ix = 0; ix < len; ++ix) {
                switch (Filter.this.tail.charAt(ix)) {
                    case '(': 
                    case ')': 
                    case '*': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '\\': 
                    case '~': {
                        break block4;
                    }
                    case '!': {
                        if (Filter.this.extended) break block4;
                    }
                    default: {
                        continue block4;
                    }
                }
            }
            String attr = Filter.this.tail.substring(0, ix);
            Filter.this.tail = Filter.this.tail.substring(ix);
            return attr;
        }

        private String getValue() {
            int ix;
            StringBuilder sb = new StringBuilder();
            int len = Filter.this.tail.length();
            block5: for (ix = 0; ix < len; ++ix) {
                char c = Filter.this.tail.charAt(ix);
                switch (c) {
                    case '(': 
                    case ')': {
                        break block5;
                    }
                    case '*': {
                        sb.append('\uffff');
                        continue block5;
                    }
                    case '\\': {
                        if (ix == len - 1) break block5;
                        sb.append(Filter.this.tail.charAt(++ix));
                        continue block5;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            Filter.this.tail = Filter.this.tail.substring(ix);
            return sb.toString();
        }
    }

    abstract class Node {
        Node() {
        }

        public abstract boolean match(Arguments var1) throws Exception;
    }

    class DictQuery
    implements Arguments {
        private Dictionary<?, ?> dict;

        DictQuery(Dictionary<?, ?> dict) {
            this.dict = dict;
        }

        @Override
        public Object getProp(String key) {
            return this.dict.get(key);
        }
    }

    static interface Arguments {
        public Object getProp(String var1) throws Exception;
    }

    class MapQuery
    implements Arguments {
        private Map<?, ?> map;

        MapQuery(Map<?, ?> dict) {
            this.map = dict;
        }

        @Override
        public Object getProp(String key) {
            return this.map.get(key);
        }
    }

    class GetQuery
    implements Arguments {
        private Get get;

        GetQuery(Get get) {
            this.get = get;
        }

        @Override
        public Object getProp(String key) throws Exception {
            return this.get.get(key);
        }
    }

    class And
    extends Node {
        final List<Node> children = new ArrayList<Node>();

        And() {
        }

        @Override
        public boolean match(Arguments arguments) throws Exception {
            for (Node node : this.children) {
                if (node.match(arguments)) continue;
                return false;
            }
            return true;
        }
    }

    class Or
    extends Node {
        final List<Node> children = new ArrayList<Node>();

        Or() {
        }

        @Override
        public boolean match(Arguments arguments) throws Exception {
            for (Node node : this.children) {
                if (!node.match(arguments)) continue;
                return true;
            }
            return false;
        }
    }

    class Not
    extends Node {
        final Node target;

        public Not(Node target) {
            this.target = target;
        }

        @Override
        public boolean match(Arguments arguments) throws Exception {
            return !this.target.match(arguments);
        }
    }

    class Simple
    extends Node {
        final String key;
        final int op;
        final String value;

        public Simple(String key, int op, String value) {
            this.key = key;
            this.op = op;
            this.value = value;
        }

        @Override
        public boolean match(Arguments arguments) throws Exception {
            Object attr = arguments.getProp(this.key);
            return Filter.this.compare(attr, this.op, this.value);
        }
    }
}

