/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.items;

import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.items.GenericItem;
import org.openhab.core.library.types.DateTimeType;
import org.openhab.core.types.Command;
import org.openhab.core.types.RefreshType;
import org.openhab.core.types.State;
import org.openhab.core.types.TimeSeries;
import org.openhab.core.types.UnDefType;

@NonNullByDefault
public class DateTimeItem
extends GenericItem {
    private static final List<Class<? extends State>> ACCEPTED_DATA_TYPES = List.of(DateTimeType.class, UnDefType.class);
    private static final List<Class<? extends Command>> ACCEPTED_COMMAND_TYPES = List.of(DateTimeType.class, RefreshType.class);

    public DateTimeItem(String name) {
        super("DateTime", name);
    }

    @Override
    public List<Class<? extends State>> getAcceptedDataTypes() {
        return ACCEPTED_DATA_TYPES;
    }

    @Override
    public List<Class<? extends Command>> getAcceptedCommandTypes() {
        return ACCEPTED_COMMAND_TYPES;
    }

    public void send(DateTimeType command) {
        this.internalSend(command, null);
    }

    public void send(DateTimeType command, @Nullable String source) {
        this.internalSend(command, source);
    }

    @Override
    public void setState(State state, @Nullable String source) {
        if (this.isAcceptedState(ACCEPTED_DATA_TYPES, state)) {
            DateTimeType convertedState = state.as(DateTimeType.class);
            if (convertedState != null) {
                this.applyState(convertedState, source);
            } else {
                this.applyState(state, source);
            }
        } else {
            this.logSetTypeError(state);
        }
    }

    @Override
    public void setTimeSeries(TimeSeries timeSeries) {
        if (timeSeries.getStates().allMatch(s -> s.state() instanceof DateTimeType)) {
            this.applyTimeSeries(timeSeries);
        } else {
            this.logSetTypeError(timeSeries);
        }
    }
}

