/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackInitialization;
import org.jivesoftware.smack.util.FileUtils;

public class Smack {
    private static final Logger LOGGER = Logger.getLogger(Smack.class.getName());
    private static final String SMACK_ORG = "org.jivesoftware";
    public static final String SMACK_PACKAGE = "org.jivesoftware.smack";
    public static final URL BUG_REPORT_URL;
    private static final String NOTICE_RESOURCE = "org.jivesoftware.smack/NOTICE";

    public static String getVersion() {
        return SmackInitialization.SMACK_VERSION;
    }

    public static InputStream getNoticeStream() {
        InputStream res = FileUtils.getInputStreamForClasspathFile(NOTICE_RESOURCE);
        assert (res != null);
        return res;
    }

    public static void ensureInitialized() {
        if (SmackConfiguration.isSmackInitialized()) {
            return;
        }
        String version = Smack.getVersion();
        LOGGER.finest("Smack " + version + " has been initialized");
    }

    static {
        try {
            BUG_REPORT_URL = URI.create("https://discourse.igniterealtime.org/c/smack/smack-support/9").toURL();
        }
        catch (MalformedURLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

