/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.BindRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.OperationResultAccessLogMessage;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class BindResultAccessLogMessage
extends BindRequestAccessLogMessage
implements OperationResultAccessLogMessage {
    private static final long serialVersionUID = -5612410738721878134L;
    @Nullable
    private final Boolean retiredPasswordUsed;
    @Nullable
    private final Boolean uncachedDataAccessed;
    @Nullable
    private final Double processingTime;
    @Nullable
    private final Double queueTime;
    @NotNull
    private final List<String> missingPrivileges;
    @NotNull
    private final List<String> preAuthZUsedPrivileges;
    @NotNull
    private final List<String> referralURLs;
    @NotNull
    private final List<String> responseControlOIDs;
    @NotNull
    private final List<String> serversAccessed;
    @NotNull
    private final List<String> usedPrivileges;
    @Nullable
    private final Long authFailureID;
    @Nullable
    private final Long intermediateResponsesReturned;
    @Nullable
    private final ResultCode resultCode;
    @Nullable
    private final String additionalInformation;
    @Nullable
    private final String authDN;
    @Nullable
    private final String authFailureReason;
    @Nullable
    private final String authzDN;
    @Nullable
    private final String clientConnectionPolicy;
    @Nullable
    private final String diagnosticMessage = this.getNamedValue("message");
    @Nullable
    private final String intermediateClientResult;
    @Nullable
    private final String matchedDN;
    @Nullable
    private final Integer targetPort;
    @Nullable
    private final String targetHost;
    @Nullable
    private final String targetProtocol;

    public BindResultAccessLogMessage(@NotNull String s) throws LogException {
        this(new LogMessage(s));
    }

    public BindResultAccessLogMessage(@NotNull LogMessage m) {
        super(m);
        this.additionalInformation = this.getNamedValue("additionalInfo");
        this.matchedDN = this.getNamedValue("matchedDN");
        this.processingTime = this.getNamedValueAsDouble("etime");
        this.queueTime = this.getNamedValueAsDouble("qtime");
        this.intermediateClientResult = this.getNamedValue("from");
        this.authDN = this.getNamedValue("authDN");
        this.authzDN = this.getNamedValue("authzDN");
        this.authFailureID = this.getNamedValueAsLong("authFailureID");
        this.authFailureReason = this.getNamedValue("authFailureReason");
        this.targetHost = this.getNamedValue("targetHost");
        this.targetPort = this.getNamedValueAsInteger("targetPort");
        this.targetProtocol = this.getNamedValue("targetProtocol");
        this.clientConnectionPolicy = this.getNamedValue("clientConnectionPolicy");
        this.intermediateResponsesReturned = this.getNamedValueAsLong("intermediateResponsesReturned");
        Integer rcInteger = this.getNamedValueAsInteger("resultCode");
        this.resultCode = rcInteger == null ? null : ResultCode.valueOf(rcInteger);
        String refStr = this.getNamedValue("referralURLs");
        if (refStr == null || refStr.isEmpty()) {
            this.referralURLs = Collections.emptyList();
        } else {
            LinkedList<String> refs = new LinkedList<String>();
            int startPos = 0;
            while (true) {
                int commaPos;
                if ((commaPos = refStr.indexOf(",ldap", startPos)) < 0) break;
                refs.add(refStr.substring(startPos, commaPos));
                startPos = commaPos + 1;
            }
            refs.add(refStr.substring(startPos));
            this.referralURLs = Collections.unmodifiableList(refs);
        }
        String controlStr = this.getNamedValue("responseControls");
        if (controlStr == null) {
            this.responseControlOIDs = Collections.emptyList();
        } else {
            LinkedList<String> controlList = new LinkedList<String>();
            StringTokenizer t = new StringTokenizer(controlStr, ",");
            while (t.hasMoreTokens()) {
                controlList.add(t.nextToken());
            }
            this.responseControlOIDs = Collections.unmodifiableList(controlList);
        }
        String serversAccessedStr = this.getNamedValue("serversAccessed");
        if (serversAccessedStr == null || serversAccessedStr.isEmpty()) {
            this.serversAccessed = Collections.emptyList();
        } else {
            LinkedList<String> servers = new LinkedList<String>();
            StringTokenizer tokenizer = new StringTokenizer(serversAccessedStr, ",");
            while (tokenizer.hasMoreTokens()) {
                servers.add(tokenizer.nextToken());
            }
            this.serversAccessed = Collections.unmodifiableList(servers);
        }
        this.uncachedDataAccessed = this.getNamedValueAsBoolean("uncachedDataAccessed");
        this.retiredPasswordUsed = this.getNamedValueAsBoolean("retiredPasswordUsed");
        String usedPrivilegesStr = this.getNamedValue("usedPrivileges");
        if (usedPrivilegesStr == null || usedPrivilegesStr.isEmpty()) {
            this.usedPrivileges = Collections.emptyList();
        } else {
            LinkedList<String> privileges = new LinkedList<String>();
            StringTokenizer tokenizer = new StringTokenizer(usedPrivilegesStr, ",");
            while (tokenizer.hasMoreTokens()) {
                privileges.add(tokenizer.nextToken());
            }
            this.usedPrivileges = Collections.unmodifiableList(privileges);
        }
        String preAuthZUsedPrivilegesStr = this.getNamedValue("preAuthZUsedPrivileges");
        if (preAuthZUsedPrivilegesStr == null || preAuthZUsedPrivilegesStr.isEmpty()) {
            this.preAuthZUsedPrivileges = Collections.emptyList();
        } else {
            LinkedList<String> privileges = new LinkedList<String>();
            StringTokenizer tokenizer = new StringTokenizer(preAuthZUsedPrivilegesStr, ",");
            while (tokenizer.hasMoreTokens()) {
                privileges.add(tokenizer.nextToken());
            }
            this.preAuthZUsedPrivileges = Collections.unmodifiableList(privileges);
        }
        String missingPrivilegesStr = this.getNamedValue("missingPrivileges");
        if (missingPrivilegesStr == null || missingPrivilegesStr.isEmpty()) {
            this.missingPrivileges = Collections.emptyList();
        } else {
            LinkedList<String> privileges = new LinkedList<String>();
            StringTokenizer tokenizer = new StringTokenizer(missingPrivilegesStr, ",");
            while (tokenizer.hasMoreTokens()) {
                privileges.add(tokenizer.nextToken());
            }
            this.missingPrivileges = Collections.unmodifiableList(privileges);
        }
    }

    @Override
    @Nullable
    public ResultCode getResultCode() {
        return this.resultCode;
    }

    @Override
    @Nullable
    public String getDiagnosticMessage() {
        return this.diagnosticMessage;
    }

    @Override
    @Nullable
    public String getAdditionalInformation() {
        return this.additionalInformation;
    }

    @Override
    @Nullable
    public String getMatchedDN() {
        return this.matchedDN;
    }

    @Override
    @NotNull
    public List<String> getReferralURLs() {
        return this.referralURLs;
    }

    @Override
    @Nullable
    public Long getIntermediateResponsesReturned() {
        return this.intermediateResponsesReturned;
    }

    @Override
    @Nullable
    public Double getProcessingTimeMillis() {
        return this.processingTime;
    }

    @Override
    @Nullable
    public Double getQueueTimeMillis() {
        return this.queueTime;
    }

    @Override
    @NotNull
    public List<String> getResponseControlOIDs() {
        return this.responseControlOIDs;
    }

    @Override
    @NotNull
    public List<String> getServersAccessed() {
        return this.serversAccessed;
    }

    @Nullable
    public Boolean getUncachedDataAccessed() {
        return this.uncachedDataAccessed;
    }

    @Override
    @Nullable
    public String getIntermediateClientResult() {
        return this.intermediateClientResult;
    }

    @Nullable
    public String getAuthenticationDN() {
        return this.authDN;
    }

    @Nullable
    public String getAuthorizationDN() {
        return this.authzDN;
    }

    @Nullable
    public Long getAuthenticationFailureID() {
        return this.authFailureID;
    }

    @Nullable
    public String getAuthenticationFailureReason() {
        return this.authFailureReason;
    }

    @Nullable
    public Boolean getRetiredPasswordUsed() {
        return this.retiredPasswordUsed;
    }

    @Nullable
    public String getTargetHost() {
        return this.targetHost;
    }

    @Nullable
    public Integer getTargetPort() {
        return this.targetPort;
    }

    @Nullable
    public String getTargetProtocol() {
        return this.targetProtocol;
    }

    @Nullable
    public String getClientConnectionPolicy() {
        return this.clientConnectionPolicy;
    }

    @NotNull
    public List<String> getUsedPrivileges() {
        return this.usedPrivileges;
    }

    @NotNull
    public List<String> getPreAuthorizationUsedPrivileges() {
        return this.preAuthZUsedPrivileges;
    }

    @NotNull
    public List<String> getMissingPrivileges() {
        return this.missingPrivileges;
    }

    @Override
    @NotNull
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.RESULT;
    }
}

