/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum GetConfigurationType {
    ACTIVE(-128, 0),
    BASELINE(-127, 1),
    ARCHIVED(-126, 2);

    static final byte ACTIVE_BER_TYPE = -128;
    static final byte BASELINE_BER_TYPE = -127;
    static final byte ARCHIVED_BER_TYPE = -126;
    private final byte berType;
    private final int intValue;

    private GetConfigurationType(byte berType, int intValue) {
        this.berType = berType;
        this.intValue = intValue;
    }

    public byte getBERType() {
        return this.berType;
    }

    public int getIntValue() {
        return this.intValue;
    }

    @Nullable
    public static GetConfigurationType forBERType(byte berType) {
        for (GetConfigurationType t : GetConfigurationType.values()) {
            if (t.berType != berType) continue;
            return t;
        }
        return null;
    }

    @Nullable
    public static GetConfigurationType forIntValue(int intValue) {
        for (GetConfigurationType t : GetConfigurationType.values()) {
            if (t.intValue != intValue) continue;
            return t;
        }
        return null;
    }

    @Nullable
    public static GetConfigurationType forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "active": {
                return ACTIVE;
            }
            case "baseline": {
                return BASELINE;
            }
            case "archived": {
                return ARCHIVED;
            }
        }
        return null;
    }
}

