/*******************************************************************************************************
 DkFakeMiniaturesDialog.h
 Created on:	29.04.2013

 nomacs is a fast and small image viewer with the capability of synchronizing multiple instances

 Copyright (C) 2011-2012 Markus Diem <markus@nomacs.org>
 Copyright (C) 2011-2012 Stefan Fiel <stefan@nomacs.org>
 Copyright (C) 2011-2012 Florian Kleber <florian@nomacs.org>

 This file is part of nomacs.

 nomacs is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 nomacs is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.

 *******************************************************************************************************/

#pragma once

#include <QDialog>
#include <QLabel>
#include <QWidget>

#ifdef WITH_OPENCV
#include "opencv2/core/core.hpp"
#include "opencv2/imgproc/imgproc.hpp"
#endif

class QSpinBox;
class QSlider;

namespace nmp
{

class DkPreviewLabel;
class DkKernelSize;
class DkSaturation;

class DkFakeMiniaturesDialog : public QDialog
{
    Q_OBJECT

public:
    explicit DkFakeMiniaturesDialog(QWidget *parent = nullptr, Qt::WindowFlags flags = Qt::WindowFlags());
    ~DkFakeMiniaturesDialog() override;
    bool wasOkPressed()
    {
        return isOk;
    };
    void setImage(const QImage *img);
    void setImagePreview(QImage img)
    {
        imgPreview = img;
    };
    QImage getImage();
    QImage applyMiniaturesFilter(QImage inImg, QRect qRoi);
    QImage getScaledImg()
    {
        return scaledImg;
    };
    void drawImgPreview();

public slots:
    void redrawImgPreview();

protected slots:
    void okPressed();
    void cancelPressed();

protected:
    bool isOk;
    const QImage *mImg;
    QImage imgPreview;
    int dialogWidth;
    int dialogHeight;
    QRect previewImgRect;
    DkPreviewLabel *previewLabel;
    QImage scaledImg;
    float rMin;
    DkKernelSize *kernelSizeWidget;
    DkSaturation *saturationWidget;

    int previewWidth;
    int previewHeight;
    int toolsWidth;
    int previewMargin;

    void init();
    void createLayout();
    void showEvent(QShowEvent *event) override;
    void createImgPreview();

#ifdef WITH_OPENCV
    cv::Mat blurPanTilt(cv::Mat src, cv::Mat depthImg, int maxKernel);
#endif
};

class DkPreviewLabel : public QLabel
{
    Q_OBJECT

public:
    explicit DkPreviewLabel(DkFakeMiniaturesDialog *parentDialog, QWidget *parent = nullptr);
    ~DkPreviewLabel() override;
    void setImgRect(QRect rect);
    QRect getROI()
    {
        return selectionRect;
    };

protected:
    void paintEvent(QPaintEvent *e) override;
    void mousePressEvent(QMouseEvent *e) override;
    void mouseMoveEvent(QMouseEvent *e) override;
    void mouseReleaseEvent(QMouseEvent *e) override;
    void enterEvent(QEnterEvent *e) override;
    void leaveEvent(QEvent *e) override;

private:
    bool selectionStarted;
    bool showROI;
    QRect selectionRect;
    QRect previewImgRect;
    DkFakeMiniaturesDialog *fmDialog;
};

class DkFakeMiniaturesToolWidget : public QWidget
{
    Q_OBJECT

public:
    DkFakeMiniaturesToolWidget(QWidget *parent, DkFakeMiniaturesDialog *parentDialog);
    ~DkFakeMiniaturesToolWidget() override;

    void setToolValue(int val);
    int getToolValue();

    int getDefaultValue()
    {
        return defaultValue;
    };

protected:
    QSpinBox *sliderSpinBox;
    QSlider *slider;
    QLabel *sliderTitle;
    QLabel *minValLabel;
    QLabel *maxValLabel;
    QLabel *middleValLabel;
    int leftSpacing;
    int topSpacing;
    int sliderLength;
    int margin;
    int minVal;
    int maxVal;
    int middleVal;
    bool valueUpdated;
    QString name;
    int defaultValue;

protected slots:

    void updateSliderSpinBox(int val);
    void updateSliderVal(int val);

signals:
    void redrawImgPreview();
};

class DkKernelSize : public DkFakeMiniaturesToolWidget
{
    Q_OBJECT

public:
    DkKernelSize(QWidget *parent, DkFakeMiniaturesDialog *parentDialog);
    ~DkKernelSize() override;
};

class DkSaturation : public DkFakeMiniaturesToolWidget
{
    Q_OBJECT

public:
    DkSaturation(QWidget *parent, DkFakeMiniaturesDialog *parentDialog);
    ~DkSaturation() override;
};

};
