# Docker Engine's use of iptables

> [!WARNING]
> This is intended for development use - the structure of docker's iptables
> (and ip6tables) rules will change between releases, it is not a stable
> interface.

> [!NOTE]
> This document is generated by `TestBridgeIptablesDoc` by running a
> daemon, creating networks and containers, and capturing iptables.
> The iptables are then merged with a text/template for each section.
> The resulting document is diffed against one in the repo, so the
> test will fail if there are differences in the generated rules (but
> changes in the templates may go unnoticed).
>
> Links to code are permalinks - they will be out of date, and may not
> point to the master branch. But, it's difficult to work out where
> some of the rules come from, the links are intended as hints.

ip6tables rules follow the same pattern as iptables rules. So, only the
IPv4 rules are shown here.

The bridge driver deletes its custom chains during its initialisation, in
[configure][100]. Rules are then re-created as networks are restored. However,
the filter-FORWARD chain is not cleared. The order in which networks are
re-created is not the order in which they were originally created. So,
rules may be arranged differently following a daemon restart.

When firewalld is running, if it's reloaded, iptables rules are cleared.
The daemon registers handlers for its reload event (received via dbus)
to reconstruct the rules.

The filter-INPUT chain is not used by Docker. Packets arriving from the host's
physical network or the host itself hit the filter-FORWARD chain, as they are
routed into the bridge network. Similarly, filter-OUTPUT is not used.

[100]: https://github.com/moby/moby/blob/fe09cab7fe04c3911417061f7c7ef60a8acc6bf3/libnetwork/drivers/bridge/bridge_linux.go#L508

Scenarios:

  - [New daemon](generated/new-daemon.md)
  - [Container on a user-defined network, with a published port](generated/usernet-portmap.md)
  - [Container on a user-defined network, with a port published on a loopback address](generated/usernet-portmap-lo.md)
  - [Container on a user-defined network, with a published port, no userland proxy](generated/usernet-portmap-noproxy.md)
  - [Container on a user-defined network with inter-container communication disabled, with a published port](generated/usernet-portmap-noicc.md)
  - [Container on a user-defined --internal network](generated/usernet-internal.md)
  - [Container on a routed-mode network, with a published port](generated/usernet-portmap-routed.md)
  - [Container on a nat-unprotected network, with a published port](generated/usernet-portmap-natunprot.md)
  - [Swarm service, with a published port](generated/swarm-portmap.md)
