/*
Copyright 2023 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package wholepkg

import (
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/apimachinery/pkg/runtime/schema"
)

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StructEverything) DeepCopyInto(out *StructEverything) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	if in.BoolPtrField != nil {
		in, out := &in.BoolPtrField, &out.BoolPtrField
		*out = new(bool)
		**out = **in
	}
	if in.IntPtrField != nil {
		in, out := &in.IntPtrField, &out.IntPtrField
		*out = new(int)
		**out = **in
	}
	if in.StringPtrField != nil {
		in, out := &in.StringPtrField, &out.StringPtrField
		*out = new(string)
		**out = **in
	}
	if in.FloatPtrField != nil {
		in, out := &in.FloatPtrField, &out.FloatPtrField
		*out = new(float64)
		**out = **in
	}
	in.PointerStructField.DeepCopyInto(&out.PointerStructField)
	if in.SliceBoolField != nil {
		in, out := &in.SliceBoolField, &out.SliceBoolField
		*out = make([]bool, len(*in))
		copy(*out, *in)
	}
	if in.SliceByteField != nil {
		in, out := &in.SliceByteField, &out.SliceByteField
		*out = make([]byte, len(*in))
		copy(*out, *in)
	}
	if in.SliceIntField != nil {
		in, out := &in.SliceIntField, &out.SliceIntField
		*out = make([]int, len(*in))
		copy(*out, *in)
	}
	if in.SliceStringField != nil {
		in, out := &in.SliceStringField, &out.SliceStringField
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.SliceFloatField != nil {
		in, out := &in.SliceFloatField, &out.SliceFloatField
		*out = make([]float64, len(*in))
		copy(*out, *in)
	}
	in.SlicesStructField.DeepCopyInto(&out.SlicesStructField)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StructEverything.
func (in *StructEverything) DeepCopy() *StructEverything {
	if in == nil {
		return nil
	}
	out := new(StructEverything)
	in.DeepCopyInto(out)
	return out
}

func (in *StructEverything) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StructPointer) DeepCopyInto(out *StructPointer) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.PointerStructPrimitivesField.DeepCopyInto(&out.PointerStructPrimitivesField)
	if in.PointerPointerStructPrimitivesField != nil {
		in, out := &in.PointerPointerStructPrimitivesField, &out.PointerPointerStructPrimitivesField
		*out = new(StructPrimitives)
		(*in).DeepCopyInto(*out)
	}
	in.PointerStructPrimitivesAliasField.DeepCopyInto(&out.PointerStructPrimitivesAliasField)
	in.PointerPointerStructPrimitivesAliasField.DeepCopyInto(&out.PointerPointerStructPrimitivesAliasField)
	in.PointerStructStructPrimitives.DeepCopyInto(&out.PointerStructStructPrimitives)
	if in.PointerPointerStructStructPrimitives != nil {
		in, out := &in.PointerPointerStructStructPrimitives, &out.PointerPointerStructStructPrimitives
		*out = new(StructStructPrimitives)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StructPointer.
func (in *StructPointer) DeepCopy() *StructPointer {
	if in == nil {
		return nil
	}
	out := new(StructPointer)
	in.DeepCopyInto(out)
	return out
}

func (in *StructPointer) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StructPrimitives) DeepCopyInto(out *StructPrimitives) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	if in.BoolField != nil {
		in, out := &in.BoolField, &out.BoolField
		*out = new(bool)
		**out = **in
	}
	if in.IntField != nil {
		in, out := &in.IntField, &out.IntField
		*out = new(int)
		**out = **in
	}
	if in.StringField != nil {
		in, out := &in.StringField, &out.StringField
		*out = new(string)
		**out = **in
	}
	if in.FloatField != nil {
		in, out := &in.FloatField, &out.FloatField
		*out = new(float64)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StructPrimitives.
func (in *StructPrimitives) DeepCopy() *StructPrimitives {
	if in == nil {
		return nil
	}
	out := new(StructPrimitives)
	in.DeepCopyInto(out)
	return out
}

func (in *StructPrimitives) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StructPrimitivesAlias) DeepCopyInto(out *StructPrimitivesAlias) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	if in.BoolField != nil {
		in, out := &in.BoolField, &out.BoolField
		*out = new(bool)
		**out = **in
	}
	if in.IntField != nil {
		in, out := &in.IntField, &out.IntField
		*out = new(int)
		**out = **in
	}
	if in.StringField != nil {
		in, out := &in.StringField, &out.StringField
		*out = new(string)
		**out = **in
	}
	if in.FloatField != nil {
		in, out := &in.FloatField, &out.FloatField
		*out = new(float64)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StructPrimitivesAlias.
func (in *StructPrimitivesAlias) DeepCopy() *StructPrimitivesAlias {
	if in == nil {
		return nil
	}
	out := new(StructPrimitivesAlias)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StructSlices) DeepCopyInto(out *StructSlices) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	if in.SliceStructPrimitivesField != nil {
		in, out := &in.SliceStructPrimitivesField, &out.SliceStructPrimitivesField
		*out = make([]StructPrimitives, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.SlicePointerStructPrimitivesField != nil {
		in, out := &in.SlicePointerStructPrimitivesField, &out.SlicePointerStructPrimitivesField
		*out = make([]*StructPrimitives, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(StructPrimitives)
				(*in).DeepCopyInto(*out)
			}
		}
	}
	if in.SliceStructPrimitivesAliasField != nil {
		in, out := &in.SliceStructPrimitivesAliasField, &out.SliceStructPrimitivesAliasField
		*out = make([]StructPrimitivesAlias, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.SlicePointerStructPrimitivesAliasField != nil {
		in, out := &in.SlicePointerStructPrimitivesAliasField, &out.SlicePointerStructPrimitivesAliasField
		*out = make([]*StructPrimitivesAlias, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(StructPrimitivesAlias)
				(*in).DeepCopyInto(*out)
			}
		}
	}
	if in.SliceStructStructPrimitives != nil {
		in, out := &in.SliceStructStructPrimitives, &out.SliceStructStructPrimitives
		*out = make([]StructStructPrimitives, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.SlicePointerStructStructPrimitives != nil {
		in, out := &in.SlicePointerStructStructPrimitives, &out.SlicePointerStructStructPrimitives
		*out = make([]*StructStructPrimitives, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(StructStructPrimitives)
				(*in).DeepCopyInto(*out)
			}
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StructSlices.
func (in *StructSlices) DeepCopy() *StructSlices {
	if in == nil {
		return nil
	}
	out := new(StructSlices)
	in.DeepCopyInto(out)
	return out
}

func (in *StructSlices) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StructStructPrimitives) DeepCopyInto(out *StructStructPrimitives) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.StructField.DeepCopyInto(&out.StructField)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StructStructPrimitives.
func (in *StructStructPrimitives) DeepCopy() *StructStructPrimitives {
	if in == nil {
		return nil
	}
	out := new(StructStructPrimitives)
	in.DeepCopyInto(out)
	return out
}

func (in *StructStructPrimitives) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

func (in *StructEverything) GetObjectKind() schema.ObjectKind       { return schema.EmptyObjectKind }
func (in *StructPointer) GetObjectKind() schema.ObjectKind          { return schema.EmptyObjectKind }
func (in *StructPrimitives) GetObjectKind() schema.ObjectKind       { return schema.EmptyObjectKind }
func (in *StructSlices) GetObjectKind() schema.ObjectKind           { return schema.EmptyObjectKind }
func (in *StructStructPrimitives) GetObjectKind() schema.ObjectKind { return schema.EmptyObjectKind }
