//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uisearchsuggestion?language=objc)
    pub unsafe trait UISearchSuggestion: NSObjectProtocol + MainThreadOnly {
        /// The localized suggestion that will be displayed as the search string
        #[unsafe(method(localizedSuggestion))]
        #[unsafe(method_family = none)]
        fn localizedSuggestion(&self) -> Option<Retained<NSString>>;

        /// The localized description used as accessibility string
        #[optional]
        #[unsafe(method(localizedDescription))]
        #[unsafe(method_family = none)]
        fn localizedDescription(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "UIImage")]
        /// Icon that represents this search suggestion item
        #[optional]
        #[unsafe(method(iconImage))]
        #[unsafe(method_family = none)]
        fn iconImage(&self) -> Option<Retained<UIImage>>;

        /// If non-null, will be displayed as the search string instead of localizedSuggestion
        #[unsafe(method(localizedAttributedSuggestion))]
        #[unsafe(method_family = none)]
        fn localizedAttributedSuggestion(&self) -> Option<Retained<NSAttributedString>>;

        /// User information
        #[unsafe(method(representedObject))]
        #[unsafe(method_family = none)]
        fn representedObject(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`representedObject`][Self::representedObject].
        ///
        /// # Safety
        ///
        /// `represented_object` should be of the correct type.
        #[unsafe(method(setRepresentedObject:))]
        #[unsafe(method_family = none)]
        unsafe fn setRepresentedObject(&self, represented_object: Option<&AnyObject>);
    }
);

extern_class!(
    /// A concrete container for search suggestion string and optional image and associated information for providing shortcuts in search experience on tvOS.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uisearchsuggestionitem?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UISearchSuggestionItem;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UISearchSuggestionItem {}
);

extern_conformance!(
    unsafe impl UISearchSuggestion for UISearchSuggestionItem {}
);

impl UISearchSuggestionItem {
    extern_methods!(
        /// Returns a new search suggestion object with a specified suggestion string.
        #[unsafe(method(suggestionWithLocalizedSuggestion:))]
        #[unsafe(method_family = none)]
        pub fn suggestionWithLocalizedSuggestion(
            suggestion: &NSString,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        /// Returns a new search suggestion object with a specified suggestion string and a description string.
        #[unsafe(method(suggestionWithLocalizedSuggestion:descriptionString:))]
        #[unsafe(method_family = none)]
        pub fn suggestionWithLocalizedSuggestion_descriptionString(
            suggestion: &NSString,
            description: Option<&NSString>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[cfg(feature = "UIImage")]
        /// Returns a new search suggestion object with a specified suggestion string, description string, and a search icon image.
        #[unsafe(method(suggestionWithLocalizedSuggestion:descriptionString:iconImage:))]
        #[unsafe(method_family = none)]
        pub fn suggestionWithLocalizedSuggestion_descriptionString_iconImage(
            suggestion: &NSString,
            description: Option<&NSString>,
            icon_image: Option<&UIImage>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        /// Factory methods taking NSAttributedString instead of NSString for the suggestion
        #[unsafe(method(suggestionWithLocalizedAttributedSuggestion:))]
        #[unsafe(method_family = none)]
        pub fn suggestionWithLocalizedAttributedSuggestion(
            suggestion: &NSAttributedString,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[unsafe(method(suggestionWithLocalizedAttributedSuggestion:descriptionString:))]
        #[unsafe(method_family = none)]
        pub fn suggestionWithLocalizedAttributedSuggestion_descriptionString(
            suggestion: &NSAttributedString,
            description: Option<&NSString>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[cfg(feature = "UIImage")]
        #[unsafe(method(suggestionWithLocalizedAttributedSuggestion:descriptionString:iconImage:))]
        #[unsafe(method_family = none)]
        pub fn suggestionWithLocalizedAttributedSuggestion_descriptionString_iconImage(
            suggestion: &NSAttributedString,
            description: Option<&NSString>,
            icon_image: Option<&UIImage>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        /// Initializes a search suggestion object with a specified search suggestion string.
        #[unsafe(method(initWithLocalizedSuggestion:))]
        #[unsafe(method_family = init)]
        pub fn initWithLocalizedSuggestion(
            this: Allocated<Self>,
            suggestion: &NSString,
        ) -> Retained<Self>;

        /// Initializes a search suggestion object with a specified search suggestion string and a description string.
        #[unsafe(method(initWithLocalizedSuggestion:localizedDescription:))]
        #[unsafe(method_family = init)]
        pub fn initWithLocalizedSuggestion_localizedDescription(
            this: Allocated<Self>,
            suggestion: &NSString,
            description: Option<&NSString>,
        ) -> Retained<Self>;

        #[cfg(feature = "UIImage")]
        /// Initializes a search suggestion object with a specified search suggestion string, a description string, and a search icon image.
        #[unsafe(method(initWithLocalizedSuggestion:localizedDescription:iconImage:))]
        #[unsafe(method_family = init)]
        pub fn initWithLocalizedSuggestion_localizedDescription_iconImage(
            this: Allocated<Self>,
            suggestion: &NSString,
            description: Option<&NSString>,
            icon_image: Option<&UIImage>,
        ) -> Retained<Self>;

        /// Initializers taking NSAttributedString instead of NSString for the suggestion
        #[unsafe(method(initWithLocalizedAttributedSuggestion:))]
        #[unsafe(method_family = init)]
        pub fn initWithLocalizedAttributedSuggestion(
            this: Allocated<Self>,
            suggestion: &NSAttributedString,
        ) -> Retained<Self>;

        #[unsafe(method(initWithLocalizedAttributedSuggestion:localizedDescription:))]
        #[unsafe(method_family = init)]
        pub fn initWithLocalizedAttributedSuggestion_localizedDescription(
            this: Allocated<Self>,
            suggestion: &NSAttributedString,
            description: Option<&NSString>,
        ) -> Retained<Self>;

        #[cfg(feature = "UIImage")]
        #[unsafe(method(initWithLocalizedAttributedSuggestion:localizedDescription:iconImage:))]
        #[unsafe(method_family = init)]
        pub fn initWithLocalizedAttributedSuggestion_localizedDescription_iconImage(
            this: Allocated<Self>,
            suggestion: &NSAttributedString,
            description: Option<&NSString>,
            icon_image: Option<&UIImage>,
        ) -> Retained<Self>;

        /// If non-null, will be displayed as the search string instead of localizedSuggestion
        #[unsafe(method(localizedAttributedSuggestion))]
        #[unsafe(method_family = none)]
        pub fn localizedAttributedSuggestion(&self) -> Option<Retained<NSAttributedString>>;

        /// The localized suggestion that will be displayed as the search string
        #[unsafe(method(localizedSuggestion))]
        #[unsafe(method_family = none)]
        pub fn localizedSuggestion(&self) -> Option<Retained<NSString>>;

        /// The localized description used as accessibility string
        #[unsafe(method(localizedDescription))]
        #[unsafe(method_family = none)]
        pub fn localizedDescription(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "UIImage")]
        /// Icon that represents this search suggestion item
        #[unsafe(method(iconImage))]
        #[unsafe(method_family = none)]
        pub fn iconImage(&self) -> Option<Retained<UIImage>>;

        /// User information
        #[unsafe(method(representedObject))]
        #[unsafe(method_family = none)]
        pub fn representedObject(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`representedObject`][Self::representedObject].
        ///
        /// # Safety
        ///
        /// `represented_object` should be of the correct type.
        #[unsafe(method(setRepresentedObject:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRepresentedObject(&self, represented_object: Option<&AnyObject>);
    );
}

/// Methods declared on superclass `NSObject`.
impl UISearchSuggestionItem {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
