//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nstextcheckingtype?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTextCheckingType(pub u64);
bitflags::bitflags! {
    impl NSTextCheckingType: u64 {
        #[doc(alias = "NSTextCheckingTypeOrthography")]
        const Orthography = 1<<0;
        #[doc(alias = "NSTextCheckingTypeSpelling")]
        const Spelling = 1<<1;
        #[doc(alias = "NSTextCheckingTypeGrammar")]
        const Grammar = 1<<2;
        #[doc(alias = "NSTextCheckingTypeDate")]
        const Date = 1<<3;
        #[doc(alias = "NSTextCheckingTypeAddress")]
        const Address = 1<<4;
        #[doc(alias = "NSTextCheckingTypeLink")]
        const Link = 1<<5;
        #[doc(alias = "NSTextCheckingTypeQuote")]
        const Quote = 1<<6;
        #[doc(alias = "NSTextCheckingTypeDash")]
        const Dash = 1<<7;
        #[doc(alias = "NSTextCheckingTypeReplacement")]
        const Replacement = 1<<8;
        #[doc(alias = "NSTextCheckingTypeCorrection")]
        const Correction = 1<<9;
        #[doc(alias = "NSTextCheckingTypeRegularExpression")]
        const RegularExpression = 1<<10;
        #[doc(alias = "NSTextCheckingTypePhoneNumber")]
        const PhoneNumber = 1<<11;
        #[doc(alias = "NSTextCheckingTypeTransitInformation")]
        const TransitInformation = 1<<12;
    }
}

unsafe impl Encode for NSTextCheckingType {
    const ENCODING: Encoding = u64::ENCODING;
}

unsafe impl RefEncode for NSTextCheckingType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nstextcheckingtypes?language=objc)
pub type NSTextCheckingTypes = u64;

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nstextcheckingallsystemtypes?language=objc)
pub const NSTextCheckingAllSystemTypes: NSTextCheckingTypes = 0xffffffff;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nstextcheckingallcustomtypes?language=objc)
pub const NSTextCheckingAllCustomTypes: NSTextCheckingTypes = 0xffffffff << 32;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nstextcheckingalltypes?language=objc)
pub const NSTextCheckingAllTypes: NSTextCheckingTypes =
    NSTextCheckingAllSystemTypes | NSTextCheckingAllCustomTypes;

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nstextcheckingkey?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
#[cfg(feature = "NSString")]
pub type NSTextCheckingKey = NSString;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nstextcheckingresult?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSTextCheckingResult;
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSCoding for NSTextCheckingResult {}
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSCopying for NSTextCheckingResult {}
);

#[cfg(feature = "NSObject")]
unsafe impl CopyingHelper for NSTextCheckingResult {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSTextCheckingResult {}
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSSecureCoding for NSTextCheckingResult {}
);

impl NSTextCheckingResult {
    extern_methods!(
        #[unsafe(method(resultType))]
        #[unsafe(method_family = none)]
        pub fn resultType(&self) -> NSTextCheckingType;

        #[cfg(feature = "NSRange")]
        #[unsafe(method(range))]
        #[unsafe(method_family = none)]
        pub fn range(&self) -> NSRange;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSTextCheckingResult {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSTextCheckingResult {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

/// NSTextCheckingResultOptional.
impl NSTextCheckingResult {
    extern_methods!(
        #[cfg(feature = "NSOrthography")]
        #[unsafe(method(orthography))]
        #[unsafe(method_family = none)]
        pub fn orthography(&self) -> Option<Retained<NSOrthography>>;

        #[cfg(all(feature = "NSArray", feature = "NSDictionary", feature = "NSString"))]
        #[unsafe(method(grammarDetails))]
        #[unsafe(method_family = none)]
        pub fn grammarDetails(
            &self,
        ) -> Option<Retained<NSArray<NSDictionary<NSString, AnyObject>>>>;

        #[cfg(feature = "NSDate")]
        #[unsafe(method(date))]
        #[unsafe(method_family = none)]
        pub fn date(&self) -> Option<Retained<NSDate>>;

        #[cfg(feature = "NSTimeZone")]
        #[unsafe(method(timeZone))]
        #[unsafe(method_family = none)]
        pub fn timeZone(&self) -> Option<Retained<NSTimeZone>>;

        #[cfg(feature = "NSDate")]
        #[unsafe(method(duration))]
        #[unsafe(method_family = none)]
        pub fn duration(&self) -> NSTimeInterval;

        #[cfg(all(feature = "NSDictionary", feature = "NSString"))]
        #[unsafe(method(components))]
        #[unsafe(method_family = none)]
        pub fn components(&self) -> Option<Retained<NSDictionary<NSTextCheckingKey, NSString>>>;

        #[cfg(feature = "NSURL")]
        #[unsafe(method(URL))]
        #[unsafe(method_family = none)]
        pub fn URL(&self) -> Option<Retained<NSURL>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(replacementString))]
        #[unsafe(method_family = none)]
        pub fn replacementString(&self) -> Option<Retained<NSString>>;

        #[cfg(all(feature = "NSArray", feature = "NSString"))]
        #[unsafe(method(alternativeStrings))]
        #[unsafe(method_family = none)]
        pub fn alternativeStrings(&self) -> Option<Retained<NSArray<NSString>>>;

        #[cfg(feature = "NSRegularExpression")]
        #[unsafe(method(regularExpression))]
        #[unsafe(method_family = none)]
        pub fn regularExpression(&self) -> Option<Retained<NSRegularExpression>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(phoneNumber))]
        #[unsafe(method_family = none)]
        pub fn phoneNumber(&self) -> Option<Retained<NSString>>;

        #[unsafe(method(numberOfRanges))]
        #[unsafe(method_family = none)]
        pub fn numberOfRanges(&self) -> NSUInteger;

        #[cfg(feature = "NSRange")]
        #[unsafe(method(rangeAtIndex:))]
        #[unsafe(method_family = none)]
        pub fn rangeAtIndex(&self, idx: NSUInteger) -> NSRange;

        #[cfg(all(feature = "NSRange", feature = "NSString"))]
        #[unsafe(method(rangeWithName:))]
        #[unsafe(method_family = none)]
        pub fn rangeWithName(&self, name: &NSString) -> NSRange;

        #[unsafe(method(resultByAdjustingRangesWithOffset:))]
        #[unsafe(method_family = none)]
        pub fn resultByAdjustingRangesWithOffset(
            &self,
            offset: NSInteger,
        ) -> Retained<NSTextCheckingResult>;

        #[cfg(all(feature = "NSDictionary", feature = "NSString"))]
        #[unsafe(method(addressComponents))]
        #[unsafe(method_family = none)]
        pub fn addressComponents(
            &self,
        ) -> Option<Retained<NSDictionary<NSTextCheckingKey, NSString>>>;
    );
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nstextcheckingnamekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSTextCheckingNameKey: &'static NSTextCheckingKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nstextcheckingjobtitlekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSTextCheckingJobTitleKey: &'static NSTextCheckingKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nstextcheckingorganizationkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSTextCheckingOrganizationKey: &'static NSTextCheckingKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nstextcheckingstreetkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSTextCheckingStreetKey: &'static NSTextCheckingKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nstextcheckingcitykey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSTextCheckingCityKey: &'static NSTextCheckingKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nstextcheckingstatekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSTextCheckingStateKey: &'static NSTextCheckingKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nstextcheckingzipkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSTextCheckingZIPKey: &'static NSTextCheckingKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nstextcheckingcountrykey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSTextCheckingCountryKey: &'static NSTextCheckingKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nstextcheckingphonekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSTextCheckingPhoneKey: &'static NSTextCheckingKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nstextcheckingairlinekey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSTextCheckingAirlineKey: &'static NSTextCheckingKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nstextcheckingflightkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSTextCheckingFlightKey: &'static NSTextCheckingKey;
}

/// NSTextCheckingResultCreation.
impl NSTextCheckingResult {
    extern_methods!(
        #[cfg(all(feature = "NSOrthography", feature = "NSRange"))]
        #[unsafe(method(orthographyCheckingResultWithRange:orthography:))]
        #[unsafe(method_family = none)]
        pub fn orthographyCheckingResultWithRange_orthography(
            range: NSRange,
            orthography: &NSOrthography,
        ) -> Retained<NSTextCheckingResult>;

        #[cfg(feature = "NSRange")]
        #[unsafe(method(spellCheckingResultWithRange:))]
        #[unsafe(method_family = none)]
        pub fn spellCheckingResultWithRange(range: NSRange) -> Retained<NSTextCheckingResult>;

        #[cfg(all(
            feature = "NSArray",
            feature = "NSDictionary",
            feature = "NSRange",
            feature = "NSString"
        ))]
        /// # Safety
        ///
        /// `details` generic generic should be of the correct type.
        #[unsafe(method(grammarCheckingResultWithRange:details:))]
        #[unsafe(method_family = none)]
        pub unsafe fn grammarCheckingResultWithRange_details(
            range: NSRange,
            details: &NSArray<NSDictionary<NSString, AnyObject>>,
        ) -> Retained<NSTextCheckingResult>;

        #[cfg(all(feature = "NSDate", feature = "NSRange"))]
        #[unsafe(method(dateCheckingResultWithRange:date:))]
        #[unsafe(method_family = none)]
        pub fn dateCheckingResultWithRange_date(
            range: NSRange,
            date: &NSDate,
        ) -> Retained<NSTextCheckingResult>;

        #[cfg(all(feature = "NSDate", feature = "NSRange", feature = "NSTimeZone"))]
        #[unsafe(method(dateCheckingResultWithRange:date:timeZone:duration:))]
        #[unsafe(method_family = none)]
        pub fn dateCheckingResultWithRange_date_timeZone_duration(
            range: NSRange,
            date: &NSDate,
            time_zone: &NSTimeZone,
            duration: NSTimeInterval,
        ) -> Retained<NSTextCheckingResult>;

        #[cfg(all(feature = "NSDictionary", feature = "NSRange", feature = "NSString"))]
        #[unsafe(method(addressCheckingResultWithRange:components:))]
        #[unsafe(method_family = none)]
        pub fn addressCheckingResultWithRange_components(
            range: NSRange,
            components: &NSDictionary<NSTextCheckingKey, NSString>,
        ) -> Retained<NSTextCheckingResult>;

        #[cfg(all(feature = "NSRange", feature = "NSURL"))]
        #[unsafe(method(linkCheckingResultWithRange:URL:))]
        #[unsafe(method_family = none)]
        pub fn linkCheckingResultWithRange_URL(
            range: NSRange,
            url: &NSURL,
        ) -> Retained<NSTextCheckingResult>;

        #[cfg(all(feature = "NSRange", feature = "NSString"))]
        #[unsafe(method(quoteCheckingResultWithRange:replacementString:))]
        #[unsafe(method_family = none)]
        pub fn quoteCheckingResultWithRange_replacementString(
            range: NSRange,
            replacement_string: &NSString,
        ) -> Retained<NSTextCheckingResult>;

        #[cfg(all(feature = "NSRange", feature = "NSString"))]
        #[unsafe(method(dashCheckingResultWithRange:replacementString:))]
        #[unsafe(method_family = none)]
        pub fn dashCheckingResultWithRange_replacementString(
            range: NSRange,
            replacement_string: &NSString,
        ) -> Retained<NSTextCheckingResult>;

        #[cfg(all(feature = "NSRange", feature = "NSString"))]
        #[unsafe(method(replacementCheckingResultWithRange:replacementString:))]
        #[unsafe(method_family = none)]
        pub fn replacementCheckingResultWithRange_replacementString(
            range: NSRange,
            replacement_string: &NSString,
        ) -> Retained<NSTextCheckingResult>;

        #[cfg(all(feature = "NSRange", feature = "NSString"))]
        #[unsafe(method(correctionCheckingResultWithRange:replacementString:))]
        #[unsafe(method_family = none)]
        pub fn correctionCheckingResultWithRange_replacementString(
            range: NSRange,
            replacement_string: &NSString,
        ) -> Retained<NSTextCheckingResult>;

        #[cfg(all(feature = "NSArray", feature = "NSRange", feature = "NSString"))]
        #[unsafe(method(correctionCheckingResultWithRange:replacementString:alternativeStrings:))]
        #[unsafe(method_family = none)]
        pub fn correctionCheckingResultWithRange_replacementString_alternativeStrings(
            range: NSRange,
            replacement_string: &NSString,
            alternative_strings: &NSArray<NSString>,
        ) -> Retained<NSTextCheckingResult>;

        #[cfg(all(feature = "NSRange", feature = "NSRegularExpression"))]
        /// # Safety
        ///
        /// `ranges` must be a valid pointer.
        #[unsafe(method(regularExpressionCheckingResultWithRanges:count:regularExpression:))]
        #[unsafe(method_family = none)]
        pub unsafe fn regularExpressionCheckingResultWithRanges_count_regularExpression(
            ranges: NSRangePointer,
            count: NSUInteger,
            regular_expression: &NSRegularExpression,
        ) -> Retained<NSTextCheckingResult>;

        #[cfg(all(feature = "NSRange", feature = "NSString"))]
        #[unsafe(method(phoneNumberCheckingResultWithRange:phoneNumber:))]
        #[unsafe(method_family = none)]
        pub fn phoneNumberCheckingResultWithRange_phoneNumber(
            range: NSRange,
            phone_number: &NSString,
        ) -> Retained<NSTextCheckingResult>;

        #[cfg(all(feature = "NSDictionary", feature = "NSRange", feature = "NSString"))]
        #[unsafe(method(transitInformationCheckingResultWithRange:components:))]
        #[unsafe(method_family = none)]
        pub fn transitInformationCheckingResultWithRange_components(
            range: NSRange,
            components: &NSDictionary<NSTextCheckingKey, NSString>,
        ) -> Retained<NSTextCheckingResult>;
    );
}
