//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitabbarsystemitem?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UITabBarSystemItem(pub NSInteger);
impl UITabBarSystemItem {
    #[doc(alias = "UITabBarSystemItemMore")]
    pub const More: Self = Self(0);
    #[doc(alias = "UITabBarSystemItemFavorites")]
    pub const Favorites: Self = Self(1);
    #[doc(alias = "UITabBarSystemItemFeatured")]
    pub const Featured: Self = Self(2);
    #[doc(alias = "UITabBarSystemItemTopRated")]
    pub const TopRated: Self = Self(3);
    #[doc(alias = "UITabBarSystemItemRecents")]
    pub const Recents: Self = Self(4);
    #[doc(alias = "UITabBarSystemItemContacts")]
    pub const Contacts: Self = Self(5);
    #[doc(alias = "UITabBarSystemItemHistory")]
    pub const History: Self = Self(6);
    #[doc(alias = "UITabBarSystemItemBookmarks")]
    pub const Bookmarks: Self = Self(7);
    #[doc(alias = "UITabBarSystemItemSearch")]
    pub const Search: Self = Self(8);
    #[doc(alias = "UITabBarSystemItemDownloads")]
    pub const Downloads: Self = Self(9);
    #[doc(alias = "UITabBarSystemItemMostRecent")]
    pub const MostRecent: Self = Self(10);
    #[doc(alias = "UITabBarSystemItemMostViewed")]
    pub const MostViewed: Self = Self(11);
}

unsafe impl Encode for UITabBarSystemItem {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UITabBarSystemItem {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitabbaritem?language=objc)
    #[unsafe(super(UIBarItem, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "UIBarItem")]
    pub struct UITabBarItem;
);

#[cfg(feature = "UIBarItem")]
extern_conformance!(
    unsafe impl NSCoding for UITabBarItem {}
);

#[cfg(feature = "UIBarItem")]
extern_conformance!(
    unsafe impl NSObjectProtocol for UITabBarItem {}
);

#[cfg(all(feature = "UIAppearance", feature = "UIBarItem"))]
extern_conformance!(
    unsafe impl UIAppearance for UITabBarItem {}
);

#[cfg(feature = "UIBarItem")]
impl UITabBarItem {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "UIImage")]
        #[unsafe(method(initWithTitle:image:tag:))]
        #[unsafe(method_family = init)]
        pub fn initWithTitle_image_tag(
            this: Allocated<Self>,
            title: Option<&NSString>,
            image: Option<&UIImage>,
            tag: NSInteger,
        ) -> Retained<Self>;

        #[cfg(feature = "UIImage")]
        #[unsafe(method(initWithTitle:image:selectedImage:))]
        #[unsafe(method_family = init)]
        pub fn initWithTitle_image_selectedImage(
            this: Allocated<Self>,
            title: Option<&NSString>,
            image: Option<&UIImage>,
            selected_image: Option<&UIImage>,
        ) -> Retained<Self>;

        #[unsafe(method(initWithTabBarSystemItem:tag:))]
        #[unsafe(method_family = init)]
        pub fn initWithTabBarSystemItem_tag(
            this: Allocated<Self>,
            system_item: UITabBarSystemItem,
            tag: NSInteger,
        ) -> Retained<Self>;

        #[cfg(feature = "UIImage")]
        #[unsafe(method(selectedImage))]
        #[unsafe(method_family = none)]
        pub fn selectedImage(&self) -> Option<Retained<UIImage>>;

        #[cfg(feature = "UIImage")]
        /// Setter for [`selectedImage`][Self::selectedImage].
        #[unsafe(method(setSelectedImage:))]
        #[unsafe(method_family = none)]
        pub fn setSelectedImage(&self, selected_image: Option<&UIImage>);

        #[unsafe(method(badgeValue))]
        #[unsafe(method_family = none)]
        pub fn badgeValue(&self) -> Option<Retained<NSString>>;

        /// Setter for [`badgeValue`][Self::badgeValue].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setBadgeValue:))]
        #[unsafe(method_family = none)]
        pub fn setBadgeValue(&self, badge_value: Option<&NSString>);

        #[cfg(feature = "UIImage")]
        #[deprecated = "Use initWithTitle:image:selectedImage: or the image and selectedImage properties along with UIImageRenderingModeAlwaysOriginal"]
        #[unsafe(method(setFinishedSelectedImage:withFinishedUnselectedImage:))]
        #[unsafe(method_family = none)]
        pub fn setFinishedSelectedImage_withFinishedUnselectedImage(
            &self,
            selected_image: Option<&UIImage>,
            unselected_image: Option<&UIImage>,
        );

        #[cfg(feature = "UIImage")]
        #[deprecated]
        #[unsafe(method(finishedSelectedImage))]
        #[unsafe(method_family = none)]
        pub fn finishedSelectedImage(&self) -> Option<Retained<UIImage>>;

        #[cfg(feature = "UIImage")]
        #[deprecated]
        #[unsafe(method(finishedUnselectedImage))]
        #[unsafe(method_family = none)]
        pub fn finishedUnselectedImage(&self) -> Option<Retained<UIImage>>;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(titlePositionAdjustment))]
        #[unsafe(method_family = none)]
        pub fn titlePositionAdjustment(&self) -> UIOffset;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        /// Setter for [`titlePositionAdjustment`][Self::titlePositionAdjustment].
        #[unsafe(method(setTitlePositionAdjustment:))]
        #[unsafe(method_family = none)]
        pub fn setTitlePositionAdjustment(&self, title_position_adjustment: UIOffset);

        #[cfg(feature = "UIColor")]
        /// If this item displays a badge, this color will be used for the badge's background. If set to nil, the default background color will be used instead.
        #[unsafe(method(badgeColor))]
        #[unsafe(method_family = none)]
        pub fn badgeColor(&self) -> Option<Retained<UIColor>>;

        #[cfg(feature = "UIColor")]
        /// Setter for [`badgeColor`][Self::badgeColor].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setBadgeColor:))]
        #[unsafe(method_family = none)]
        pub fn setBadgeColor(&self, badge_color: Option<&UIColor>);

        #[cfg(feature = "UIControl")]
        /// Provide text attributes to use to draw the badge text for the given singular control state (Normal, Disabled, Focused, Selected, or Highlighted). Default values will be supplied for keys that are not provided by this dictionary. See NSAttributedString.h for details on what keys are available.
        ///
        /// # Safety
        ///
        /// `text_attributes` generic should be of the correct type.
        #[unsafe(method(setBadgeTextAttributes:forState:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBadgeTextAttributes_forState(
            &self,
            text_attributes: Option<&NSDictionary<NSAttributedStringKey, AnyObject>>,
            state: UIControlState,
        );

        #[cfg(feature = "UIControl")]
        /// Returns attributes previously set via -setBadgeTextAttributes:forState:.
        #[unsafe(method(badgeTextAttributesForState:))]
        #[unsafe(method_family = none)]
        pub fn badgeTextAttributesForState(
            &self,
            state: UIControlState,
        ) -> Option<Retained<NSDictionary<NSAttributedStringKey, AnyObject>>>;

        #[cfg(all(feature = "UIBarAppearance", feature = "UITabBarAppearance"))]
        /// When set and this item is selected, overrides the hosting tab bar's standardAppearance.
        #[unsafe(method(standardAppearance))]
        #[unsafe(method_family = none)]
        pub fn standardAppearance(&self) -> Option<Retained<UITabBarAppearance>>;

        #[cfg(all(feature = "UIBarAppearance", feature = "UITabBarAppearance"))]
        /// Setter for [`standardAppearance`][Self::standardAppearance].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setStandardAppearance:))]
        #[unsafe(method_family = none)]
        pub fn setStandardAppearance(&self, standard_appearance: Option<&UITabBarAppearance>);

        #[cfg(all(feature = "UIBarAppearance", feature = "UITabBarAppearance"))]
        /// When set and this item is selected, overrides the hosting tab bar's scrollEdgeAppearance.
        #[unsafe(method(scrollEdgeAppearance))]
        #[unsafe(method_family = none)]
        pub fn scrollEdgeAppearance(&self) -> Option<Retained<UITabBarAppearance>>;

        #[cfg(all(feature = "UIBarAppearance", feature = "UITabBarAppearance"))]
        /// Setter for [`scrollEdgeAppearance`][Self::scrollEdgeAppearance].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setScrollEdgeAppearance:))]
        #[unsafe(method_family = none)]
        pub fn setScrollEdgeAppearance(&self, scroll_edge_appearance: Option<&UITabBarAppearance>);
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "UIBarItem")]
impl UITabBarItem {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// SpringLoading.
#[cfg(feature = "UIBarItem")]
impl UITabBarItem {
    extern_methods!();
}

#[cfg(all(feature = "UIBarItem", feature = "UISpringLoadedInteractionSupporting"))]
extern_conformance!(
    unsafe impl UISpringLoadedInteractionSupporting for UITabBarItem {}
);
