/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.ui.internal.proxy;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpHeader;
import org.openhab.core.library.types.StringType;
import org.openhab.core.model.sitemap.SitemapProvider;
import org.openhab.core.model.sitemap.sitemap.Image;
import org.openhab.core.model.sitemap.sitemap.Sitemap;
import org.openhab.core.model.sitemap.sitemap.Video;
import org.openhab.core.model.sitemap.sitemap.Widget;
import org.openhab.core.types.State;
import org.openhab.core.ui.internal.proxy.AsyncProxyServlet;
import org.openhab.core.ui.internal.proxy.BlockingProxyServlet;
import org.openhab.core.ui.items.ItemUIRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, property={"service.pid=org.openhab.proxy"})
public class ProxyServletService
extends HttpServlet {
    public static final String PROXY_ALIAS = "proxy";
    private static final long serialVersionUID = -4716754591953017793L;
    private static final String CONFIG_MAX_THREADS = "maxThreads";
    private static final int DEFAULT_MAX_THREADS = 8;
    public static final String ATTR_URI = ProxyServletService.class.getName() + ".URI";
    public static final String ATTR_SERVLET_EXCEPTION = ProxyServletService.class.getName() + ".ProxyServletException";
    private final Logger logger = LoggerFactory.getLogger(ProxyServletService.class);
    private @Nullable Servlet impl;
    protected final HttpService httpService;
    protected final ItemUIRegistry itemUIRegistry;
    protected final List<SitemapProvider> sitemapProviders = new CopyOnWriteArrayList<SitemapProvider>();

    @Activate
    public ProxyServletService(@Reference HttpService httpService, @Reference ItemUIRegistry itemUIRegistry, Map<String, Object> config) {
        this.httpService = httpService;
        this.itemUIRegistry = itemUIRegistry;
        Servlet servlet = this.getImpl();
        this.logger.debug("Starting up '{}' servlet  at /{}", (Object)servlet.getServletInfo(), (Object)PROXY_ALIAS);
        try {
            httpService.registerServlet("/proxy", servlet, this.propsFromConfig(config, servlet), httpService.createDefaultHttpContext());
        }
        catch (ServletException | NamespaceException e) {
            this.logger.error("Error during servlet startup: {}", (Object)e.getMessage());
        }
    }

    @Deactivate
    protected void deactivate() {
        try {
            this.httpService.unregister("/proxy");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addSitemapProvider(SitemapProvider provider) {
        this.sitemapProviders.add(provider);
    }

    protected void removeSitemapProvider(SitemapProvider provider) {
        this.sitemapProviders.remove(provider);
    }

    private Servlet getImpl() {
        Object servlet = this.impl;
        if (servlet == null) {
            try {
                ServletRequest.class.getMethod("startAsync", new Class[0]);
                servlet = new AsyncProxyServlet(this);
            }
            catch (Throwable t) {
                servlet = new BlockingProxyServlet(this);
            }
            this.impl = servlet;
        }
        return servlet;
    }

    private Hashtable<String, @Nullable String> propsFromConfig(Map<String, Object> config, Servlet servlet) {
        Hashtable<String, @Nullable String> props = new Hashtable<String, String>();
        for (Map.Entry<String, Object> entry : config.entrySet()) {
            props.put(entry.getKey(), entry.getValue().toString());
        }
        if (props.get(CONFIG_MAX_THREADS) == null) {
            props.put(CONFIG_MAX_THREADS, String.valueOf(Math.max(8, Runtime.getRuntime().availableProcessors())));
        }
        if (servlet instanceof AsyncProxyServlet) {
            props.put("async-supported", "true");
        }
        return props;
    }

    @Nullable URI uriFromRequest(HttpServletRequest request) {
        State state;
        String uriString;
        URI uri;
        block17: {
            try {
                uri = (URI)request.getAttribute(ATTR_URI);
                if (uri != null) {
                    return uri;
                }
                ProxyServletException pse = (ProxyServletException)request.getAttribute(ATTR_SERVLET_EXCEPTION);
                if (pse == null) break block17;
                return null;
            }
            catch (ProxyServletException pse) {
                request.setAttribute(ATTR_SERVLET_EXCEPTION, (Object)pse);
                return null;
            }
        }
        String sitemapName = request.getParameter("sitemap");
        if (sitemapName == null) {
            throw new ProxyServletException(400, "Parameter 'sitemap' must be provided!");
        }
        String widgetId = request.getParameter("widgetId");
        if (widgetId == null) {
            throw new ProxyServletException(400, "Parameter 'widgetId' must be provided!");
        }
        Sitemap sitemap = this.getSitemap(sitemapName);
        if (sitemap == null) {
            throw new ProxyServletException(404, String.format("Sitemap '%s' could not be found!", sitemapName));
        }
        Widget widget = this.itemUIRegistry.getWidget(sitemap, widgetId);
        if (widget == null) {
            throw new ProxyServletException(404, String.format("Widget '%s' could not be found!", widgetId));
        }
        if (widget instanceof Image) {
            Image image = (Image)widget;
            uriString = image.getUrl();
        } else if (widget instanceof Video) {
            Video video = (Video)widget;
            uriString = video.getUrl();
        } else {
            throw new ProxyServletException(403, String.format("Widget type '%s' is not supported!", widget.getClass().getName()));
        }
        String itemName = widget.getItem();
        if (itemName != null && (state = this.itemUIRegistry.getItemState(itemName)) instanceof StringType) {
            try {
                uri = this.createURIFromString(state.toString());
                request.setAttribute(ATTR_URI, (Object)uri);
                return uri;
            }
            catch (MalformedURLException | URISyntaxException exception) {
                // empty catch block
            }
        }
        try {
            uri = this.createURIFromString(uriString);
            request.setAttribute(ATTR_URI, (Object)uri);
            return uri;
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new ProxyServletException(500, String.format("URL '%s' is not a valid URL.", uriString));
        }
    }

    private @Nullable Sitemap getSitemap(String sitemapName) {
        Sitemap sitemap = null;
        for (SitemapProvider sitemapProvider : this.sitemapProviders) {
            sitemap = sitemapProvider.getSitemap(sitemapName);
            if (sitemap != null) break;
        }
        return sitemap;
    }

    private URI createURIFromString(String url) throws MalformedURLException, URISyntaxException {
        URI uri = new URI(url);
        try {
            uri.toURL();
        }
        catch (IllegalArgumentException e) {
            throw new MalformedURLException(e.getMessage());
        }
        return uri;
    }

    void maybeAppendAuthHeader(@Nullable URI uri, Request request) {
        String[] userInfo;
        if (uri != null && uri.getUserInfo() != null && (userInfo = uri.getUserInfo().split(":")).length >= 1) {
            String user = userInfo[0];
            String password = userInfo.length >= 2 ? userInfo[1] : null;
            String authString = password != null ? user + ":" + password : user + ":";
            String basicAuthentication = "Basic " + Base64.getEncoder().encodeToString(authString.getBytes());
            request.header(HttpHeader.AUTHORIZATION, basicAuthentication);
        }
    }

    boolean proxyingVideoWidget(HttpServletRequest request) {
        Widget widget;
        block9: {
            block8: {
                try {
                    String sitemapName = request.getParameter("sitemap");
                    if (sitemapName == null) {
                        throw new ProxyServletException(400, "Parameter 'sitemap' must be provided!");
                    }
                    String widgetId = request.getParameter("widgetId");
                    if (widgetId == null) {
                        throw new ProxyServletException(400, "Parameter 'widgetId' must be provided!");
                    }
                    Sitemap sitemap = this.getSitemap(sitemapName);
                    if (sitemap == null) {
                        throw new ProxyServletException(404, String.format("Sitemap '%s' could not be found!", sitemapName));
                    }
                    widget = this.itemUIRegistry.getWidget(sitemap, widgetId);
                    if (widget == null) {
                        throw new ProxyServletException(404, String.format("Widget '%s' could not be found!", widgetId));
                    }
                    if (!(widget instanceof Image)) break block8;
                    return false;
                }
                catch (ProxyServletException pse) {
                    request.setAttribute(ATTR_SERVLET_EXCEPTION, (Object)pse);
                    return false;
                }
            }
            if (!(widget instanceof Video)) break block9;
            return true;
        }
        throw new ProxyServletException(403, String.format("Widget type '%s' is not supported!", widget.getClass().getName()));
    }

    void sendError(HttpServletRequest request, HttpServletResponse response) {
        ProxyServletException pse = (ProxyServletException)request.getAttribute(ATTR_SERVLET_EXCEPTION);
        if (pse != null) {
            try {
                response.sendError(pse.getCode(), pse.getMessage());
            }
            catch (IOException ioe) {
                response.setStatus(pse.getCode());
            }
        } else {
            response.setStatus(403);
        }
    }

    static class ProxyServletException
    extends Exception {
        static final long serialVersionUID = -1L;
        private final int code;

        public ProxyServletException(int code, String message) {
            super(message);
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

