# Unicode normalization tests, generated from NormalizationTests.txt in the
# Unicode database by S15-normalization/test-gen.raku.
# Generated from Unicode version 15.0.0.

use Test;

plan 1074;

ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x1BF2, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x1BF2, 0x05B0, 0x0062,), '0061 05B0 094D 3099 1BF2 0062 -> 0061 3099 094D 1BF2 05B0 0062';
ok Uni.new(0x0061, 0x1BF2, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x1BF2, 0x094D, 0x05B0, 0x0062,), '0061 1BF2 05B0 094D 3099 0062 -> 0061 3099 1BF2 094D 05B0 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x1BF3, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x1BF3, 0x05B0, 0x0062,), '0061 05B0 094D 3099 1BF3 0062 -> 0061 3099 094D 1BF3 05B0 0062';
ok Uni.new(0x0061, 0x1BF3, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x1BF3, 0x094D, 0x05B0, 0x0062,), '0061 1BF3 05B0 094D 3099 0062 -> 0061 3099 1BF3 094D 05B0 0062';
ok Uni.new(0x0061, 0x3099, 0x093C, 0x16FF0, 0x1C37, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x093C, 0x1C37, 0x3099, 0x0062,), '0061 3099 093C 16FF0 1C37 0062 -> 0061 16FF0 093C 1C37 3099 0062';
ok Uni.new(0x0061, 0x1C37, 0x3099, 0x093C, 0x16FF0, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x1C37, 0x093C, 0x3099, 0x0062,), '0061 1C37 3099 093C 16FF0 0062 -> 0061 16FF0 1C37 093C 3099 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1CD0, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1CD0, 0x0315, 0x0062,), '0061 0315 0300 05AE 1CD0 0062 -> 0061 05AE 0300 1CD0 0315 0062';
ok Uni.new(0x0061, 0x1CD0, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1CD0, 0x0300, 0x0315, 0x0062,), '0061 1CD0 0315 0300 05AE 0062 -> 0061 05AE 1CD0 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1CD1, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1CD1, 0x0315, 0x0062,), '0061 0315 0300 05AE 1CD1 0062 -> 0061 05AE 0300 1CD1 0315 0062';
ok Uni.new(0x0061, 0x1CD1, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1CD1, 0x0300, 0x0315, 0x0062,), '0061 1CD1 0315 0300 05AE 0062 -> 0061 05AE 1CD1 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1CD2, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1CD2, 0x0315, 0x0062,), '0061 0315 0300 05AE 1CD2 0062 -> 0061 05AE 0300 1CD2 0315 0062';
ok Uni.new(0x0061, 0x1CD2, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1CD2, 0x0300, 0x0315, 0x0062,), '0061 1CD2 0315 0300 05AE 0062 -> 0061 05AE 1CD2 0300 0315 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x1CD4, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x1CD4, 0x16FF0, 0x0062,), '0061 16FF0 0334 1CD4 0062 -> 0061 0334 1CD4 16FF0 0062';
ok Uni.new(0x0061, 0x1CD4, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x1CD4, 0x0334, 0x16FF0, 0x0062,), '0061 1CD4 16FF0 0334 0062 -> 0061 1CD4 0334 16FF0 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CD5, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1CD5, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1CD5 0062 -> 0061 1DFA 0316 1CD5 059A 0062';
ok Uni.new(0x0061, 0x1CD5, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1CD5, 0x0316, 0x059A, 0x0062,), '0061 1CD5 059A 0316 1DFA 0062 -> 0061 1DFA 1CD5 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CD6, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1CD6, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1CD6 0062 -> 0061 1DFA 0316 1CD6 059A 0062';
ok Uni.new(0x0061, 0x1CD6, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1CD6, 0x0316, 0x059A, 0x0062,), '0061 1CD6 059A 0316 1DFA 0062 -> 0061 1DFA 1CD6 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CD7, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1CD7, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1CD7 0062 -> 0061 1DFA 0316 1CD7 059A 0062';
ok Uni.new(0x0061, 0x1CD7, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1CD7, 0x0316, 0x059A, 0x0062,), '0061 1CD7 059A 0316 1DFA 0062 -> 0061 1DFA 1CD7 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CD8, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1CD8, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1CD8 0062 -> 0061 1DFA 0316 1CD8 059A 0062';
ok Uni.new(0x0061, 0x1CD8, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1CD8, 0x0316, 0x059A, 0x0062,), '0061 1CD8 059A 0316 1DFA 0062 -> 0061 1DFA 1CD8 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CD9, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1CD9, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1CD9 0062 -> 0061 1DFA 0316 1CD9 059A 0062';
ok Uni.new(0x0061, 0x1CD9, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1CD9, 0x0316, 0x059A, 0x0062,), '0061 1CD9 059A 0316 1DFA 0062 -> 0061 1DFA 1CD9 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1CDA, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1CDA, 0x0315, 0x0062,), '0061 0315 0300 05AE 1CDA 0062 -> 0061 05AE 0300 1CDA 0315 0062';
ok Uni.new(0x0061, 0x1CDA, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1CDA, 0x0300, 0x0315, 0x0062,), '0061 1CDA 0315 0300 05AE 0062 -> 0061 05AE 1CDA 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1CDB, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1CDB, 0x0315, 0x0062,), '0061 0315 0300 05AE 1CDB 0062 -> 0061 05AE 0300 1CDB 0315 0062';
ok Uni.new(0x0061, 0x1CDB, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1CDB, 0x0300, 0x0315, 0x0062,), '0061 1CDB 0315 0300 05AE 0062 -> 0061 05AE 1CDB 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CDC, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1CDC, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1CDC 0062 -> 0061 1DFA 0316 1CDC 059A 0062';
ok Uni.new(0x0061, 0x1CDC, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1CDC, 0x0316, 0x059A, 0x0062,), '0061 1CDC 059A 0316 1DFA 0062 -> 0061 1DFA 1CDC 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CDD, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1CDD, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1CDD 0062 -> 0061 1DFA 0316 1CDD 059A 0062';
ok Uni.new(0x0061, 0x1CDD, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1CDD, 0x0316, 0x059A, 0x0062,), '0061 1CDD 059A 0316 1DFA 0062 -> 0061 1DFA 1CDD 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CDE, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1CDE, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1CDE 0062 -> 0061 1DFA 0316 1CDE 059A 0062';
ok Uni.new(0x0061, 0x1CDE, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1CDE, 0x0316, 0x059A, 0x0062,), '0061 1CDE 059A 0316 1DFA 0062 -> 0061 1DFA 1CDE 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CDF, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1CDF, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1CDF 0062 -> 0061 1DFA 0316 1CDF 059A 0062';
ok Uni.new(0x0061, 0x1CDF, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1CDF, 0x0316, 0x059A, 0x0062,), '0061 1CDF 059A 0316 1DFA 0062 -> 0061 1DFA 1CDF 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1CE0, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1CE0, 0x0315, 0x0062,), '0061 0315 0300 05AE 1CE0 0062 -> 0061 05AE 0300 1CE0 0315 0062';
ok Uni.new(0x0061, 0x1CE0, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1CE0, 0x0300, 0x0315, 0x0062,), '0061 1CE0 0315 0300 05AE 0062 -> 0061 05AE 1CE0 0300 0315 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x1CE2, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x1CE2, 0x16FF0, 0x0062,), '0061 16FF0 0334 1CE2 0062 -> 0061 0334 1CE2 16FF0 0062';
ok Uni.new(0x0061, 0x1CE2, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x1CE2, 0x0334, 0x16FF0, 0x0062,), '0061 1CE2 16FF0 0334 0062 -> 0061 1CE2 0334 16FF0 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x1CE3, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x1CE3, 0x16FF0, 0x0062,), '0061 16FF0 0334 1CE3 0062 -> 0061 0334 1CE3 16FF0 0062';
ok Uni.new(0x0061, 0x1CE3, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x1CE3, 0x0334, 0x16FF0, 0x0062,), '0061 1CE3 16FF0 0334 0062 -> 0061 1CE3 0334 16FF0 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x1CE4, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x1CE4, 0x16FF0, 0x0062,), '0061 16FF0 0334 1CE4 0062 -> 0061 0334 1CE4 16FF0 0062';
ok Uni.new(0x0061, 0x1CE4, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x1CE4, 0x0334, 0x16FF0, 0x0062,), '0061 1CE4 16FF0 0334 0062 -> 0061 1CE4 0334 16FF0 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x1CE5, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x1CE5, 0x16FF0, 0x0062,), '0061 16FF0 0334 1CE5 0062 -> 0061 0334 1CE5 16FF0 0062';
ok Uni.new(0x0061, 0x1CE5, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x1CE5, 0x0334, 0x16FF0, 0x0062,), '0061 1CE5 16FF0 0334 0062 -> 0061 1CE5 0334 16FF0 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x1CE6, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x1CE6, 0x16FF0, 0x0062,), '0061 16FF0 0334 1CE6 0062 -> 0061 0334 1CE6 16FF0 0062';
ok Uni.new(0x0061, 0x1CE6, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x1CE6, 0x0334, 0x16FF0, 0x0062,), '0061 1CE6 16FF0 0334 0062 -> 0061 1CE6 0334 16FF0 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x1CE7, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x1CE7, 0x16FF0, 0x0062,), '0061 16FF0 0334 1CE7 0062 -> 0061 0334 1CE7 16FF0 0062';
ok Uni.new(0x0061, 0x1CE7, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x1CE7, 0x0334, 0x16FF0, 0x0062,), '0061 1CE7 16FF0 0334 0062 -> 0061 1CE7 0334 16FF0 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x1CE8, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x1CE8, 0x16FF0, 0x0062,), '0061 16FF0 0334 1CE8 0062 -> 0061 0334 1CE8 16FF0 0062';
ok Uni.new(0x0061, 0x1CE8, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x1CE8, 0x0334, 0x16FF0, 0x0062,), '0061 1CE8 16FF0 0334 0062 -> 0061 1CE8 0334 16FF0 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1CED, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1CED, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1CED 0062 -> 0061 1DFA 0316 1CED 059A 0062';
ok Uni.new(0x0061, 0x1CED, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1CED, 0x0316, 0x059A, 0x0062,), '0061 1CED 059A 0316 1DFA 0062 -> 0061 1DFA 1CED 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1CF4, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1CF4, 0x0315, 0x0062,), '0061 0315 0300 05AE 1CF4 0062 -> 0061 05AE 0300 1CF4 0315 0062';
ok Uni.new(0x0061, 0x1CF4, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1CF4, 0x0300, 0x0315, 0x0062,), '0061 1CF4 0315 0300 05AE 0062 -> 0061 05AE 1CF4 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1CF8, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1CF8, 0x0315, 0x0062,), '0061 0315 0300 05AE 1CF8 0062 -> 0061 05AE 0300 1CF8 0315 0062';
ok Uni.new(0x0061, 0x1CF8, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1CF8, 0x0300, 0x0315, 0x0062,), '0061 1CF8 0315 0300 05AE 0062 -> 0061 05AE 1CF8 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1CF9, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1CF9, 0x0315, 0x0062,), '0061 0315 0300 05AE 1CF9 0062 -> 0061 05AE 0300 1CF9 0315 0062';
ok Uni.new(0x0061, 0x1CF9, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1CF9, 0x0300, 0x0315, 0x0062,), '0061 1CF9 0315 0300 05AE 0062 -> 0061 05AE 1CF9 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC0, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DC0, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DC0 0062 -> 0061 05AE 0300 1DC0 0315 0062';
ok Uni.new(0x0061, 0x1DC0, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DC0, 0x0300, 0x0315, 0x0062,), '0061 1DC0 0315 0300 05AE 0062 -> 0061 05AE 1DC0 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC1, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DC1, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DC1 0062 -> 0061 05AE 0300 1DC1 0315 0062';
ok Uni.new(0x0061, 0x1DC1, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DC1, 0x0300, 0x0315, 0x0062,), '0061 1DC1 0315 0300 05AE 0062 -> 0061 05AE 1DC1 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1DC2, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1DC2, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1DC2 0062 -> 0061 1DFA 0316 1DC2 059A 0062';
ok Uni.new(0x0061, 0x1DC2, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1DC2, 0x0316, 0x059A, 0x0062,), '0061 1DC2 059A 0316 1DFA 0062 -> 0061 1DFA 1DC2 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC3, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DC3, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DC3 0062 -> 0061 05AE 0300 1DC3 0315 0062';
ok Uni.new(0x0061, 0x1DC3, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DC3, 0x0300, 0x0315, 0x0062,), '0061 1DC3 0315 0300 05AE 0062 -> 0061 05AE 1DC3 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC4, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DC4, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DC4 0062 -> 0061 05AE 0300 1DC4 0315 0062';
ok Uni.new(0x0061, 0x1DC4, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DC4, 0x0300, 0x0315, 0x0062,), '0061 1DC4 0315 0300 05AE 0062 -> 0061 05AE 1DC4 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC5, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DC5, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DC5 0062 -> 0061 05AE 0300 1DC5 0315 0062';
ok Uni.new(0x0061, 0x1DC5, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DC5, 0x0300, 0x0315, 0x0062,), '0061 1DC5 0315 0300 05AE 0062 -> 0061 05AE 1DC5 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC6, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DC6, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DC6 0062 -> 0061 05AE 0300 1DC6 0315 0062';
ok Uni.new(0x0061, 0x1DC6, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DC6, 0x0300, 0x0315, 0x0062,), '0061 1DC6 0315 0300 05AE 0062 -> 0061 05AE 1DC6 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC7, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DC7, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DC7 0062 -> 0061 05AE 0300 1DC7 0315 0062';
ok Uni.new(0x0061, 0x1DC7, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DC7, 0x0300, 0x0315, 0x0062,), '0061 1DC7 0315 0300 05AE 0062 -> 0061 05AE 1DC7 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC8, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DC8, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DC8 0062 -> 0061 05AE 0300 1DC8 0315 0062';
ok Uni.new(0x0061, 0x1DC8, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DC8, 0x0300, 0x0315, 0x0062,), '0061 1DC8 0315 0300 05AE 0062 -> 0061 05AE 1DC8 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DC9, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DC9, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DC9 0062 -> 0061 05AE 0300 1DC9 0315 0062';
ok Uni.new(0x0061, 0x1DC9, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DC9, 0x0300, 0x0315, 0x0062,), '0061 1DC9 0315 0300 05AE 0062 -> 0061 05AE 1DC9 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1DCA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1DCA, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1DCA 0062 -> 0061 1DFA 0316 1DCA 059A 0062';
ok Uni.new(0x0061, 0x1DCA, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1DCA, 0x0316, 0x059A, 0x0062,), '0061 1DCA 059A 0316 1DFA 0062 -> 0061 1DFA 1DCA 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DCB, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DCB, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DCB 0062 -> 0061 05AE 0300 1DCB 0315 0062';
ok Uni.new(0x0061, 0x1DCB, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DCB, 0x0300, 0x0315, 0x0062,), '0061 1DCB 0315 0300 05AE 0062 -> 0061 05AE 1DCB 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DCC, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DCC, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DCC 0062 -> 0061 05AE 0300 1DCC 0315 0062';
ok Uni.new(0x0061, 0x1DCC, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DCC, 0x0300, 0x0315, 0x0062,), '0061 1DCC 0315 0300 05AE 0062 -> 0061 05AE 1DCC 0300 0315 0062';
ok Uni.new(0x0061, 0x0345, 0x035D, 0x035C, 0x1DCD, 0x0062).NFD.list ~~ (0x0061, 0x035C, 0x035D, 0x1DCD, 0x0345, 0x0062,), '0061 0345 035D 035C 1DCD 0062 -> 0061 035C 035D 1DCD 0345 0062';
ok Uni.new(0x0061, 0x1DCD, 0x0345, 0x035D, 0x035C, 0x0062).NFD.list ~~ (0x0061, 0x035C, 0x1DCD, 0x035D, 0x0345, 0x0062,), '0061 1DCD 0345 035D 035C 0062 -> 0061 035C 1DCD 035D 0345 0062';
ok Uni.new(0x0061, 0x031B, 0x1DCE, 0x0321, 0x1DCE, 0x0062).NFD.list ~~ (0x0061, 0x0321, 0x1DCE, 0x1DCE, 0x031B, 0x0062,), '0061 031B 1DCE 0321 1DCE 0062 -> 0061 0321 1DCE 1DCE 031B 0062';
ok Uni.new(0x0061, 0x1DCE, 0x031B, 0x1DCE, 0x0321, 0x0062).NFD.list ~~ (0x0061, 0x0321, 0x1DCE, 0x1DCE, 0x031B, 0x0062,), '0061 1DCE 031B 1DCE 0321 0062 -> 0061 0321 1DCE 1DCE 031B 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1DCF, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1DCF, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1DCF 0062 -> 0061 1DFA 0316 1DCF 059A 0062';
ok Uni.new(0x0061, 0x1DCF, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1DCF, 0x0316, 0x059A, 0x0062,), '0061 1DCF 059A 0316 1DFA 0062 -> 0061 1DFA 1DCF 0316 059A 0062';
ok Uni.new(0x0061, 0x1DCE, 0x0321, 0x0F74, 0x1DD0, 0x0062).NFD.list ~~ (0x0061, 0x0F74, 0x0321, 0x1DD0, 0x1DCE, 0x0062,), '0061 1DCE 0321 0F74 1DD0 0062 -> 0061 0F74 0321 1DD0 1DCE 0062';
ok Uni.new(0x0061, 0x1DD0, 0x1DCE, 0x0321, 0x0F74, 0x0062).NFD.list ~~ (0x0061, 0x0F74, 0x1DD0, 0x0321, 0x1DCE, 0x0062,), '0061 1DD0 1DCE 0321 0F74 0062 -> 0061 0F74 1DD0 0321 1DCE 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD1, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DD1, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DD1 0062 -> 0061 05AE 0300 1DD1 0315 0062';
ok Uni.new(0x0061, 0x1DD1, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DD1, 0x0300, 0x0315, 0x0062,), '0061 1DD1 0315 0300 05AE 0062 -> 0061 05AE 1DD1 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD2, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DD2, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DD2 0062 -> 0061 05AE 0300 1DD2 0315 0062';
ok Uni.new(0x0061, 0x1DD2, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DD2, 0x0300, 0x0315, 0x0062,), '0061 1DD2 0315 0300 05AE 0062 -> 0061 05AE 1DD2 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD3, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DD3, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DD3 0062 -> 0061 05AE 0300 1DD3 0315 0062';
ok Uni.new(0x0061, 0x1DD3, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DD3, 0x0300, 0x0315, 0x0062,), '0061 1DD3 0315 0300 05AE 0062 -> 0061 05AE 1DD3 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD4, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DD4, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DD4 0062 -> 0061 05AE 0300 1DD4 0315 0062';
ok Uni.new(0x0061, 0x1DD4, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DD4, 0x0300, 0x0315, 0x0062,), '0061 1DD4 0315 0300 05AE 0062 -> 0061 05AE 1DD4 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD5, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DD5, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DD5 0062 -> 0061 05AE 0300 1DD5 0315 0062';
ok Uni.new(0x0061, 0x1DD5, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DD5, 0x0300, 0x0315, 0x0062,), '0061 1DD5 0315 0300 05AE 0062 -> 0061 05AE 1DD5 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD6, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DD6, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DD6 0062 -> 0061 05AE 0300 1DD6 0315 0062';
ok Uni.new(0x0061, 0x1DD6, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DD6, 0x0300, 0x0315, 0x0062,), '0061 1DD6 0315 0300 05AE 0062 -> 0061 05AE 1DD6 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD7, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DD7, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DD7 0062 -> 0061 05AE 0300 1DD7 0315 0062';
ok Uni.new(0x0061, 0x1DD7, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DD7, 0x0300, 0x0315, 0x0062,), '0061 1DD7 0315 0300 05AE 0062 -> 0061 05AE 1DD7 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD8, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DD8, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DD8 0062 -> 0061 05AE 0300 1DD8 0315 0062';
ok Uni.new(0x0061, 0x1DD8, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DD8, 0x0300, 0x0315, 0x0062,), '0061 1DD8 0315 0300 05AE 0062 -> 0061 05AE 1DD8 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DD9, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DD9, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DD9 0062 -> 0061 05AE 0300 1DD9 0315 0062';
ok Uni.new(0x0061, 0x1DD9, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DD9, 0x0300, 0x0315, 0x0062,), '0061 1DD9 0315 0300 05AE 0062 -> 0061 05AE 1DD9 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DDA, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DDA, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DDA 0062 -> 0061 05AE 0300 1DDA 0315 0062';
ok Uni.new(0x0061, 0x1DDA, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DDA, 0x0300, 0x0315, 0x0062,), '0061 1DDA 0315 0300 05AE 0062 -> 0061 05AE 1DDA 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DDB, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DDB, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DDB 0062 -> 0061 05AE 0300 1DDB 0315 0062';
ok Uni.new(0x0061, 0x1DDB, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DDB, 0x0300, 0x0315, 0x0062,), '0061 1DDB 0315 0300 05AE 0062 -> 0061 05AE 1DDB 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DDC, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DDC, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DDC 0062 -> 0061 05AE 0300 1DDC 0315 0062';
ok Uni.new(0x0061, 0x1DDC, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DDC, 0x0300, 0x0315, 0x0062,), '0061 1DDC 0315 0300 05AE 0062 -> 0061 05AE 1DDC 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DDD, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DDD, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DDD 0062 -> 0061 05AE 0300 1DDD 0315 0062';
ok Uni.new(0x0061, 0x1DDD, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DDD, 0x0300, 0x0315, 0x0062,), '0061 1DDD 0315 0300 05AE 0062 -> 0061 05AE 1DDD 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DDE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DDE, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DDE 0062 -> 0061 05AE 0300 1DDE 0315 0062';
ok Uni.new(0x0061, 0x1DDE, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DDE, 0x0300, 0x0315, 0x0062,), '0061 1DDE 0315 0300 05AE 0062 -> 0061 05AE 1DDE 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DDF, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DDF, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DDF 0062 -> 0061 05AE 0300 1DDF 0315 0062';
ok Uni.new(0x0061, 0x1DDF, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DDF, 0x0300, 0x0315, 0x0062,), '0061 1DDF 0315 0300 05AE 0062 -> 0061 05AE 1DDF 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE0, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DE0, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DE0 0062 -> 0061 05AE 0300 1DE0 0315 0062';
ok Uni.new(0x0061, 0x1DE0, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DE0, 0x0300, 0x0315, 0x0062,), '0061 1DE0 0315 0300 05AE 0062 -> 0061 05AE 1DE0 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE1, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DE1, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DE1 0062 -> 0061 05AE 0300 1DE1 0315 0062';
ok Uni.new(0x0061, 0x1DE1, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DE1, 0x0300, 0x0315, 0x0062,), '0061 1DE1 0315 0300 05AE 0062 -> 0061 05AE 1DE1 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE2, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DE2, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DE2 0062 -> 0061 05AE 0300 1DE2 0315 0062';
ok Uni.new(0x0061, 0x1DE2, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DE2, 0x0300, 0x0315, 0x0062,), '0061 1DE2 0315 0300 05AE 0062 -> 0061 05AE 1DE2 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE3, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DE3, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DE3 0062 -> 0061 05AE 0300 1DE3 0315 0062';
ok Uni.new(0x0061, 0x1DE3, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DE3, 0x0300, 0x0315, 0x0062,), '0061 1DE3 0315 0300 05AE 0062 -> 0061 05AE 1DE3 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE4, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DE4, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DE4 0062 -> 0061 05AE 0300 1DE4 0315 0062';
ok Uni.new(0x0061, 0x1DE4, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DE4, 0x0300, 0x0315, 0x0062,), '0061 1DE4 0315 0300 05AE 0062 -> 0061 05AE 1DE4 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE5, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DE5, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DE5 0062 -> 0061 05AE 0300 1DE5 0315 0062';
ok Uni.new(0x0061, 0x1DE5, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DE5, 0x0300, 0x0315, 0x0062,), '0061 1DE5 0315 0300 05AE 0062 -> 0061 05AE 1DE5 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE6, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DE6, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DE6 0062 -> 0061 05AE 0300 1DE6 0315 0062';
ok Uni.new(0x0061, 0x1DE6, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DE6, 0x0300, 0x0315, 0x0062,), '0061 1DE6 0315 0300 05AE 0062 -> 0061 05AE 1DE6 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE7, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DE7, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DE7 0062 -> 0061 05AE 0300 1DE7 0315 0062';
ok Uni.new(0x0061, 0x1DE7, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DE7, 0x0300, 0x0315, 0x0062,), '0061 1DE7 0315 0300 05AE 0062 -> 0061 05AE 1DE7 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE8, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DE8, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DE8 0062 -> 0061 05AE 0300 1DE8 0315 0062';
ok Uni.new(0x0061, 0x1DE8, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DE8, 0x0300, 0x0315, 0x0062,), '0061 1DE8 0315 0300 05AE 0062 -> 0061 05AE 1DE8 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DE9, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DE9, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DE9 0062 -> 0061 05AE 0300 1DE9 0315 0062';
ok Uni.new(0x0061, 0x1DE9, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DE9, 0x0300, 0x0315, 0x0062,), '0061 1DE9 0315 0300 05AE 0062 -> 0061 05AE 1DE9 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DEA, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DEA, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DEA 0062 -> 0061 05AE 0300 1DEA 0315 0062';
ok Uni.new(0x0061, 0x1DEA, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DEA, 0x0300, 0x0315, 0x0062,), '0061 1DEA 0315 0300 05AE 0062 -> 0061 05AE 1DEA 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DEB, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DEB, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DEB 0062 -> 0061 05AE 0300 1DEB 0315 0062';
ok Uni.new(0x0061, 0x1DEB, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DEB, 0x0300, 0x0315, 0x0062,), '0061 1DEB 0315 0300 05AE 0062 -> 0061 05AE 1DEB 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DEC, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DEC, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DEC 0062 -> 0061 05AE 0300 1DEC 0315 0062';
ok Uni.new(0x0061, 0x1DEC, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DEC, 0x0300, 0x0315, 0x0062,), '0061 1DEC 0315 0300 05AE 0062 -> 0061 05AE 1DEC 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DED, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DED, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DED 0062 -> 0061 05AE 0300 1DED 0315 0062';
ok Uni.new(0x0061, 0x1DED, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DED, 0x0300, 0x0315, 0x0062,), '0061 1DED 0315 0300 05AE 0062 -> 0061 05AE 1DED 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DEE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DEE, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DEE 0062 -> 0061 05AE 0300 1DEE 0315 0062';
ok Uni.new(0x0061, 0x1DEE, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DEE, 0x0300, 0x0315, 0x0062,), '0061 1DEE 0315 0300 05AE 0062 -> 0061 05AE 1DEE 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DEF, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DEF, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DEF 0062 -> 0061 05AE 0300 1DEF 0315 0062';
ok Uni.new(0x0061, 0x1DEF, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DEF, 0x0300, 0x0315, 0x0062,), '0061 1DEF 0315 0300 05AE 0062 -> 0061 05AE 1DEF 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DF0, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DF0, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DF0 0062 -> 0061 05AE 0300 1DF0 0315 0062';
ok Uni.new(0x0061, 0x1DF0, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DF0, 0x0300, 0x0315, 0x0062,), '0061 1DF0 0315 0300 05AE 0062 -> 0061 05AE 1DF0 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DF1, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DF1, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DF1 0062 -> 0061 05AE 0300 1DF1 0315 0062';
ok Uni.new(0x0061, 0x1DF1, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DF1, 0x0300, 0x0315, 0x0062,), '0061 1DF1 0315 0300 05AE 0062 -> 0061 05AE 1DF1 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DF2, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DF2, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DF2 0062 -> 0061 05AE 0300 1DF2 0315 0062';
ok Uni.new(0x0061, 0x1DF2, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DF2, 0x0300, 0x0315, 0x0062,), '0061 1DF2 0315 0300 05AE 0062 -> 0061 05AE 1DF2 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DF3, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DF3, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DF3 0062 -> 0061 05AE 0300 1DF3 0315 0062';
ok Uni.new(0x0061, 0x1DF3, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DF3, 0x0300, 0x0315, 0x0062,), '0061 1DF3 0315 0300 05AE 0062 -> 0061 05AE 1DF3 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DF4, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DF4, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DF4 0062 -> 0061 05AE 0300 1DF4 0315 0062';
ok Uni.new(0x0061, 0x1DF4, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DF4, 0x0300, 0x0315, 0x0062,), '0061 1DF4 0315 0300 05AE 0062 -> 0061 05AE 1DF4 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DF5, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DF5, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DF5 0062 -> 0061 05AE 0300 1DF5 0315 0062';
ok Uni.new(0x0061, 0x1DF5, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DF5, 0x0300, 0x0315, 0x0062,), '0061 1DF5 0315 0300 05AE 0062 -> 0061 05AE 1DF5 0300 0315 0062';
ok Uni.new(0x0061, 0x035C, 0x0315, 0x0300, 0x1DF6, 0x0062).NFD.list ~~ (0x0061, 0x0300, 0x0315, 0x1DF6, 0x035C, 0x0062,), '0061 035C 0315 0300 1DF6 0062 -> 0061 0300 0315 1DF6 035C 0062';
ok Uni.new(0x0061, 0x1DF6, 0x035C, 0x0315, 0x0300, 0x0062).NFD.list ~~ (0x0061, 0x0300, 0x1DF6, 0x0315, 0x035C, 0x0062,), '0061 1DF6 035C 0315 0300 0062 -> 0061 0300 1DF6 0315 035C 0062';
ok Uni.new(0x0061, 0x0300, 0x05AE, 0x1D16D, 0x1DF7, 0x0062).NFD.list ~~ (0x0061, 0x1D16D, 0x05AE, 0x1DF7, 0x0300, 0x0062,), '0061 0300 05AE 1D16D 1DF7 0062 -> 0061 1D16D 05AE 1DF7 0300 0062';
ok Uni.new(0x0061, 0x1DF7, 0x0300, 0x05AE, 0x1D16D, 0x0062).NFD.list ~~ (0x0061, 0x1D16D, 0x1DF7, 0x05AE, 0x0300, 0x0062,), '0061 1DF7 0300 05AE 1D16D 0062 -> 0061 1D16D 1DF7 05AE 0300 0062';
ok Uni.new(0x0061, 0x0300, 0x05AE, 0x1D16D, 0x1DF8, 0x0062).NFD.list ~~ (0x0061, 0x1D16D, 0x05AE, 0x1DF8, 0x0300, 0x0062,), '0061 0300 05AE 1D16D 1DF8 0062 -> 0061 1D16D 05AE 1DF8 0300 0062';
ok Uni.new(0x0061, 0x1DF8, 0x0300, 0x05AE, 0x1D16D, 0x0062).NFD.list ~~ (0x0061, 0x1D16D, 0x1DF8, 0x05AE, 0x0300, 0x0062,), '0061 1DF8 0300 05AE 1D16D 0062 -> 0061 1D16D 1DF8 05AE 0300 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1DF9, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1DF9, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1DF9 0062 -> 0061 1DFA 0316 1DF9 059A 0062';
ok Uni.new(0x0061, 0x1DF9, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1DF9, 0x0316, 0x059A, 0x0062,), '0061 1DF9 059A 0316 1DFA 0062 -> 0061 1DFA 1DF9 0316 059A 0062';
ok Uni.new(0x0061, 0x0316, 0x1DFA, 0x031B, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x031B, 0x1DFA, 0x1DFA, 0x0316, 0x0062,), '0061 0316 1DFA 031B 1DFA 0062 -> 0061 031B 1DFA 1DFA 0316 0062';
ok Uni.new(0x0061, 0x1DFA, 0x0316, 0x1DFA, 0x031B, 0x0062).NFD.list ~~ (0x0061, 0x031B, 0x1DFA, 0x1DFA, 0x0316, 0x0062,), '0061 1DFA 0316 1DFA 031B 0062 -> 0061 031B 1DFA 1DFA 0316 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DFB, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DFB, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DFB 0062 -> 0061 05AE 0300 1DFB 0315 0062';
ok Uni.new(0x0061, 0x1DFB, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DFB, 0x0300, 0x0315, 0x0062,), '0061 1DFB 0315 0300 05AE 0062 -> 0061 05AE 1DFB 0300 0315 0062';
ok Uni.new(0x0061, 0x035D, 0x035C, 0x0315, 0x1DFC, 0x0062).NFD.list ~~ (0x0061, 0x0315, 0x035C, 0x1DFC, 0x035D, 0x0062,), '0061 035D 035C 0315 1DFC 0062 -> 0061 0315 035C 1DFC 035D 0062';
ok Uni.new(0x0061, 0x1DFC, 0x035D, 0x035C, 0x0315, 0x0062).NFD.list ~~ (0x0061, 0x0315, 0x1DFC, 0x035C, 0x035D, 0x0062,), '0061 1DFC 035D 035C 0315 0062 -> 0061 0315 1DFC 035C 035D 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1DFD, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1DFD, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1DFD 0062 -> 0061 1DFA 0316 1DFD 059A 0062';
ok Uni.new(0x0061, 0x1DFD, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1DFD, 0x0316, 0x059A, 0x0062,), '0061 1DFD 059A 0316 1DFA 0062 -> 0061 1DFA 1DFD 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1DFE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1DFE, 0x0315, 0x0062,), '0061 0315 0300 05AE 1DFE 0062 -> 0061 05AE 0300 1DFE 0315 0062';
ok Uni.new(0x0061, 0x1DFE, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1DFE, 0x0300, 0x0315, 0x0062,), '0061 1DFE 0315 0300 05AE 0062 -> 0061 05AE 1DFE 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1DFF, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1DFF, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1DFF 0062 -> 0061 1DFA 0316 1DFF 059A 0062';
ok Uni.new(0x0061, 0x1DFF, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1DFF, 0x0316, 0x059A, 0x0062,), '0061 1DFF 059A 0316 1DFA 0062 -> 0061 1DFA 1DFF 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x20D0, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x20D0, 0x0315, 0x0062,), '0061 0315 0300 05AE 20D0 0062 -> 0061 05AE 0300 20D0 0315 0062';
ok Uni.new(0x0061, 0x20D0, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x20D0, 0x0300, 0x0315, 0x0062,), '0061 20D0 0315 0300 05AE 0062 -> 0061 05AE 20D0 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x20D1, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x20D1, 0x0315, 0x0062,), '0061 0315 0300 05AE 20D1 0062 -> 0061 05AE 0300 20D1 0315 0062';
ok Uni.new(0x0061, 0x20D1, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x20D1, 0x0300, 0x0315, 0x0062,), '0061 20D1 0315 0300 05AE 0062 -> 0061 05AE 20D1 0300 0315 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x20D2, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x20D2, 0x16FF0, 0x0062,), '0061 16FF0 0334 20D2 0062 -> 0061 0334 20D2 16FF0 0062';
ok Uni.new(0x0061, 0x20D2, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x20D2, 0x0334, 0x16FF0, 0x0062,), '0061 20D2 16FF0 0334 0062 -> 0061 20D2 0334 16FF0 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x20D3, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x20D3, 0x16FF0, 0x0062,), '0061 16FF0 0334 20D3 0062 -> 0061 0334 20D3 16FF0 0062';
ok Uni.new(0x0061, 0x20D3, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x20D3, 0x0334, 0x16FF0, 0x0062,), '0061 20D3 16FF0 0334 0062 -> 0061 20D3 0334 16FF0 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x20D4, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x20D4, 0x0315, 0x0062,), '0061 0315 0300 05AE 20D4 0062 -> 0061 05AE 0300 20D4 0315 0062';
ok Uni.new(0x0061, 0x20D4, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x20D4, 0x0300, 0x0315, 0x0062,), '0061 20D4 0315 0300 05AE 0062 -> 0061 05AE 20D4 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x20D5, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x20D5, 0x0315, 0x0062,), '0061 0315 0300 05AE 20D5 0062 -> 0061 05AE 0300 20D5 0315 0062';
ok Uni.new(0x0061, 0x20D5, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x20D5, 0x0300, 0x0315, 0x0062,), '0061 20D5 0315 0300 05AE 0062 -> 0061 05AE 20D5 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x20D6, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x20D6, 0x0315, 0x0062,), '0061 0315 0300 05AE 20D6 0062 -> 0061 05AE 0300 20D6 0315 0062';
ok Uni.new(0x0061, 0x20D6, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x20D6, 0x0300, 0x0315, 0x0062,), '0061 20D6 0315 0300 05AE 0062 -> 0061 05AE 20D6 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x20D7, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x20D7, 0x0315, 0x0062,), '0061 0315 0300 05AE 20D7 0062 -> 0061 05AE 0300 20D7 0315 0062';
ok Uni.new(0x0061, 0x20D7, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x20D7, 0x0300, 0x0315, 0x0062,), '0061 20D7 0315 0300 05AE 0062 -> 0061 05AE 20D7 0300 0315 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x20D8, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x20D8, 0x16FF0, 0x0062,), '0061 16FF0 0334 20D8 0062 -> 0061 0334 20D8 16FF0 0062';
ok Uni.new(0x0061, 0x20D8, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x20D8, 0x0334, 0x16FF0, 0x0062,), '0061 20D8 16FF0 0334 0062 -> 0061 20D8 0334 16FF0 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x20D9, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x20D9, 0x16FF0, 0x0062,), '0061 16FF0 0334 20D9 0062 -> 0061 0334 20D9 16FF0 0062';
ok Uni.new(0x0061, 0x20D9, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x20D9, 0x0334, 0x16FF0, 0x0062,), '0061 20D9 16FF0 0334 0062 -> 0061 20D9 0334 16FF0 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x20DA, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x20DA, 0x16FF0, 0x0062,), '0061 16FF0 0334 20DA 0062 -> 0061 0334 20DA 16FF0 0062';
ok Uni.new(0x0061, 0x20DA, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x20DA, 0x0334, 0x16FF0, 0x0062,), '0061 20DA 16FF0 0334 0062 -> 0061 20DA 0334 16FF0 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x20DB, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x20DB, 0x0315, 0x0062,), '0061 0315 0300 05AE 20DB 0062 -> 0061 05AE 0300 20DB 0315 0062';
ok Uni.new(0x0061, 0x20DB, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x20DB, 0x0300, 0x0315, 0x0062,), '0061 20DB 0315 0300 05AE 0062 -> 0061 05AE 20DB 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x20DC, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x20DC, 0x0315, 0x0062,), '0061 0315 0300 05AE 20DC 0062 -> 0061 05AE 0300 20DC 0315 0062';
ok Uni.new(0x0061, 0x20DC, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x20DC, 0x0300, 0x0315, 0x0062,), '0061 20DC 0315 0300 05AE 0062 -> 0061 05AE 20DC 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x20E1, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x20E1, 0x0315, 0x0062,), '0061 0315 0300 05AE 20E1 0062 -> 0061 05AE 0300 20E1 0315 0062';
ok Uni.new(0x0061, 0x20E1, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x20E1, 0x0300, 0x0315, 0x0062,), '0061 20E1 0315 0300 05AE 0062 -> 0061 05AE 20E1 0300 0315 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x20E5, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x20E5, 0x16FF0, 0x0062,), '0061 16FF0 0334 20E5 0062 -> 0061 0334 20E5 16FF0 0062';
ok Uni.new(0x0061, 0x20E5, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x20E5, 0x0334, 0x16FF0, 0x0062,), '0061 20E5 16FF0 0334 0062 -> 0061 20E5 0334 16FF0 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x20E6, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x20E6, 0x16FF0, 0x0062,), '0061 16FF0 0334 20E6 0062 -> 0061 0334 20E6 16FF0 0062';
ok Uni.new(0x0061, 0x20E6, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x20E6, 0x0334, 0x16FF0, 0x0062,), '0061 20E6 16FF0 0334 0062 -> 0061 20E6 0334 16FF0 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x20E7, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x20E7, 0x0315, 0x0062,), '0061 0315 0300 05AE 20E7 0062 -> 0061 05AE 0300 20E7 0315 0062';
ok Uni.new(0x0061, 0x20E7, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x20E7, 0x0300, 0x0315, 0x0062,), '0061 20E7 0315 0300 05AE 0062 -> 0061 05AE 20E7 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x20E8, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x20E8, 0x059A, 0x0062,), '0061 059A 0316 1DFA 20E8 0062 -> 0061 1DFA 0316 20E8 059A 0062';
ok Uni.new(0x0061, 0x20E8, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x20E8, 0x0316, 0x059A, 0x0062,), '0061 20E8 059A 0316 1DFA 0062 -> 0061 1DFA 20E8 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x20E9, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x20E9, 0x0315, 0x0062,), '0061 0315 0300 05AE 20E9 0062 -> 0061 05AE 0300 20E9 0315 0062';
ok Uni.new(0x0061, 0x20E9, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x20E9, 0x0300, 0x0315, 0x0062,), '0061 20E9 0315 0300 05AE 0062 -> 0061 05AE 20E9 0300 0315 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x20EA, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x20EA, 0x16FF0, 0x0062,), '0061 16FF0 0334 20EA 0062 -> 0061 0334 20EA 16FF0 0062';
ok Uni.new(0x0061, 0x20EA, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x20EA, 0x0334, 0x16FF0, 0x0062,), '0061 20EA 16FF0 0334 0062 -> 0061 20EA 0334 16FF0 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x20EB, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x20EB, 0x16FF0, 0x0062,), '0061 16FF0 0334 20EB 0062 -> 0061 0334 20EB 16FF0 0062';
ok Uni.new(0x0061, 0x20EB, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x20EB, 0x0334, 0x16FF0, 0x0062,), '0061 20EB 16FF0 0334 0062 -> 0061 20EB 0334 16FF0 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x20EC, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x20EC, 0x059A, 0x0062,), '0061 059A 0316 1DFA 20EC 0062 -> 0061 1DFA 0316 20EC 059A 0062';
ok Uni.new(0x0061, 0x20EC, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x20EC, 0x0316, 0x059A, 0x0062,), '0061 20EC 059A 0316 1DFA 0062 -> 0061 1DFA 20EC 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x20ED, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x20ED, 0x059A, 0x0062,), '0061 059A 0316 1DFA 20ED 0062 -> 0061 1DFA 0316 20ED 059A 0062';
ok Uni.new(0x0061, 0x20ED, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x20ED, 0x0316, 0x059A, 0x0062,), '0061 20ED 059A 0316 1DFA 0062 -> 0061 1DFA 20ED 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x20EE, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x20EE, 0x059A, 0x0062,), '0061 059A 0316 1DFA 20EE 0062 -> 0061 1DFA 0316 20EE 059A 0062';
ok Uni.new(0x0061, 0x20EE, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x20EE, 0x0316, 0x059A, 0x0062,), '0061 20EE 059A 0316 1DFA 0062 -> 0061 1DFA 20EE 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x20EF, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x20EF, 0x059A, 0x0062,), '0061 059A 0316 1DFA 20EF 0062 -> 0061 1DFA 0316 20EF 059A 0062';
ok Uni.new(0x0061, 0x20EF, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x20EF, 0x0316, 0x059A, 0x0062,), '0061 20EF 059A 0316 1DFA 0062 -> 0061 1DFA 20EF 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x20F0, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x20F0, 0x0315, 0x0062,), '0061 0315 0300 05AE 20F0 0062 -> 0061 05AE 0300 20F0 0315 0062';
ok Uni.new(0x0061, 0x20F0, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x20F0, 0x0300, 0x0315, 0x0062,), '0061 20F0 0315 0300 05AE 0062 -> 0061 05AE 20F0 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2CEF, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2CEF, 0x0315, 0x0062,), '0061 0315 0300 05AE 2CEF 0062 -> 0061 05AE 0300 2CEF 0315 0062';
ok Uni.new(0x0061, 0x2CEF, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2CEF, 0x0300, 0x0315, 0x0062,), '0061 2CEF 0315 0300 05AE 0062 -> 0061 05AE 2CEF 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2CF0, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2CF0, 0x0315, 0x0062,), '0061 0315 0300 05AE 2CF0 0062 -> 0061 05AE 0300 2CF0 0315 0062';
ok Uni.new(0x0061, 0x2CF0, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2CF0, 0x0300, 0x0315, 0x0062,), '0061 2CF0 0315 0300 05AE 0062 -> 0061 05AE 2CF0 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2CF1, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2CF1, 0x0315, 0x0062,), '0061 0315 0300 05AE 2CF1 0062 -> 0061 05AE 0300 2CF1 0315 0062';
ok Uni.new(0x0061, 0x2CF1, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2CF1, 0x0300, 0x0315, 0x0062,), '0061 2CF1 0315 0300 05AE 0062 -> 0061 05AE 2CF1 0300 0315 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x2D7F, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x2D7F, 0x05B0, 0x0062,), '0061 05B0 094D 3099 2D7F 0062 -> 0061 3099 094D 2D7F 05B0 0062';
ok Uni.new(0x0061, 0x2D7F, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x2D7F, 0x094D, 0x05B0, 0x0062,), '0061 2D7F 05B0 094D 3099 0062 -> 0061 3099 2D7F 094D 05B0 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE0, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DE0, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DE0 0062 -> 0061 05AE 0300 2DE0 0315 0062';
ok Uni.new(0x0061, 0x2DE0, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DE0, 0x0300, 0x0315, 0x0062,), '0061 2DE0 0315 0300 05AE 0062 -> 0061 05AE 2DE0 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE1, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DE1, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DE1 0062 -> 0061 05AE 0300 2DE1 0315 0062';
ok Uni.new(0x0061, 0x2DE1, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DE1, 0x0300, 0x0315, 0x0062,), '0061 2DE1 0315 0300 05AE 0062 -> 0061 05AE 2DE1 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE2, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DE2, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DE2 0062 -> 0061 05AE 0300 2DE2 0315 0062';
ok Uni.new(0x0061, 0x2DE2, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DE2, 0x0300, 0x0315, 0x0062,), '0061 2DE2 0315 0300 05AE 0062 -> 0061 05AE 2DE2 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE3, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DE3, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DE3 0062 -> 0061 05AE 0300 2DE3 0315 0062';
ok Uni.new(0x0061, 0x2DE3, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DE3, 0x0300, 0x0315, 0x0062,), '0061 2DE3 0315 0300 05AE 0062 -> 0061 05AE 2DE3 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE4, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DE4, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DE4 0062 -> 0061 05AE 0300 2DE4 0315 0062';
ok Uni.new(0x0061, 0x2DE4, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DE4, 0x0300, 0x0315, 0x0062,), '0061 2DE4 0315 0300 05AE 0062 -> 0061 05AE 2DE4 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE5, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DE5, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DE5 0062 -> 0061 05AE 0300 2DE5 0315 0062';
ok Uni.new(0x0061, 0x2DE5, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DE5, 0x0300, 0x0315, 0x0062,), '0061 2DE5 0315 0300 05AE 0062 -> 0061 05AE 2DE5 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE6, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DE6, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DE6 0062 -> 0061 05AE 0300 2DE6 0315 0062';
ok Uni.new(0x0061, 0x2DE6, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DE6, 0x0300, 0x0315, 0x0062,), '0061 2DE6 0315 0300 05AE 0062 -> 0061 05AE 2DE6 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE7, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DE7, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DE7 0062 -> 0061 05AE 0300 2DE7 0315 0062';
ok Uni.new(0x0061, 0x2DE7, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DE7, 0x0300, 0x0315, 0x0062,), '0061 2DE7 0315 0300 05AE 0062 -> 0061 05AE 2DE7 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE8, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DE8, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DE8 0062 -> 0061 05AE 0300 2DE8 0315 0062';
ok Uni.new(0x0061, 0x2DE8, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DE8, 0x0300, 0x0315, 0x0062,), '0061 2DE8 0315 0300 05AE 0062 -> 0061 05AE 2DE8 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DE9, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DE9, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DE9 0062 -> 0061 05AE 0300 2DE9 0315 0062';
ok Uni.new(0x0061, 0x2DE9, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DE9, 0x0300, 0x0315, 0x0062,), '0061 2DE9 0315 0300 05AE 0062 -> 0061 05AE 2DE9 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DEA, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DEA, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DEA 0062 -> 0061 05AE 0300 2DEA 0315 0062';
ok Uni.new(0x0061, 0x2DEA, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DEA, 0x0300, 0x0315, 0x0062,), '0061 2DEA 0315 0300 05AE 0062 -> 0061 05AE 2DEA 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DEB, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DEB, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DEB 0062 -> 0061 05AE 0300 2DEB 0315 0062';
ok Uni.new(0x0061, 0x2DEB, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DEB, 0x0300, 0x0315, 0x0062,), '0061 2DEB 0315 0300 05AE 0062 -> 0061 05AE 2DEB 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DEC, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DEC, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DEC 0062 -> 0061 05AE 0300 2DEC 0315 0062';
ok Uni.new(0x0061, 0x2DEC, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DEC, 0x0300, 0x0315, 0x0062,), '0061 2DEC 0315 0300 05AE 0062 -> 0061 05AE 2DEC 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DED, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DED, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DED 0062 -> 0061 05AE 0300 2DED 0315 0062';
ok Uni.new(0x0061, 0x2DED, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DED, 0x0300, 0x0315, 0x0062,), '0061 2DED 0315 0300 05AE 0062 -> 0061 05AE 2DED 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DEE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DEE, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DEE 0062 -> 0061 05AE 0300 2DEE 0315 0062';
ok Uni.new(0x0061, 0x2DEE, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DEE, 0x0300, 0x0315, 0x0062,), '0061 2DEE 0315 0300 05AE 0062 -> 0061 05AE 2DEE 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DEF, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DEF, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DEF 0062 -> 0061 05AE 0300 2DEF 0315 0062';
ok Uni.new(0x0061, 0x2DEF, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DEF, 0x0300, 0x0315, 0x0062,), '0061 2DEF 0315 0300 05AE 0062 -> 0061 05AE 2DEF 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF0, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DF0, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DF0 0062 -> 0061 05AE 0300 2DF0 0315 0062';
ok Uni.new(0x0061, 0x2DF0, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DF0, 0x0300, 0x0315, 0x0062,), '0061 2DF0 0315 0300 05AE 0062 -> 0061 05AE 2DF0 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF1, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DF1, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DF1 0062 -> 0061 05AE 0300 2DF1 0315 0062';
ok Uni.new(0x0061, 0x2DF1, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DF1, 0x0300, 0x0315, 0x0062,), '0061 2DF1 0315 0300 05AE 0062 -> 0061 05AE 2DF1 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF2, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DF2, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DF2 0062 -> 0061 05AE 0300 2DF2 0315 0062';
ok Uni.new(0x0061, 0x2DF2, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DF2, 0x0300, 0x0315, 0x0062,), '0061 2DF2 0315 0300 05AE 0062 -> 0061 05AE 2DF2 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF3, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DF3, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DF3 0062 -> 0061 05AE 0300 2DF3 0315 0062';
ok Uni.new(0x0061, 0x2DF3, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DF3, 0x0300, 0x0315, 0x0062,), '0061 2DF3 0315 0300 05AE 0062 -> 0061 05AE 2DF3 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF4, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DF4, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DF4 0062 -> 0061 05AE 0300 2DF4 0315 0062';
ok Uni.new(0x0061, 0x2DF4, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DF4, 0x0300, 0x0315, 0x0062,), '0061 2DF4 0315 0300 05AE 0062 -> 0061 05AE 2DF4 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF5, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DF5, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DF5 0062 -> 0061 05AE 0300 2DF5 0315 0062';
ok Uni.new(0x0061, 0x2DF5, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DF5, 0x0300, 0x0315, 0x0062,), '0061 2DF5 0315 0300 05AE 0062 -> 0061 05AE 2DF5 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF6, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DF6, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DF6 0062 -> 0061 05AE 0300 2DF6 0315 0062';
ok Uni.new(0x0061, 0x2DF6, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DF6, 0x0300, 0x0315, 0x0062,), '0061 2DF6 0315 0300 05AE 0062 -> 0061 05AE 2DF6 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF7, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DF7, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DF7 0062 -> 0061 05AE 0300 2DF7 0315 0062';
ok Uni.new(0x0061, 0x2DF7, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DF7, 0x0300, 0x0315, 0x0062,), '0061 2DF7 0315 0300 05AE 0062 -> 0061 05AE 2DF7 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF8, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DF8, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DF8 0062 -> 0061 05AE 0300 2DF8 0315 0062';
ok Uni.new(0x0061, 0x2DF8, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DF8, 0x0300, 0x0315, 0x0062,), '0061 2DF8 0315 0300 05AE 0062 -> 0061 05AE 2DF8 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DF9, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DF9, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DF9 0062 -> 0061 05AE 0300 2DF9 0315 0062';
ok Uni.new(0x0061, 0x2DF9, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DF9, 0x0300, 0x0315, 0x0062,), '0061 2DF9 0315 0300 05AE 0062 -> 0061 05AE 2DF9 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DFA, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DFA, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DFA 0062 -> 0061 05AE 0300 2DFA 0315 0062';
ok Uni.new(0x0061, 0x2DFA, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DFA, 0x0300, 0x0315, 0x0062,), '0061 2DFA 0315 0300 05AE 0062 -> 0061 05AE 2DFA 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DFB, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DFB, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DFB 0062 -> 0061 05AE 0300 2DFB 0315 0062';
ok Uni.new(0x0061, 0x2DFB, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DFB, 0x0300, 0x0315, 0x0062,), '0061 2DFB 0315 0300 05AE 0062 -> 0061 05AE 2DFB 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DFC, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DFC, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DFC 0062 -> 0061 05AE 0300 2DFC 0315 0062';
ok Uni.new(0x0061, 0x2DFC, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DFC, 0x0300, 0x0315, 0x0062,), '0061 2DFC 0315 0300 05AE 0062 -> 0061 05AE 2DFC 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DFD, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DFD, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DFD 0062 -> 0061 05AE 0300 2DFD 0315 0062';
ok Uni.new(0x0061, 0x2DFD, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DFD, 0x0300, 0x0315, 0x0062,), '0061 2DFD 0315 0300 05AE 0062 -> 0061 05AE 2DFD 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DFE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DFE, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DFE 0062 -> 0061 05AE 0300 2DFE 0315 0062';
ok Uni.new(0x0061, 0x2DFE, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DFE, 0x0300, 0x0315, 0x0062,), '0061 2DFE 0315 0300 05AE 0062 -> 0061 05AE 2DFE 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x2DFF, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x2DFF, 0x0315, 0x0062,), '0061 0315 0300 05AE 2DFF 0062 -> 0061 05AE 0300 2DFF 0315 0062';
ok Uni.new(0x0061, 0x2DFF, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x2DFF, 0x0300, 0x0315, 0x0062,), '0061 2DFF 0315 0300 05AE 0062 -> 0061 05AE 2DFF 0300 0315 0062';
ok Uni.new(0x0061, 0x0316, 0x1DFA, 0x031B, 0x302A, 0x0062).NFD.list ~~ (0x0061, 0x031B, 0x1DFA, 0x302A, 0x0316, 0x0062,), '0061 0316 1DFA 031B 302A 0062 -> 0061 031B 1DFA 302A 0316 0062';
ok Uni.new(0x0061, 0x302A, 0x0316, 0x1DFA, 0x031B, 0x0062).NFD.list ~~ (0x0061, 0x031B, 0x302A, 0x1DFA, 0x0316, 0x0062,), '0061 302A 0316 1DFA 031B 0062 -> 0061 031B 302A 1DFA 0316 0062';
ok Uni.new(0x0061, 0x0300, 0x05AE, 0x1D16D, 0x302B, 0x0062).NFD.list ~~ (0x0061, 0x1D16D, 0x05AE, 0x302B, 0x0300, 0x0062,), '0061 0300 05AE 1D16D 302B 0062 -> 0061 1D16D 05AE 302B 0300 0062';
ok Uni.new(0x0061, 0x302B, 0x0300, 0x05AE, 0x1D16D, 0x0062).NFD.list ~~ (0x0061, 0x1D16D, 0x302B, 0x05AE, 0x0300, 0x0062,), '0061 302B 0300 05AE 1D16D 0062 -> 0061 1D16D 302B 05AE 0300 0062';
ok Uni.new(0x0061, 0x035C, 0x0315, 0x0300, 0x302C, 0x0062).NFD.list ~~ (0x0061, 0x0300, 0x0315, 0x302C, 0x035C, 0x0062,), '0061 035C 0315 0300 302C 0062 -> 0061 0300 0315 302C 035C 0062';
ok Uni.new(0x0061, 0x302C, 0x035C, 0x0315, 0x0300, 0x0062).NFD.list ~~ (0x0061, 0x0300, 0x302C, 0x0315, 0x035C, 0x0062,), '0061 302C 035C 0315 0300 0062 -> 0061 0300 302C 0315 035C 0062';
ok Uni.new(0x0061, 0x302E, 0x059A, 0x0316, 0x302D, 0x0062).NFD.list ~~ (0x0061, 0x0316, 0x059A, 0x302D, 0x302E, 0x0062,), '0061 302E 059A 0316 302D 0062 -> 0061 0316 059A 302D 302E 0062';
ok Uni.new(0x0061, 0x302D, 0x302E, 0x059A, 0x0316, 0x0062).NFD.list ~~ (0x0061, 0x0316, 0x302D, 0x059A, 0x302E, 0x0062,), '0061 302D 302E 059A 0316 0062 -> 0061 0316 302D 059A 302E 0062';
ok Uni.new(0x0061, 0x1D16D, 0x302E, 0x059A, 0x302E, 0x0062).NFD.list ~~ (0x0061, 0x059A, 0x302E, 0x302E, 0x1D16D, 0x0062,), '0061 1D16D 302E 059A 302E 0062 -> 0061 059A 302E 302E 1D16D 0062';
ok Uni.new(0x0061, 0x302E, 0x1D16D, 0x302E, 0x059A, 0x0062).NFD.list ~~ (0x0061, 0x059A, 0x302E, 0x302E, 0x1D16D, 0x0062,), '0061 302E 1D16D 302E 059A 0062 -> 0061 059A 302E 302E 1D16D 0062';
ok Uni.new(0x0061, 0x1D16D, 0x302E, 0x059A, 0x302F, 0x0062).NFD.list ~~ (0x0061, 0x059A, 0x302E, 0x302F, 0x1D16D, 0x0062,), '0061 1D16D 302E 059A 302F 0062 -> 0061 059A 302E 302F 1D16D 0062';
ok Uni.new(0x0061, 0x302F, 0x1D16D, 0x302E, 0x059A, 0x0062).NFD.list ~~ (0x0061, 0x059A, 0x302F, 0x302E, 0x1D16D, 0x0062,), '0061 302F 1D16D 302E 059A 0062 -> 0061 059A 302F 302E 1D16D 0062';
ok Uni.new(0x0061, 0x094D, 0x3099, 0x093C, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x093C, 0x3099, 0x3099, 0x094D, 0x0062,), '0061 094D 3099 093C 3099 0062 -> 0061 093C 3099 3099 094D 0062';
ok Uni.new(0x0061, 0x3099, 0x094D, 0x3099, 0x093C, 0x0062).NFD.list ~~ (0x0061, 0x093C, 0x3099, 0x3099, 0x094D, 0x0062,), '0061 3099 094D 3099 093C 0062 -> 0061 093C 3099 3099 094D 0062';
ok Uni.new(0x0061, 0x094D, 0x3099, 0x093C, 0x309A, 0x0062).NFD.list ~~ (0x0061, 0x093C, 0x3099, 0x309A, 0x094D, 0x0062,), '0061 094D 3099 093C 309A 0062 -> 0061 093C 3099 309A 094D 0062';
ok Uni.new(0x0061, 0x309A, 0x094D, 0x3099, 0x093C, 0x0062).NFD.list ~~ (0x0061, 0x093C, 0x309A, 0x3099, 0x094D, 0x0062,), '0061 309A 094D 3099 093C 0062 -> 0061 093C 309A 3099 094D 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA66F, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA66F, 0x0315, 0x0062,), '0061 0315 0300 05AE A66F 0062 -> 0061 05AE 0300 A66F 0315 0062';
ok Uni.new(0x0061, 0xA66F, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA66F, 0x0300, 0x0315, 0x0062,), '0061 A66F 0315 0300 05AE 0062 -> 0061 05AE A66F 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA674, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA674, 0x0315, 0x0062,), '0061 0315 0300 05AE A674 0062 -> 0061 05AE 0300 A674 0315 0062';
ok Uni.new(0x0061, 0xA674, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA674, 0x0300, 0x0315, 0x0062,), '0061 A674 0315 0300 05AE 0062 -> 0061 05AE A674 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA675, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA675, 0x0315, 0x0062,), '0061 0315 0300 05AE A675 0062 -> 0061 05AE 0300 A675 0315 0062';
ok Uni.new(0x0061, 0xA675, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA675, 0x0300, 0x0315, 0x0062,), '0061 A675 0315 0300 05AE 0062 -> 0061 05AE A675 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA676, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA676, 0x0315, 0x0062,), '0061 0315 0300 05AE A676 0062 -> 0061 05AE 0300 A676 0315 0062';
ok Uni.new(0x0061, 0xA676, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA676, 0x0300, 0x0315, 0x0062,), '0061 A676 0315 0300 05AE 0062 -> 0061 05AE A676 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA677, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA677, 0x0315, 0x0062,), '0061 0315 0300 05AE A677 0062 -> 0061 05AE 0300 A677 0315 0062';
ok Uni.new(0x0061, 0xA677, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA677, 0x0300, 0x0315, 0x0062,), '0061 A677 0315 0300 05AE 0062 -> 0061 05AE A677 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA678, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA678, 0x0315, 0x0062,), '0061 0315 0300 05AE A678 0062 -> 0061 05AE 0300 A678 0315 0062';
ok Uni.new(0x0061, 0xA678, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA678, 0x0300, 0x0315, 0x0062,), '0061 A678 0315 0300 05AE 0062 -> 0061 05AE A678 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA679, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA679, 0x0315, 0x0062,), '0061 0315 0300 05AE A679 0062 -> 0061 05AE 0300 A679 0315 0062';
ok Uni.new(0x0061, 0xA679, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA679, 0x0300, 0x0315, 0x0062,), '0061 A679 0315 0300 05AE 0062 -> 0061 05AE A679 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA67A, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA67A, 0x0315, 0x0062,), '0061 0315 0300 05AE A67A 0062 -> 0061 05AE 0300 A67A 0315 0062';
ok Uni.new(0x0061, 0xA67A, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA67A, 0x0300, 0x0315, 0x0062,), '0061 A67A 0315 0300 05AE 0062 -> 0061 05AE A67A 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA67B, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA67B, 0x0315, 0x0062,), '0061 0315 0300 05AE A67B 0062 -> 0061 05AE 0300 A67B 0315 0062';
ok Uni.new(0x0061, 0xA67B, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA67B, 0x0300, 0x0315, 0x0062,), '0061 A67B 0315 0300 05AE 0062 -> 0061 05AE A67B 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA67C, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA67C, 0x0315, 0x0062,), '0061 0315 0300 05AE A67C 0062 -> 0061 05AE 0300 A67C 0315 0062';
ok Uni.new(0x0061, 0xA67C, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA67C, 0x0300, 0x0315, 0x0062,), '0061 A67C 0315 0300 05AE 0062 -> 0061 05AE A67C 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA67D, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA67D, 0x0315, 0x0062,), '0061 0315 0300 05AE A67D 0062 -> 0061 05AE 0300 A67D 0315 0062';
ok Uni.new(0x0061, 0xA67D, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA67D, 0x0300, 0x0315, 0x0062,), '0061 A67D 0315 0300 05AE 0062 -> 0061 05AE A67D 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA69E, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA69E, 0x0315, 0x0062,), '0061 0315 0300 05AE A69E 0062 -> 0061 05AE 0300 A69E 0315 0062';
ok Uni.new(0x0061, 0xA69E, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA69E, 0x0300, 0x0315, 0x0062,), '0061 A69E 0315 0300 05AE 0062 -> 0061 05AE A69E 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA69F, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA69F, 0x0315, 0x0062,), '0061 0315 0300 05AE A69F 0062 -> 0061 05AE 0300 A69F 0315 0062';
ok Uni.new(0x0061, 0xA69F, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA69F, 0x0300, 0x0315, 0x0062,), '0061 A69F 0315 0300 05AE 0062 -> 0061 05AE A69F 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA6F0, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA6F0, 0x0315, 0x0062,), '0061 0315 0300 05AE A6F0 0062 -> 0061 05AE 0300 A6F0 0315 0062';
ok Uni.new(0x0061, 0xA6F0, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA6F0, 0x0300, 0x0315, 0x0062,), '0061 A6F0 0315 0300 05AE 0062 -> 0061 05AE A6F0 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA6F1, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA6F1, 0x0315, 0x0062,), '0061 0315 0300 05AE A6F1 0062 -> 0061 05AE 0300 A6F1 0315 0062';
ok Uni.new(0x0061, 0xA6F1, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA6F1, 0x0300, 0x0315, 0x0062,), '0061 A6F1 0315 0300 05AE 0062 -> 0061 05AE A6F1 0300 0315 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0xA806, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0xA806, 0x05B0, 0x0062,), '0061 05B0 094D 3099 A806 0062 -> 0061 3099 094D A806 05B0 0062';
ok Uni.new(0x0061, 0xA806, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0xA806, 0x094D, 0x05B0, 0x0062,), '0061 A806 05B0 094D 3099 0062 -> 0061 3099 A806 094D 05B0 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0xA82C, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0xA82C, 0x05B0, 0x0062,), '0061 05B0 094D 3099 A82C 0062 -> 0061 3099 094D A82C 05B0 0062';
ok Uni.new(0x0061, 0xA82C, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0xA82C, 0x094D, 0x05B0, 0x0062,), '0061 A82C 05B0 094D 3099 0062 -> 0061 3099 A82C 094D 05B0 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0xA8C4, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0xA8C4, 0x05B0, 0x0062,), '0061 05B0 094D 3099 A8C4 0062 -> 0061 3099 094D A8C4 05B0 0062';
ok Uni.new(0x0061, 0xA8C4, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0xA8C4, 0x094D, 0x05B0, 0x0062,), '0061 A8C4 05B0 094D 3099 0062 -> 0061 3099 A8C4 094D 05B0 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E0, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA8E0, 0x0315, 0x0062,), '0061 0315 0300 05AE A8E0 0062 -> 0061 05AE 0300 A8E0 0315 0062';
ok Uni.new(0x0061, 0xA8E0, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA8E0, 0x0300, 0x0315, 0x0062,), '0061 A8E0 0315 0300 05AE 0062 -> 0061 05AE A8E0 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E1, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA8E1, 0x0315, 0x0062,), '0061 0315 0300 05AE A8E1 0062 -> 0061 05AE 0300 A8E1 0315 0062';
ok Uni.new(0x0061, 0xA8E1, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA8E1, 0x0300, 0x0315, 0x0062,), '0061 A8E1 0315 0300 05AE 0062 -> 0061 05AE A8E1 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E2, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA8E2, 0x0315, 0x0062,), '0061 0315 0300 05AE A8E2 0062 -> 0061 05AE 0300 A8E2 0315 0062';
ok Uni.new(0x0061, 0xA8E2, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA8E2, 0x0300, 0x0315, 0x0062,), '0061 A8E2 0315 0300 05AE 0062 -> 0061 05AE A8E2 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E3, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA8E3, 0x0315, 0x0062,), '0061 0315 0300 05AE A8E3 0062 -> 0061 05AE 0300 A8E3 0315 0062';
ok Uni.new(0x0061, 0xA8E3, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA8E3, 0x0300, 0x0315, 0x0062,), '0061 A8E3 0315 0300 05AE 0062 -> 0061 05AE A8E3 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E4, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA8E4, 0x0315, 0x0062,), '0061 0315 0300 05AE A8E4 0062 -> 0061 05AE 0300 A8E4 0315 0062';
ok Uni.new(0x0061, 0xA8E4, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA8E4, 0x0300, 0x0315, 0x0062,), '0061 A8E4 0315 0300 05AE 0062 -> 0061 05AE A8E4 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E5, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA8E5, 0x0315, 0x0062,), '0061 0315 0300 05AE A8E5 0062 -> 0061 05AE 0300 A8E5 0315 0062';
ok Uni.new(0x0061, 0xA8E5, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA8E5, 0x0300, 0x0315, 0x0062,), '0061 A8E5 0315 0300 05AE 0062 -> 0061 05AE A8E5 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E6, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA8E6, 0x0315, 0x0062,), '0061 0315 0300 05AE A8E6 0062 -> 0061 05AE 0300 A8E6 0315 0062';
ok Uni.new(0x0061, 0xA8E6, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA8E6, 0x0300, 0x0315, 0x0062,), '0061 A8E6 0315 0300 05AE 0062 -> 0061 05AE A8E6 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E7, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA8E7, 0x0315, 0x0062,), '0061 0315 0300 05AE A8E7 0062 -> 0061 05AE 0300 A8E7 0315 0062';
ok Uni.new(0x0061, 0xA8E7, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA8E7, 0x0300, 0x0315, 0x0062,), '0061 A8E7 0315 0300 05AE 0062 -> 0061 05AE A8E7 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E8, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA8E8, 0x0315, 0x0062,), '0061 0315 0300 05AE A8E8 0062 -> 0061 05AE 0300 A8E8 0315 0062';
ok Uni.new(0x0061, 0xA8E8, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA8E8, 0x0300, 0x0315, 0x0062,), '0061 A8E8 0315 0300 05AE 0062 -> 0061 05AE A8E8 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA8E9, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA8E9, 0x0315, 0x0062,), '0061 0315 0300 05AE A8E9 0062 -> 0061 05AE 0300 A8E9 0315 0062';
ok Uni.new(0x0061, 0xA8E9, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA8E9, 0x0300, 0x0315, 0x0062,), '0061 A8E9 0315 0300 05AE 0062 -> 0061 05AE A8E9 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA8EA, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA8EA, 0x0315, 0x0062,), '0061 0315 0300 05AE A8EA 0062 -> 0061 05AE 0300 A8EA 0315 0062';
ok Uni.new(0x0061, 0xA8EA, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA8EA, 0x0300, 0x0315, 0x0062,), '0061 A8EA 0315 0300 05AE 0062 -> 0061 05AE A8EA 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA8EB, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA8EB, 0x0315, 0x0062,), '0061 0315 0300 05AE A8EB 0062 -> 0061 05AE 0300 A8EB 0315 0062';
ok Uni.new(0x0061, 0xA8EB, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA8EB, 0x0300, 0x0315, 0x0062,), '0061 A8EB 0315 0300 05AE 0062 -> 0061 05AE A8EB 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA8EC, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA8EC, 0x0315, 0x0062,), '0061 0315 0300 05AE A8EC 0062 -> 0061 05AE 0300 A8EC 0315 0062';
ok Uni.new(0x0061, 0xA8EC, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA8EC, 0x0300, 0x0315, 0x0062,), '0061 A8EC 0315 0300 05AE 0062 -> 0061 05AE A8EC 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA8ED, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA8ED, 0x0315, 0x0062,), '0061 0315 0300 05AE A8ED 0062 -> 0061 05AE 0300 A8ED 0315 0062';
ok Uni.new(0x0061, 0xA8ED, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA8ED, 0x0300, 0x0315, 0x0062,), '0061 A8ED 0315 0300 05AE 0062 -> 0061 05AE A8ED 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA8EE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA8EE, 0x0315, 0x0062,), '0061 0315 0300 05AE A8EE 0062 -> 0061 05AE 0300 A8EE 0315 0062';
ok Uni.new(0x0061, 0xA8EE, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA8EE, 0x0300, 0x0315, 0x0062,), '0061 A8EE 0315 0300 05AE 0062 -> 0061 05AE A8EE 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA8EF, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA8EF, 0x0315, 0x0062,), '0061 0315 0300 05AE A8EF 0062 -> 0061 05AE 0300 A8EF 0315 0062';
ok Uni.new(0x0061, 0xA8EF, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA8EF, 0x0300, 0x0315, 0x0062,), '0061 A8EF 0315 0300 05AE 0062 -> 0061 05AE A8EF 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA8F0, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA8F0, 0x0315, 0x0062,), '0061 0315 0300 05AE A8F0 0062 -> 0061 05AE 0300 A8F0 0315 0062';
ok Uni.new(0x0061, 0xA8F0, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA8F0, 0x0300, 0x0315, 0x0062,), '0061 A8F0 0315 0300 05AE 0062 -> 0061 05AE A8F0 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xA8F1, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xA8F1, 0x0315, 0x0062,), '0061 0315 0300 05AE A8F1 0062 -> 0061 05AE 0300 A8F1 0315 0062';
ok Uni.new(0x0061, 0xA8F1, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xA8F1, 0x0300, 0x0315, 0x0062,), '0061 A8F1 0315 0300 05AE 0062 -> 0061 05AE A8F1 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0xA92B, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0xA92B, 0x059A, 0x0062,), '0061 059A 0316 1DFA A92B 0062 -> 0061 1DFA 0316 A92B 059A 0062';
ok Uni.new(0x0061, 0xA92B, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0xA92B, 0x0316, 0x059A, 0x0062,), '0061 A92B 059A 0316 1DFA 0062 -> 0061 1DFA A92B 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0xA92C, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0xA92C, 0x059A, 0x0062,), '0061 059A 0316 1DFA A92C 0062 -> 0061 1DFA 0316 A92C 059A 0062';
ok Uni.new(0x0061, 0xA92C, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0xA92C, 0x0316, 0x059A, 0x0062,), '0061 A92C 059A 0316 1DFA 0062 -> 0061 1DFA A92C 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0xA92D, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0xA92D, 0x059A, 0x0062,), '0061 059A 0316 1DFA A92D 0062 -> 0061 1DFA 0316 A92D 059A 0062';
ok Uni.new(0x0061, 0xA92D, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0xA92D, 0x0316, 0x059A, 0x0062,), '0061 A92D 059A 0316 1DFA 0062 -> 0061 1DFA A92D 0316 059A 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0xA953, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0xA953, 0x05B0, 0x0062,), '0061 05B0 094D 3099 A953 0062 -> 0061 3099 094D A953 05B0 0062';
ok Uni.new(0x0061, 0xA953, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0xA953, 0x094D, 0x05B0, 0x0062,), '0061 A953 05B0 094D 3099 0062 -> 0061 3099 A953 094D 05B0 0062';
ok Uni.new(0x0061, 0x3099, 0x093C, 0x16FF0, 0xA9B3, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x093C, 0xA9B3, 0x3099, 0x0062,), '0061 3099 093C 16FF0 A9B3 0062 -> 0061 16FF0 093C A9B3 3099 0062';
ok Uni.new(0x0061, 0xA9B3, 0x3099, 0x093C, 0x16FF0, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0xA9B3, 0x093C, 0x3099, 0x0062,), '0061 A9B3 3099 093C 16FF0 0062 -> 0061 16FF0 A9B3 093C 3099 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0xA9C0, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0xA9C0, 0x05B0, 0x0062,), '0061 05B0 094D 3099 A9C0 0062 -> 0061 3099 094D A9C0 05B0 0062';
ok Uni.new(0x0061, 0xA9C0, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0xA9C0, 0x094D, 0x05B0, 0x0062,), '0061 A9C0 05B0 094D 3099 0062 -> 0061 3099 A9C0 094D 05B0 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xAAB0, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xAAB0, 0x0315, 0x0062,), '0061 0315 0300 05AE AAB0 0062 -> 0061 05AE 0300 AAB0 0315 0062';
ok Uni.new(0x0061, 0xAAB0, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xAAB0, 0x0300, 0x0315, 0x0062,), '0061 AAB0 0315 0300 05AE 0062 -> 0061 05AE AAB0 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xAAB2, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xAAB2, 0x0315, 0x0062,), '0061 0315 0300 05AE AAB2 0062 -> 0061 05AE 0300 AAB2 0315 0062';
ok Uni.new(0x0061, 0xAAB2, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xAAB2, 0x0300, 0x0315, 0x0062,), '0061 AAB2 0315 0300 05AE 0062 -> 0061 05AE AAB2 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xAAB3, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xAAB3, 0x0315, 0x0062,), '0061 0315 0300 05AE AAB3 0062 -> 0061 05AE 0300 AAB3 0315 0062';
ok Uni.new(0x0061, 0xAAB3, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xAAB3, 0x0300, 0x0315, 0x0062,), '0061 AAB3 0315 0300 05AE 0062 -> 0061 05AE AAB3 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0xAAB4, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0xAAB4, 0x059A, 0x0062,), '0061 059A 0316 1DFA AAB4 0062 -> 0061 1DFA 0316 AAB4 059A 0062';
ok Uni.new(0x0061, 0xAAB4, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0xAAB4, 0x0316, 0x059A, 0x0062,), '0061 AAB4 059A 0316 1DFA 0062 -> 0061 1DFA AAB4 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xAAB7, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xAAB7, 0x0315, 0x0062,), '0061 0315 0300 05AE AAB7 0062 -> 0061 05AE 0300 AAB7 0315 0062';
ok Uni.new(0x0061, 0xAAB7, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xAAB7, 0x0300, 0x0315, 0x0062,), '0061 AAB7 0315 0300 05AE 0062 -> 0061 05AE AAB7 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xAAB8, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xAAB8, 0x0315, 0x0062,), '0061 0315 0300 05AE AAB8 0062 -> 0061 05AE 0300 AAB8 0315 0062';
ok Uni.new(0x0061, 0xAAB8, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xAAB8, 0x0300, 0x0315, 0x0062,), '0061 AAB8 0315 0300 05AE 0062 -> 0061 05AE AAB8 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xAABE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xAABE, 0x0315, 0x0062,), '0061 0315 0300 05AE AABE 0062 -> 0061 05AE 0300 AABE 0315 0062';
ok Uni.new(0x0061, 0xAABE, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xAABE, 0x0300, 0x0315, 0x0062,), '0061 AABE 0315 0300 05AE 0062 -> 0061 05AE AABE 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xAABF, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xAABF, 0x0315, 0x0062,), '0061 0315 0300 05AE AABF 0062 -> 0061 05AE 0300 AABF 0315 0062';
ok Uni.new(0x0061, 0xAABF, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xAABF, 0x0300, 0x0315, 0x0062,), '0061 AABF 0315 0300 05AE 0062 -> 0061 05AE AABF 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xAAC1, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xAAC1, 0x0315, 0x0062,), '0061 0315 0300 05AE AAC1 0062 -> 0061 05AE 0300 AAC1 0315 0062';
ok Uni.new(0x0061, 0xAAC1, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xAAC1, 0x0300, 0x0315, 0x0062,), '0061 AAC1 0315 0300 05AE 0062 -> 0061 05AE AAC1 0300 0315 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0xAAF6, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0xAAF6, 0x05B0, 0x0062,), '0061 05B0 094D 3099 AAF6 0062 -> 0061 3099 094D AAF6 05B0 0062';
ok Uni.new(0x0061, 0xAAF6, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0xAAF6, 0x094D, 0x05B0, 0x0062,), '0061 AAF6 05B0 094D 3099 0062 -> 0061 3099 AAF6 094D 05B0 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0xABED, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0xABED, 0x05B0, 0x0062,), '0061 05B0 094D 3099 ABED 0062 -> 0061 3099 094D ABED 05B0 0062';
ok Uni.new(0x0061, 0xABED, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0xABED, 0x094D, 0x05B0, 0x0062,), '0061 ABED 05B0 094D 3099 0062 -> 0061 3099 ABED 094D 05B0 0062';
ok Uni.new(0x0061, 0x064B, 0xFB1E, 0x05C2, 0xFB1E, 0x0062).NFD.list ~~ (0x0061, 0x05C2, 0xFB1E, 0xFB1E, 0x064B, 0x0062,), '0061 064B FB1E 05C2 FB1E 0062 -> 0061 05C2 FB1E FB1E 064B 0062';
ok Uni.new(0x0061, 0xFB1E, 0x064B, 0xFB1E, 0x05C2, 0x0062).NFD.list ~~ (0x0061, 0x05C2, 0xFB1E, 0xFB1E, 0x064B, 0x0062,), '0061 FB1E 064B FB1E 05C2 0062 -> 0061 05C2 FB1E FB1E 064B 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xFE20, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xFE20, 0x0315, 0x0062,), '0061 0315 0300 05AE FE20 0062 -> 0061 05AE 0300 FE20 0315 0062';
ok Uni.new(0x0061, 0xFE20, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xFE20, 0x0300, 0x0315, 0x0062,), '0061 FE20 0315 0300 05AE 0062 -> 0061 05AE FE20 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xFE21, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xFE21, 0x0315, 0x0062,), '0061 0315 0300 05AE FE21 0062 -> 0061 05AE 0300 FE21 0315 0062';
ok Uni.new(0x0061, 0xFE21, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xFE21, 0x0300, 0x0315, 0x0062,), '0061 FE21 0315 0300 05AE 0062 -> 0061 05AE FE21 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xFE22, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xFE22, 0x0315, 0x0062,), '0061 0315 0300 05AE FE22 0062 -> 0061 05AE 0300 FE22 0315 0062';
ok Uni.new(0x0061, 0xFE22, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xFE22, 0x0300, 0x0315, 0x0062,), '0061 FE22 0315 0300 05AE 0062 -> 0061 05AE FE22 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xFE23, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xFE23, 0x0315, 0x0062,), '0061 0315 0300 05AE FE23 0062 -> 0061 05AE 0300 FE23 0315 0062';
ok Uni.new(0x0061, 0xFE23, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xFE23, 0x0300, 0x0315, 0x0062,), '0061 FE23 0315 0300 05AE 0062 -> 0061 05AE FE23 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xFE24, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xFE24, 0x0315, 0x0062,), '0061 0315 0300 05AE FE24 0062 -> 0061 05AE 0300 FE24 0315 0062';
ok Uni.new(0x0061, 0xFE24, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xFE24, 0x0300, 0x0315, 0x0062,), '0061 FE24 0315 0300 05AE 0062 -> 0061 05AE FE24 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xFE25, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xFE25, 0x0315, 0x0062,), '0061 0315 0300 05AE FE25 0062 -> 0061 05AE 0300 FE25 0315 0062';
ok Uni.new(0x0061, 0xFE25, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xFE25, 0x0300, 0x0315, 0x0062,), '0061 FE25 0315 0300 05AE 0062 -> 0061 05AE FE25 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xFE26, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xFE26, 0x0315, 0x0062,), '0061 0315 0300 05AE FE26 0062 -> 0061 05AE 0300 FE26 0315 0062';
ok Uni.new(0x0061, 0xFE26, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xFE26, 0x0300, 0x0315, 0x0062,), '0061 FE26 0315 0300 05AE 0062 -> 0061 05AE FE26 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0xFE27, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0xFE27, 0x059A, 0x0062,), '0061 059A 0316 1DFA FE27 0062 -> 0061 1DFA 0316 FE27 059A 0062';
ok Uni.new(0x0061, 0xFE27, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0xFE27, 0x0316, 0x059A, 0x0062,), '0061 FE27 059A 0316 1DFA 0062 -> 0061 1DFA FE27 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0xFE28, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0xFE28, 0x059A, 0x0062,), '0061 059A 0316 1DFA FE28 0062 -> 0061 1DFA 0316 FE28 059A 0062';
ok Uni.new(0x0061, 0xFE28, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0xFE28, 0x0316, 0x059A, 0x0062,), '0061 FE28 059A 0316 1DFA 0062 -> 0061 1DFA FE28 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0xFE29, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0xFE29, 0x059A, 0x0062,), '0061 059A 0316 1DFA FE29 0062 -> 0061 1DFA 0316 FE29 059A 0062';
ok Uni.new(0x0061, 0xFE29, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0xFE29, 0x0316, 0x059A, 0x0062,), '0061 FE29 059A 0316 1DFA 0062 -> 0061 1DFA FE29 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0xFE2A, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0xFE2A, 0x059A, 0x0062,), '0061 059A 0316 1DFA FE2A 0062 -> 0061 1DFA 0316 FE2A 059A 0062';
ok Uni.new(0x0061, 0xFE2A, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0xFE2A, 0x0316, 0x059A, 0x0062,), '0061 FE2A 059A 0316 1DFA 0062 -> 0061 1DFA FE2A 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0xFE2B, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0xFE2B, 0x059A, 0x0062,), '0061 059A 0316 1DFA FE2B 0062 -> 0061 1DFA 0316 FE2B 059A 0062';
ok Uni.new(0x0061, 0xFE2B, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0xFE2B, 0x0316, 0x059A, 0x0062,), '0061 FE2B 059A 0316 1DFA 0062 -> 0061 1DFA FE2B 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0xFE2C, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0xFE2C, 0x059A, 0x0062,), '0061 059A 0316 1DFA FE2C 0062 -> 0061 1DFA 0316 FE2C 059A 0062';
ok Uni.new(0x0061, 0xFE2C, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0xFE2C, 0x0316, 0x059A, 0x0062,), '0061 FE2C 059A 0316 1DFA 0062 -> 0061 1DFA FE2C 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0xFE2D, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0xFE2D, 0x059A, 0x0062,), '0061 059A 0316 1DFA FE2D 0062 -> 0061 1DFA 0316 FE2D 059A 0062';
ok Uni.new(0x0061, 0xFE2D, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0xFE2D, 0x0316, 0x059A, 0x0062,), '0061 FE2D 059A 0316 1DFA 0062 -> 0061 1DFA FE2D 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xFE2E, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xFE2E, 0x0315, 0x0062,), '0061 0315 0300 05AE FE2E 0062 -> 0061 05AE 0300 FE2E 0315 0062';
ok Uni.new(0x0061, 0xFE2E, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xFE2E, 0x0300, 0x0315, 0x0062,), '0061 FE2E 0315 0300 05AE 0062 -> 0061 05AE FE2E 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0xFE2F, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0xFE2F, 0x0315, 0x0062,), '0061 0315 0300 05AE FE2F 0062 -> 0061 05AE 0300 FE2F 0315 0062';
ok Uni.new(0x0061, 0xFE2F, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0xFE2F, 0x0300, 0x0315, 0x0062,), '0061 FE2F 0315 0300 05AE 0062 -> 0061 05AE FE2F 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x101FD, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x101FD, 0x059A, 0x0062,), '0061 059A 0316 1DFA 101FD 0062 -> 0061 1DFA 0316 101FD 059A 0062';
ok Uni.new(0x0061, 0x101FD, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x101FD, 0x0316, 0x059A, 0x0062,), '0061 101FD 059A 0316 1DFA 0062 -> 0061 1DFA 101FD 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x102E0, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x102E0, 0x059A, 0x0062,), '0061 059A 0316 1DFA 102E0 0062 -> 0061 1DFA 0316 102E0 059A 0062';
ok Uni.new(0x0061, 0x102E0, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x102E0, 0x0316, 0x059A, 0x0062,), '0061 102E0 059A 0316 1DFA 0062 -> 0061 1DFA 102E0 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x10376, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x10376, 0x0315, 0x0062,), '0061 0315 0300 05AE 10376 0062 -> 0061 05AE 0300 10376 0315 0062';
ok Uni.new(0x0061, 0x10376, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x10376, 0x0300, 0x0315, 0x0062,), '0061 10376 0315 0300 05AE 0062 -> 0061 05AE 10376 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x10377, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x10377, 0x0315, 0x0062,), '0061 0315 0300 05AE 10377 0062 -> 0061 05AE 0300 10377 0315 0062';
ok Uni.new(0x0061, 0x10377, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x10377, 0x0300, 0x0315, 0x0062,), '0061 10377 0315 0300 05AE 0062 -> 0061 05AE 10377 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x10378, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x10378, 0x0315, 0x0062,), '0061 0315 0300 05AE 10378 0062 -> 0061 05AE 0300 10378 0315 0062';
ok Uni.new(0x0061, 0x10378, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x10378, 0x0300, 0x0315, 0x0062,), '0061 10378 0315 0300 05AE 0062 -> 0061 05AE 10378 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x10379, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x10379, 0x0315, 0x0062,), '0061 0315 0300 05AE 10379 0062 -> 0061 05AE 0300 10379 0315 0062';
ok Uni.new(0x0061, 0x10379, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x10379, 0x0300, 0x0315, 0x0062,), '0061 10379 0315 0300 05AE 0062 -> 0061 05AE 10379 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1037A, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1037A, 0x0315, 0x0062,), '0061 0315 0300 05AE 1037A 0062 -> 0061 05AE 0300 1037A 0315 0062';
ok Uni.new(0x0061, 0x1037A, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1037A, 0x0300, 0x0315, 0x0062,), '0061 1037A 0315 0300 05AE 0062 -> 0061 05AE 1037A 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x10A0D, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x10A0D, 0x059A, 0x0062,), '0061 059A 0316 1DFA 10A0D 0062 -> 0061 1DFA 0316 10A0D 059A 0062';
ok Uni.new(0x0061, 0x10A0D, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x10A0D, 0x0316, 0x059A, 0x0062,), '0061 10A0D 059A 0316 1DFA 0062 -> 0061 1DFA 10A0D 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x10A0F, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x10A0F, 0x0315, 0x0062,), '0061 0315 0300 05AE 10A0F 0062 -> 0061 05AE 0300 10A0F 0315 0062';
ok Uni.new(0x0061, 0x10A0F, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x10A0F, 0x0300, 0x0315, 0x0062,), '0061 10A0F 0315 0300 05AE 0062 -> 0061 05AE 10A0F 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x10A38, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x10A38, 0x0315, 0x0062,), '0061 0315 0300 05AE 10A38 0062 -> 0061 05AE 0300 10A38 0315 0062';
ok Uni.new(0x0061, 0x10A38, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x10A38, 0x0300, 0x0315, 0x0062,), '0061 10A38 0315 0300 05AE 0062 -> 0061 05AE 10A38 0300 0315 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x10A39, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x10A39, 0x16FF0, 0x0062,), '0061 16FF0 0334 10A39 0062 -> 0061 0334 10A39 16FF0 0062';
ok Uni.new(0x0061, 0x10A39, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x10A39, 0x0334, 0x16FF0, 0x0062,), '0061 10A39 16FF0 0334 0062 -> 0061 10A39 0334 16FF0 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x10A3A, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x10A3A, 0x059A, 0x0062,), '0061 059A 0316 1DFA 10A3A 0062 -> 0061 1DFA 0316 10A3A 059A 0062';
ok Uni.new(0x0061, 0x10A3A, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x10A3A, 0x0316, 0x059A, 0x0062,), '0061 10A3A 059A 0316 1DFA 0062 -> 0061 1DFA 10A3A 0316 059A 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x10A3F, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x10A3F, 0x05B0, 0x0062,), '0061 05B0 094D 3099 10A3F 0062 -> 0061 3099 094D 10A3F 05B0 0062';
ok Uni.new(0x0061, 0x10A3F, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x10A3F, 0x094D, 0x05B0, 0x0062,), '0061 10A3F 05B0 094D 3099 0062 -> 0061 3099 10A3F 094D 05B0 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x10AE5, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x10AE5, 0x0315, 0x0062,), '0061 0315 0300 05AE 10AE5 0062 -> 0061 05AE 0300 10AE5 0315 0062';
ok Uni.new(0x0061, 0x10AE5, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x10AE5, 0x0300, 0x0315, 0x0062,), '0061 10AE5 0315 0300 05AE 0062 -> 0061 05AE 10AE5 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x10AE6, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x10AE6, 0x059A, 0x0062,), '0061 059A 0316 1DFA 10AE6 0062 -> 0061 1DFA 0316 10AE6 059A 0062';
ok Uni.new(0x0061, 0x10AE6, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x10AE6, 0x0316, 0x059A, 0x0062,), '0061 10AE6 059A 0316 1DFA 0062 -> 0061 1DFA 10AE6 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x10D24, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x10D24, 0x0315, 0x0062,), '0061 0315 0300 05AE 10D24 0062 -> 0061 05AE 0300 10D24 0315 0062';
ok Uni.new(0x0061, 0x10D24, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x10D24, 0x0300, 0x0315, 0x0062,), '0061 10D24 0315 0300 05AE 0062 -> 0061 05AE 10D24 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x10D25, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x10D25, 0x0315, 0x0062,), '0061 0315 0300 05AE 10D25 0062 -> 0061 05AE 0300 10D25 0315 0062';
ok Uni.new(0x0061, 0x10D25, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x10D25, 0x0300, 0x0315, 0x0062,), '0061 10D25 0315 0300 05AE 0062 -> 0061 05AE 10D25 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x10D26, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x10D26, 0x0315, 0x0062,), '0061 0315 0300 05AE 10D26 0062 -> 0061 05AE 0300 10D26 0315 0062';
ok Uni.new(0x0061, 0x10D26, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x10D26, 0x0300, 0x0315, 0x0062,), '0061 10D26 0315 0300 05AE 0062 -> 0061 05AE 10D26 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x10D27, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x10D27, 0x0315, 0x0062,), '0061 0315 0300 05AE 10D27 0062 -> 0061 05AE 0300 10D27 0315 0062';
ok Uni.new(0x0061, 0x10D27, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x10D27, 0x0300, 0x0315, 0x0062,), '0061 10D27 0315 0300 05AE 0062 -> 0061 05AE 10D27 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x10EAB, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x10EAB, 0x0315, 0x0062,), '0061 0315 0300 05AE 10EAB 0062 -> 0061 05AE 0300 10EAB 0315 0062';
ok Uni.new(0x0061, 0x10EAB, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x10EAB, 0x0300, 0x0315, 0x0062,), '0061 10EAB 0315 0300 05AE 0062 -> 0061 05AE 10EAB 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x10EAC, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x10EAC, 0x0315, 0x0062,), '0061 0315 0300 05AE 10EAC 0062 -> 0061 05AE 0300 10EAC 0315 0062';
ok Uni.new(0x0061, 0x10EAC, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x10EAC, 0x0300, 0x0315, 0x0062,), '0061 10EAC 0315 0300 05AE 0062 -> 0061 05AE 10EAC 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x10EFD, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x10EFD, 0x059A, 0x0062,), '0061 059A 0316 1DFA 10EFD 0062 -> 0061 1DFA 0316 10EFD 059A 0062';
ok Uni.new(0x0061, 0x10EFD, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x10EFD, 0x0316, 0x059A, 0x0062,), '0061 10EFD 059A 0316 1DFA 0062 -> 0061 1DFA 10EFD 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x10EFE, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x10EFE, 0x059A, 0x0062,), '0061 059A 0316 1DFA 10EFE 0062 -> 0061 1DFA 0316 10EFE 059A 0062';
ok Uni.new(0x0061, 0x10EFE, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x10EFE, 0x0316, 0x059A, 0x0062,), '0061 10EFE 059A 0316 1DFA 0062 -> 0061 1DFA 10EFE 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x10EFF, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x10EFF, 0x059A, 0x0062,), '0061 059A 0316 1DFA 10EFF 0062 -> 0061 1DFA 0316 10EFF 059A 0062';
ok Uni.new(0x0061, 0x10EFF, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x10EFF, 0x0316, 0x059A, 0x0062,), '0061 10EFF 059A 0316 1DFA 0062 -> 0061 1DFA 10EFF 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F46, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x10F46, 0x059A, 0x0062,), '0061 059A 0316 1DFA 10F46 0062 -> 0061 1DFA 0316 10F46 059A 0062';
ok Uni.new(0x0061, 0x10F46, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x10F46, 0x0316, 0x059A, 0x0062,), '0061 10F46 059A 0316 1DFA 0062 -> 0061 1DFA 10F46 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F47, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x10F47, 0x059A, 0x0062,), '0061 059A 0316 1DFA 10F47 0062 -> 0061 1DFA 0316 10F47 059A 0062';
ok Uni.new(0x0061, 0x10F47, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x10F47, 0x0316, 0x059A, 0x0062,), '0061 10F47 059A 0316 1DFA 0062 -> 0061 1DFA 10F47 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x10F48, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x10F48, 0x0315, 0x0062,), '0061 0315 0300 05AE 10F48 0062 -> 0061 05AE 0300 10F48 0315 0062';
ok Uni.new(0x0061, 0x10F48, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x10F48, 0x0300, 0x0315, 0x0062,), '0061 10F48 0315 0300 05AE 0062 -> 0061 05AE 10F48 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x10F49, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x10F49, 0x0315, 0x0062,), '0061 0315 0300 05AE 10F49 0062 -> 0061 05AE 0300 10F49 0315 0062';
ok Uni.new(0x0061, 0x10F49, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x10F49, 0x0300, 0x0315, 0x0062,), '0061 10F49 0315 0300 05AE 0062 -> 0061 05AE 10F49 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x10F4A, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x10F4A, 0x0315, 0x0062,), '0061 0315 0300 05AE 10F4A 0062 -> 0061 05AE 0300 10F4A 0315 0062';
ok Uni.new(0x0061, 0x10F4A, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x10F4A, 0x0300, 0x0315, 0x0062,), '0061 10F4A 0315 0300 05AE 0062 -> 0061 05AE 10F4A 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F4B, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x10F4B, 0x059A, 0x0062,), '0061 059A 0316 1DFA 10F4B 0062 -> 0061 1DFA 0316 10F4B 059A 0062';
ok Uni.new(0x0061, 0x10F4B, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x10F4B, 0x0316, 0x059A, 0x0062,), '0061 10F4B 059A 0316 1DFA 0062 -> 0061 1DFA 10F4B 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x10F4C, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x10F4C, 0x0315, 0x0062,), '0061 0315 0300 05AE 10F4C 0062 -> 0061 05AE 0300 10F4C 0315 0062';
ok Uni.new(0x0061, 0x10F4C, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x10F4C, 0x0300, 0x0315, 0x0062,), '0061 10F4C 0315 0300 05AE 0062 -> 0061 05AE 10F4C 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F4D, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x10F4D, 0x059A, 0x0062,), '0061 059A 0316 1DFA 10F4D 0062 -> 0061 1DFA 0316 10F4D 059A 0062';
ok Uni.new(0x0061, 0x10F4D, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x10F4D, 0x0316, 0x059A, 0x0062,), '0061 10F4D 059A 0316 1DFA 0062 -> 0061 1DFA 10F4D 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F4E, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x10F4E, 0x059A, 0x0062,), '0061 059A 0316 1DFA 10F4E 0062 -> 0061 1DFA 0316 10F4E 059A 0062';
ok Uni.new(0x0061, 0x10F4E, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x10F4E, 0x0316, 0x059A, 0x0062,), '0061 10F4E 059A 0316 1DFA 0062 -> 0061 1DFA 10F4E 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F4F, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x10F4F, 0x059A, 0x0062,), '0061 059A 0316 1DFA 10F4F 0062 -> 0061 1DFA 0316 10F4F 059A 0062';
ok Uni.new(0x0061, 0x10F4F, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x10F4F, 0x0316, 0x059A, 0x0062,), '0061 10F4F 059A 0316 1DFA 0062 -> 0061 1DFA 10F4F 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F50, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x10F50, 0x059A, 0x0062,), '0061 059A 0316 1DFA 10F50 0062 -> 0061 1DFA 0316 10F50 059A 0062';
ok Uni.new(0x0061, 0x10F50, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x10F50, 0x0316, 0x059A, 0x0062,), '0061 10F50 059A 0316 1DFA 0062 -> 0061 1DFA 10F50 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x10F82, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x10F82, 0x0315, 0x0062,), '0061 0315 0300 05AE 10F82 0062 -> 0061 05AE 0300 10F82 0315 0062';
ok Uni.new(0x0061, 0x10F82, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x10F82, 0x0300, 0x0315, 0x0062,), '0061 10F82 0315 0300 05AE 0062 -> 0061 05AE 10F82 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F83, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x10F83, 0x059A, 0x0062,), '0061 059A 0316 1DFA 10F83 0062 -> 0061 1DFA 0316 10F83 059A 0062';
ok Uni.new(0x0061, 0x10F83, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x10F83, 0x0316, 0x059A, 0x0062,), '0061 10F83 059A 0316 1DFA 0062 -> 0061 1DFA 10F83 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x10F84, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x10F84, 0x0315, 0x0062,), '0061 0315 0300 05AE 10F84 0062 -> 0061 05AE 0300 10F84 0315 0062';
ok Uni.new(0x0061, 0x10F84, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x10F84, 0x0300, 0x0315, 0x0062,), '0061 10F84 0315 0300 05AE 0062 -> 0061 05AE 10F84 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x10F85, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x10F85, 0x059A, 0x0062,), '0061 059A 0316 1DFA 10F85 0062 -> 0061 1DFA 0316 10F85 059A 0062';
ok Uni.new(0x0061, 0x10F85, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x10F85, 0x0316, 0x059A, 0x0062,), '0061 10F85 059A 0316 1DFA 0062 -> 0061 1DFA 10F85 0316 059A 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x11046, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x11046, 0x05B0, 0x0062,), '0061 05B0 094D 3099 11046 0062 -> 0061 3099 094D 11046 05B0 0062';
ok Uni.new(0x0061, 0x11046, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x11046, 0x094D, 0x05B0, 0x0062,), '0061 11046 05B0 094D 3099 0062 -> 0061 3099 11046 094D 05B0 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x11070, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x11070, 0x05B0, 0x0062,), '0061 05B0 094D 3099 11070 0062 -> 0061 3099 094D 11070 05B0 0062';
ok Uni.new(0x0061, 0x11070, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x11070, 0x094D, 0x05B0, 0x0062,), '0061 11070 05B0 094D 3099 0062 -> 0061 3099 11070 094D 05B0 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x1107F, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x1107F, 0x05B0, 0x0062,), '0061 05B0 094D 3099 1107F 0062 -> 0061 3099 094D 1107F 05B0 0062';
ok Uni.new(0x0061, 0x1107F, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x1107F, 0x094D, 0x05B0, 0x0062,), '0061 1107F 05B0 094D 3099 0062 -> 0061 3099 1107F 094D 05B0 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x110B9, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x110B9, 0x05B0, 0x0062,), '0061 05B0 094D 3099 110B9 0062 -> 0061 3099 094D 110B9 05B0 0062';
ok Uni.new(0x0061, 0x110B9, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x110B9, 0x094D, 0x05B0, 0x0062,), '0061 110B9 05B0 094D 3099 0062 -> 0061 3099 110B9 094D 05B0 0062';
ok Uni.new(0x0061, 0x3099, 0x093C, 0x16FF0, 0x110BA, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x093C, 0x110BA, 0x3099, 0x0062,), '0061 3099 093C 16FF0 110BA 0062 -> 0061 16FF0 093C 110BA 3099 0062';
ok Uni.new(0x0061, 0x110BA, 0x3099, 0x093C, 0x16FF0, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x110BA, 0x093C, 0x3099, 0x0062,), '0061 110BA 3099 093C 16FF0 0062 -> 0061 16FF0 110BA 093C 3099 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x11100, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x11100, 0x0315, 0x0062,), '0061 0315 0300 05AE 11100 0062 -> 0061 05AE 0300 11100 0315 0062';
ok Uni.new(0x0061, 0x11100, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x11100, 0x0300, 0x0315, 0x0062,), '0061 11100 0315 0300 05AE 0062 -> 0061 05AE 11100 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x11101, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x11101, 0x0315, 0x0062,), '0061 0315 0300 05AE 11101 0062 -> 0061 05AE 0300 11101 0315 0062';
ok Uni.new(0x0061, 0x11101, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x11101, 0x0300, 0x0315, 0x0062,), '0061 11101 0315 0300 05AE 0062 -> 0061 05AE 11101 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x11102, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x11102, 0x0315, 0x0062,), '0061 0315 0300 05AE 11102 0062 -> 0061 05AE 0300 11102 0315 0062';
ok Uni.new(0x0061, 0x11102, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x11102, 0x0300, 0x0315, 0x0062,), '0061 11102 0315 0300 05AE 0062 -> 0061 05AE 11102 0300 0315 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x11133, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x11133, 0x05B0, 0x0062,), '0061 05B0 094D 3099 11133 0062 -> 0061 3099 094D 11133 05B0 0062';
ok Uni.new(0x0061, 0x11133, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x11133, 0x094D, 0x05B0, 0x0062,), '0061 11133 05B0 094D 3099 0062 -> 0061 3099 11133 094D 05B0 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x11134, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x11134, 0x05B0, 0x0062,), '0061 05B0 094D 3099 11134 0062 -> 0061 3099 094D 11134 05B0 0062';
ok Uni.new(0x0061, 0x11134, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x11134, 0x094D, 0x05B0, 0x0062,), '0061 11134 05B0 094D 3099 0062 -> 0061 3099 11134 094D 05B0 0062';
ok Uni.new(0x0061, 0x3099, 0x093C, 0x16FF0, 0x11173, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x093C, 0x11173, 0x3099, 0x0062,), '0061 3099 093C 16FF0 11173 0062 -> 0061 16FF0 093C 11173 3099 0062';
ok Uni.new(0x0061, 0x11173, 0x3099, 0x093C, 0x16FF0, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x11173, 0x093C, 0x3099, 0x0062,), '0061 11173 3099 093C 16FF0 0062 -> 0061 16FF0 11173 093C 3099 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x111C0, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x111C0, 0x05B0, 0x0062,), '0061 05B0 094D 3099 111C0 0062 -> 0061 3099 094D 111C0 05B0 0062';
ok Uni.new(0x0061, 0x111C0, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x111C0, 0x094D, 0x05B0, 0x0062,), '0061 111C0 05B0 094D 3099 0062 -> 0061 3099 111C0 094D 05B0 0062';
ok Uni.new(0x0061, 0x3099, 0x093C, 0x16FF0, 0x111CA, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x093C, 0x111CA, 0x3099, 0x0062,), '0061 3099 093C 16FF0 111CA 0062 -> 0061 16FF0 093C 111CA 3099 0062';
ok Uni.new(0x0061, 0x111CA, 0x3099, 0x093C, 0x16FF0, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x111CA, 0x093C, 0x3099, 0x0062,), '0061 111CA 3099 093C 16FF0 0062 -> 0061 16FF0 111CA 093C 3099 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x11235, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x11235, 0x05B0, 0x0062,), '0061 05B0 094D 3099 11235 0062 -> 0061 3099 094D 11235 05B0 0062';
ok Uni.new(0x0061, 0x11235, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x11235, 0x094D, 0x05B0, 0x0062,), '0061 11235 05B0 094D 3099 0062 -> 0061 3099 11235 094D 05B0 0062';
ok Uni.new(0x0061, 0x3099, 0x093C, 0x16FF0, 0x11236, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x093C, 0x11236, 0x3099, 0x0062,), '0061 3099 093C 16FF0 11236 0062 -> 0061 16FF0 093C 11236 3099 0062';
ok Uni.new(0x0061, 0x11236, 0x3099, 0x093C, 0x16FF0, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x11236, 0x093C, 0x3099, 0x0062,), '0061 11236 3099 093C 16FF0 0062 -> 0061 16FF0 11236 093C 3099 0062';
ok Uni.new(0x0061, 0x3099, 0x093C, 0x16FF0, 0x112E9, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x093C, 0x112E9, 0x3099, 0x0062,), '0061 3099 093C 16FF0 112E9 0062 -> 0061 16FF0 093C 112E9 3099 0062';
ok Uni.new(0x0061, 0x112E9, 0x3099, 0x093C, 0x16FF0, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x112E9, 0x093C, 0x3099, 0x0062,), '0061 112E9 3099 093C 16FF0 0062 -> 0061 16FF0 112E9 093C 3099 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x112EA, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x112EA, 0x05B0, 0x0062,), '0061 05B0 094D 3099 112EA 0062 -> 0061 3099 094D 112EA 05B0 0062';
ok Uni.new(0x0061, 0x112EA, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x112EA, 0x094D, 0x05B0, 0x0062,), '0061 112EA 05B0 094D 3099 0062 -> 0061 3099 112EA 094D 05B0 0062';
ok Uni.new(0x0061, 0x3099, 0x093C, 0x16FF0, 0x1133B, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x093C, 0x1133B, 0x3099, 0x0062,), '0061 3099 093C 16FF0 1133B 0062 -> 0061 16FF0 093C 1133B 3099 0062';
ok Uni.new(0x0061, 0x1133B, 0x3099, 0x093C, 0x16FF0, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x1133B, 0x093C, 0x3099, 0x0062,), '0061 1133B 3099 093C 16FF0 0062 -> 0061 16FF0 1133B 093C 3099 0062';
ok Uni.new(0x0061, 0x3099, 0x093C, 0x16FF0, 0x1133C, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x093C, 0x1133C, 0x3099, 0x0062,), '0061 3099 093C 16FF0 1133C 0062 -> 0061 16FF0 093C 1133C 3099 0062';
ok Uni.new(0x0061, 0x1133C, 0x3099, 0x093C, 0x16FF0, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x1133C, 0x093C, 0x3099, 0x0062,), '0061 1133C 3099 093C 16FF0 0062 -> 0061 16FF0 1133C 093C 3099 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x1134D, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x1134D, 0x05B0, 0x0062,), '0061 05B0 094D 3099 1134D 0062 -> 0061 3099 094D 1134D 05B0 0062';
ok Uni.new(0x0061, 0x1134D, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x1134D, 0x094D, 0x05B0, 0x0062,), '0061 1134D 05B0 094D 3099 0062 -> 0061 3099 1134D 094D 05B0 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x11366, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x11366, 0x0315, 0x0062,), '0061 0315 0300 05AE 11366 0062 -> 0061 05AE 0300 11366 0315 0062';
ok Uni.new(0x0061, 0x11366, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x11366, 0x0300, 0x0315, 0x0062,), '0061 11366 0315 0300 05AE 0062 -> 0061 05AE 11366 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x11367, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x11367, 0x0315, 0x0062,), '0061 0315 0300 05AE 11367 0062 -> 0061 05AE 0300 11367 0315 0062';
ok Uni.new(0x0061, 0x11367, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x11367, 0x0300, 0x0315, 0x0062,), '0061 11367 0315 0300 05AE 0062 -> 0061 05AE 11367 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x11368, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x11368, 0x0315, 0x0062,), '0061 0315 0300 05AE 11368 0062 -> 0061 05AE 0300 11368 0315 0062';
ok Uni.new(0x0061, 0x11368, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x11368, 0x0300, 0x0315, 0x0062,), '0061 11368 0315 0300 05AE 0062 -> 0061 05AE 11368 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x11369, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x11369, 0x0315, 0x0062,), '0061 0315 0300 05AE 11369 0062 -> 0061 05AE 0300 11369 0315 0062';
ok Uni.new(0x0061, 0x11369, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x11369, 0x0300, 0x0315, 0x0062,), '0061 11369 0315 0300 05AE 0062 -> 0061 05AE 11369 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1136A, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1136A, 0x0315, 0x0062,), '0061 0315 0300 05AE 1136A 0062 -> 0061 05AE 0300 1136A 0315 0062';
ok Uni.new(0x0061, 0x1136A, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1136A, 0x0300, 0x0315, 0x0062,), '0061 1136A 0315 0300 05AE 0062 -> 0061 05AE 1136A 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1136B, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1136B, 0x0315, 0x0062,), '0061 0315 0300 05AE 1136B 0062 -> 0061 05AE 0300 1136B 0315 0062';
ok Uni.new(0x0061, 0x1136B, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1136B, 0x0300, 0x0315, 0x0062,), '0061 1136B 0315 0300 05AE 0062 -> 0061 05AE 1136B 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1136C, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1136C, 0x0315, 0x0062,), '0061 0315 0300 05AE 1136C 0062 -> 0061 05AE 0300 1136C 0315 0062';
ok Uni.new(0x0061, 0x1136C, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1136C, 0x0300, 0x0315, 0x0062,), '0061 1136C 0315 0300 05AE 0062 -> 0061 05AE 1136C 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x11370, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x11370, 0x0315, 0x0062,), '0061 0315 0300 05AE 11370 0062 -> 0061 05AE 0300 11370 0315 0062';
ok Uni.new(0x0061, 0x11370, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x11370, 0x0300, 0x0315, 0x0062,), '0061 11370 0315 0300 05AE 0062 -> 0061 05AE 11370 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x11371, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x11371, 0x0315, 0x0062,), '0061 0315 0300 05AE 11371 0062 -> 0061 05AE 0300 11371 0315 0062';
ok Uni.new(0x0061, 0x11371, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x11371, 0x0300, 0x0315, 0x0062,), '0061 11371 0315 0300 05AE 0062 -> 0061 05AE 11371 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x11372, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x11372, 0x0315, 0x0062,), '0061 0315 0300 05AE 11372 0062 -> 0061 05AE 0300 11372 0315 0062';
ok Uni.new(0x0061, 0x11372, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x11372, 0x0300, 0x0315, 0x0062,), '0061 11372 0315 0300 05AE 0062 -> 0061 05AE 11372 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x11373, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x11373, 0x0315, 0x0062,), '0061 0315 0300 05AE 11373 0062 -> 0061 05AE 0300 11373 0315 0062';
ok Uni.new(0x0061, 0x11373, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x11373, 0x0300, 0x0315, 0x0062,), '0061 11373 0315 0300 05AE 0062 -> 0061 05AE 11373 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x11374, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x11374, 0x0315, 0x0062,), '0061 0315 0300 05AE 11374 0062 -> 0061 05AE 0300 11374 0315 0062';
ok Uni.new(0x0061, 0x11374, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x11374, 0x0300, 0x0315, 0x0062,), '0061 11374 0315 0300 05AE 0062 -> 0061 05AE 11374 0300 0315 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x11442, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x11442, 0x05B0, 0x0062,), '0061 05B0 094D 3099 11442 0062 -> 0061 3099 094D 11442 05B0 0062';
ok Uni.new(0x0061, 0x11442, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x11442, 0x094D, 0x05B0, 0x0062,), '0061 11442 05B0 094D 3099 0062 -> 0061 3099 11442 094D 05B0 0062';
ok Uni.new(0x0061, 0x3099, 0x093C, 0x16FF0, 0x11446, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x093C, 0x11446, 0x3099, 0x0062,), '0061 3099 093C 16FF0 11446 0062 -> 0061 16FF0 093C 11446 3099 0062';
ok Uni.new(0x0061, 0x11446, 0x3099, 0x093C, 0x16FF0, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x11446, 0x093C, 0x3099, 0x0062,), '0061 11446 3099 093C 16FF0 0062 -> 0061 16FF0 11446 093C 3099 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1145E, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1145E, 0x0315, 0x0062,), '0061 0315 0300 05AE 1145E 0062 -> 0061 05AE 0300 1145E 0315 0062';
ok Uni.new(0x0061, 0x1145E, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1145E, 0x0300, 0x0315, 0x0062,), '0061 1145E 0315 0300 05AE 0062 -> 0061 05AE 1145E 0300 0315 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x114C2, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x114C2, 0x05B0, 0x0062,), '0061 05B0 094D 3099 114C2 0062 -> 0061 3099 094D 114C2 05B0 0062';
ok Uni.new(0x0061, 0x114C2, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x114C2, 0x094D, 0x05B0, 0x0062,), '0061 114C2 05B0 094D 3099 0062 -> 0061 3099 114C2 094D 05B0 0062';
ok Uni.new(0x0061, 0x3099, 0x093C, 0x16FF0, 0x114C3, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x093C, 0x114C3, 0x3099, 0x0062,), '0061 3099 093C 16FF0 114C3 0062 -> 0061 16FF0 093C 114C3 3099 0062';
ok Uni.new(0x0061, 0x114C3, 0x3099, 0x093C, 0x16FF0, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x114C3, 0x093C, 0x3099, 0x0062,), '0061 114C3 3099 093C 16FF0 0062 -> 0061 16FF0 114C3 093C 3099 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x115BF, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x115BF, 0x05B0, 0x0062,), '0061 05B0 094D 3099 115BF 0062 -> 0061 3099 094D 115BF 05B0 0062';
ok Uni.new(0x0061, 0x115BF, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x115BF, 0x094D, 0x05B0, 0x0062,), '0061 115BF 05B0 094D 3099 0062 -> 0061 3099 115BF 094D 05B0 0062';
ok Uni.new(0x0061, 0x3099, 0x093C, 0x16FF0, 0x115C0, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x093C, 0x115C0, 0x3099, 0x0062,), '0061 3099 093C 16FF0 115C0 0062 -> 0061 16FF0 093C 115C0 3099 0062';
ok Uni.new(0x0061, 0x115C0, 0x3099, 0x093C, 0x16FF0, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x115C0, 0x093C, 0x3099, 0x0062,), '0061 115C0 3099 093C 16FF0 0062 -> 0061 16FF0 115C0 093C 3099 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x1163F, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x1163F, 0x05B0, 0x0062,), '0061 05B0 094D 3099 1163F 0062 -> 0061 3099 094D 1163F 05B0 0062';
ok Uni.new(0x0061, 0x1163F, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x1163F, 0x094D, 0x05B0, 0x0062,), '0061 1163F 05B0 094D 3099 0062 -> 0061 3099 1163F 094D 05B0 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x116B6, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x116B6, 0x05B0, 0x0062,), '0061 05B0 094D 3099 116B6 0062 -> 0061 3099 094D 116B6 05B0 0062';
ok Uni.new(0x0061, 0x116B6, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x116B6, 0x094D, 0x05B0, 0x0062,), '0061 116B6 05B0 094D 3099 0062 -> 0061 3099 116B6 094D 05B0 0062';
ok Uni.new(0x0061, 0x3099, 0x093C, 0x16FF0, 0x116B7, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x093C, 0x116B7, 0x3099, 0x0062,), '0061 3099 093C 16FF0 116B7 0062 -> 0061 16FF0 093C 116B7 3099 0062';
ok Uni.new(0x0061, 0x116B7, 0x3099, 0x093C, 0x16FF0, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x116B7, 0x093C, 0x3099, 0x0062,), '0061 116B7 3099 093C 16FF0 0062 -> 0061 16FF0 116B7 093C 3099 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x1172B, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x1172B, 0x05B0, 0x0062,), '0061 05B0 094D 3099 1172B 0062 -> 0061 3099 094D 1172B 05B0 0062';
ok Uni.new(0x0061, 0x1172B, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x1172B, 0x094D, 0x05B0, 0x0062,), '0061 1172B 05B0 094D 3099 0062 -> 0061 3099 1172B 094D 05B0 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x11839, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x11839, 0x05B0, 0x0062,), '0061 05B0 094D 3099 11839 0062 -> 0061 3099 094D 11839 05B0 0062';
ok Uni.new(0x0061, 0x11839, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x11839, 0x094D, 0x05B0, 0x0062,), '0061 11839 05B0 094D 3099 0062 -> 0061 3099 11839 094D 05B0 0062';
ok Uni.new(0x0061, 0x3099, 0x093C, 0x16FF0, 0x1183A, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x093C, 0x1183A, 0x3099, 0x0062,), '0061 3099 093C 16FF0 1183A 0062 -> 0061 16FF0 093C 1183A 3099 0062';
ok Uni.new(0x0061, 0x1183A, 0x3099, 0x093C, 0x16FF0, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x1183A, 0x093C, 0x3099, 0x0062,), '0061 1183A 3099 093C 16FF0 0062 -> 0061 16FF0 1183A 093C 3099 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x1193D, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x1193D, 0x05B0, 0x0062,), '0061 05B0 094D 3099 1193D 0062 -> 0061 3099 094D 1193D 05B0 0062';
ok Uni.new(0x0061, 0x1193D, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x1193D, 0x094D, 0x05B0, 0x0062,), '0061 1193D 05B0 094D 3099 0062 -> 0061 3099 1193D 094D 05B0 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x1193E, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x1193E, 0x05B0, 0x0062,), '0061 05B0 094D 3099 1193E 0062 -> 0061 3099 094D 1193E 05B0 0062';
ok Uni.new(0x0061, 0x1193E, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x1193E, 0x094D, 0x05B0, 0x0062,), '0061 1193E 05B0 094D 3099 0062 -> 0061 3099 1193E 094D 05B0 0062';
ok Uni.new(0x0061, 0x3099, 0x093C, 0x16FF0, 0x11943, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x093C, 0x11943, 0x3099, 0x0062,), '0061 3099 093C 16FF0 11943 0062 -> 0061 16FF0 093C 11943 3099 0062';
ok Uni.new(0x0061, 0x11943, 0x3099, 0x093C, 0x16FF0, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x11943, 0x093C, 0x3099, 0x0062,), '0061 11943 3099 093C 16FF0 0062 -> 0061 16FF0 11943 093C 3099 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x119E0, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x119E0, 0x05B0, 0x0062,), '0061 05B0 094D 3099 119E0 0062 -> 0061 3099 094D 119E0 05B0 0062';
ok Uni.new(0x0061, 0x119E0, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x119E0, 0x094D, 0x05B0, 0x0062,), '0061 119E0 05B0 094D 3099 0062 -> 0061 3099 119E0 094D 05B0 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x11A34, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x11A34, 0x05B0, 0x0062,), '0061 05B0 094D 3099 11A34 0062 -> 0061 3099 094D 11A34 05B0 0062';
ok Uni.new(0x0061, 0x11A34, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x11A34, 0x094D, 0x05B0, 0x0062,), '0061 11A34 05B0 094D 3099 0062 -> 0061 3099 11A34 094D 05B0 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x11A47, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x11A47, 0x05B0, 0x0062,), '0061 05B0 094D 3099 11A47 0062 -> 0061 3099 094D 11A47 05B0 0062';
ok Uni.new(0x0061, 0x11A47, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x11A47, 0x094D, 0x05B0, 0x0062,), '0061 11A47 05B0 094D 3099 0062 -> 0061 3099 11A47 094D 05B0 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x11A99, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x11A99, 0x05B0, 0x0062,), '0061 05B0 094D 3099 11A99 0062 -> 0061 3099 094D 11A99 05B0 0062';
ok Uni.new(0x0061, 0x11A99, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x11A99, 0x094D, 0x05B0, 0x0062,), '0061 11A99 05B0 094D 3099 0062 -> 0061 3099 11A99 094D 05B0 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x11C3F, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x11C3F, 0x05B0, 0x0062,), '0061 05B0 094D 3099 11C3F 0062 -> 0061 3099 094D 11C3F 05B0 0062';
ok Uni.new(0x0061, 0x11C3F, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x11C3F, 0x094D, 0x05B0, 0x0062,), '0061 11C3F 05B0 094D 3099 0062 -> 0061 3099 11C3F 094D 05B0 0062';
ok Uni.new(0x0061, 0x3099, 0x093C, 0x16FF0, 0x11D42, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x093C, 0x11D42, 0x3099, 0x0062,), '0061 3099 093C 16FF0 11D42 0062 -> 0061 16FF0 093C 11D42 3099 0062';
ok Uni.new(0x0061, 0x11D42, 0x3099, 0x093C, 0x16FF0, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x11D42, 0x093C, 0x3099, 0x0062,), '0061 11D42 3099 093C 16FF0 0062 -> 0061 16FF0 11D42 093C 3099 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x11D44, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x11D44, 0x05B0, 0x0062,), '0061 05B0 094D 3099 11D44 0062 -> 0061 3099 094D 11D44 05B0 0062';
ok Uni.new(0x0061, 0x11D44, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x11D44, 0x094D, 0x05B0, 0x0062,), '0061 11D44 05B0 094D 3099 0062 -> 0061 3099 11D44 094D 05B0 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x11D45, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x11D45, 0x05B0, 0x0062,), '0061 05B0 094D 3099 11D45 0062 -> 0061 3099 094D 11D45 05B0 0062';
ok Uni.new(0x0061, 0x11D45, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x11D45, 0x094D, 0x05B0, 0x0062,), '0061 11D45 05B0 094D 3099 0062 -> 0061 3099 11D45 094D 05B0 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x11D97, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x11D97, 0x05B0, 0x0062,), '0061 05B0 094D 3099 11D97 0062 -> 0061 3099 094D 11D97 05B0 0062';
ok Uni.new(0x0061, 0x11D97, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x11D97, 0x094D, 0x05B0, 0x0062,), '0061 11D97 05B0 094D 3099 0062 -> 0061 3099 11D97 094D 05B0 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x11F41, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x11F41, 0x05B0, 0x0062,), '0061 05B0 094D 3099 11F41 0062 -> 0061 3099 094D 11F41 05B0 0062';
ok Uni.new(0x0061, 0x11F41, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x11F41, 0x094D, 0x05B0, 0x0062,), '0061 11F41 05B0 094D 3099 0062 -> 0061 3099 11F41 094D 05B0 0062';
ok Uni.new(0x0061, 0x05B0, 0x094D, 0x3099, 0x11F42, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x094D, 0x11F42, 0x05B0, 0x0062,), '0061 05B0 094D 3099 11F42 0062 -> 0061 3099 094D 11F42 05B0 0062';
ok Uni.new(0x0061, 0x11F42, 0x05B0, 0x094D, 0x3099, 0x0062).NFD.list ~~ (0x0061, 0x3099, 0x11F42, 0x094D, 0x05B0, 0x0062,), '0061 11F42 05B0 094D 3099 0062 -> 0061 3099 11F42 094D 05B0 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x16AF0, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x16AF0, 0x16FF0, 0x0062,), '0061 16FF0 0334 16AF0 0062 -> 0061 0334 16AF0 16FF0 0062';
ok Uni.new(0x0061, 0x16AF0, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x16AF0, 0x0334, 0x16FF0, 0x0062,), '0061 16AF0 16FF0 0334 0062 -> 0061 16AF0 0334 16FF0 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x16AF1, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x16AF1, 0x16FF0, 0x0062,), '0061 16FF0 0334 16AF1 0062 -> 0061 0334 16AF1 16FF0 0062';
ok Uni.new(0x0061, 0x16AF1, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x16AF1, 0x0334, 0x16FF0, 0x0062,), '0061 16AF1 16FF0 0334 0062 -> 0061 16AF1 0334 16FF0 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x16AF2, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x16AF2, 0x16FF0, 0x0062,), '0061 16FF0 0334 16AF2 0062 -> 0061 0334 16AF2 16FF0 0062';
ok Uni.new(0x0061, 0x16AF2, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x16AF2, 0x0334, 0x16FF0, 0x0062,), '0061 16AF2 16FF0 0334 0062 -> 0061 16AF2 0334 16FF0 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x16AF3, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x16AF3, 0x16FF0, 0x0062,), '0061 16FF0 0334 16AF3 0062 -> 0061 0334 16AF3 16FF0 0062';
ok Uni.new(0x0061, 0x16AF3, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x16AF3, 0x0334, 0x16FF0, 0x0062,), '0061 16AF3 16FF0 0334 0062 -> 0061 16AF3 0334 16FF0 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x16AF4, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x16AF4, 0x16FF0, 0x0062,), '0061 16FF0 0334 16AF4 0062 -> 0061 0334 16AF4 16FF0 0062';
ok Uni.new(0x0061, 0x16AF4, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x16AF4, 0x0334, 0x16FF0, 0x0062,), '0061 16AF4 16FF0 0334 0062 -> 0061 16AF4 0334 16FF0 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x16B30, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x16B30, 0x0315, 0x0062,), '0061 0315 0300 05AE 16B30 0062 -> 0061 05AE 0300 16B30 0315 0062';
ok Uni.new(0x0061, 0x16B30, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x16B30, 0x0300, 0x0315, 0x0062,), '0061 16B30 0315 0300 05AE 0062 -> 0061 05AE 16B30 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x16B31, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x16B31, 0x0315, 0x0062,), '0061 0315 0300 05AE 16B31 0062 -> 0061 05AE 0300 16B31 0315 0062';
ok Uni.new(0x0061, 0x16B31, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x16B31, 0x0300, 0x0315, 0x0062,), '0061 16B31 0315 0300 05AE 0062 -> 0061 05AE 16B31 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x16B32, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x16B32, 0x0315, 0x0062,), '0061 0315 0300 05AE 16B32 0062 -> 0061 05AE 0300 16B32 0315 0062';
ok Uni.new(0x0061, 0x16B32, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x16B32, 0x0300, 0x0315, 0x0062,), '0061 16B32 0315 0300 05AE 0062 -> 0061 05AE 16B32 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x16B33, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x16B33, 0x0315, 0x0062,), '0061 0315 0300 05AE 16B33 0062 -> 0061 05AE 0300 16B33 0315 0062';
ok Uni.new(0x0061, 0x16B33, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x16B33, 0x0300, 0x0315, 0x0062,), '0061 16B33 0315 0300 05AE 0062 -> 0061 05AE 16B33 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x16B34, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x16B34, 0x0315, 0x0062,), '0061 0315 0300 05AE 16B34 0062 -> 0061 05AE 0300 16B34 0315 0062';
ok Uni.new(0x0061, 0x16B34, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x16B34, 0x0300, 0x0315, 0x0062,), '0061 16B34 0315 0300 05AE 0062 -> 0061 05AE 16B34 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x16B35, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x16B35, 0x0315, 0x0062,), '0061 0315 0300 05AE 16B35 0062 -> 0061 05AE 0300 16B35 0315 0062';
ok Uni.new(0x0061, 0x16B35, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x16B35, 0x0300, 0x0315, 0x0062,), '0061 16B35 0315 0300 05AE 0062 -> 0061 05AE 16B35 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x16B36, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x16B36, 0x0315, 0x0062,), '0061 0315 0300 05AE 16B36 0062 -> 0061 05AE 0300 16B36 0315 0062';
ok Uni.new(0x0061, 0x16B36, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x16B36, 0x0300, 0x0315, 0x0062,), '0061 16B36 0315 0300 05AE 0062 -> 0061 05AE 16B36 0300 0315 0062';
ok Uni.new(0x0061, 0x093C, 0x16FF0, 0x0334, 0x16FF0, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x16FF0, 0x16FF0, 0x093C, 0x0062,), '0061 093C 16FF0 0334 16FF0 0062 -> 0061 0334 16FF0 16FF0 093C 0062';
ok Uni.new(0x0061, 0x16FF0, 0x093C, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x16FF0, 0x16FF0, 0x093C, 0x0062,), '0061 16FF0 093C 16FF0 0334 0062 -> 0061 0334 16FF0 16FF0 093C 0062';
ok Uni.new(0x0061, 0x093C, 0x16FF0, 0x0334, 0x16FF1, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x16FF0, 0x16FF1, 0x093C, 0x0062,), '0061 093C 16FF0 0334 16FF1 0062 -> 0061 0334 16FF0 16FF1 093C 0062';
ok Uni.new(0x0061, 0x16FF1, 0x093C, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x16FF1, 0x16FF0, 0x093C, 0x0062,), '0061 16FF1 093C 16FF0 0334 0062 -> 0061 0334 16FF1 16FF0 093C 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x1BC9E, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x1BC9E, 0x16FF0, 0x0062,), '0061 16FF0 0334 1BC9E 0062 -> 0061 0334 1BC9E 16FF0 0062';
ok Uni.new(0x0061, 0x1BC9E, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x1BC9E, 0x0334, 0x16FF0, 0x0062,), '0061 1BC9E 16FF0 0334 0062 -> 0061 1BC9E 0334 16FF0 0062';
ok Uni.new(0x0061, 0x1DFA, 0x031B, 0x1DCE, 0x1D165, 0x0062).NFD.list ~~ (0x0061, 0x1DCE, 0x031B, 0x1D165, 0x1DFA, 0x0062,), '0061 1DFA 031B 1DCE 1D165 0062 -> 0061 1DCE 031B 1D165 1DFA 0062';
ok Uni.new(0x0061, 0x1D165, 0x1DFA, 0x031B, 0x1DCE, 0x0062).NFD.list ~~ (0x0061, 0x1DCE, 0x1D165, 0x031B, 0x1DFA, 0x0062,), '0061 1D165 1DFA 031B 1DCE 0062 -> 0061 1DCE 1D165 031B 1DFA 0062';
ok Uni.new(0x0061, 0x1DFA, 0x031B, 0x1DCE, 0x1D166, 0x0062).NFD.list ~~ (0x0061, 0x1DCE, 0x031B, 0x1D166, 0x1DFA, 0x0062,), '0061 1DFA 031B 1DCE 1D166 0062 -> 0061 1DCE 031B 1D166 1DFA 0062';
ok Uni.new(0x0061, 0x1D166, 0x1DFA, 0x031B, 0x1DCE, 0x0062).NFD.list ~~ (0x0061, 0x1DCE, 0x1D166, 0x031B, 0x1DFA, 0x0062,), '0061 1D166 1DFA 031B 1DCE 0062 -> 0061 1DCE 1D166 031B 1DFA 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x1D167, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x1D167, 0x16FF0, 0x0062,), '0061 16FF0 0334 1D167 0062 -> 0061 0334 1D167 16FF0 0062';
ok Uni.new(0x0061, 0x1D167, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x1D167, 0x0334, 0x16FF0, 0x0062,), '0061 1D167 16FF0 0334 0062 -> 0061 1D167 0334 16FF0 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x1D168, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x1D168, 0x16FF0, 0x0062,), '0061 16FF0 0334 1D168 0062 -> 0061 0334 1D168 16FF0 0062';
ok Uni.new(0x0061, 0x1D168, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x1D168, 0x0334, 0x16FF0, 0x0062,), '0061 1D168 16FF0 0334 0062 -> 0061 1D168 0334 16FF0 0062';
ok Uni.new(0x0061, 0x16FF0, 0x0334, 0x1D169, 0x0062).NFD.list ~~ (0x0061, 0x0334, 0x1D169, 0x16FF0, 0x0062,), '0061 16FF0 0334 1D169 0062 -> 0061 0334 1D169 16FF0 0062';
ok Uni.new(0x0061, 0x1D169, 0x16FF0, 0x0334, 0x0062).NFD.list ~~ (0x0061, 0x1D169, 0x0334, 0x16FF0, 0x0062,), '0061 1D169 16FF0 0334 0062 -> 0061 1D169 0334 16FF0 0062';
ok Uni.new(0x0061, 0x05AE, 0x1D16D, 0x302E, 0x1D16D, 0x0062).NFD.list ~~ (0x0061, 0x302E, 0x1D16D, 0x1D16D, 0x05AE, 0x0062,), '0061 05AE 1D16D 302E 1D16D 0062 -> 0061 302E 1D16D 1D16D 05AE 0062';
ok Uni.new(0x0061, 0x1D16D, 0x05AE, 0x1D16D, 0x302E, 0x0062).NFD.list ~~ (0x0061, 0x302E, 0x1D16D, 0x1D16D, 0x05AE, 0x0062,), '0061 1D16D 05AE 1D16D 302E 0062 -> 0061 302E 1D16D 1D16D 05AE 0062';
ok Uni.new(0x0061, 0x1DFA, 0x031B, 0x1DCE, 0x1D16E, 0x0062).NFD.list ~~ (0x0061, 0x1DCE, 0x031B, 0x1D16E, 0x1DFA, 0x0062,), '0061 1DFA 031B 1DCE 1D16E 0062 -> 0061 1DCE 031B 1D16E 1DFA 0062';
ok Uni.new(0x0061, 0x1D16E, 0x1DFA, 0x031B, 0x1DCE, 0x0062).NFD.list ~~ (0x0061, 0x1DCE, 0x1D16E, 0x031B, 0x1DFA, 0x0062,), '0061 1D16E 1DFA 031B 1DCE 0062 -> 0061 1DCE 1D16E 031B 1DFA 0062';
ok Uni.new(0x0061, 0x1DFA, 0x031B, 0x1DCE, 0x1D16F, 0x0062).NFD.list ~~ (0x0061, 0x1DCE, 0x031B, 0x1D16F, 0x1DFA, 0x0062,), '0061 1DFA 031B 1DCE 1D16F 0062 -> 0061 1DCE 031B 1D16F 1DFA 0062';
ok Uni.new(0x0061, 0x1D16F, 0x1DFA, 0x031B, 0x1DCE, 0x0062).NFD.list ~~ (0x0061, 0x1DCE, 0x1D16F, 0x031B, 0x1DFA, 0x0062,), '0061 1D16F 1DFA 031B 1DCE 0062 -> 0061 1DCE 1D16F 031B 1DFA 0062';
ok Uni.new(0x0061, 0x1DFA, 0x031B, 0x1DCE, 0x1D170, 0x0062).NFD.list ~~ (0x0061, 0x1DCE, 0x031B, 0x1D170, 0x1DFA, 0x0062,), '0061 1DFA 031B 1DCE 1D170 0062 -> 0061 1DCE 031B 1D170 1DFA 0062';
ok Uni.new(0x0061, 0x1D170, 0x1DFA, 0x031B, 0x1DCE, 0x0062).NFD.list ~~ (0x0061, 0x1DCE, 0x1D170, 0x031B, 0x1DFA, 0x0062,), '0061 1D170 1DFA 031B 1DCE 0062 -> 0061 1DCE 1D170 031B 1DFA 0062';
ok Uni.new(0x0061, 0x1DFA, 0x031B, 0x1DCE, 0x1D171, 0x0062).NFD.list ~~ (0x0061, 0x1DCE, 0x031B, 0x1D171, 0x1DFA, 0x0062,), '0061 1DFA 031B 1DCE 1D171 0062 -> 0061 1DCE 031B 1D171 1DFA 0062';
ok Uni.new(0x0061, 0x1D171, 0x1DFA, 0x031B, 0x1DCE, 0x0062).NFD.list ~~ (0x0061, 0x1DCE, 0x1D171, 0x031B, 0x1DFA, 0x0062,), '0061 1D171 1DFA 031B 1DCE 0062 -> 0061 1DCE 1D171 031B 1DFA 0062';
ok Uni.new(0x0061, 0x1DFA, 0x031B, 0x1DCE, 0x1D172, 0x0062).NFD.list ~~ (0x0061, 0x1DCE, 0x031B, 0x1D172, 0x1DFA, 0x0062,), '0061 1DFA 031B 1DCE 1D172 0062 -> 0061 1DCE 031B 1D172 1DFA 0062';
ok Uni.new(0x0061, 0x1D172, 0x1DFA, 0x031B, 0x1DCE, 0x0062).NFD.list ~~ (0x0061, 0x1DCE, 0x1D172, 0x031B, 0x1DFA, 0x0062,), '0061 1D172 1DFA 031B 1DCE 0062 -> 0061 1DCE 1D172 031B 1DFA 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D17B, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1D17B, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1D17B 0062 -> 0061 1DFA 0316 1D17B 059A 0062';
ok Uni.new(0x0061, 0x1D17B, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1D17B, 0x0316, 0x059A, 0x0062,), '0061 1D17B 059A 0316 1DFA 0062 -> 0061 1DFA 1D17B 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D17C, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1D17C, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1D17C 0062 -> 0061 1DFA 0316 1D17C 059A 0062';
ok Uni.new(0x0061, 0x1D17C, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1D17C, 0x0316, 0x059A, 0x0062,), '0061 1D17C 059A 0316 1DFA 0062 -> 0061 1DFA 1D17C 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D17D, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1D17D, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1D17D 0062 -> 0061 1DFA 0316 1D17D 059A 0062';
ok Uni.new(0x0061, 0x1D17D, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1D17D, 0x0316, 0x059A, 0x0062,), '0061 1D17D 059A 0316 1DFA 0062 -> 0061 1DFA 1D17D 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D17E, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1D17E, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1D17E 0062 -> 0061 1DFA 0316 1D17E 059A 0062';
ok Uni.new(0x0061, 0x1D17E, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1D17E, 0x0316, 0x059A, 0x0062,), '0061 1D17E 059A 0316 1DFA 0062 -> 0061 1DFA 1D17E 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D17F, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1D17F, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1D17F 0062 -> 0061 1DFA 0316 1D17F 059A 0062';
ok Uni.new(0x0061, 0x1D17F, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1D17F, 0x0316, 0x059A, 0x0062,), '0061 1D17F 059A 0316 1DFA 0062 -> 0061 1DFA 1D17F 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D180, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1D180, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1D180 0062 -> 0061 1DFA 0316 1D180 059A 0062';
ok Uni.new(0x0061, 0x1D180, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1D180, 0x0316, 0x059A, 0x0062,), '0061 1D180 059A 0316 1DFA 0062 -> 0061 1DFA 1D180 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D181, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1D181, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1D181 0062 -> 0061 1DFA 0316 1D181 059A 0062';
ok Uni.new(0x0061, 0x1D181, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1D181, 0x0316, 0x059A, 0x0062,), '0061 1D181 059A 0316 1DFA 0062 -> 0061 1DFA 1D181 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D182, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1D182, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1D182 0062 -> 0061 1DFA 0316 1D182 059A 0062';
ok Uni.new(0x0061, 0x1D182, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1D182, 0x0316, 0x059A, 0x0062,), '0061 1D182 059A 0316 1DFA 0062 -> 0061 1DFA 1D182 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1D185, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1D185, 0x0315, 0x0062,), '0061 0315 0300 05AE 1D185 0062 -> 0061 05AE 0300 1D185 0315 0062';
ok Uni.new(0x0061, 0x1D185, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1D185, 0x0300, 0x0315, 0x0062,), '0061 1D185 0315 0300 05AE 0062 -> 0061 05AE 1D185 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1D186, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1D186, 0x0315, 0x0062,), '0061 0315 0300 05AE 1D186 0062 -> 0061 05AE 0300 1D186 0315 0062';
ok Uni.new(0x0061, 0x1D186, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1D186, 0x0300, 0x0315, 0x0062,), '0061 1D186 0315 0300 05AE 0062 -> 0061 05AE 1D186 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1D187, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1D187, 0x0315, 0x0062,), '0061 0315 0300 05AE 1D187 0062 -> 0061 05AE 0300 1D187 0315 0062';
ok Uni.new(0x0061, 0x1D187, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1D187, 0x0300, 0x0315, 0x0062,), '0061 1D187 0315 0300 05AE 0062 -> 0061 05AE 1D187 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1D188, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1D188, 0x0315, 0x0062,), '0061 0315 0300 05AE 1D188 0062 -> 0061 05AE 0300 1D188 0315 0062';
ok Uni.new(0x0061, 0x1D188, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1D188, 0x0300, 0x0315, 0x0062,), '0061 1D188 0315 0300 05AE 0062 -> 0061 05AE 1D188 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1D189, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1D189, 0x0315, 0x0062,), '0061 0315 0300 05AE 1D189 0062 -> 0061 05AE 0300 1D189 0315 0062';
ok Uni.new(0x0061, 0x1D189, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1D189, 0x0300, 0x0315, 0x0062,), '0061 1D189 0315 0300 05AE 0062 -> 0061 05AE 1D189 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D18A, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1D18A, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1D18A 0062 -> 0061 1DFA 0316 1D18A 059A 0062';
ok Uni.new(0x0061, 0x1D18A, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1D18A, 0x0316, 0x059A, 0x0062,), '0061 1D18A 059A 0316 1DFA 0062 -> 0061 1DFA 1D18A 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1D18B, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1D18B, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1D18B 0062 -> 0061 1DFA 0316 1D18B 059A 0062';
ok Uni.new(0x0061, 0x1D18B, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1D18B, 0x0316, 0x059A, 0x0062,), '0061 1D18B 059A 0316 1DFA 0062 -> 0061 1DFA 1D18B 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1D1AA, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1D1AA, 0x0315, 0x0062,), '0061 0315 0300 05AE 1D1AA 0062 -> 0061 05AE 0300 1D1AA 0315 0062';
ok Uni.new(0x0061, 0x1D1AA, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1D1AA, 0x0300, 0x0315, 0x0062,), '0061 1D1AA 0315 0300 05AE 0062 -> 0061 05AE 1D1AA 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1D1AB, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1D1AB, 0x0315, 0x0062,), '0061 0315 0300 05AE 1D1AB 0062 -> 0061 05AE 0300 1D1AB 0315 0062';
ok Uni.new(0x0061, 0x1D1AB, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1D1AB, 0x0300, 0x0315, 0x0062,), '0061 1D1AB 0315 0300 05AE 0062 -> 0061 05AE 1D1AB 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1D1AC, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1D1AC, 0x0315, 0x0062,), '0061 0315 0300 05AE 1D1AC 0062 -> 0061 05AE 0300 1D1AC 0315 0062';
ok Uni.new(0x0061, 0x1D1AC, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1D1AC, 0x0300, 0x0315, 0x0062,), '0061 1D1AC 0315 0300 05AE 0062 -> 0061 05AE 1D1AC 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1D1AD, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1D1AD, 0x0315, 0x0062,), '0061 0315 0300 05AE 1D1AD 0062 -> 0061 05AE 0300 1D1AD 0315 0062';
ok Uni.new(0x0061, 0x1D1AD, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1D1AD, 0x0300, 0x0315, 0x0062,), '0061 1D1AD 0315 0300 05AE 0062 -> 0061 05AE 1D1AD 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1D242, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1D242, 0x0315, 0x0062,), '0061 0315 0300 05AE 1D242 0062 -> 0061 05AE 0300 1D242 0315 0062';
ok Uni.new(0x0061, 0x1D242, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1D242, 0x0300, 0x0315, 0x0062,), '0061 1D242 0315 0300 05AE 0062 -> 0061 05AE 1D242 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1D243, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1D243, 0x0315, 0x0062,), '0061 0315 0300 05AE 1D243 0062 -> 0061 05AE 0300 1D243 0315 0062';
ok Uni.new(0x0061, 0x1D243, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1D243, 0x0300, 0x0315, 0x0062,), '0061 1D243 0315 0300 05AE 0062 -> 0061 05AE 1D243 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1D244, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1D244, 0x0315, 0x0062,), '0061 0315 0300 05AE 1D244 0062 -> 0061 05AE 0300 1D244 0315 0062';
ok Uni.new(0x0061, 0x1D244, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1D244, 0x0300, 0x0315, 0x0062,), '0061 1D244 0315 0300 05AE 0062 -> 0061 05AE 1D244 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E000, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E000, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E000 0062 -> 0061 05AE 0300 1E000 0315 0062';
ok Uni.new(0x0061, 0x1E000, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E000, 0x0300, 0x0315, 0x0062,), '0061 1E000 0315 0300 05AE 0062 -> 0061 05AE 1E000 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E001, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E001, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E001 0062 -> 0061 05AE 0300 1E001 0315 0062';
ok Uni.new(0x0061, 0x1E001, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E001, 0x0300, 0x0315, 0x0062,), '0061 1E001 0315 0300 05AE 0062 -> 0061 05AE 1E001 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E002, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E002, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E002 0062 -> 0061 05AE 0300 1E002 0315 0062';
ok Uni.new(0x0061, 0x1E002, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E002, 0x0300, 0x0315, 0x0062,), '0061 1E002 0315 0300 05AE 0062 -> 0061 05AE 1E002 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E003, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E003, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E003 0062 -> 0061 05AE 0300 1E003 0315 0062';
ok Uni.new(0x0061, 0x1E003, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E003, 0x0300, 0x0315, 0x0062,), '0061 1E003 0315 0300 05AE 0062 -> 0061 05AE 1E003 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E004, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E004, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E004 0062 -> 0061 05AE 0300 1E004 0315 0062';
ok Uni.new(0x0061, 0x1E004, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E004, 0x0300, 0x0315, 0x0062,), '0061 1E004 0315 0300 05AE 0062 -> 0061 05AE 1E004 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E005, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E005, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E005 0062 -> 0061 05AE 0300 1E005 0315 0062';
ok Uni.new(0x0061, 0x1E005, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E005, 0x0300, 0x0315, 0x0062,), '0061 1E005 0315 0300 05AE 0062 -> 0061 05AE 1E005 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E006, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E006, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E006 0062 -> 0061 05AE 0300 1E006 0315 0062';
ok Uni.new(0x0061, 0x1E006, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E006, 0x0300, 0x0315, 0x0062,), '0061 1E006 0315 0300 05AE 0062 -> 0061 05AE 1E006 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E008, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E008, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E008 0062 -> 0061 05AE 0300 1E008 0315 0062';
ok Uni.new(0x0061, 0x1E008, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E008, 0x0300, 0x0315, 0x0062,), '0061 1E008 0315 0300 05AE 0062 -> 0061 05AE 1E008 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E009, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E009, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E009 0062 -> 0061 05AE 0300 1E009 0315 0062';
ok Uni.new(0x0061, 0x1E009, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E009, 0x0300, 0x0315, 0x0062,), '0061 1E009 0315 0300 05AE 0062 -> 0061 05AE 1E009 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E00A, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E00A, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E00A 0062 -> 0061 05AE 0300 1E00A 0315 0062';
ok Uni.new(0x0061, 0x1E00A, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E00A, 0x0300, 0x0315, 0x0062,), '0061 1E00A 0315 0300 05AE 0062 -> 0061 05AE 1E00A 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E00B, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E00B, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E00B 0062 -> 0061 05AE 0300 1E00B 0315 0062';
ok Uni.new(0x0061, 0x1E00B, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E00B, 0x0300, 0x0315, 0x0062,), '0061 1E00B 0315 0300 05AE 0062 -> 0061 05AE 1E00B 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E00C, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E00C, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E00C 0062 -> 0061 05AE 0300 1E00C 0315 0062';
ok Uni.new(0x0061, 0x1E00C, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E00C, 0x0300, 0x0315, 0x0062,), '0061 1E00C 0315 0300 05AE 0062 -> 0061 05AE 1E00C 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E00D, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E00D, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E00D 0062 -> 0061 05AE 0300 1E00D 0315 0062';
ok Uni.new(0x0061, 0x1E00D, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E00D, 0x0300, 0x0315, 0x0062,), '0061 1E00D 0315 0300 05AE 0062 -> 0061 05AE 1E00D 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E00E, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E00E, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E00E 0062 -> 0061 05AE 0300 1E00E 0315 0062';
ok Uni.new(0x0061, 0x1E00E, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E00E, 0x0300, 0x0315, 0x0062,), '0061 1E00E 0315 0300 05AE 0062 -> 0061 05AE 1E00E 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E00F, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E00F, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E00F 0062 -> 0061 05AE 0300 1E00F 0315 0062';
ok Uni.new(0x0061, 0x1E00F, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E00F, 0x0300, 0x0315, 0x0062,), '0061 1E00F 0315 0300 05AE 0062 -> 0061 05AE 1E00F 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E010, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E010, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E010 0062 -> 0061 05AE 0300 1E010 0315 0062';
ok Uni.new(0x0061, 0x1E010, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E010, 0x0300, 0x0315, 0x0062,), '0061 1E010 0315 0300 05AE 0062 -> 0061 05AE 1E010 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E011, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E011, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E011 0062 -> 0061 05AE 0300 1E011 0315 0062';
ok Uni.new(0x0061, 0x1E011, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E011, 0x0300, 0x0315, 0x0062,), '0061 1E011 0315 0300 05AE 0062 -> 0061 05AE 1E011 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E012, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E012, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E012 0062 -> 0061 05AE 0300 1E012 0315 0062';
ok Uni.new(0x0061, 0x1E012, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E012, 0x0300, 0x0315, 0x0062,), '0061 1E012 0315 0300 05AE 0062 -> 0061 05AE 1E012 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E013, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E013, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E013 0062 -> 0061 05AE 0300 1E013 0315 0062';
ok Uni.new(0x0061, 0x1E013, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E013, 0x0300, 0x0315, 0x0062,), '0061 1E013 0315 0300 05AE 0062 -> 0061 05AE 1E013 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E014, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E014, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E014 0062 -> 0061 05AE 0300 1E014 0315 0062';
ok Uni.new(0x0061, 0x1E014, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E014, 0x0300, 0x0315, 0x0062,), '0061 1E014 0315 0300 05AE 0062 -> 0061 05AE 1E014 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E015, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E015, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E015 0062 -> 0061 05AE 0300 1E015 0315 0062';
ok Uni.new(0x0061, 0x1E015, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E015, 0x0300, 0x0315, 0x0062,), '0061 1E015 0315 0300 05AE 0062 -> 0061 05AE 1E015 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E016, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E016, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E016 0062 -> 0061 05AE 0300 1E016 0315 0062';
ok Uni.new(0x0061, 0x1E016, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E016, 0x0300, 0x0315, 0x0062,), '0061 1E016 0315 0300 05AE 0062 -> 0061 05AE 1E016 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E017, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E017, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E017 0062 -> 0061 05AE 0300 1E017 0315 0062';
ok Uni.new(0x0061, 0x1E017, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E017, 0x0300, 0x0315, 0x0062,), '0061 1E017 0315 0300 05AE 0062 -> 0061 05AE 1E017 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E018, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E018, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E018 0062 -> 0061 05AE 0300 1E018 0315 0062';
ok Uni.new(0x0061, 0x1E018, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E018, 0x0300, 0x0315, 0x0062,), '0061 1E018 0315 0300 05AE 0062 -> 0061 05AE 1E018 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E01B, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E01B, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E01B 0062 -> 0061 05AE 0300 1E01B 0315 0062';
ok Uni.new(0x0061, 0x1E01B, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E01B, 0x0300, 0x0315, 0x0062,), '0061 1E01B 0315 0300 05AE 0062 -> 0061 05AE 1E01B 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E01C, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E01C, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E01C 0062 -> 0061 05AE 0300 1E01C 0315 0062';
ok Uni.new(0x0061, 0x1E01C, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E01C, 0x0300, 0x0315, 0x0062,), '0061 1E01C 0315 0300 05AE 0062 -> 0061 05AE 1E01C 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E01D, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E01D, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E01D 0062 -> 0061 05AE 0300 1E01D 0315 0062';
ok Uni.new(0x0061, 0x1E01D, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E01D, 0x0300, 0x0315, 0x0062,), '0061 1E01D 0315 0300 05AE 0062 -> 0061 05AE 1E01D 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E01E, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E01E, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E01E 0062 -> 0061 05AE 0300 1E01E 0315 0062';
ok Uni.new(0x0061, 0x1E01E, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E01E, 0x0300, 0x0315, 0x0062,), '0061 1E01E 0315 0300 05AE 0062 -> 0061 05AE 1E01E 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E01F, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E01F, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E01F 0062 -> 0061 05AE 0300 1E01F 0315 0062';
ok Uni.new(0x0061, 0x1E01F, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E01F, 0x0300, 0x0315, 0x0062,), '0061 1E01F 0315 0300 05AE 0062 -> 0061 05AE 1E01F 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E020, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E020, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E020 0062 -> 0061 05AE 0300 1E020 0315 0062';
ok Uni.new(0x0061, 0x1E020, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E020, 0x0300, 0x0315, 0x0062,), '0061 1E020 0315 0300 05AE 0062 -> 0061 05AE 1E020 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E021, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E021, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E021 0062 -> 0061 05AE 0300 1E021 0315 0062';
ok Uni.new(0x0061, 0x1E021, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E021, 0x0300, 0x0315, 0x0062,), '0061 1E021 0315 0300 05AE 0062 -> 0061 05AE 1E021 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E023, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E023, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E023 0062 -> 0061 05AE 0300 1E023 0315 0062';
ok Uni.new(0x0061, 0x1E023, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E023, 0x0300, 0x0315, 0x0062,), '0061 1E023 0315 0300 05AE 0062 -> 0061 05AE 1E023 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E024, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E024, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E024 0062 -> 0061 05AE 0300 1E024 0315 0062';
ok Uni.new(0x0061, 0x1E024, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E024, 0x0300, 0x0315, 0x0062,), '0061 1E024 0315 0300 05AE 0062 -> 0061 05AE 1E024 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E026, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E026, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E026 0062 -> 0061 05AE 0300 1E026 0315 0062';
ok Uni.new(0x0061, 0x1E026, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E026, 0x0300, 0x0315, 0x0062,), '0061 1E026 0315 0300 05AE 0062 -> 0061 05AE 1E026 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E027, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E027, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E027 0062 -> 0061 05AE 0300 1E027 0315 0062';
ok Uni.new(0x0061, 0x1E027, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E027, 0x0300, 0x0315, 0x0062,), '0061 1E027 0315 0300 05AE 0062 -> 0061 05AE 1E027 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E028, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E028, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E028 0062 -> 0061 05AE 0300 1E028 0315 0062';
ok Uni.new(0x0061, 0x1E028, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E028, 0x0300, 0x0315, 0x0062,), '0061 1E028 0315 0300 05AE 0062 -> 0061 05AE 1E028 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E029, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E029, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E029 0062 -> 0061 05AE 0300 1E029 0315 0062';
ok Uni.new(0x0061, 0x1E029, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E029, 0x0300, 0x0315, 0x0062,), '0061 1E029 0315 0300 05AE 0062 -> 0061 05AE 1E029 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E02A, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E02A, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E02A 0062 -> 0061 05AE 0300 1E02A 0315 0062';
ok Uni.new(0x0061, 0x1E02A, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E02A, 0x0300, 0x0315, 0x0062,), '0061 1E02A 0315 0300 05AE 0062 -> 0061 05AE 1E02A 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E08F, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E08F, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E08F 0062 -> 0061 05AE 0300 1E08F 0315 0062';
ok Uni.new(0x0061, 0x1E08F, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E08F, 0x0300, 0x0315, 0x0062,), '0061 1E08F 0315 0300 05AE 0062 -> 0061 05AE 1E08F 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E130, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E130, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E130 0062 -> 0061 05AE 0300 1E130 0315 0062';
ok Uni.new(0x0061, 0x1E130, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E130, 0x0300, 0x0315, 0x0062,), '0061 1E130 0315 0300 05AE 0062 -> 0061 05AE 1E130 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E131, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E131, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E131 0062 -> 0061 05AE 0300 1E131 0315 0062';
ok Uni.new(0x0061, 0x1E131, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E131, 0x0300, 0x0315, 0x0062,), '0061 1E131 0315 0300 05AE 0062 -> 0061 05AE 1E131 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E132, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E132, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E132 0062 -> 0061 05AE 0300 1E132 0315 0062';
ok Uni.new(0x0061, 0x1E132, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E132, 0x0300, 0x0315, 0x0062,), '0061 1E132 0315 0300 05AE 0062 -> 0061 05AE 1E132 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E133, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E133, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E133 0062 -> 0061 05AE 0300 1E133 0315 0062';
ok Uni.new(0x0061, 0x1E133, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E133, 0x0300, 0x0315, 0x0062,), '0061 1E133 0315 0300 05AE 0062 -> 0061 05AE 1E133 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E134, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E134, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E134 0062 -> 0061 05AE 0300 1E134 0315 0062';
ok Uni.new(0x0061, 0x1E134, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E134, 0x0300, 0x0315, 0x0062,), '0061 1E134 0315 0300 05AE 0062 -> 0061 05AE 1E134 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E135, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E135, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E135 0062 -> 0061 05AE 0300 1E135 0315 0062';
ok Uni.new(0x0061, 0x1E135, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E135, 0x0300, 0x0315, 0x0062,), '0061 1E135 0315 0300 05AE 0062 -> 0061 05AE 1E135 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E136, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E136, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E136 0062 -> 0061 05AE 0300 1E136 0315 0062';
ok Uni.new(0x0061, 0x1E136, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E136, 0x0300, 0x0315, 0x0062,), '0061 1E136 0315 0300 05AE 0062 -> 0061 05AE 1E136 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E2AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E2AE, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E2AE 0062 -> 0061 05AE 0300 1E2AE 0315 0062';
ok Uni.new(0x0061, 0x1E2AE, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E2AE, 0x0300, 0x0315, 0x0062,), '0061 1E2AE 0315 0300 05AE 0062 -> 0061 05AE 1E2AE 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E2EC, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E2EC, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E2EC 0062 -> 0061 05AE 0300 1E2EC 0315 0062';
ok Uni.new(0x0061, 0x1E2EC, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E2EC, 0x0300, 0x0315, 0x0062,), '0061 1E2EC 0315 0300 05AE 0062 -> 0061 05AE 1E2EC 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E2ED, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E2ED, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E2ED 0062 -> 0061 05AE 0300 1E2ED 0315 0062';
ok Uni.new(0x0061, 0x1E2ED, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E2ED, 0x0300, 0x0315, 0x0062,), '0061 1E2ED 0315 0300 05AE 0062 -> 0061 05AE 1E2ED 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E2EE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E2EE, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E2EE 0062 -> 0061 05AE 0300 1E2EE 0315 0062';
ok Uni.new(0x0061, 0x1E2EE, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E2EE, 0x0300, 0x0315, 0x0062,), '0061 1E2EE 0315 0300 05AE 0062 -> 0061 05AE 1E2EE 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E2EF, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E2EF, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E2EF 0062 -> 0061 05AE 0300 1E2EF 0315 0062';
ok Uni.new(0x0061, 0x1E2EF, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E2EF, 0x0300, 0x0315, 0x0062,), '0061 1E2EF 0315 0300 05AE 0062 -> 0061 05AE 1E2EF 0300 0315 0062';
ok Uni.new(0x0061, 0x035C, 0x0315, 0x0300, 0x1E4EC, 0x0062).NFD.list ~~ (0x0061, 0x0300, 0x0315, 0x1E4EC, 0x035C, 0x0062,), '0061 035C 0315 0300 1E4EC 0062 -> 0061 0300 0315 1E4EC 035C 0062';
ok Uni.new(0x0061, 0x1E4EC, 0x035C, 0x0315, 0x0300, 0x0062).NFD.list ~~ (0x0061, 0x0300, 0x1E4EC, 0x0315, 0x035C, 0x0062,), '0061 1E4EC 035C 0315 0300 0062 -> 0061 0300 1E4EC 0315 035C 0062';
ok Uni.new(0x0061, 0x035C, 0x0315, 0x0300, 0x1E4ED, 0x0062).NFD.list ~~ (0x0061, 0x0300, 0x0315, 0x1E4ED, 0x035C, 0x0062,), '0061 035C 0315 0300 1E4ED 0062 -> 0061 0300 0315 1E4ED 035C 0062';
ok Uni.new(0x0061, 0x1E4ED, 0x035C, 0x0315, 0x0300, 0x0062).NFD.list ~~ (0x0061, 0x0300, 0x1E4ED, 0x0315, 0x035C, 0x0062,), '0061 1E4ED 035C 0315 0300 0062 -> 0061 0300 1E4ED 0315 035C 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1E4EE, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1E4EE, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1E4EE 0062 -> 0061 1DFA 0316 1E4EE 059A 0062';
ok Uni.new(0x0061, 0x1E4EE, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1E4EE, 0x0316, 0x059A, 0x0062,), '0061 1E4EE 059A 0316 1DFA 0062 -> 0061 1DFA 1E4EE 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E4EF, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E4EF, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E4EF 0062 -> 0061 05AE 0300 1E4EF 0315 0062';
ok Uni.new(0x0061, 0x1E4EF, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E4EF, 0x0300, 0x0315, 0x0062,), '0061 1E4EF 0315 0300 05AE 0062 -> 0061 05AE 1E4EF 0300 0315 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1E8D0, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1E8D0, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1E8D0 0062 -> 0061 1DFA 0316 1E8D0 059A 0062';
ok Uni.new(0x0061, 0x1E8D0, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1E8D0, 0x0316, 0x059A, 0x0062,), '0061 1E8D0 059A 0316 1DFA 0062 -> 0061 1DFA 1E8D0 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1E8D1, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1E8D1, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1E8D1 0062 -> 0061 1DFA 0316 1E8D1 059A 0062';
ok Uni.new(0x0061, 0x1E8D1, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1E8D1, 0x0316, 0x059A, 0x0062,), '0061 1E8D1 059A 0316 1DFA 0062 -> 0061 1DFA 1E8D1 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1E8D2, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1E8D2, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1E8D2 0062 -> 0061 1DFA 0316 1E8D2 059A 0062';
ok Uni.new(0x0061, 0x1E8D2, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1E8D2, 0x0316, 0x059A, 0x0062,), '0061 1E8D2 059A 0316 1DFA 0062 -> 0061 1DFA 1E8D2 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1E8D3, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1E8D3, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1E8D3 0062 -> 0061 1DFA 0316 1E8D3 059A 0062';
ok Uni.new(0x0061, 0x1E8D3, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1E8D3, 0x0316, 0x059A, 0x0062,), '0061 1E8D3 059A 0316 1DFA 0062 -> 0061 1DFA 1E8D3 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1E8D4, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1E8D4, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1E8D4 0062 -> 0061 1DFA 0316 1E8D4 059A 0062';
ok Uni.new(0x0061, 0x1E8D4, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1E8D4, 0x0316, 0x059A, 0x0062,), '0061 1E8D4 059A 0316 1DFA 0062 -> 0061 1DFA 1E8D4 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1E8D5, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1E8D5, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1E8D5 0062 -> 0061 1DFA 0316 1E8D5 059A 0062';
ok Uni.new(0x0061, 0x1E8D5, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1E8D5, 0x0316, 0x059A, 0x0062,), '0061 1E8D5 059A 0316 1DFA 0062 -> 0061 1DFA 1E8D5 0316 059A 0062';
ok Uni.new(0x0061, 0x059A, 0x0316, 0x1DFA, 0x1E8D6, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x0316, 0x1E8D6, 0x059A, 0x0062,), '0061 059A 0316 1DFA 1E8D6 0062 -> 0061 1DFA 0316 1E8D6 059A 0062';
ok Uni.new(0x0061, 0x1E8D6, 0x059A, 0x0316, 0x1DFA, 0x0062).NFD.list ~~ (0x0061, 0x1DFA, 0x1E8D6, 0x0316, 0x059A, 0x0062,), '0061 1E8D6 059A 0316 1DFA 0062 -> 0061 1DFA 1E8D6 0316 059A 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E944, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E944, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E944 0062 -> 0061 05AE 0300 1E944 0315 0062';
ok Uni.new(0x0061, 0x1E944, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E944, 0x0300, 0x0315, 0x0062,), '0061 1E944 0315 0300 05AE 0062 -> 0061 05AE 1E944 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E945, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E945, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E945 0062 -> 0061 05AE 0300 1E945 0315 0062';
ok Uni.new(0x0061, 0x1E945, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E945, 0x0300, 0x0315, 0x0062,), '0061 1E945 0315 0300 05AE 0062 -> 0061 05AE 1E945 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E946, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E946, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E946 0062 -> 0061 05AE 0300 1E946 0315 0062';
ok Uni.new(0x0061, 0x1E946, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E946, 0x0300, 0x0315, 0x0062,), '0061 1E946 0315 0300 05AE 0062 -> 0061 05AE 1E946 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E947, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E947, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E947 0062 -> 0061 05AE 0300 1E947 0315 0062';
ok Uni.new(0x0061, 0x1E947, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E947, 0x0300, 0x0315, 0x0062,), '0061 1E947 0315 0300 05AE 0062 -> 0061 05AE 1E947 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E948, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E948, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E948 0062 -> 0061 05AE 0300 1E948 0315 0062';
ok Uni.new(0x0061, 0x1E948, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E948, 0x0300, 0x0315, 0x0062,), '0061 1E948 0315 0300 05AE 0062 -> 0061 05AE 1E948 0300 0315 0062';
ok Uni.new(0x0061, 0x0315, 0x0300, 0x05AE, 0x1E949, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x0300, 0x1E949, 0x0315, 0x0062,), '0061 0315 0300 05AE 1E949 0062 -> 0061 05AE 0300 1E949 0315 0062';
ok Uni.new(0x0061, 0x1E949, 0x0315, 0x0300, 0x05AE, 0x0062).NFD.list ~~ (0x0061, 0x05AE, 0x1E949, 0x0300, 0x0315, 0x0062,), '0061 1E949 0315 0300 05AE 0062 -> 0061 05AE 1E949 0300 0315 0062';
ok Uni.new(0x0061, 0x3099, 0x093C, 0x16FF0, 0x1E94A, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x093C, 0x1E94A, 0x3099, 0x0062,), '0061 3099 093C 16FF0 1E94A 0062 -> 0061 16FF0 093C 1E94A 3099 0062';
ok Uni.new(0x0061, 0x1E94A, 0x3099, 0x093C, 0x16FF0, 0x0062).NFD.list ~~ (0x0061, 0x16FF0, 0x1E94A, 0x093C, 0x3099, 0x0062,), '0061 1E94A 3099 093C 16FF0 0062 -> 0061 16FF0 1E94A 093C 3099 0062';
ok Uni.new(0x09C7, 0x0334, 0x09BE).NFD.list ~~ (0x09C7, 0x0334, 0x09BE,), '09C7 0334 09BE -> 09C7 0334 09BE';
ok Uni.new(0x09C7, 0x0334, 0x09D7).NFD.list ~~ (0x09C7, 0x0334, 0x09D7,), '09C7 0334 09D7 -> 09C7 0334 09D7';
ok Uni.new(0x0B47, 0x0334, 0x0B3E).NFD.list ~~ (0x0B47, 0x0334, 0x0B3E,), '0B47 0334 0B3E -> 0B47 0334 0B3E';
ok Uni.new(0x0B47, 0x0334, 0x0B56).NFD.list ~~ (0x0B47, 0x0334, 0x0B56,), '0B47 0334 0B56 -> 0B47 0334 0B56';
ok Uni.new(0x0B47, 0x0334, 0x0B57).NFD.list ~~ (0x0B47, 0x0334, 0x0B57,), '0B47 0334 0B57 -> 0B47 0334 0B57';
ok Uni.new(0x0B92, 0x0334, 0x0BD7).NFD.list ~~ (0x0B92, 0x0334, 0x0BD7,), '0B92 0334 0BD7 -> 0B92 0334 0BD7';
ok Uni.new(0x0BC6, 0x0334, 0x0BBE).NFD.list ~~ (0x0BC6, 0x0334, 0x0BBE,), '0BC6 0334 0BBE -> 0BC6 0334 0BBE';
ok Uni.new(0x0BC6, 0x0334, 0x0BD7).NFD.list ~~ (0x0BC6, 0x0334, 0x0BD7,), '0BC6 0334 0BD7 -> 0BC6 0334 0BD7';
ok Uni.new(0x0BC7, 0x0334, 0x0BBE).NFD.list ~~ (0x0BC7, 0x0334, 0x0BBE,), '0BC7 0334 0BBE -> 0BC7 0334 0BBE';
ok Uni.new(0x0CBF, 0x0334, 0x0CD5).NFD.list ~~ (0x0CBF, 0x0334, 0x0CD5,), '0CBF 0334 0CD5 -> 0CBF 0334 0CD5';
ok Uni.new(0x0CC6, 0x0334, 0x0CC2).NFD.list ~~ (0x0CC6, 0x0334, 0x0CC2,), '0CC6 0334 0CC2 -> 0CC6 0334 0CC2';
ok Uni.new(0x0CC6, 0x0334, 0x0CD5).NFD.list ~~ (0x0CC6, 0x0334, 0x0CD5,), '0CC6 0334 0CD5 -> 0CC6 0334 0CD5';
ok Uni.new(0x0CC6, 0x0334, 0x0CD6).NFD.list ~~ (0x0CC6, 0x0334, 0x0CD6,), '0CC6 0334 0CD6 -> 0CC6 0334 0CD6';
ok Uni.new(0x0CCA, 0x0334, 0x0CD5).NFD.list ~~ (0x0CC6, 0x0CC2, 0x0334, 0x0CD5,), '0CCA 0334 0CD5 -> 0CC6 0CC2 0334 0CD5';
ok Uni.new(0x0D46, 0x0334, 0x0D3E).NFD.list ~~ (0x0D46, 0x0334, 0x0D3E,), '0D46 0334 0D3E -> 0D46 0334 0D3E';
ok Uni.new(0x0D46, 0x0334, 0x0D57).NFD.list ~~ (0x0D46, 0x0334, 0x0D57,), '0D46 0334 0D57 -> 0D46 0334 0D57';
ok Uni.new(0x0D47, 0x0334, 0x0D3E).NFD.list ~~ (0x0D47, 0x0334, 0x0D3E,), '0D47 0334 0D3E -> 0D47 0334 0D3E';
ok Uni.new(0x0DD9, 0x0334, 0x0DCF).NFD.list ~~ (0x0DD9, 0x0334, 0x0DCF,), '0DD9 0334 0DCF -> 0DD9 0334 0DCF';
ok Uni.new(0x0DD9, 0x0334, 0x0DDF).NFD.list ~~ (0x0DD9, 0x0334, 0x0DDF,), '0DD9 0334 0DDF -> 0DD9 0334 0DDF';
ok Uni.new(0x0F40, 0x0334, 0x0FB5).NFD.list ~~ (0x0F40, 0x0334, 0x0FB5,), '0F40 0334 0FB5 -> 0F40 0334 0FB5';
ok Uni.new(0x0F42, 0x0334, 0x0FB7).NFD.list ~~ (0x0F42, 0x0334, 0x0FB7,), '0F42 0334 0FB7 -> 0F42 0334 0FB7';
ok Uni.new(0x0F4C, 0x0334, 0x0FB7).NFD.list ~~ (0x0F4C, 0x0334, 0x0FB7,), '0F4C 0334 0FB7 -> 0F4C 0334 0FB7';
ok Uni.new(0x0F51, 0x0334, 0x0FB7).NFD.list ~~ (0x0F51, 0x0334, 0x0FB7,), '0F51 0334 0FB7 -> 0F51 0334 0FB7';
ok Uni.new(0x0F56, 0x0334, 0x0FB7).NFD.list ~~ (0x0F56, 0x0334, 0x0FB7,), '0F56 0334 0FB7 -> 0F56 0334 0FB7';
ok Uni.new(0x0F5B, 0x0334, 0x0FB7).NFD.list ~~ (0x0F5B, 0x0334, 0x0FB7,), '0F5B 0334 0FB7 -> 0F5B 0334 0FB7';
ok Uni.new(0x0F90, 0x0334, 0x0FB5).NFD.list ~~ (0x0F90, 0x0334, 0x0FB5,), '0F90 0334 0FB5 -> 0F90 0334 0FB5';
ok Uni.new(0x0F92, 0x0334, 0x0FB7).NFD.list ~~ (0x0F92, 0x0334, 0x0FB7,), '0F92 0334 0FB7 -> 0F92 0334 0FB7';
ok Uni.new(0x0F9C, 0x0334, 0x0FB7).NFD.list ~~ (0x0F9C, 0x0334, 0x0FB7,), '0F9C 0334 0FB7 -> 0F9C 0334 0FB7';
ok Uni.new(0x0FA1, 0x0334, 0x0FB7).NFD.list ~~ (0x0FA1, 0x0334, 0x0FB7,), '0FA1 0334 0FB7 -> 0FA1 0334 0FB7';
ok Uni.new(0x0FA6, 0x0334, 0x0FB7).NFD.list ~~ (0x0FA6, 0x0334, 0x0FB7,), '0FA6 0334 0FB7 -> 0FA6 0334 0FB7';
ok Uni.new(0x0FAB, 0x0334, 0x0FB7).NFD.list ~~ (0x0FAB, 0x0334, 0x0FB7,), '0FAB 0334 0FB7 -> 0FAB 0334 0FB7';
ok Uni.new(0x1025, 0x0334, 0x102E).NFD.list ~~ (0x1025, 0x0334, 0x102E,), '1025 0334 102E -> 1025 0334 102E';
ok Uni.new(0x1100, 0x0334, 0x1161).NFD.list ~~ (0x1100, 0x0334, 0x1161,), '1100 0334 1161 -> 1100 0334 1161';
ok Uni.new(0x1100, 0x0334, 0x116E).NFD.list ~~ (0x1100, 0x0334, 0x116E,), '1100 0334 116E -> 1100 0334 116E';
ok Uni.new(0x1101, 0x0334, 0x1166).NFD.list ~~ (0x1101, 0x0334, 0x1166,), '1101 0334 1166 -> 1101 0334 1166';
ok Uni.new(0x1101, 0x0334, 0x1173).NFD.list ~~ (0x1101, 0x0334, 0x1173,), '1101 0334 1173 -> 1101 0334 1173';
ok Uni.new(0x1102, 0x0334, 0x116B).NFD.list ~~ (0x1102, 0x0334, 0x116B,), '1102 0334 116B -> 1102 0334 116B';
ok Uni.new(0x1103, 0x0334, 0x1163).NFD.list ~~ (0x1103, 0x0334, 0x1163,), '1103 0334 1163 -> 1103 0334 1163';
ok Uni.new(0x1103, 0x0334, 0x1170).NFD.list ~~ (0x1103, 0x0334, 0x1170,), '1103 0334 1170 -> 1103 0334 1170';
ok Uni.new(0x1104, 0x0334, 0x1168).NFD.list ~~ (0x1104, 0x0334, 0x1168,), '1104 0334 1168 -> 1104 0334 1168';
ok Uni.new(0x1104, 0x0334, 0x1175).NFD.list ~~ (0x1104, 0x0334, 0x1175,), '1104 0334 1175 -> 1104 0334 1175';
ok Uni.new(0x1105, 0x0334, 0x116D).NFD.list ~~ (0x1105, 0x0334, 0x116D,), '1105 0334 116D -> 1105 0334 116D';
ok Uni.new(0x1106, 0x0334, 0x1165).NFD.list ~~ (0x1106, 0x0334, 0x1165,), '1106 0334 1165 -> 1106 0334 1165';
ok Uni.new(0x1106, 0x0334, 0x1172).NFD.list ~~ (0x1106, 0x0334, 0x1172,), '1106 0334 1172 -> 1106 0334 1172';
ok Uni.new(0x1107, 0x0334, 0x116A).NFD.list ~~ (0x1107, 0x0334, 0x116A,), '1107 0334 116A -> 1107 0334 116A';
ok Uni.new(0x1108, 0x0334, 0x1162).NFD.list ~~ (0x1108, 0x0334, 0x1162,), '1108 0334 1162 -> 1108 0334 1162';
ok Uni.new(0x1108, 0x0334, 0x116F).NFD.list ~~ (0x1108, 0x0334, 0x116F,), '1108 0334 116F -> 1108 0334 116F';
ok Uni.new(0x1109, 0x0334, 0x1167).NFD.list ~~ (0x1109, 0x0334, 0x1167,), '1109 0334 1167 -> 1109 0334 1167';
ok Uni.new(0x1109, 0x0334, 0x1174).NFD.list ~~ (0x1109, 0x0334, 0x1174,), '1109 0334 1174 -> 1109 0334 1174';
ok Uni.new(0x110A, 0x0334, 0x116C).NFD.list ~~ (0x110A, 0x0334, 0x116C,), '110A 0334 116C -> 110A 0334 116C';
ok Uni.new(0x110B, 0x0334, 0x1164).NFD.list ~~ (0x110B, 0x0334, 0x1164,), '110B 0334 1164 -> 110B 0334 1164';
ok Uni.new(0x110B, 0x0334, 0x1171).NFD.list ~~ (0x110B, 0x0334, 0x1171,), '110B 0334 1171 -> 110B 0334 1171';
ok Uni.new(0x110C, 0x0334, 0x1169).NFD.list ~~ (0x110C, 0x0334, 0x1169,), '110C 0334 1169 -> 110C 0334 1169';
ok Uni.new(0x110D, 0x0334, 0x1161).NFD.list ~~ (0x110D, 0x0334, 0x1161,), '110D 0334 1161 -> 110D 0334 1161';
ok Uni.new(0x110D, 0x0334, 0x116E).NFD.list ~~ (0x110D, 0x0334, 0x116E,), '110D 0334 116E -> 110D 0334 116E';
ok Uni.new(0x110E, 0x0334, 0x1166).NFD.list ~~ (0x110E, 0x0334, 0x1166,), '110E 0334 1166 -> 110E 0334 1166';
ok Uni.new(0x110E, 0x0334, 0x1173).NFD.list ~~ (0x110E, 0x0334, 0x1173,), '110E 0334 1173 -> 110E 0334 1173';
ok Uni.new(0x110F, 0x0334, 0x116B).NFD.list ~~ (0x110F, 0x0334, 0x116B,), '110F 0334 116B -> 110F 0334 116B';
ok Uni.new(0x1110, 0x0334, 0x1163).NFD.list ~~ (0x1110, 0x0334, 0x1163,), '1110 0334 1163 -> 1110 0334 1163';
ok Uni.new(0x1110, 0x0334, 0x1170).NFD.list ~~ (0x1110, 0x0334, 0x1170,), '1110 0334 1170 -> 1110 0334 1170';
ok Uni.new(0x1111, 0x0334, 0x1168).NFD.list ~~ (0x1111, 0x0334, 0x1168,), '1111 0334 1168 -> 1111 0334 1168';
ok Uni.new(0x1111, 0x0334, 0x1175).NFD.list ~~ (0x1111, 0x0334, 0x1175,), '1111 0334 1175 -> 1111 0334 1175';
ok Uni.new(0x1112, 0x0334, 0x116D).NFD.list ~~ (0x1112, 0x0334, 0x116D,), '1112 0334 116D -> 1112 0334 116D';
ok Uni.new(0x1B05, 0x0334, 0x1B35).NFD.list ~~ (0x1B05, 0x0334, 0x1B35,), '1B05 0334 1B35 -> 1B05 0334 1B35';
ok Uni.new(0x1B07, 0x0334, 0x1B35).NFD.list ~~ (0x1B07, 0x0334, 0x1B35,), '1B07 0334 1B35 -> 1B07 0334 1B35';
ok Uni.new(0x1B09, 0x0334, 0x1B35).NFD.list ~~ (0x1B09, 0x0334, 0x1B35,), '1B09 0334 1B35 -> 1B09 0334 1B35';
ok Uni.new(0x1B0B, 0x0334, 0x1B35).NFD.list ~~ (0x1B0B, 0x0334, 0x1B35,), '1B0B 0334 1B35 -> 1B0B 0334 1B35';
ok Uni.new(0x1B0D, 0x0334, 0x1B35).NFD.list ~~ (0x1B0D, 0x0334, 0x1B35,), '1B0D 0334 1B35 -> 1B0D 0334 1B35';
ok Uni.new(0x1B11, 0x0334, 0x1B35).NFD.list ~~ (0x1B11, 0x0334, 0x1B35,), '1B11 0334 1B35 -> 1B11 0334 1B35';
ok Uni.new(0x1B3A, 0x0334, 0x1B35).NFD.list ~~ (0x1B3A, 0x0334, 0x1B35,), '1B3A 0334 1B35 -> 1B3A 0334 1B35';
ok Uni.new(0x1B3C, 0x0334, 0x1B35).NFD.list ~~ (0x1B3C, 0x0334, 0x1B35,), '1B3C 0334 1B35 -> 1B3C 0334 1B35';
ok Uni.new(0x1B3E, 0x0334, 0x1B35).NFD.list ~~ (0x1B3E, 0x0334, 0x1B35,), '1B3E 0334 1B35 -> 1B3E 0334 1B35';
ok Uni.new(0x1B3F, 0x0334, 0x1B35).NFD.list ~~ (0x1B3F, 0x0334, 0x1B35,), '1B3F 0334 1B35 -> 1B3F 0334 1B35';
ok Uni.new(0x1B42, 0x0334, 0x1B35).NFD.list ~~ (0x1B42, 0x0334, 0x1B35,), '1B42 0334 1B35 -> 1B42 0334 1B35';
ok Uni.new(0xAC54, 0x0334, 0x11AE).NFD.list ~~ (0x1100, 0x1164, 0x0334, 0x11AE,), 'AC54 0334 11AE -> 1100 1164 0334 11AE';
ok Uni.new(0xACA8, 0x0334, 0x11B5).NFD.list ~~ (0x1100, 0x1167, 0x0334, 0x11B5,), 'ACA8 0334 11B5 -> 1100 1167 0334 11B5';
ok Uni.new(0xACFC, 0x0334, 0x11BC).NFD.list ~~ (0x1100, 0x116A, 0x0334, 0x11BC,), 'ACFC 0334 11BC -> 1100 116A 0334 11BC';
ok Uni.new(0xADC0, 0x0334, 0x11AE).NFD.list ~~ (0x1100, 0x1171, 0x0334, 0x11AE,), 'ADC0 0334 11AE -> 1100 1171 0334 11AE';
ok Uni.new(0xAE14, 0x0334, 0x11B5).NFD.list ~~ (0x1100, 0x1174, 0x0334, 0x11B5,), 'AE14 0334 11B5 -> 1100 1174 0334 11B5';
ok Uni.new(0xAE68, 0x0334, 0x11BC).NFD.list ~~ (0x1101, 0x1162, 0x0334, 0x11BC,), 'AE68 0334 11BC -> 1101 1162 0334 11BC';
ok Uni.new(0xAF2C, 0x0334, 0x11AE).NFD.list ~~ (0x1101, 0x1169, 0x0334, 0x11AE,), 'AF2C 0334 11AE -> 1101 1169 0334 11AE';
ok Uni.new(0xAF80, 0x0334, 0x11B5).NFD.list ~~ (0x1101, 0x116C, 0x0334, 0x11B5,), 'AF80 0334 11B5 -> 1101 116C 0334 11B5';
ok Uni.new(0xAFD4, 0x0334, 0x11BC).NFD.list ~~ (0x1101, 0x116F, 0x0334, 0x11BC,), 'AFD4 0334 11BC -> 1101 116F 0334 11BC';
ok Uni.new(0xB098, 0x0334, 0x11AE).NFD.list ~~ (0x1102, 0x1161, 0x0334, 0x11AE,), 'B098 0334 11AE -> 1102 1161 0334 11AE';
ok Uni.new(0xB0EC, 0x0334, 0x11B5).NFD.list ~~ (0x1102, 0x1164, 0x0334, 0x11B5,), 'B0EC 0334 11B5 -> 1102 1164 0334 11B5';
ok Uni.new(0xB140, 0x0334, 0x11BC).NFD.list ~~ (0x1102, 0x1167, 0x0334, 0x11BC,), 'B140 0334 11BC -> 1102 1167 0334 11BC';
ok Uni.new(0xB204, 0x0334, 0x11AE).NFD.list ~~ (0x1102, 0x116E, 0x0334, 0x11AE,), 'B204 0334 11AE -> 1102 116E 0334 11AE';
ok Uni.new(0xB258, 0x0334, 0x11B5).NFD.list ~~ (0x1102, 0x1171, 0x0334, 0x11B5,), 'B258 0334 11B5 -> 1102 1171 0334 11B5';
ok Uni.new(0xB2AC, 0x0334, 0x11BC).NFD.list ~~ (0x1102, 0x1174, 0x0334, 0x11BC,), 'B2AC 0334 11BC -> 1102 1174 0334 11BC';
ok Uni.new(0xB370, 0x0334, 0x11AE).NFD.list ~~ (0x1103, 0x1166, 0x0334, 0x11AE,), 'B370 0334 11AE -> 1103 1166 0334 11AE';
ok Uni.new(0xB3C4, 0x0334, 0x11B5).NFD.list ~~ (0x1103, 0x1169, 0x0334, 0x11B5,), 'B3C4 0334 11B5 -> 1103 1169 0334 11B5';
ok Uni.new(0xB418, 0x0334, 0x11BC).NFD.list ~~ (0x1103, 0x116C, 0x0334, 0x11BC,), 'B418 0334 11BC -> 1103 116C 0334 11BC';
ok Uni.new(0xB4DC, 0x0334, 0x11AE).NFD.list ~~ (0x1103, 0x1173, 0x0334, 0x11AE,), 'B4DC 0334 11AE -> 1103 1173 0334 11AE';
ok Uni.new(0xB530, 0x0334, 0x11B5).NFD.list ~~ (0x1104, 0x1161, 0x0334, 0x11B5,), 'B530 0334 11B5 -> 1104 1161 0334 11B5';
ok Uni.new(0xB584, 0x0334, 0x11BC).NFD.list ~~ (0x1104, 0x1164, 0x0334, 0x11BC,), 'B584 0334 11BC -> 1104 1164 0334 11BC';
ok Uni.new(0xB648, 0x0334, 0x11AE).NFD.list ~~ (0x1104, 0x116B, 0x0334, 0x11AE,), 'B648 0334 11AE -> 1104 116B 0334 11AE';
ok Uni.new(0xB69C, 0x0334, 0x11B5).NFD.list ~~ (0x1104, 0x116E, 0x0334, 0x11B5,), 'B69C 0334 11B5 -> 1104 116E 0334 11B5';
ok Uni.new(0xB6F0, 0x0334, 0x11BC).NFD.list ~~ (0x1104, 0x1171, 0x0334, 0x11BC,), 'B6F0 0334 11BC -> 1104 1171 0334 11BC';
ok Uni.new(0xB7B4, 0x0334, 0x11AE).NFD.list ~~ (0x1105, 0x1163, 0x0334, 0x11AE,), 'B7B4 0334 11AE -> 1105 1163 0334 11AE';
ok Uni.new(0xB808, 0x0334, 0x11B5).NFD.list ~~ (0x1105, 0x1166, 0x0334, 0x11B5,), 'B808 0334 11B5 -> 1105 1166 0334 11B5';
ok Uni.new(0xB85C, 0x0334, 0x11BC).NFD.list ~~ (0x1105, 0x1169, 0x0334, 0x11BC,), 'B85C 0334 11BC -> 1105 1169 0334 11BC';
ok Uni.new(0xB920, 0x0334, 0x11AE).NFD.list ~~ (0x1105, 0x1170, 0x0334, 0x11AE,), 'B920 0334 11AE -> 1105 1170 0334 11AE';
ok Uni.new(0xB974, 0x0334, 0x11B5).NFD.list ~~ (0x1105, 0x1173, 0x0334, 0x11B5,), 'B974 0334 11B5 -> 1105 1173 0334 11B5';
ok Uni.new(0xB9C8, 0x0334, 0x11BC).NFD.list ~~ (0x1106, 0x1161, 0x0334, 0x11BC,), 'B9C8 0334 11BC -> 1106 1161 0334 11BC';
ok Uni.new(0xBA8C, 0x0334, 0x11AE).NFD.list ~~ (0x1106, 0x1168, 0x0334, 0x11AE,), 'BA8C 0334 11AE -> 1106 1168 0334 11AE';
ok Uni.new(0xBAE0, 0x0334, 0x11B5).NFD.list ~~ (0x1106, 0x116B, 0x0334, 0x11B5,), 'BAE0 0334 11B5 -> 1106 116B 0334 11B5';
ok Uni.new(0xBB34, 0x0334, 0x11BC).NFD.list ~~ (0x1106, 0x116E, 0x0334, 0x11BC,), 'BB34 0334 11BC -> 1106 116E 0334 11BC';
ok Uni.new(0xBBF8, 0x0334, 0x11AE).NFD.list ~~ (0x1106, 0x1175, 0x0334, 0x11AE,), 'BBF8 0334 11AE -> 1106 1175 0334 11AE';
ok Uni.new(0xBC4C, 0x0334, 0x11B5).NFD.list ~~ (0x1107, 0x1163, 0x0334, 0x11B5,), 'BC4C 0334 11B5 -> 1107 1163 0334 11B5';
ok Uni.new(0xBCA0, 0x0334, 0x11BC).NFD.list ~~ (0x1107, 0x1166, 0x0334, 0x11BC,), 'BCA0 0334 11BC -> 1107 1166 0334 11BC';
ok Uni.new(0xBD64, 0x0334, 0x11AE).NFD.list ~~ (0x1107, 0x116D, 0x0334, 0x11AE,), 'BD64 0334 11AE -> 1107 116D 0334 11AE';
ok Uni.new(0xBDB8, 0x0334, 0x11B5).NFD.list ~~ (0x1107, 0x1170, 0x0334, 0x11B5,), 'BDB8 0334 11B5 -> 1107 1170 0334 11B5';
ok Uni.new(0xBE0C, 0x0334, 0x11BC).NFD.list ~~ (0x1107, 0x1173, 0x0334, 0x11BC,), 'BE0C 0334 11BC -> 1107 1173 0334 11BC';
ok Uni.new(0xBED0, 0x0334, 0x11AE).NFD.list ~~ (0x1108, 0x1165, 0x0334, 0x11AE,), 'BED0 0334 11AE -> 1108 1165 0334 11AE';
ok Uni.new(0xBF24, 0x0334, 0x11B5).NFD.list ~~ (0x1108, 0x1168, 0x0334, 0x11B5,), 'BF24 0334 11B5 -> 1108 1168 0334 11B5';
ok Uni.new(0xBF78, 0x0334, 0x11BC).NFD.list ~~ (0x1108, 0x116B, 0x0334, 0x11BC,), 'BF78 0334 11BC -> 1108 116B 0334 11BC';
ok Uni.new(0xC03C, 0x0334, 0x11AE).NFD.list ~~ (0x1108, 0x1172, 0x0334, 0x11AE,), 'C03C 0334 11AE -> 1108 1172 0334 11AE';
ok Uni.new(0xC090, 0x0334, 0x11B5).NFD.list ~~ (0x1108, 0x1175, 0x0334, 0x11B5,), 'C090 0334 11B5 -> 1108 1175 0334 11B5';
ok Uni.new(0xC0E4, 0x0334, 0x11BC).NFD.list ~~ (0x1109, 0x1163, 0x0334, 0x11BC,), 'C0E4 0334 11BC -> 1109 1163 0334 11BC';
ok Uni.new(0xC1A8, 0x0334, 0x11AE).NFD.list ~~ (0x1109, 0x116A, 0x0334, 0x11AE,), 'C1A8 0334 11AE -> 1109 116A 0334 11AE';
ok Uni.new(0xC1FC, 0x0334, 0x11B5).NFD.list ~~ (0x1109, 0x116D, 0x0334, 0x11B5,), 'C1FC 0334 11B5 -> 1109 116D 0334 11B5';
ok Uni.new(0xC250, 0x0334, 0x11BC).NFD.list ~~ (0x1109, 0x1170, 0x0334, 0x11BC,), 'C250 0334 11BC -> 1109 1170 0334 11BC';
ok Uni.new(0xC314, 0x0334, 0x11AE).NFD.list ~~ (0x110A, 0x1162, 0x0334, 0x11AE,), 'C314 0334 11AE -> 110A 1162 0334 11AE';
ok Uni.new(0xC368, 0x0334, 0x11B5).NFD.list ~~ (0x110A, 0x1165, 0x0334, 0x11B5,), 'C368 0334 11B5 -> 110A 1165 0334 11B5';
ok Uni.new(0xC3BC, 0x0334, 0x11BC).NFD.list ~~ (0x110A, 0x1168, 0x0334, 0x11BC,), 'C3BC 0334 11BC -> 110A 1168 0334 11BC';
ok Uni.new(0xC480, 0x0334, 0x11AE).NFD.list ~~ (0x110A, 0x116F, 0x0334, 0x11AE,), 'C480 0334 11AE -> 110A 116F 0334 11AE';
ok Uni.new(0xC4D4, 0x0334, 0x11B5).NFD.list ~~ (0x110A, 0x1172, 0x0334, 0x11B5,), 'C4D4 0334 11B5 -> 110A 1172 0334 11B5';
ok Uni.new(0xC528, 0x0334, 0x11BC).NFD.list ~~ (0x110A, 0x1175, 0x0334, 0x11BC,), 'C528 0334 11BC -> 110A 1175 0334 11BC';
ok Uni.new(0xC5EC, 0x0334, 0x11AE).NFD.list ~~ (0x110B, 0x1167, 0x0334, 0x11AE,), 'C5EC 0334 11AE -> 110B 1167 0334 11AE';
ok Uni.new(0xC640, 0x0334, 0x11B5).NFD.list ~~ (0x110B, 0x116A, 0x0334, 0x11B5,), 'C640 0334 11B5 -> 110B 116A 0334 11B5';
ok Uni.new(0xC694, 0x0334, 0x11BC).NFD.list ~~ (0x110B, 0x116D, 0x0334, 0x11BC,), 'C694 0334 11BC -> 110B 116D 0334 11BC';
ok Uni.new(0xC758, 0x0334, 0x11AE).NFD.list ~~ (0x110B, 0x1174, 0x0334, 0x11AE,), 'C758 0334 11AE -> 110B 1174 0334 11AE';
ok Uni.new(0xC7AC, 0x0334, 0x11B5).NFD.list ~~ (0x110C, 0x1162, 0x0334, 0x11B5,), 'C7AC 0334 11B5 -> 110C 1162 0334 11B5';
ok Uni.new(0xC800, 0x0334, 0x11BC).NFD.list ~~ (0x110C, 0x1165, 0x0334, 0x11BC,), 'C800 0334 11BC -> 110C 1165 0334 11BC';
ok Uni.new(0xC8C4, 0x0334, 0x11AE).NFD.list ~~ (0x110C, 0x116C, 0x0334, 0x11AE,), 'C8C4 0334 11AE -> 110C 116C 0334 11AE';
ok Uni.new(0xC918, 0x0334, 0x11B5).NFD.list ~~ (0x110C, 0x116F, 0x0334, 0x11B5,), 'C918 0334 11B5 -> 110C 116F 0334 11B5';
ok Uni.new(0xC96C, 0x0334, 0x11BC).NFD.list ~~ (0x110C, 0x1172, 0x0334, 0x11BC,), 'C96C 0334 11BC -> 110C 1172 0334 11BC';
ok Uni.new(0xCA30, 0x0334, 0x11AE).NFD.list ~~ (0x110D, 0x1164, 0x0334, 0x11AE,), 'CA30 0334 11AE -> 110D 1164 0334 11AE';
ok Uni.new(0xCA84, 0x0334, 0x11B5).NFD.list ~~ (0x110D, 0x1167, 0x0334, 0x11B5,), 'CA84 0334 11B5 -> 110D 1167 0334 11B5';
ok Uni.new(0xCAD8, 0x0334, 0x11BC).NFD.list ~~ (0x110D, 0x116A, 0x0334, 0x11BC,), 'CAD8 0334 11BC -> 110D 116A 0334 11BC';
ok Uni.new(0xCB9C, 0x0334, 0x11AE).NFD.list ~~ (0x110D, 0x1171, 0x0334, 0x11AE,), 'CB9C 0334 11AE -> 110D 1171 0334 11AE';
ok Uni.new(0xCBF0, 0x0334, 0x11B5).NFD.list ~~ (0x110D, 0x1174, 0x0334, 0x11B5,), 'CBF0 0334 11B5 -> 110D 1174 0334 11B5';
ok Uni.new(0xCC44, 0x0334, 0x11BC).NFD.list ~~ (0x110E, 0x1162, 0x0334, 0x11BC,), 'CC44 0334 11BC -> 110E 1162 0334 11BC';
ok Uni.new(0xCD08, 0x0334, 0x11AE).NFD.list ~~ (0x110E, 0x1169, 0x0334, 0x11AE,), 'CD08 0334 11AE -> 110E 1169 0334 11AE';
ok Uni.new(0xCD5C, 0x0334, 0x11B5).NFD.list ~~ (0x110E, 0x116C, 0x0334, 0x11B5,), 'CD5C 0334 11B5 -> 110E 116C 0334 11B5';
ok Uni.new(0xCDB0, 0x0334, 0x11BC).NFD.list ~~ (0x110E, 0x116F, 0x0334, 0x11BC,), 'CDB0 0334 11BC -> 110E 116F 0334 11BC';
ok Uni.new(0xCE74, 0x0334, 0x11AE).NFD.list ~~ (0x110F, 0x1161, 0x0334, 0x11AE,), 'CE74 0334 11AE -> 110F 1161 0334 11AE';
ok Uni.new(0xCEC8, 0x0334, 0x11B5).NFD.list ~~ (0x110F, 0x1164, 0x0334, 0x11B5,), 'CEC8 0334 11B5 -> 110F 1164 0334 11B5';
ok Uni.new(0xCF1C, 0x0334, 0x11BC).NFD.list ~~ (0x110F, 0x1167, 0x0334, 0x11BC,), 'CF1C 0334 11BC -> 110F 1167 0334 11BC';
ok Uni.new(0xCFE0, 0x0334, 0x11AE).NFD.list ~~ (0x110F, 0x116E, 0x0334, 0x11AE,), 'CFE0 0334 11AE -> 110F 116E 0334 11AE';
ok Uni.new(0xD034, 0x0334, 0x11B5).NFD.list ~~ (0x110F, 0x1171, 0x0334, 0x11B5,), 'D034 0334 11B5 -> 110F 1171 0334 11B5';
ok Uni.new(0xD088, 0x0334, 0x11BC).NFD.list ~~ (0x110F, 0x1174, 0x0334, 0x11BC,), 'D088 0334 11BC -> 110F 1174 0334 11BC';
ok Uni.new(0xD14C, 0x0334, 0x11AE).NFD.list ~~ (0x1110, 0x1166, 0x0334, 0x11AE,), 'D14C 0334 11AE -> 1110 1166 0334 11AE';
ok Uni.new(0xD1A0, 0x0334, 0x11B5).NFD.list ~~ (0x1110, 0x1169, 0x0334, 0x11B5,), 'D1A0 0334 11B5 -> 1110 1169 0334 11B5';
ok Uni.new(0xD1F4, 0x0334, 0x11BC).NFD.list ~~ (0x1110, 0x116C, 0x0334, 0x11BC,), 'D1F4 0334 11BC -> 1110 116C 0334 11BC';
ok Uni.new(0xD2B8, 0x0334, 0x11AE).NFD.list ~~ (0x1110, 0x1173, 0x0334, 0x11AE,), 'D2B8 0334 11AE -> 1110 1173 0334 11AE';
ok Uni.new(0xD30C, 0x0334, 0x11B5).NFD.list ~~ (0x1111, 0x1161, 0x0334, 0x11B5,), 'D30C 0334 11B5 -> 1111 1161 0334 11B5';
ok Uni.new(0xD360, 0x0334, 0x11BC).NFD.list ~~ (0x1111, 0x1164, 0x0334, 0x11BC,), 'D360 0334 11BC -> 1111 1164 0334 11BC';
ok Uni.new(0xD424, 0x0334, 0x11AE).NFD.list ~~ (0x1111, 0x116B, 0x0334, 0x11AE,), 'D424 0334 11AE -> 1111 116B 0334 11AE';
ok Uni.new(0xD478, 0x0334, 0x11B5).NFD.list ~~ (0x1111, 0x116E, 0x0334, 0x11B5,), 'D478 0334 11B5 -> 1111 116E 0334 11B5';
ok Uni.new(0xD4CC, 0x0334, 0x11BC).NFD.list ~~ (0x1111, 0x1171, 0x0334, 0x11BC,), 'D4CC 0334 11BC -> 1111 1171 0334 11BC';
ok Uni.new(0xD590, 0x0334, 0x11AE).NFD.list ~~ (0x1112, 0x1163, 0x0334, 0x11AE,), 'D590 0334 11AE -> 1112 1163 0334 11AE';
ok Uni.new(0xD5E4, 0x0334, 0x11B5).NFD.list ~~ (0x1112, 0x1166, 0x0334, 0x11B5,), 'D5E4 0334 11B5 -> 1112 1166 0334 11B5';
ok Uni.new(0xD638, 0x0334, 0x11BC).NFD.list ~~ (0x1112, 0x1169, 0x0334, 0x11BC,), 'D638 0334 11BC -> 1112 1169 0334 11BC';
ok Uni.new(0xD6FC, 0x0334, 0x11AE).NFD.list ~~ (0x1112, 0x1170, 0x0334, 0x11AE,), 'D6FC 0334 11AE -> 1112 1170 0334 11AE';
ok Uni.new(0xD750, 0x0334, 0x11B5).NFD.list ~~ (0x1112, 0x1173, 0x0334, 0x11B5,), 'D750 0334 11B5 -> 1112 1173 0334 11B5';
ok Uni.new(0x11131, 0x0334, 0x11127).NFD.list ~~ (0x11131, 0x0334, 0x11127,), '11131 0334 11127 -> 11131 0334 11127';
ok Uni.new(0x11132, 0x0334, 0x11127).NFD.list ~~ (0x11132, 0x0334, 0x11127,), '11132 0334 11127 -> 11132 0334 11127';
ok Uni.new(0x11347, 0x0334, 0x1133E).NFD.list ~~ (0x11347, 0x0334, 0x1133E,), '11347 0334 1133E -> 11347 0334 1133E';
ok Uni.new(0x11347, 0x0334, 0x11357).NFD.list ~~ (0x11347, 0x0334, 0x11357,), '11347 0334 11357 -> 11347 0334 11357';
ok Uni.new(0x114B9, 0x0334, 0x114B0).NFD.list ~~ (0x114B9, 0x0334, 0x114B0,), '114B9 0334 114B0 -> 114B9 0334 114B0';
ok Uni.new(0x114B9, 0x0334, 0x114BA).NFD.list ~~ (0x114B9, 0x0334, 0x114BA,), '114B9 0334 114BA -> 114B9 0334 114BA';
ok Uni.new(0x114B9, 0x0334, 0x114BD).NFD.list ~~ (0x114B9, 0x0334, 0x114BD,), '114B9 0334 114BD -> 114B9 0334 114BD';
ok Uni.new(0x115B8, 0x0334, 0x115AF).NFD.list ~~ (0x115B8, 0x0334, 0x115AF,), '115B8 0334 115AF -> 115B8 0334 115AF';
ok Uni.new(0x115B9, 0x0334, 0x115AF).NFD.list ~~ (0x115B9, 0x0334, 0x115AF,), '115B9 0334 115AF -> 115B9 0334 115AF';
ok Uni.new(0x11935, 0x0334, 0x11930).NFD.list ~~ (0x11935, 0x0334, 0x11930,), '11935 0334 11930 -> 11935 0334 11930';
