//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// Type of the callback function used to add a retain to the user-specified
/// info parameter.  This callback may returns the value to use whenever the
/// info parameter is retained, which is usually the value parameter passed
/// to this callback, but may be a different value if a different value
/// should be used.
///
/// Parameter `info`: A user-supplied info parameter provided in a CFTreeContext.
///
/// Returns: The retained info parameter.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cftreeretaincallback?language=objc)
pub type CFTreeRetainCallBack = Option<unsafe extern "C-unwind" fn(*const c_void) -> *const c_void>;

/// Type of the callback function used to remove a retain previously
/// added to the user-specified info parameter.
///
/// Parameter `info`: A user-supplied info parameter provided in a CFTreeContext.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cftreereleasecallback?language=objc)
pub type CFTreeReleaseCallBack = Option<unsafe extern "C-unwind" fn(*const c_void)>;

/// Type of the callback function used to provide a description of the
/// user-specified info parameter.
///
/// Parameter `info`: A user-supplied info parameter provided in a CFTreeContext.
///
/// Returns: A description of the info parameter.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cftreecopydescriptioncallback?language=objc)
pub type CFTreeCopyDescriptionCallBack =
    Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>;

/// Structure containing user-specified data and callbacks for a CFTree.
/// Field: version The version number of the structure type being passed
/// in as a parameter to the CFTree creation function.
/// This structure is version 0.
/// Field: info A C pointer to a user-specified block of data.
/// Field: retain The callback used to add a retain for the info field.
/// If this parameter is not a pointer to a function of the correct
/// prototype, the behavior is undefined.  The value may be NULL.
/// Field: release The calllback used to remove a retain previously added
/// for the info field.  If this parameter is not a pointer to a
/// function of the correct prototype, the behavior is undefined.
/// The value may be NULL.
/// Field: copyDescription The callback used to provide a description of
/// the info field.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cftreecontext?language=objc)
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFTreeContext {
    pub version: CFIndex,
    pub info: *mut c_void,
    pub retain: CFTreeRetainCallBack,
    pub release: CFTreeReleaseCallBack,
    pub copyDescription: CFTreeCopyDescriptionCallBack,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFTreeContext {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <CFIndex>::ENCODING,
            <*mut c_void>::ENCODING,
            <CFTreeRetainCallBack>::ENCODING,
            <CFTreeReleaseCallBack>::ENCODING,
            <CFTreeCopyDescriptionCallBack>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFTreeContext {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Type of the callback function used by the apply functions of
/// CFTree.
///
/// Parameter `value`: The current value from the CFTree
///
/// Parameter `context`: The user-defined context parameter give to the apply
/// function.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cftreeapplierfunction?language=objc)
pub type CFTreeApplierFunction = Option<unsafe extern "C-unwind" fn(*const c_void, *mut c_void)>;

/// This is the type of a reference to CFTrees.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cftree?language=objc)
#[doc(alias = "CFTreeRef")]
#[repr(C)]
pub struct CFTree {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFTree {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFTree"> for CFTree {}
);

unsafe impl ConcreteType for CFTree {
    /// Returns the type identifier of all CFTree instances.
    #[doc(alias = "CFTreeGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFTreeGetTypeID() -> CFTypeID;
        }
        unsafe { CFTreeGetTypeID() }
    }
}

impl CFTree {
    /// Creates a new mutable tree.
    ///
    /// Parameter `allocator`: The CFAllocator which should be used to allocate
    /// memory for the tree and storage for its children.  This
    /// parameter may be NULL in which case the current default
    /// CFAllocator is used.  If this reference is not a valid
    /// CFAllocator, the behavior is undefined.
    ///
    /// Parameter `context`: A C pointer to a CFTreeContext structure to be copied
    /// and used as the context of the new tree.  The info parameter
    /// will be retained by the tree if a retain function is provided.
    /// If this value is not a valid C pointer to a CFTreeContext
    /// structure-sized block of storage, the result is undefined.
    /// If the version number of the storage is not a valid CFTreeContext
    /// version number, the result is undefined.
    ///
    /// Returns: A reference to the new CFTree.
    ///
    /// # Safety
    ///
    /// - `allocator` might not allow `None`.
    /// - `context` must be a valid pointer.
    #[doc(alias = "CFTreeCreate")]
    #[inline]
    pub unsafe fn new(
        allocator: Option<&CFAllocator>,
        context: *const CFTreeContext,
    ) -> Option<CFRetained<CFTree>> {
        extern "C-unwind" {
            fn CFTreeCreate(
                allocator: Option<&CFAllocator>,
                context: *const CFTreeContext,
            ) -> Option<NonNull<CFTree>>;
        }
        let ret = unsafe { CFTreeCreate(allocator, context) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns the parent of the specified tree.
    ///
    /// Parameter `tree`: The tree to be queried.  If this parameter is not a valid
    /// CFTree, the behavior is undefined.
    ///
    /// Returns: The parent of the tree.
    #[doc(alias = "CFTreeGetParent")]
    #[inline]
    pub fn parent(&self) -> Option<CFRetained<CFTree>> {
        extern "C-unwind" {
            fn CFTreeGetParent(tree: &CFTree) -> Option<NonNull<CFTree>>;
        }
        let ret = unsafe { CFTreeGetParent(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Returns the sibling after the specified tree in the parent tree's list.
    ///
    /// Parameter `tree`: The tree to be queried.  If this parameter is not a valid
    /// CFTree, the behavior is undefined.
    ///
    /// Returns: The next sibling of the tree.
    #[doc(alias = "CFTreeGetNextSibling")]
    #[inline]
    pub fn next_sibling(&self) -> Option<CFRetained<CFTree>> {
        extern "C-unwind" {
            fn CFTreeGetNextSibling(tree: &CFTree) -> Option<NonNull<CFTree>>;
        }
        let ret = unsafe { CFTreeGetNextSibling(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Returns the first child of the tree.
    ///
    /// Parameter `tree`: The tree to be queried.  If this parameter is not a valid
    /// CFTree, the behavior is undefined.
    ///
    /// Returns: The first child of the tree.
    #[doc(alias = "CFTreeGetFirstChild")]
    #[inline]
    pub fn first_child(&self) -> Option<CFRetained<CFTree>> {
        extern "C-unwind" {
            fn CFTreeGetFirstChild(tree: &CFTree) -> Option<NonNull<CFTree>>;
        }
        let ret = unsafe { CFTreeGetFirstChild(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Returns the context of the specified tree.
    ///
    /// Parameter `tree`: The tree to be queried.  If this parameter is not a valid
    /// CFTree, the behavior is undefined.
    ///
    /// Parameter `context`: A C pointer to a CFTreeContext structure to be filled in with
    /// the context of the specified tree.  If this value is not a valid C
    /// pointer to a CFTreeContext structure-sized block of storage, the
    /// result is undefined.  If the version number of the storage is not
    /// a valid CFTreeContext version number, the result is undefined.
    ///
    /// # Safety
    ///
    /// `context` must be a valid pointer.
    #[doc(alias = "CFTreeGetContext")]
    #[inline]
    pub unsafe fn context(&self, context: *mut CFTreeContext) {
        extern "C-unwind" {
            fn CFTreeGetContext(tree: &CFTree, context: *mut CFTreeContext);
        }
        unsafe { CFTreeGetContext(self, context) }
    }

    /// Returns the number of children of the specified tree.
    ///
    /// Parameter `tree`: The tree to be queried.  If this parameter is not a valid
    /// CFTree, the behavior is undefined.
    ///
    /// Returns: The number of children.
    #[doc(alias = "CFTreeGetChildCount")]
    #[inline]
    pub fn child_count(&self) -> CFIndex {
        extern "C-unwind" {
            fn CFTreeGetChildCount(tree: &CFTree) -> CFIndex;
        }
        unsafe { CFTreeGetChildCount(self) }
    }

    /// Returns the nth child of the specified tree.
    ///
    /// Parameter `tree`: The tree to be queried.  If this parameter is not a valid
    /// CFTree, the behavior is undefined.
    ///
    /// Parameter `idx`: The index of the child tree to be returned.  If this parameter
    /// is less than zero or greater than the number of children of the
    /// tree, the result is undefined.
    ///
    /// Returns: A reference to the specified child tree.
    #[doc(alias = "CFTreeGetChildAtIndex")]
    #[inline]
    pub fn child_at_index(&self, idx: CFIndex) -> Option<CFRetained<CFTree>> {
        extern "C-unwind" {
            fn CFTreeGetChildAtIndex(tree: &CFTree, idx: CFIndex) -> Option<NonNull<CFTree>>;
        }
        let ret = unsafe { CFTreeGetChildAtIndex(self, idx) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Fills the buffer with children from the tree.
    ///
    /// Parameter `tree`: The tree to be queried.  If this parameter is not a valid
    /// CFTree, the behavior is undefined.
    ///
    /// Parameter `children`: A C array of pointer-sized values to be filled with
    /// children from the tree.  If this parameter is not a valid pointer to a
    /// C array of at least CFTreeGetChildCount() pointers, the behavior is undefined.
    ///
    /// # Safety
    ///
    /// `children` must be a valid pointer.
    #[doc(alias = "CFTreeGetChildren")]
    #[inline]
    pub unsafe fn children(&self, children: *mut *mut CFTree) {
        extern "C-unwind" {
            fn CFTreeGetChildren(tree: &CFTree, children: *mut *mut CFTree);
        }
        unsafe { CFTreeGetChildren(self, children) }
    }

    /// Calls a function once for each child of the tree.  Note that the applier
    /// only operates one level deep, and does not operate on descendents further
    /// removed than the immediate children of the tree.
    ///
    /// Parameter `tree`: The tree to be operated upon.  If this parameter is not a
    /// valid CFTree, the behavior is undefined.
    ///
    /// Parameter `applier`: The callback function to call once for each child of
    /// the given tree.  If this parameter is not a pointer to a
    /// function of the correct prototype, the behavior is undefined.
    /// If there are values in the tree which the applier function does
    /// not expect or cannot properly apply to, the behavior is undefined.
    ///
    /// Parameter `context`: A pointer-sized user-defined value, which is passed
    /// as the second parameter to the applier function, but is
    /// otherwise unused by this function.  If the context is not
    /// what is expected by the applier function, the behavior is
    /// undefined.
    ///
    /// # Safety
    ///
    /// - `applier` must be implemented correctly.
    /// - `context` must be a valid pointer.
    #[doc(alias = "CFTreeApplyFunctionToChildren")]
    #[inline]
    pub unsafe fn apply_function_to_children(
        &self,
        applier: CFTreeApplierFunction,
        context: *mut c_void,
    ) {
        extern "C-unwind" {
            fn CFTreeApplyFunctionToChildren(
                tree: &CFTree,
                applier: CFTreeApplierFunction,
                context: *mut c_void,
            );
        }
        unsafe { CFTreeApplyFunctionToChildren(self, applier, context) }
    }

    /// Returns the root tree of which the specified tree is a descendent.
    ///
    /// Parameter `tree`: The tree to be queried.  If this parameter is not a valid
    /// CFTree, the behavior is undefined.
    ///
    /// Returns: A reference to the root of the tree.
    #[doc(alias = "CFTreeFindRoot")]
    #[inline]
    pub fn find_root(&self) -> Option<CFRetained<CFTree>> {
        extern "C-unwind" {
            fn CFTreeFindRoot(tree: &CFTree) -> Option<NonNull<CFTree>>;
        }
        let ret = unsafe { CFTreeFindRoot(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Replaces the context of a tree.  The tree releases its retain on the
    /// info of the previous context, and retains the info of the new context.
    ///
    /// Parameter `tree`: The tree to be operated on.  If this parameter is not a valid
    /// CFTree, the behavior is undefined.
    ///
    /// Parameter `context`: A C pointer to a CFTreeContext structure to be copied
    /// and used as the context of the new tree.  The info parameter
    /// will be retained by the tree if a retain function is provided.
    /// If this value is not a valid C pointer to a CFTreeContext
    /// structure-sized block of storage, the result is undefined.
    /// If the version number of the storage is not a valid CFTreeContext
    /// version number, the result is undefined.
    ///
    /// # Safety
    ///
    /// `context` must be a valid pointer.
    #[doc(alias = "CFTreeSetContext")]
    #[inline]
    pub unsafe fn set_context(&self, context: *const CFTreeContext) {
        extern "C-unwind" {
            fn CFTreeSetContext(tree: &CFTree, context: *const CFTreeContext);
        }
        unsafe { CFTreeSetContext(self, context) }
    }

    /// Adds the newChild to the specified tree as the first in its list of children.
    ///
    /// Parameter `tree`: The tree to be operated on.  If this parameter is not a valid
    /// CFTree, the behavior is undefined.
    ///
    /// Parameter `newChild`: The child to be added.
    /// If this parameter is not a valid CFTree, the behavior is undefined.
    /// If this parameter is a tree which is already a child of any tree,
    /// the behavior is undefined.
    ///
    /// # Safety
    ///
    /// `new_child` might not allow `None`.
    #[doc(alias = "CFTreePrependChild")]
    #[inline]
    pub unsafe fn prepend_child(&self, new_child: Option<&CFTree>) {
        extern "C-unwind" {
            fn CFTreePrependChild(tree: &CFTree, new_child: Option<&CFTree>);
        }
        unsafe { CFTreePrependChild(self, new_child) }
    }

    /// Adds the newChild to the specified tree as the last in its list of children.
    ///
    /// Parameter `tree`: The tree to be operated on.  If this parameter is not a valid
    /// CFTree, the behavior is undefined.
    ///
    /// Parameter `newChild`: The child to be added.
    /// If this parameter is not a valid CFTree, the behavior is undefined.
    /// If this parameter is a tree which is already a child of any tree,
    /// the behavior is undefined.
    ///
    /// # Safety
    ///
    /// `new_child` might not allow `None`.
    #[doc(alias = "CFTreeAppendChild")]
    #[inline]
    pub unsafe fn append_child(&self, new_child: Option<&CFTree>) {
        extern "C-unwind" {
            fn CFTreeAppendChild(tree: &CFTree, new_child: Option<&CFTree>);
        }
        unsafe { CFTreeAppendChild(self, new_child) }
    }

    /// Inserts newSibling into the the parent tree's linked list of children after
    /// tree.  The newSibling will have the same parent as tree.
    ///
    /// Parameter `tree`: The tree to insert newSibling after.  If this parameter is not a valid
    /// CFTree, the behavior is undefined.  If the tree does not have a
    /// parent, the behavior is undefined.
    ///
    /// Parameter `newSibling`: The sibling to be added.
    /// If this parameter is not a valid CFTree, the behavior is undefined.
    /// If this parameter is a tree which is already a child of any tree,
    /// the behavior is undefined.
    ///
    /// # Safety
    ///
    /// `new_sibling` might not allow `None`.
    #[doc(alias = "CFTreeInsertSibling")]
    #[inline]
    pub unsafe fn insert_sibling(&self, new_sibling: Option<&CFTree>) {
        extern "C-unwind" {
            fn CFTreeInsertSibling(tree: &CFTree, new_sibling: Option<&CFTree>);
        }
        unsafe { CFTreeInsertSibling(self, new_sibling) }
    }

    /// Removes the tree from its parent.
    ///
    /// Parameter `tree`: The tree to be removed.  If this parameter is not a valid
    /// CFTree, the behavior is undefined.
    #[doc(alias = "CFTreeRemove")]
    #[inline]
    pub fn remove(&self) {
        extern "C-unwind" {
            fn CFTreeRemove(tree: &CFTree);
        }
        unsafe { CFTreeRemove(self) }
    }

    /// Removes all the children of the tree.
    ///
    /// Parameter `tree`: The tree to remove all children from.  If this parameter is not a valid
    /// CFTree, the behavior is undefined.
    #[doc(alias = "CFTreeRemoveAllChildren")]
    #[inline]
    pub fn remove_all_children(&self) {
        extern "C-unwind" {
            fn CFTreeRemoveAllChildren(tree: &CFTree);
        }
        unsafe { CFTreeRemoveAllChildren(self) }
    }

    /// Sorts the children of the specified tree using the specified comparator function.
    ///
    /// Parameter `tree`: The tree to be operated on.  If this parameter is not a valid
    /// CFTree, the behavior is undefined.
    ///
    /// Parameter `comparator`: The function with the comparator function type
    /// signature which is used in the sort operation to compare
    /// children of the tree with the given value. If this parameter
    /// is not a pointer to a function of the correct prototype, the
    /// the behavior is undefined. The children of the tree are sorted
    /// from least to greatest according to this function.
    ///
    /// Parameter `context`: A pointer-sized user-defined value, which is passed
    /// as the third parameter to the comparator function, but is
    /// otherwise unused by this function. If the context is not
    /// what is expected by the comparator function, the behavior is
    /// undefined.
    ///
    /// # Safety
    ///
    /// - `comparator` must be implemented correctly.
    /// - `context` must be a valid pointer.
    #[doc(alias = "CFTreeSortChildren")]
    #[inline]
    pub unsafe fn sort_children(&self, comparator: CFComparatorFunction, context: *mut c_void) {
        extern "C-unwind" {
            fn CFTreeSortChildren(
                tree: &CFTree,
                comparator: CFComparatorFunction,
                context: *mut c_void,
            );
        }
        unsafe { CFTreeSortChildren(self, comparator, context) }
    }
}

#[deprecated = "renamed to `CFTree::new`"]
#[inline]
pub unsafe extern "C-unwind" fn CFTreeCreate(
    allocator: Option<&CFAllocator>,
    context: *const CFTreeContext,
) -> Option<CFRetained<CFTree>> {
    extern "C-unwind" {
        fn CFTreeCreate(
            allocator: Option<&CFAllocator>,
            context: *const CFTreeContext,
        ) -> Option<NonNull<CFTree>>;
    }
    let ret = unsafe { CFTreeCreate(allocator, context) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFTree::parent`"]
#[inline]
pub extern "C-unwind" fn CFTreeGetParent(tree: &CFTree) -> Option<CFRetained<CFTree>> {
    extern "C-unwind" {
        fn CFTreeGetParent(tree: &CFTree) -> Option<NonNull<CFTree>>;
    }
    let ret = unsafe { CFTreeGetParent(tree) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `CFTree::next_sibling`"]
#[inline]
pub extern "C-unwind" fn CFTreeGetNextSibling(tree: &CFTree) -> Option<CFRetained<CFTree>> {
    extern "C-unwind" {
        fn CFTreeGetNextSibling(tree: &CFTree) -> Option<NonNull<CFTree>>;
    }
    let ret = unsafe { CFTreeGetNextSibling(tree) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `CFTree::first_child`"]
#[inline]
pub extern "C-unwind" fn CFTreeGetFirstChild(tree: &CFTree) -> Option<CFRetained<CFTree>> {
    extern "C-unwind" {
        fn CFTreeGetFirstChild(tree: &CFTree) -> Option<NonNull<CFTree>>;
    }
    let ret = unsafe { CFTreeGetFirstChild(tree) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFTree::context`"]
    pub fn CFTreeGetContext(tree: &CFTree, context: *mut CFTreeContext);
}

#[deprecated = "renamed to `CFTree::child_count`"]
#[inline]
pub extern "C-unwind" fn CFTreeGetChildCount(tree: &CFTree) -> CFIndex {
    extern "C-unwind" {
        fn CFTreeGetChildCount(tree: &CFTree) -> CFIndex;
    }
    unsafe { CFTreeGetChildCount(tree) }
}

#[deprecated = "renamed to `CFTree::child_at_index`"]
#[inline]
pub extern "C-unwind" fn CFTreeGetChildAtIndex(
    tree: &CFTree,
    idx: CFIndex,
) -> Option<CFRetained<CFTree>> {
    extern "C-unwind" {
        fn CFTreeGetChildAtIndex(tree: &CFTree, idx: CFIndex) -> Option<NonNull<CFTree>>;
    }
    let ret = unsafe { CFTreeGetChildAtIndex(tree, idx) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFTree::children`"]
    pub fn CFTreeGetChildren(tree: &CFTree, children: *mut *mut CFTree);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFTree::apply_function_to_children`"]
    pub fn CFTreeApplyFunctionToChildren(
        tree: &CFTree,
        applier: CFTreeApplierFunction,
        context: *mut c_void,
    );
}

#[deprecated = "renamed to `CFTree::find_root`"]
#[inline]
pub extern "C-unwind" fn CFTreeFindRoot(tree: &CFTree) -> Option<CFRetained<CFTree>> {
    extern "C-unwind" {
        fn CFTreeFindRoot(tree: &CFTree) -> Option<NonNull<CFTree>>;
    }
    let ret = unsafe { CFTreeFindRoot(tree) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFTree::set_context`"]
    pub fn CFTreeSetContext(tree: &CFTree, context: *const CFTreeContext);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFTree::prepend_child`"]
    pub fn CFTreePrependChild(tree: &CFTree, new_child: Option<&CFTree>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFTree::append_child`"]
    pub fn CFTreeAppendChild(tree: &CFTree, new_child: Option<&CFTree>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFTree::insert_sibling`"]
    pub fn CFTreeInsertSibling(tree: &CFTree, new_sibling: Option<&CFTree>);
}

#[deprecated = "renamed to `CFTree::remove`"]
#[inline]
pub extern "C-unwind" fn CFTreeRemove(tree: &CFTree) {
    extern "C-unwind" {
        fn CFTreeRemove(tree: &CFTree);
    }
    unsafe { CFTreeRemove(tree) }
}

#[deprecated = "renamed to `CFTree::remove_all_children`"]
#[inline]
pub extern "C-unwind" fn CFTreeRemoveAllChildren(tree: &CFTree) {
    extern "C-unwind" {
        fn CFTreeRemoveAllChildren(tree: &CFTree);
    }
    unsafe { CFTreeRemoveAllChildren(tree) }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFTree::sort_children`"]
    pub fn CFTreeSortChildren(
        tree: &CFTree,
        comparator: CFComparatorFunction,
        context: *mut c_void,
    );
}
