// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by sidekick. DO NOT EDIT.

#[allow(unused_imports)]
use super::*;

#[doc(hidden)]
impl serde::ser::Serialize for super::ErrorInfo {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.reason.is_empty() {
            state.serialize_entry("reason", &self.reason)?;
        }
        if !self.domain.is_empty() {
            state.serialize_entry("domain", &self.domain)?;
        }
        if !self.metadata.is_empty() {
            state.serialize_entry("metadata", &self.metadata)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::RetryInfo {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if self.retry_delay.is_some() {
            state.serialize_entry("retryDelay", &self.retry_delay)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::DebugInfo {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.stack_entries.is_empty() {
            state.serialize_entry("stackEntries", &self.stack_entries)?;
        }
        if !self.detail.is_empty() {
            state.serialize_entry("detail", &self.detail)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::QuotaFailure {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.violations.is_empty() {
            state.serialize_entry("violations", &self.violations)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::quota_failure::Violation {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.subject.is_empty() {
            state.serialize_entry("subject", &self.subject)?;
        }
        if !self.description.is_empty() {
            state.serialize_entry("description", &self.description)?;
        }
        if !self.api_service.is_empty() {
            state.serialize_entry("apiService", &self.api_service)?;
        }
        if !self.quota_metric.is_empty() {
            state.serialize_entry("quotaMetric", &self.quota_metric)?;
        }
        if !self.quota_id.is_empty() {
            state.serialize_entry("quotaId", &self.quota_id)?;
        }
        if !self.quota_dimensions.is_empty() {
            state.serialize_entry("quotaDimensions", &self.quota_dimensions)?;
        }
        if !wkt::internal::is_default(&self.quota_value) {
            struct __With<'a>(&'a i64);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<wkt::internal::I64>::serialize(self.0, serializer)
                }
            }
            state.serialize_entry("quotaValue", &__With(&self.quota_value))?;
        }
        if self.future_quota_value.is_some() {
            struct __With<'a>(&'a std::option::Option<i64>);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<std::option::Option<wkt::internal::I64>>::serialize(
                        self.0, serializer,
                    )
                }
            }
            state.serialize_entry("futureQuotaValue", &__With(&self.future_quota_value))?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::PreconditionFailure {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.violations.is_empty() {
            state.serialize_entry("violations", &self.violations)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::precondition_failure::Violation {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.r#type.is_empty() {
            state.serialize_entry("type", &self.r#type)?;
        }
        if !self.subject.is_empty() {
            state.serialize_entry("subject", &self.subject)?;
        }
        if !self.description.is_empty() {
            state.serialize_entry("description", &self.description)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::BadRequest {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.field_violations.is_empty() {
            state.serialize_entry("fieldViolations", &self.field_violations)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::bad_request::FieldViolation {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.field.is_empty() {
            state.serialize_entry("field", &self.field)?;
        }
        if !self.description.is_empty() {
            state.serialize_entry("description", &self.description)?;
        }
        if !self.reason.is_empty() {
            state.serialize_entry("reason", &self.reason)?;
        }
        if self.localized_message.is_some() {
            state.serialize_entry("localizedMessage", &self.localized_message)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::RequestInfo {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.request_id.is_empty() {
            state.serialize_entry("requestId", &self.request_id)?;
        }
        if !self.serving_data.is_empty() {
            state.serialize_entry("servingData", &self.serving_data)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::ResourceInfo {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.resource_type.is_empty() {
            state.serialize_entry("resourceType", &self.resource_type)?;
        }
        if !self.resource_name.is_empty() {
            state.serialize_entry("resourceName", &self.resource_name)?;
        }
        if !self.owner.is_empty() {
            state.serialize_entry("owner", &self.owner)?;
        }
        if !self.description.is_empty() {
            state.serialize_entry("description", &self.description)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::Help {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.links.is_empty() {
            state.serialize_entry("links", &self.links)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::help::Link {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.description.is_empty() {
            state.serialize_entry("description", &self.description)?;
        }
        if !self.url.is_empty() {
            state.serialize_entry("url", &self.url)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::LocalizedMessage {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.locale.is_empty() {
            state.serialize_entry("locale", &self.locale)?;
        }
        if !self.message.is_empty() {
            state.serialize_entry("message", &self.message)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::HttpRequest {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.method.is_empty() {
            state.serialize_entry("method", &self.method)?;
        }
        if !self.uri.is_empty() {
            state.serialize_entry("uri", &self.uri)?;
        }
        if !self.headers.is_empty() {
            state.serialize_entry("headers", &self.headers)?;
        }
        if !self.body.is_empty() {
            struct __With<'a>(&'a ::bytes::Bytes);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<serde_with::base64::Base64>::serialize(self.0, serializer)
                }
            }
            state.serialize_entry("body", &__With(&self.body))?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::HttpResponse {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !wkt::internal::is_default(&self.status) {
            struct __With<'a>(&'a i32);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<wkt::internal::I32>::serialize(self.0, serializer)
                }
            }
            state.serialize_entry("status", &__With(&self.status))?;
        }
        if !self.reason.is_empty() {
            state.serialize_entry("reason", &self.reason)?;
        }
        if !self.headers.is_empty() {
            state.serialize_entry("headers", &self.headers)?;
        }
        if !self.body.is_empty() {
            struct __With<'a>(&'a ::bytes::Bytes);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<serde_with::base64::Base64>::serialize(self.0, serializer)
                }
            }
            state.serialize_entry("body", &__With(&self.body))?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::HttpHeader {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.key.is_empty() {
            state.serialize_entry("key", &self.key)?;
        }
        if !self.value.is_empty() {
            state.serialize_entry("value", &self.value)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::Status {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !wkt::internal::is_default(&self.code) {
            struct __With<'a>(&'a i32);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<wkt::internal::I32>::serialize(self.0, serializer)
                }
            }
            state.serialize_entry("code", &__With(&self.code))?;
        }
        if !self.message.is_empty() {
            state.serialize_entry("message", &self.message)?;
        }
        if !self.details.is_empty() {
            state.serialize_entry("details", &self.details)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}
