/*
    SPDX-FileCopyrightText: 2008-2009 Friedrich W. H. Kossebau <kossebau@kde.org>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#ifndef KASTEN_ABSTRACTMODELEXPORTER_P_HPP
#define KASTEN_ABSTRACTMODELEXPORTER_P_HPP

#include "abstractmodelexporter.hpp"

namespace Kasten {

class AbstractModelExporterPrivate
{
public:
    AbstractModelExporterPrivate(AbstractModelExporter* parent,
                                 const QString& remoteTypeName, const QString& remoteMimeType);
    AbstractModelExporterPrivate(const AbstractModelExporterPrivate&) = delete;
    AbstractModelExporterPrivate(AbstractModelExporterPrivate&&) = delete;

    virtual ~AbstractModelExporterPrivate();

    AbstractModelExporterPrivate& operator=(const AbstractModelExporterPrivate&) = delete;
    AbstractModelExporterPrivate& operator=(AbstractModelExporterPrivate&&) = delete;

public:
    [[nodiscard]]
    const QString& remoteTypeName() const;
    [[nodiscard]]
    const QString& remoteMimeType() const;

protected:
    AbstractModelExporter* const q_ptr;

private:
    const QString mRemoteTypeName;
    const QString mRemoteMimeType;
};

inline AbstractModelExporterPrivate::AbstractModelExporterPrivate(AbstractModelExporter* parent,
                                                                  const QString& remoteTypeName, const QString& remoteMimeType)
    : q_ptr(parent)
    , mRemoteTypeName(remoteTypeName)
    , mRemoteMimeType(remoteMimeType)
{}

inline AbstractModelExporterPrivate::~AbstractModelExporterPrivate() = default;

inline const QString& AbstractModelExporterPrivate::remoteTypeName() const { return mRemoteTypeName; }
inline const QString& AbstractModelExporterPrivate::remoteMimeType() const { return mRemoteMimeType; }

}

#endif
