# 0.6.0

### Fixes

- Soundness bug fix: The `Class::dec_ref_count` trait method is now marked `unsafe`.
- It was previously possible for a failed allocation to cause a memory leak
  during construction of COM servers. This version fixes the leak.
- Fixed all Clippy warnings in `com` crates and in the code generated by
  `com::class!` and `com::interfaces!`.

### Added

- COM servers now generate `From` impls for the interfaces implemented by a server.
  You can now use `IFoo::from(&**my_server)` to acquire an interface pointer to a
  server. This eliminates the need to use `unwrap()` on a call to
  `query_interface()`.
- `ClassAllocation<T>` now implements `Clone`, which simply clones an owned
  reference.
- `ClassAllocation<T>` now implements `Send` and `Sync`.

- COM servers may now implement `Drop`. Previously, the `com::class!` macro
  generated a `Drop` implementation, which prevented apps from providing their
  own. The `Drop` implementation runs when the last reference is released. 
- Added unit tests that cover `com::class!` parsing and code generation.

### Changed

- COM servers now use `AtomicU32` for reference counts, so they can now be used
  in thread-safe systems. (We plan on providing the option to select between
  thread-safe and non-thread-safe reference counts, in the future.)

- COM servers now generate static vtables, rather than dynamically allocating
  and building vtables in the heap. This reduces memory and CPU used.

# 0.5.0 (2021-10-05)

### Fixes

- Fix `class!` macro's buggy parsing of complex inheritance hierarchies [#209](https://github.com/microsoft/com-rs/pull/209)
- Properly handle COM interfaces with conflicting method names [#219](https://github.com/microsoft/com-rs/pull/219)

### Added

- Add `usize` as `AbiTransferable` [#207](https://github.com/microsoft/com-rs/pull/207)
- Implement `PartialEq` and `Eq` for interfaces [#220](https://github.com/microsoft/com-rs/pull/220)

### Changed

- The minimum supported Rust version is now 1.46.0 [#221](https://github.com/microsoft/com-rs/pull/221)

# 0.4.0 (2021-01-27)

### Fixes

- Clippy warnings have been fixed [#201](https://github.com/microsoft/com-rs/pull/201)
- A few things which were not properly being converted to their ABI representation now are [#191](https://github.com/microsoft/com-rs/pull/191) 
- Incorrect CLSID Registry keys [#190](https://github.com/microsoft/com-rs/pull/190)
- Handle COM classes with multiple fields [#188](https://github.com/microsoft/com-rs/pull/188)
- Keep leading zeros in COM GUID [#187](https://github.com/microsoft/com-rs/pull/187)

### Added

- Support for `#[no_std]` environments [#199](https://github.com/microsoft/com-rs/pull/199)

### Changed

- The ABI for COM functions is now "system" instead of hard-coding "stdcall" [#203](https://github.com/microsoft/com-rs/pull/203)

# 0.3.0 (2020-04-03)

### Changed

The public API for this crate has changed considerably since the previous version. Please take a look at the README and docs folder for information on how to use this crate.

# 0.2.0 (2020-04-03)

### Fixes

- Fixed docs.rs build [#93](https://github.com/microsoft/com-rs/pull/93)
- Support paths when defining super traits [#110](https://github.com/microsoft/com-rs/pull/110)
- Made interface pointers more correct [#125](https://github.com/microsoft/com-rs/pull/125)
- Fix multiple user generated fields not being generated [#132](https://github.com/microsoft/com-rs/pull/132)

### Added

- `Debug` for `IID` [#128](https://github.com/microsoft/com-rs/pull/128)
- Allow more interfaces [#135](https://github.com/microsoft/com-rs/pull/135)

### Changed

- Define IIDs as strings [#107](https://github.com/microsoft/com-rs/pull/107)
- Require unsafe for interface methods [#120](https://github.com/microsoft/com-rs/pull/120)
- Remove winapi as dependency [#122](https://github.com/microsoft/com-rs/pull/122)
- Interface{Ptr,Rc} => Com{Ptr,Rc} [#129](https://github.com/microsoft/com-rs/pull/129)
- Runtime is now done through stand alone functions [#136](https://github.com/microsoft/com-rs/pull/136)

# 0.1.0 (2019-10-01)

Initial release of the `com` crate.

A one stop shop for all things related to [COM](https://docs.microsoft.com/en-us/windows/win32/com/component-object-model--com--portal) programming in Rust.

This library exposes various macros, structs and functions to the user for both producing and consuming COM components in an idiomatic manner.
