/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.unicode;

import org.jcodings.IntHolder;
import org.jcodings.unicode.UnicodeEncoding;
import org.jcodings.util.Macros;

public abstract class FixedWidthUnicodeEncoding
extends UnicodeEncoding {
    protected final int shift;

    protected FixedWidthUnicodeEncoding(String name2, int width) {
        super(name2, width, width, (int[])null);
        this.shift = FixedWidthUnicodeEncoding.log2(width);
    }

    @Override
    public final int length(byte c) {
        return this.minLength;
    }

    @Override
    public int length(byte[] bytes2, int p2, int e) {
        if (e < p2) {
            return Macros.CONSTRUCT_MBCLEN_INVALID();
        }
        if (e - p2 < 4) {
            return Macros.CONSTRUCT_MBCLEN_NEEDMORE(4 - e - p2);
        }
        int c = this.mbcToCode(bytes2, p2, e);
        if (!Macros.UNICODE_VALID_CODEPOINT_P(c)) {
            return Macros.CONSTRUCT_MBCLEN_INVALID();
        }
        return Macros.CONSTRUCT_MBCLEN_CHARFOUND(4);
    }

    @Override
    public final int strLength(byte[] bytes2, int p2, int end2) {
        return end2 - p2 >>> this.shift;
    }

    @Override
    public final int strCodeAt(byte[] bytes2, int p2, int end2, int index2) {
        return this.mbcToCode(bytes2, p2 + (index2 << this.shift), end2);
    }

    @Override
    public final int codeToMbcLength(int code) {
        return this.minLength;
    }

    @Override
    public final int[] ctypeCodeRange(int ctype, IntHolder sbOut) {
        sbOut.value = 0;
        return super.ctypeCodeRange(ctype);
    }

    @Override
    public final int leftAdjustCharHead(byte[] bytes2, int p2, int s2, int end2) {
        if (s2 <= p2) {
            return s2;
        }
        return s2 - (s2 - p2) % this.maxLength;
    }

    @Override
    public final boolean isReverseMatchAllowed(byte[] bytes2, int p2, int end2) {
        return false;
    }

    private static int log2(int n) {
        int log3 = 0;
        while ((n >>>= 1) != 0) {
            ++log3;
        }
        return log3;
    }
}

