/*
Copyright (c) Facebook, Inc. and its affiliates.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by MockGen. DO NOT EDIT.
// Source: time/phc/pps_source.go

// Package phc is a generated GoMock package.
package phc

import (
	os "os"
	reflect "reflect"
	time "time"

	servo "github.com/facebook/time/servo"
	gomock "github.com/golang/mock/gomock"
)

// MockServoController is a mock of ServoController interface.
type MockServoController struct {
	ctrl     *gomock.Controller
	recorder *MockServoControllerMockRecorder
}

// MockServoControllerMockRecorder is the mock recorder for MockServoController.
type MockServoControllerMockRecorder struct {
	mock *MockServoController
}

// NewMockServoController creates a new mock instance.
func NewMockServoController(ctrl *gomock.Controller) *MockServoController {
	mock := &MockServoController{ctrl: ctrl}
	mock.recorder = &MockServoControllerMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockServoController) EXPECT() *MockServoControllerMockRecorder {
	return m.recorder
}

// Sample mocks base method.
func (m *MockServoController) Sample(offset int64, localTs uint64) (float64, servo.State) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Sample", offset, localTs)
	ret0, _ := ret[0].(float64)
	ret1, _ := ret[1].(servo.State)
	return ret0, ret1
}

// Sample indicates an expected call of Sample.
func (mr *MockServoControllerMockRecorder) Sample(offset, localTs interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Sample", reflect.TypeOf((*MockServoController)(nil).Sample), offset, localTs)
}

// Unlock mocks base method.
func (m *MockServoController) Unlock() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Unlock")
}

// Unlock indicates an expected call of Unlock.
func (mr *MockServoControllerMockRecorder) Unlock() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Unlock", reflect.TypeOf((*MockServoController)(nil).Unlock))
}

// MockTimestamper is a mock of Timestamper interface.
type MockTimestamper struct {
	ctrl     *gomock.Controller
	recorder *MockTimestamperMockRecorder
}

// MockTimestamperMockRecorder is the mock recorder for MockTimestamper.
type MockTimestamperMockRecorder struct {
	mock *MockTimestamper
}

// NewMockTimestamper creates a new mock instance.
func NewMockTimestamper(ctrl *gomock.Controller) *MockTimestamper {
	mock := &MockTimestamper{ctrl: ctrl}
	mock.recorder = &MockTimestamperMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockTimestamper) EXPECT() *MockTimestamperMockRecorder {
	return m.recorder
}

// Timestamp mocks base method.
func (m *MockTimestamper) Timestamp() (*time.Time, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Timestamp")
	ret0, _ := ret[0].(*time.Time)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Timestamp indicates an expected call of Timestamp.
func (mr *MockTimestamperMockRecorder) Timestamp() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Timestamp", reflect.TypeOf((*MockTimestamper)(nil).Timestamp))
}

// MockDeviceController is a mock of DeviceController interface.
type MockDeviceController struct {
	ctrl     *gomock.Controller
	recorder *MockDeviceControllerMockRecorder
}

// MockDeviceControllerMockRecorder is the mock recorder for MockDeviceController.
type MockDeviceControllerMockRecorder struct {
	mock *MockDeviceController
}

// NewMockDeviceController creates a new mock instance.
func NewMockDeviceController(ctrl *gomock.Controller) *MockDeviceController {
	mock := &MockDeviceController{ctrl: ctrl}
	mock.recorder = &MockDeviceControllerMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockDeviceController) EXPECT() *MockDeviceControllerMockRecorder {
	return m.recorder
}

// AdjFreq mocks base method.
func (m *MockDeviceController) AdjFreq(freq float64) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AdjFreq", freq)
	ret0, _ := ret[0].(error)
	return ret0
}

// AdjFreq indicates an expected call of AdjFreq.
func (mr *MockDeviceControllerMockRecorder) AdjFreq(freq interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AdjFreq", reflect.TypeOf((*MockDeviceController)(nil).AdjFreq), freq)
}

// Fd mocks base method.
func (m *MockDeviceController) Fd() uintptr {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Fd")
	ret0, _ := ret[0].(uintptr)
	return ret0
}

// Fd indicates an expected call of Fd.
func (mr *MockDeviceControllerMockRecorder) Fd() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Fd", reflect.TypeOf((*MockDeviceController)(nil).Fd))
}

// File mocks base method.
func (m *MockDeviceController) File() *os.File {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "File")
	ret0, _ := ret[0].(*os.File)
	return ret0
}

// File indicates an expected call of File.
func (mr *MockDeviceControllerMockRecorder) File() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "File", reflect.TypeOf((*MockDeviceController)(nil).File))
}

// Read mocks base method.
func (m *MockDeviceController) Read(buf []byte) (int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Read", buf)
	ret0, _ := ret[0].(int)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Read indicates an expected call of Read.
func (mr *MockDeviceControllerMockRecorder) Read(buf interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Read", reflect.TypeOf((*MockDeviceController)(nil).Read), buf)
}

// Step mocks base method.
func (m *MockDeviceController) Step(offset time.Duration) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Step", offset)
	ret0, _ := ret[0].(error)
	return ret0
}

// Step indicates an expected call of Step.
func (mr *MockDeviceControllerMockRecorder) Step(offset interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Step", reflect.TypeOf((*MockDeviceController)(nil).Step), offset)
}

// Time mocks base method.
func (m *MockDeviceController) Time() (time.Time, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Time")
	ret0, _ := ret[0].(time.Time)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Time indicates an expected call of Time.
func (mr *MockDeviceControllerMockRecorder) Time() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Time", reflect.TypeOf((*MockDeviceController)(nil).Time))
}

// extTTSRequest mocks base method.
func (m *MockDeviceController) extTTSRequest(req *PtpExttsRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "extTTSRequest", req)
	ret0, _ := ret[0].(error)
	return ret0
}

// extTTSRequest indicates an expected call of extTTSRequest.
func (mr *MockDeviceControllerMockRecorder) extTTSRequest(req interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "extTTSRequest", reflect.TypeOf((*MockDeviceController)(nil).extTTSRequest), req)
}

// setPTPPerout mocks base method.
func (m *MockDeviceController) setPTPPerout(req *PtpPeroutRequest) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "setPTPPerout", req)
	ret0, _ := ret[0].(error)
	return ret0
}

// setPTPPerout indicates an expected call of setPTPPerout.
func (mr *MockDeviceControllerMockRecorder) setPTPPerout(req interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "setPTPPerout", reflect.TypeOf((*MockDeviceController)(nil).setPTPPerout), req)
}

// setPinFunc mocks base method.
func (m *MockDeviceController) setPinFunc(index uint, pf int, ch uint) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "setPinFunc", index, pf, ch)
	ret0, _ := ret[0].(error)
	return ret0
}

// setPinFunc indicates an expected call of setPinFunc.
func (mr *MockDeviceControllerMockRecorder) setPinFunc(index, pf, ch interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "setPinFunc", reflect.TypeOf((*MockDeviceController)(nil).setPinFunc), index, pf, ch)
}

// MockPPSPoller is a mock of PPSPoller interface.
type MockPPSPoller struct {
	ctrl     *gomock.Controller
	recorder *MockPPSPollerMockRecorder
}

// MockPPSPollerMockRecorder is the mock recorder for MockPPSPoller.
type MockPPSPollerMockRecorder struct {
	mock *MockPPSPoller
}

// NewMockPPSPoller creates a new mock instance.
func NewMockPPSPoller(ctrl *gomock.Controller) *MockPPSPoller {
	mock := &MockPPSPoller{ctrl: ctrl}
	mock.recorder = &MockPPSPollerMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockPPSPoller) EXPECT() *MockPPSPollerMockRecorder {
	return m.recorder
}

// pollPPSSink mocks base method.
func (m *MockPPSPoller) pollPPSSink() (time.Time, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "pollPPSSink")
	ret0, _ := ret[0].(time.Time)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// pollPPSSink indicates an expected call of pollPPSSink.
func (mr *MockPPSPollerMockRecorder) pollPPSSink() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "pollPPSSink", reflect.TypeOf((*MockPPSPoller)(nil).pollPPSSink))
}

// MockFrequencyGetter is a mock of FrequencyGetter interface.
type MockFrequencyGetter struct {
	ctrl     *gomock.Controller
	recorder *MockFrequencyGetterMockRecorder
}

// MockFrequencyGetterMockRecorder is the mock recorder for MockFrequencyGetter.
type MockFrequencyGetterMockRecorder struct {
	mock *MockFrequencyGetter
}

// NewMockFrequencyGetter creates a new mock instance.
func NewMockFrequencyGetter(ctrl *gomock.Controller) *MockFrequencyGetter {
	mock := &MockFrequencyGetter{ctrl: ctrl}
	mock.recorder = &MockFrequencyGetterMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockFrequencyGetter) EXPECT() *MockFrequencyGetterMockRecorder {
	return m.recorder
}

// FreqPPB mocks base method.
func (m *MockFrequencyGetter) FreqPPB() (float64, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FreqPPB")
	ret0, _ := ret[0].(float64)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// FreqPPB indicates an expected call of FreqPPB.
func (mr *MockFrequencyGetterMockRecorder) FreqPPB() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FreqPPB", reflect.TypeOf((*MockFrequencyGetter)(nil).FreqPPB))
}

// MaxFreqAdjPPB mocks base method.
func (m *MockFrequencyGetter) MaxFreqAdjPPB() (float64, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "MaxFreqAdjPPB")
	ret0, _ := ret[0].(float64)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// MaxFreqAdjPPB indicates an expected call of MaxFreqAdjPPB.
func (mr *MockFrequencyGetterMockRecorder) MaxFreqAdjPPB() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "MaxFreqAdjPPB", reflect.TypeOf((*MockFrequencyGetter)(nil).MaxFreqAdjPPB))
}
