/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_update_report_status.c
 * @brief Implementation of the update_report_status function for Postgres
 * @author Christian Grothoff
 */
#include "platform.h"
#include <taler/taler_error_codes.h>
#include <taler/taler_dbevents.h>
#include <taler/taler_pq_lib.h>
#include "pg_update_report_status.h"
#include "pg_helper.h"


enum GNUNET_DB_QueryStatus
TMH_PG_update_report_status (
  void *cls,
  const char *instance_id,
  uint64_t report_id,
  struct GNUNET_TIME_Timestamp next_transmission,
  enum TALER_ErrorCode last_error_code,
  const char *last_error_detail)
{
  struct PostgresClosure *pg = cls;
  uint32_t ec = (uint32_t) last_error_code;
  struct GNUNET_PQ_QueryParam params[] = {
    GNUNET_PQ_query_param_string (instance_id),
    GNUNET_PQ_query_param_uint64 (&report_id),
    GNUNET_PQ_query_param_timestamp (&next_transmission),
    TALER_EC_NONE == ec
    ? GNUNET_PQ_query_param_null ()
    : GNUNET_PQ_query_param_uint32 (&ec),
    NULL == last_error_detail
    ? GNUNET_PQ_query_param_null ()
    : GNUNET_PQ_query_param_string (last_error_detail),
    GNUNET_PQ_query_param_end
  };

  check_connection (pg);
  PREPARE (pg,
           "update_report_status",
           "UPDATE merchant_reports SET"
           " next_transmission=$3"
           ",last_error_code=$4"
           ",last_error_detail=$5"
           " WHERE merchant_serial="
           "   (SELECT merchant_serial"
           "      FROM merchant_instances"
           "     WHERE merchant_id=$1)"
           "   AND report_serial=$2;");
  return GNUNET_PQ_eval_prepared_non_select (pg->conn,
                                             "update_report_status",
                                             params);
}
