/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_update_money_pot.h
 * @brief implementation of the update_money_pot function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_UPDATE_MONEY_POT_H
#define PG_UPDATE_MONEY_POT_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"

/**
 * Update details about a particular money pot.
 *
 * @param cls closure
 * @param instance_id instance to update token family for
 * @param money_pot_id serial number of the pot to delete
 * @param name set to name of the pot
 * @param description set to description of the pot
 * @param opt_len length of @a old_pot_totals
 * @param old_pot_totals amounts expected currently in the pot,
 *        NULL to not check (non-NULL but @a opt_len=0 checks for [])
 * @param npt_len length of @a new_pot_totals
 * @param new_pot_totals new amounts in the pot,
 *        NULL to not update (non-NULL but @a npt_len=0 resets to [])
 * @param[out] conflict_total set to true if @a old_pot_total does not match
 * @param[out] conflict_name set to true if @a name is used by another pot
 * @return database result code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_update_money_pot (
  void *cls,
  const char *instance_id,
  uint64_t money_pot_id,
  const char *name,
  const char *description,
  size_t opt_len,
  const struct TALER_Amount *old_pot_totals,
  size_t npt_len,
  const struct TALER_Amount *new_pot_totals,
  bool *conflict_total,
  bool *conflict_name);


#endif
