/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_lookup_statistics_amount_by_bucket2.h
 * @brief implementation of the lookup_statistics_amount_by_bucket2 function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_LOOKUP_STATISTICS_AMOUNT_BY_BUCKET2_H
#define PG_LOOKUP_STATISTICS_AMOUNT_BY_BUCKET2_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"


/**
 * Lookup amount statistics for instance and slug by bucket,
 * restricting to a fixed number of buckets at a given granularity.
 *
 * @param cls closure
 * @param instance_id instance to lookup statistics for
 * @param slug instance to lookup statistics for
 * @param granularity limit to buckets of this size
 * @param counter requested number of buckets
 * @param cb function to call on all token families found
 * @param cb_cls closure for @a cb
 * @return database result code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_lookup_statistics_amount_by_bucket2 (
  void *cls,
  const char *instance_id,
  const char *slug,
  const char *granularity,
  uint64_t counter,
  TALER_MERCHANTDB_AmountByBucketStatisticsCallback2 cb,
  void *cb_cls);

#endif
