/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_lookup_custom_units_by_names.h
 * @brief Lookup custom measurement units by name
 * @author Bohdan Potuzhnyi
 */
#ifndef PG_LOOKUP_CUSTOM_UNITS_BY_NAMES_H
#define PG_LOOKUP_CUSTOM_UNITS_BY_NAMES_H

#include <taler/taler_util.h>
#include "taler_merchantdb_plugin.h"

/**
 * Lookup custom measurement units by name.
 *
 * @param cls closure
 * @param instance_id instance to fetch units for
 * @param units array of unit identifiers
 * @param num_units length of @a units
 * @param cb function to call with each unit
 * @param cb_cls closure for @a cb
 * @return database result code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_lookup_custom_units_by_names (void *cls,
                                     const char *instance_id,
                                     const char *const *units,
                                     size_t num_units,
                                     TALER_MERCHANTDB_UnitsCallback cb,
                                     void *cb_cls);

#endif
