/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_check_report.c
 * @brief Implementation of the check_report function for Postgres
 * @author Christian Grothoff
 */
#include "platform.h"
#include <taler/taler_error_codes.h>
#include <taler/taler_dbevents.h>
#include <taler/taler_pq_lib.h>
#include "pg_check_report.h"
#include "pg_helper.h"

enum GNUNET_DB_QueryStatus
TMH_PG_check_report (void *cls,
                     uint64_t report_id,
                     const struct TALER_MERCHANT_ReportToken *report_token,
                     const char *mime_type,
                     char **instance_id,
                     char **data_source)
{
  struct PostgresClosure *pg = cls;
  struct GNUNET_PQ_QueryParam params[] = {
    GNUNET_PQ_query_param_uint64 (&report_id),
    GNUNET_PQ_query_param_auto_from_type (report_token),
    GNUNET_PQ_query_param_string (mime_type),
    GNUNET_PQ_query_param_end
  };
  struct GNUNET_PQ_ResultSpec rs[] = {
    GNUNET_PQ_result_spec_string ("merchant_id",
                                  instance_id),
    GNUNET_PQ_result_spec_string ("data_source",
                                  data_source),
    GNUNET_PQ_result_spec_end
  };

  check_connection (pg);
  PREPARE (pg,
           "check_report",
           "SELECT"
           "  mi.merchant_id"
           " ,mr.data_source"
           " FROM merchant_reports mr"
           " JOIN merchant_instances mi"
           "   USING (merchant_serial)"
           " WHERE mr.report_serial=$1"
           "   AND mr.report_token=$2"
           "   AND mr.mime_type=$3;");
  return GNUNET_PQ_eval_prepared_singleton_select (
    pg->conn,
    "check_report",
    params,
    rs);
}
