/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_check_money_pots.h
 * @brief implementation of the check_money_pots function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_CHECK_MONEY_POTS_H
#define PG_CHECK_MONEY_POTS_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"


/**
 * Check that all of the money pots given exist at the instance,
 * returning one that does *not* exist (for generating an error)
 * if the check fails.
 *
 * @param cls closure
 * @param instance_id instance to lookup token families for
 * @param pots_len length of the @a pots array
 * @param pots money pot identifiers to check if they exist
 * @param[out] pot_missing set to ID of pot not known at the instance
 * @return transaction status,
 *   #GNUNET_DB_STATUS_SUCCESS_NO_RESULTS means that all pots exist
 *   #GNUNET_DB_STATUS_SUCCESS_ONE_RESULT indicates that
 *       @a pot_missing was initialized to a missing pot
 */
enum GNUNET_DB_QueryStatus
TMH_PG_check_money_pots (void *cls,
                         const char *instance_id,
                         unsigned int pots_len,
                         uint64_t pots[static pots_len],
                         uint64_t *pot_missing);

#endif
