/*
  This file is part of TALER
  Copyright (C) 2019, 2021, 2025 Taler Systems SA

  TALER is free software; you can redistribute it and/or modify it under the
  terms of the GNU Affero General Public License as published by the Free Software
  Foundation; either version 3, or (at your option) any later version.

  TALER is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more details.

  You should have received a copy of the GNU Affero General Public License along with
  TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
*/
/**
 * @file taler-merchant-httpd_terms.c
 * @brief Handle /terms requests to return the terms of service
 * @author Christian Grothoff
 */
#include "taler-merchant-httpd_get-terms.h"

/**
 * Our terms of service.
 */
static struct TALER_MHD_Legal *tos;


/**
 * Our privacy policy.
 */
static struct TALER_MHD_Legal *pp;


MHD_RESULT
TMH_handler_terms (const struct TMH_RequestHandler *rh,
                   struct MHD_Connection *connection,
                   struct TMH_HandlerContext *rc)
{
  (void) rh;
  (void) rc;
  return TALER_MHD_reply_legal (connection,
                                tos);
}


MHD_RESULT
TMH_handler_privacy (const struct TMH_RequestHandler *rh,
                     struct MHD_Connection *connection,
                     struct TMH_HandlerContext *rc)
{
  (void) rh;
  (void) rc;
  return TALER_MHD_reply_legal (connection,
                                pp);
}


void
TMH_load_terms (const struct GNUNET_CONFIGURATION_Handle *cfg)
{
  tos = TALER_MHD_legal_load (cfg,
                              "merchant",
                              "TERMS_DIR",
                              "TERMS_ETAG");
  if (NULL == tos)
    GNUNET_log (GNUNET_ERROR_TYPE_WARNING,
                "Terms of service not configured\n");
  pp = TALER_MHD_legal_load (cfg,
                             "merchant",
                             "PRIVACY_DIR",
                             "PRIVACY_ETAG");
  if (NULL == pp)
    GNUNET_log (GNUNET_ERROR_TYPE_WARNING,
                "Privacy policy not configured\n");
}


/* end of taler-merchant-httpd_terms.c */
