/*
  This file is part of DONAU
  Copyright (C) 2014-2022 Donau Systems SA

  DONAU is free software; you can redistribute it and/or modify it under the
  terms of the GNU General Public License as published by the Free Software
  Foundation; either version 3, or (at your option) any later version.

  DONAU is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  DONAU; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
*/
/**
 * @file donau_signatures.h
 * @brief message formats and signature constants used to define
 *        the binary formats of signatures in Donau
 *
 * This file should define the constants and C structs that one needs
 * to know to implement Donau clients (wallets or merchants or
 * auditor) that need to produce or verify Donau signatures.
 */
#ifndef DONAU_SIGNATURES_H
#define DONAU_SIGNATURES_H


/**
 * The signature is done by the Donau. The Donau signes over the total amount of the corresponding year, the corresponding year and the donation identifier of a specific donor. The statement confirms that the donor made this total in donations for the given year.
 */
#define DONAU_SIGNATURE_DONAU_DONATION_STATEMENT 1500


/**
 * The signature is made by a charity and shows that the charity is in agreement with the donation request which it sends to the Donau. The charity signs over all blinded identifiers and key pairs which it has received from the donor. The signature affirms that the charity wants the donation receipts to be issued on its behalf.
 */
#define DONAU_SIGNATURE_CHARITY_DONATION_CONFIRMATION 1501


/**
 * The signature is made by a charity to request information about its status from a Donau. It is not over anything in particular and is just there for access control.
 */
#define DONAU_SIGNATURE_CHARITY_GET_INFO 1502


#endif
