# Copyright 2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.15.0

EAPI=8

CRATES="
	emlop@0.8.2
	adler2@2.0.1
	aho-corasick@1.1.3
	anstream@0.6.20
	anstyle-parse@0.2.7
	anstyle-query@1.1.4
	anstyle-wincon@3.0.10
	anstyle@1.0.11
	anyhow@1.0.99
	assert_cmd@2.0.17
	atoi@2.0.0
	autocfg@1.5.0
	bstr@1.12.0
	cfg-if@1.0.3
	clap@4.5.46
	clap_builder@4.5.46
	clap_complete@4.5.57
	clap_derive@4.5.45
	clap_lex@0.7.5
	colorchoice@1.0.4
	crc32fast@1.5.0
	deranged@0.4.0
	difflib@0.4.0
	doc-comment@0.3.3
	env_filter@0.1.3
	env_logger@0.11.8
	equivalent@1.0.2
	flate2@1.1.2
	hashbrown@0.15.5
	heck@0.5.0
	indexmap@2.11.0
	is_terminal_polyfill@1.70.1
	itoa@1.0.15
	libc@0.2.175
	libz-rs-sys@0.5.1
	log@0.4.27
	memchr@2.7.5
	miniz_oxide@0.8.9
	num-conv@0.1.0
	num-traits@0.2.19
	num_threads@0.1.7
	once_cell_polyfill@1.70.1
	powerfmt@0.2.0
	predicates-core@1.0.9
	predicates-tree@1.0.12
	predicates@3.1.3
	proc-macro2@1.0.101
	quote@1.0.40
	regex-automata@0.4.10
	regex-syntax@0.8.6
	regex@1.11.2
	rev_lines@0.3.0
	ryu@1.0.20
	serde@1.0.219
	serde_derive@1.0.219
	serde_json@1.0.143
	serde_spanned@1.0.0
	strsim@0.11.1
	syn@2.0.106
	termtree@0.5.1
	thiserror-impl@1.0.69
	thiserror@1.0.69
	time-core@0.1.4
	time-macros@0.2.22
	time@0.3.41
	toml@0.9.5
	toml_datetime@0.7.0
	toml_parser@1.0.2
	toml_writer@1.0.2
	unicode-ident@1.0.18
	utf8parse@0.2.2
	wait-timeout@0.2.1
	windows-link@0.1.3
	windows-sys@0.60.2
	windows-targets@0.53.3
	windows_aarch64_gnullvm@0.53.0
	windows_aarch64_msvc@0.53.0
	windows_i686_gnu@0.53.0
	windows_i686_gnullvm@0.53.0
	windows_i686_msvc@0.53.0
	windows_x86_64_gnu@0.53.0
	windows_x86_64_gnullvm@0.53.0
	windows_x86_64_msvc@0.53.0
	winnow@0.7.13
	zlib-rs@0.5.1
"

RUST_MIN_VER="1.80.1"

inherit cargo shell-completion

DESCRIPTION="A fast, accurate, ergonomic emerge.log parser"
HOMEPAGE="https://github.com/vincentdephily/emlop"
SRC_URI="
	${CARGO_CRATE_URIS}
"

LICENSE="GPL-3"
# Dependent crate licenses
LICENSE+="
	   MIT Unicode-DFS-2016
	   || ( Apache-2.0 Boost-1.0 )
"

SLOT="0"
KEYWORDS="~amd64 ~x86"

# rust does not use *FLAGS from make.conf, silence portage warning
QA_FLAGS_IGNORED="usr/bin/${PN}"

src_install() {
	cargo_src_install
	dodoc README.md CHANGELOG.md emlop.toml
	newbashcomp completion.bash emlop
	newfishcomp completion.fish emlop.fish
	newzshcomp completion.zsh _emlop
}
