/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.model;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.Environment;
import com.xmlcalabash.model.Input;
import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.Step;
import java.util.HashSet;
import java.util.Hashtable;
import net.sf.saxon.s9api.XdmNode;

public class Choose
extends DeclareStep {
    public Choose(XProcRuntime xproc, XdmNode node, String name) {
        super(xproc, node, name);
        this.declaration = this;
        this.stepType = XProcConstants.p_choose;
    }

    @Override
    public boolean isPipeline() {
        return false;
    }

    @Override
    public DeclareStep getDeclaration() {
        return this.declaration;
    }

    @Override
    public void addInput(Input input) {
        input.setStep(this);
        for (Input current : this.inputs) {
            if (!current.getPort().equals(input.getPort())) continue;
            if ("#xpath-context".equals(input.getPort())) {
                return;
            }
            throw XProcException.staticError(11, "Input port name '" + input.getPort() + "' appears more than once.");
        }
        this.inputs.add(input);
    }

    @Override
    protected void augmentIO() {
        if (this.getInput("#xpath-context") == null) {
            Input isource = new Input(this.runtime, this.node);
            isource.setPort("#xpath-context");
            this.addInput(isource);
        }
        if (this.subpipeline.size() > 0) {
            Step step = (Step)this.subpipeline.get(0);
            for (Input input : step.inputs()) {
                Input cinput = new Input(this.runtime, step.getNode());
                cinput.setPort(input.getPort());
                cinput.setPrimary(input.getPrimary());
                cinput.setSequence(input.getSequence());
                this.addInput(cinput);
            }
            for (Output output : step.outputs()) {
                Output coutput = new Output(this.runtime, step.getNode());
                coutput.setPort(output.getPort());
                coutput.setPrimary(output.getPrimary());
                coutput.setSequence(output.getSequence());
                this.addOutput(coutput);
            }
        }
        super.augmentIO();
    }

    @Override
    public HashSet<String> getExcludeInlineNamespaces() {
        return ((DeclareStep)this.parent).getExcludeInlineNamespaces();
    }

    @Override
    protected void setEnvironment(Environment newEnvironment) {
        Environment env = new Environment(newEnvironment);
        this.patchEnvironment(env);
        super.setEnvironment(env);
        for (Step step : this.subpipeline()) {
            Environment senv = new Environment(env);
            step.setEnvironment(senv);
        }
    }

    @Override
    protected boolean validBindings() {
        boolean valid = true;
        Hashtable<String, Input> inputs = new Hashtable<String, Input>();
        Hashtable<String, Output> outputs = new Hashtable<String, Output>();
        Step step = null;
        if (this.subpipeline.size() > 0) {
            step = (Step)this.subpipeline.get(0);
            for (Input input : step.inputs()) {
                inputs.put(input.getPort(), input);
            }
            for (Output output : step.outputs()) {
                outputs.put(output.getPort(), output);
            }
            for (int pos = 1; pos < this.subpipeline.size(); ++pos) {
                step = (Step)this.subpipeline.get(pos);
                for (Input input : step.inputs()) {
                    if (inputs.containsKey(input.getPort())) {
                        Input s1input;
                        if ("#xpath-context".equals(input.getPort()) || input.getPort().startsWith("|") || (s1input = (Input)inputs.get(input.getPort())).getPrimary() == input.getPrimary()) continue;
                        valid = false;
                        this.error("Input port " + input.getPort() + " has different primary status.", XProcConstants.staticError(7));
                        continue;
                    }
                    valid = false;
                    this.error("Input port " + input.getPort() + " is extra.", XProcConstants.staticError(7));
                }
                for (String port : inputs.keySet()) {
                    if (port.startsWith("|") || port.startsWith("#") || step.getInput(port) != null) continue;
                    valid = false;
                    this.error("Input port " + port + " missing.", XProcConstants.staticError(7));
                }
                for (Output output : step.outputs()) {
                    if (outputs.containsKey(output.getPort())) {
                        Output chooseOut;
                        Output s1output = (Output)outputs.get(output.getPort());
                        chooseOut.setSequence((chooseOut = this.getOutput(output.getPort())).getSequence() || output.getSequence());
                        if (output.getPort().endsWith("|") || output.getPort().startsWith("!") || s1output.getPrimary() == output.getPrimary()) continue;
                        valid = false;
                        this.error("Output port " + output.getPort() + " has different primary status.", XProcConstants.staticError(7));
                        continue;
                    }
                    valid = false;
                    this.error("Output port " + output.getPort() + " is extra.", XProcConstants.staticError(7));
                }
                for (String port : outputs.keySet()) {
                    if (port.endsWith("|") || step.getOutput(port) != null) continue;
                    valid = false;
                    this.error("Output port " + port + " missing.", XProcConstants.staticError(7));
                }
            }
        } else {
            this.error("Choose must contain when or otherwise", XProcConstants.staticError(27));
        }
        return valid && super.validBindings();
    }

    @Override
    protected boolean validOutputBinding() {
        return true;
    }
}

