/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class Err {
    public static final int ELEMENT = 1;
    public static final int ATTRIBUTE = 2;
    public static final int FUNCTION = 3;
    public static final int VALUE = 4;
    public static final int VARIABLE = 5;
    public static final int GENERAL = 6;
    public static final int URI = 7;

    public static String wrap(CharSequence cs) {
        return Err.wrap(cs, 6);
    }

    public static String wrap(CharSequence cs, int valueType) {
        String s;
        if (cs == null) {
            return "(NULL)";
        }
        FastStringBuffer sb = new FastStringBuffer(64);
        int len = cs.length();
        block12: for (int i = 0; i < len; ++i) {
            char c = cs.charAt(i);
            switch (c) {
                case '\n': {
                    sb.append("\\n");
                    continue block12;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block12;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block12;
                }
                default: {
                    if (c < ' ' || c > '\u00ff') {
                        sb.append("\\u");
                        String hex = Integer.toHexString(c);
                        while (hex.length() < 4) {
                            hex = "0" + hex;
                        }
                        sb.append(hex);
                        continue block12;
                    }
                    sb.append(c);
                }
            }
        }
        if (len > 30) {
            if (valueType == 1 && sb.charAt(0) == '{') {
                StructuredQName qn = StructuredQName.fromClarkName(sb.toString());
                String uri = qn.getNamespaceURI();
                if (uri.length() > 15) {
                    uri = "..." + uri.substring(uri.length() - 15);
                }
                s = "{" + uri + "}" + qn.getLocalName();
            } else {
                s = valueType == 7 ? "..." + sb.toString().substring(len - 30) : sb.toString().substring(0, 30) + "...";
            }
        } else {
            s = sb.toString();
        }
        switch (valueType) {
            case 1: {
                return "<" + s + ">";
            }
            case 2: {
                return "@" + s;
            }
            case 3: {
                return s + "()";
            }
            case 5: {
                return "$" + s;
            }
            case 4: {
                return "\"" + s + "\"";
            }
        }
        return "{" + s + "}";
    }

    public static CharSequence depict(Item item) {
        if (item instanceof AtomicValue) {
            CharSequence cs = item.getStringValueCS();
            if (item instanceof StringValue) {
                return '\"' + ((Object)Err.truncate30(cs)).toString() + '\"';
            }
            return Err.truncate30(cs);
        }
        if (item instanceof NodeInfo) {
            NodeInfo node = (NodeInfo)item;
            switch (node.getNodeKind()) {
                case 9: {
                    return "document-node()";
                }
                case 1: {
                    return "<" + node.getDisplayName() + "/>";
                }
                case 2: {
                    return "@" + node.getDisplayName();
                }
                case 3: {
                    return "text(\"" + Err.truncate30(node.getStringValue()) + "\")";
                }
                case 8: {
                    return "<!--" + Err.truncate30(node.getStringValue()) + "-->";
                }
                case 7: {
                    return "<?" + node.getDisplayName() + "?>";
                }
                case 13: {
                    String prefix = node.getLocalPart();
                    return "xmlns" + (prefix.equals("") ? "" : ":" + prefix) + "=\"" + node.getStringValue() + '\"';
                }
            }
            return "";
        }
        return "function item";
    }

    private static CharSequence truncate30(CharSequence cs) {
        if (cs.length() <= 30) {
            return Whitespace.collapseWhitespace(cs);
        }
        return ((Object)Whitespace.collapseWhitespace(cs.subSequence(0, 30))).toString() + "...";
    }
}

