/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Arrays;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Whitespace;

public class HexBinaryValue
extends AtomicValue {
    private byte[] binaryValue;

    public HexBinaryValue(CharSequence in) throws XPathException {
        CharSequence s = Whitespace.trimWhitespace(in);
        if ((s.length() & 1) != 0) {
            XPathException err = new XPathException("A hexBinary value must contain an even number of characters");
            err.setErrorCode("FORG0001");
            throw err;
        }
        this.binaryValue = new byte[s.length() / 2];
        for (int i = 0; i < this.binaryValue.length; ++i) {
            this.binaryValue[i] = (byte)((this.fromHex(s.charAt(2 * i)) << 4) + this.fromHex(s.charAt(2 * i + 1)));
        }
        this.typeLabel = BuiltInAtomicType.HEX_BINARY;
    }

    public HexBinaryValue(CharSequence s, AtomicType type) {
        if ((s.length() & 1) != 0) {
            throw new IllegalArgumentException("A hexBinary value must contain an even number of characters");
        }
        this.binaryValue = new byte[s.length() / 2];
        try {
            for (int i = 0; i < this.binaryValue.length; ++i) {
                this.binaryValue[i] = (byte)((this.fromHex(s.charAt(2 * i)) << 4) + this.fromHex(s.charAt(2 * i + 1)));
            }
        }
        catch (XPathException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.typeLabel = type;
    }

    public HexBinaryValue(byte[] value) {
        this.binaryValue = value;
        this.typeLabel = BuiltInAtomicType.HEX_BINARY;
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        HexBinaryValue v = new HexBinaryValue(this.binaryValue);
        v.typeLabel = typeLabel;
        return v;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.HEX_BINARY;
    }

    public byte[] getBinaryValue() {
        return this.binaryValue;
    }

    private int fromHex(char c) throws XPathException {
        int d = "0123456789ABCDEFabcdef".indexOf(c);
        if (d > 15) {
            d -= 6;
        }
        if (d < 0) {
            XPathException err = new XPathException("Invalid hexadecimal digit");
            err.setErrorCode("FORG0001");
            throw err;
        }
        return d;
    }

    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, ConversionRules rules) {
        switch (requiredType.getPrimitiveType()) {
            case 527: 
            case 632: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
            case 528: {
                return new Base64BinaryValue(this.binaryValue);
            }
        }
        ValidationFailure err = new ValidationFailure("Cannot convert hexBinarry to " + requiredType.getDisplayName());
        err.setErrorCode("XPTY0004");
        return err;
    }

    public CharSequence getPrimitiveStringValue() {
        String digits = "0123456789ABCDEF";
        FastStringBuffer sb = new FastStringBuffer(this.binaryValue.length * 2);
        for (int i = 0; i < this.binaryValue.length; ++i) {
            sb.append(digits.charAt(this.binaryValue[i] >> 4 & 0xF));
            sb.append(digits.charAt(this.binaryValue[i] & 0xF));
        }
        return sb;
    }

    public int getLengthInOctets() {
        return this.binaryValue.length;
    }

    public Comparable getSchemaComparable() {
        return new HexBinaryComparable();
    }

    public Object getXPathComparable(boolean ordered, StringCollator collator, XPathContext context) {
        return ordered ? null : this;
    }

    public boolean equals(Object other) {
        return other instanceof HexBinaryValue && Arrays.equals(this.binaryValue, ((HexBinaryValue)other).binaryValue);
    }

    public int hashCode() {
        return Base64BinaryValue.byteArrayHashCode(this.binaryValue);
    }

    private class HexBinaryComparable
    implements Comparable {
        private HexBinaryComparable() {
        }

        public HexBinaryValue getHexBinaryValue() {
            return HexBinaryValue.this;
        }

        public int compareTo(Object o) {
            if (o instanceof HexBinaryComparable && Arrays.equals(this.getHexBinaryValue().binaryValue, ((HexBinaryComparable)o).getHexBinaryValue().binaryValue)) {
                return 0;
            }
            return Integer.MIN_VALUE;
        }

        public boolean equals(Object o) {
            return this.compareTo(o) == 0;
        }

        public int hashCode() {
            return HexBinaryValue.this.hashCode();
        }
    }
}

