/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.NUrl;
import org.python.indexer.types.NClassType;
import org.python.indexer.types.NDictType;
import org.python.indexer.types.NFuncType;
import org.python.indexer.types.NListType;
import org.python.indexer.types.NModuleType;
import org.python.indexer.types.NTupleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnionType;
import org.python.indexer.types.NUnknownType;

public class Builtins {
    public static final String LIBRARY_URL = "http://docs.python.org/library/";
    public static final String TUTORIAL_URL = "http://docs.python.org/tutorial/";
    public static final String REFERENCE_URL = "http://docs.python.org/reference/";
    public static final String DATAMODEL_URL = "http://docs.python.org/reference/datamodel#";
    public NModuleType Builtin;
    public NClassType Object;
    public NClassType Type;
    public NClassType None;
    public NClassType BaseNum;
    public NClassType BaseComplex;
    public NClassType BaseBool;
    public NClassType BaseStr;
    public NClassType BaseList;
    public NClassType BaseArray;
    public NClassType BaseDict;
    public NClassType BaseTuple;
    public NClassType BaseModule;
    public NClassType BaseFile;
    public NClassType BaseException;
    public NClassType BaseStruct;
    public NClassType BaseFunction;
    public NClassType BaseClass;
    public NClassType Datetime_datetime;
    public NClassType Datetime_date;
    public NClassType Datetime_time;
    public NClassType Datetime_timedelta;
    public NClassType Datetime_tzinfo;
    public NClassType Time_struct_time;
    Scope globaltable;
    Scope moduleTable;
    String[] builtin_exception_types = new String[]{"ArithmeticError", "AssertionError", "AttributeError", "BaseException", "Exception", "DeprecationWarning", "EOFError", "EnvironmentError", "FloatingPointError", "FutureWarning", "GeneratorExit", "IOError", "ImportError", "ImportWarning", "IndentationError", "IndexError", "KeyError", "KeyboardInterrupt", "LookupError", "MemoryError", "NameError", "NotImplemented", "NotImplementedError", "OSError", "OverflowError", "PendingDeprecationWarning", "ReferenceError", "RuntimeError", "RuntimeWarning", "StandardError", "StopIteration", "SyntaxError", "SyntaxWarning", "SystemError", "SystemExit", "TabError", "TypeError", "UnboundLocalError", "UnicodeDecodeError", "UnicodeEncodeError", "UnicodeError", "UnicodeTranslateError", "UnicodeWarning", "UserWarning", "ValueError", "Warning", "ZeroDivisionError"};
    Set<NType> nativeTypes = new HashSet<NType>();
    private Map<String, NativeModule> modules = new HashMap<String, NativeModule>();

    public static NUrl newLibUrl(String module, String name) {
        return Builtins.newLibUrl(module + ".html#" + name);
    }

    public static NUrl newLibUrl(String path) {
        if (!path.endsWith(".html")) {
            path = path + ".html";
        }
        return new NUrl(LIBRARY_URL + path);
    }

    public static NUrl newRefUrl(String path) {
        return new NUrl(REFERENCE_URL + path);
    }

    public static NUrl newDataModelUrl(String path) {
        return new NUrl(DATAMODEL_URL + path);
    }

    public static NUrl newTutUrl(String path) {
        return new NUrl(TUTORIAL_URL + path);
    }

    NClassType newClass(String name, Scope table) {
        return this.newClass(name, table, null, new NClassType[0]);
    }

    NClassType newClass(String name, Scope table, NClassType superClass, NClassType ... moreSupers) {
        NClassType t = new NClassType(name, table, superClass);
        for (NClassType c : moreSupers) {
            t.addSuper(c);
        }
        this.nativeTypes.add(t);
        return t;
    }

    NModuleType newModule(String name) {
        NModuleType mt = new NModuleType(name, null, this.globaltable);
        this.nativeTypes.add(mt);
        return mt;
    }

    NUnknownType unknown() {
        NUnknownType t = new NUnknownType();
        this.nativeTypes.add(t);
        return t;
    }

    NClassType newException(String name, Scope t) {
        return this.newClass(name, t, this.BaseException, new NClassType[0]);
    }

    NFuncType newFunc() {
        NFuncType t = new NFuncType();
        this.nativeTypes.add(t);
        return t;
    }

    NFuncType newFunc(NType type) {
        NFuncType t = new NFuncType(type);
        this.nativeTypes.add(t);
        return t;
    }

    NListType newList() {
        return this.newList(this.unknown());
    }

    NListType newList(NType type) {
        NListType t = new NListType(type);
        this.nativeTypes.add(t);
        return t;
    }

    NDictType newDict(NType ktype, NType vtype) {
        NDictType t = new NDictType(ktype, vtype);
        this.nativeTypes.add(t);
        return t;
    }

    NTupleType newTuple(NType ... types) {
        NTupleType t = new NTupleType(types);
        this.nativeTypes.add(t);
        return t;
    }

    NUnionType newUnion(NType ... types) {
        NUnionType t = new NUnionType(types);
        this.nativeTypes.add(t);
        return t;
    }

    String[] list(String ... names) {
        return names;
    }

    public Builtins(Scope globals, Scope modules) {
        this.globaltable = globals;
        this.moduleTable = modules;
        this.buildTypes();
    }

    private void buildTypes() {
        new BuiltinsModule();
        Scope bt = this.Builtin.getTable();
        this.Object = this.newClass("object", bt);
        this.None = this.newClass("None", bt);
        this.Type = this.newClass("type", bt, this.Object, new NClassType[0]);
        this.BaseTuple = this.newClass("tuple", bt, this.Object, new NClassType[0]);
        this.BaseList = this.newClass("list", bt, this.Object, new NClassType[0]);
        this.BaseArray = this.newClass("array", bt);
        this.BaseDict = this.newClass("dict", bt, this.Object, new NClassType[0]);
        this.BaseNum = this.newClass("float", bt, this.Object, new NClassType[0]);
        this.BaseComplex = this.newClass("complex", bt, this.Object, new NClassType[0]);
        this.BaseBool = this.newClass("bool", bt, this.BaseNum, new NClassType[0]);
        this.BaseStr = this.newClass("str", bt, this.Object, new NClassType[0]);
        this.BaseModule = this.newClass("module", bt);
        this.BaseFile = this.newClass("file", bt, this.Object, new NClassType[0]);
        this.BaseFunction = this.newClass("function", bt, this.Object, new NClassType[0]);
        this.BaseClass = this.newClass("classobj", bt, this.Object, new NClassType[0]);
    }

    void init() {
        this.buildObjectType();
        this.buildTupleType();
        this.buildArrayType();
        this.buildListType();
        this.buildDictType();
        this.buildNumTypes();
        this.buildStrType();
        this.buildModuleType();
        this.buildFileType();
        this.buildFunctionType();
        this.buildClassType();
        this.modules.get("__builtin__").initBindings();
        new ArrayModule();
        new AudioopModule();
        new BinasciiModule();
        new Bz2Module();
        new CPickleModule();
        new CStringIOModule();
        new CMathModule();
        new CollectionsModule();
        new CryptModule();
        new CTypesModule();
        new DatetimeModule();
        new DbmModule();
        new ErrnoModule();
        new ExceptionsModule();
        new FcntlModule();
        new FpectlModule();
        new GcModule();
        new GdbmModule();
        new GrpModule();
        new ImpModule();
        new ItertoolsModule();
        new MarshalModule();
        new MathModule();
        new Md5Module();
        new MmapModule();
        new NisModule();
        new OperatorModule();
        new OsModule();
        new ParserModule();
        new PosixModule();
        new PwdModule();
        new PyexpatModule();
        new ReadlineModule();
        new ResourceModule();
        new SelectModule();
        new SignalModule();
        new ShaModule();
        new SpwdModule();
        new StropModule();
        new StructModule();
        new SysModule();
        new SyslogModule();
        new TermiosModule();
        new ThreadModule();
        new TimeModule();
        new UnicodedataModule();
        new ZipimportModule();
        new ZlibModule();
    }

    public NModuleType get(String name) {
        if (name.indexOf(".") == -1) {
            return this.getModule(name);
        }
        String[] mods = name.split("\\.");
        NType type = this.getModule(mods[0]);
        if (type == null) {
            return null;
        }
        for (int i = 1; i < mods.length; ++i) {
            if ((type = type.getTable().lookupType(mods[i])) instanceof NModuleType) continue;
            return null;
        }
        return type;
    }

    private NModuleType getModule(String name) {
        NativeModule wrap = this.modules.get(name);
        return wrap == null ? null : wrap.getModule();
    }

    public boolean isNative(NType type) {
        return this.nativeTypes.contains(type);
    }

    void buildObjectType() {
        String[] obj_methods;
        for (String m : obj_methods = new String[]{"__delattr__", "__format__", "__getattribute__", "__hash__", "__init__", "__new__", "__reduce__", "__reduce_ex__", "__repr__", "__setattr__", "__sizeof__", "__str__", "__subclasshook__"}) {
            this.Object.getTable().update(m, Builtins.newLibUrl("stdtypes"), (NType)this.newFunc(), NBinding.Kind.METHOD);
        }
        this.Object.getTable().update("__doc__", Builtins.newLibUrl("stdtypes"), (NType)this.BaseStr, NBinding.Kind.CLASS);
        this.Object.getTable().update("__class__", Builtins.newLibUrl("stdtypes"), (NType)this.unknown(), NBinding.Kind.CLASS);
    }

    void buildTupleType() {
        String[] tuple_methods;
        Scope bt = this.BaseTuple.getTable();
        for (String m : tuple_methods = new String[]{"__add__", "__contains__", "__eq__", "__ge__", "__getnewargs__", "__gt__", "__iter__", "__le__", "__len__", "__lt__", "__mul__", "__ne__", "__new__", "__rmul__", "count", "index"}) {
            bt.update(m, Builtins.newLibUrl("stdtypes"), (NType)this.newFunc(), NBinding.Kind.METHOD);
        }
        NBinding b = bt.update("__getslice__", Builtins.newDataModelUrl("object.__getslice__"), (NType)this.newFunc(), NBinding.Kind.METHOD);
        b.markDeprecated();
        bt.update("__getitem__", Builtins.newDataModelUrl("object.__getitem__"), (NType)this.newFunc(), NBinding.Kind.METHOD);
        bt.update("__iter__", Builtins.newDataModelUrl("object.__iter__"), (NType)this.newFunc(), NBinding.Kind.METHOD);
    }

    void buildArrayType() {
        String[] array_methods_str;
        String[] array_methods_num;
        String[] array_methods_none;
        for (String m : array_methods_none = new String[]{"append", "buffer_info", "byteswap", "extend", "fromfile", "fromlist", "fromstring", "fromunicode", "index", "insert", "pop", "read", "remove", "reverse", "tofile", "tolist", "typecode", "write"}) {
            this.BaseArray.getTable().update(m, Builtins.newLibUrl("array"), (NType)this.newFunc(this.None), NBinding.Kind.METHOD);
        }
        for (String m : array_methods_num = new String[]{"count", "itemsize"}) {
            this.BaseArray.getTable().update(m, Builtins.newLibUrl("array"), (NType)this.newFunc(this.BaseNum), NBinding.Kind.METHOD);
        }
        for (String m : array_methods_str = new String[]{"tostring", "tounicode"}) {
            this.BaseArray.getTable().update(m, Builtins.newLibUrl("array"), (NType)this.newFunc(this.BaseStr), NBinding.Kind.METHOD);
        }
    }

    void buildListType() {
        String[] list_methods_num;
        String[] list_methods_none;
        this.BaseList.getTable().update("__getslice__", Builtins.newDataModelUrl("object.__getslice__"), (NType)this.newFunc(this.BaseList), NBinding.Kind.METHOD);
        this.BaseList.getTable().update("__getitem__", Builtins.newDataModelUrl("object.__getitem__"), (NType)this.newFunc(this.BaseList), NBinding.Kind.METHOD);
        this.BaseList.getTable().update("__iter__", Builtins.newDataModelUrl("object.__iter__"), (NType)this.newFunc(this.BaseList), NBinding.Kind.METHOD);
        for (String m : list_methods_none = new String[]{"append", "extend", "index", "insert", "pop", "remove", "reverse", "sort"}) {
            this.BaseList.getTable().update(m, Builtins.newLibUrl("stdtypes"), (NType)this.newFunc(this.None), NBinding.Kind.METHOD);
        }
        for (String m : list_methods_num = new String[]{"count"}) {
            this.BaseList.getTable().update(m, Builtins.newLibUrl("stdtypes"), (NType)this.newFunc(this.BaseNum), NBinding.Kind.METHOD);
        }
    }

    NUrl numUrl() {
        return Builtins.newLibUrl("stdtypes", "typesnumeric");
    }

    void buildNumTypes() {
        String[] complex_methods_num;
        String[] complex_methods;
        String[] num_methods_num;
        Scope bnt = this.BaseNum.getTable();
        for (String m : num_methods_num = new String[]{"__abs__", "__add__", "__coerce__", "__div__", "__divmod__", "__eq__", "__float__", "__floordiv__", "__format__", "__ge__", "__getformat__", "__gt__", "__int__", "__le__", "__long__", "__lt__", "__mod__", "__mul__", "__ne__", "__neg__", "__new__", "__nonzero__", "__pos__", "__pow__", "__radd__", "__rdiv__", "__rdivmod__", "__rfloordiv__", "__rmod__", "__rmul__", "__rpow__", "__rsub__", "__rtruediv__", "__setformat__", "__sub__", "__truediv__", "__trunc__", "as_integer_ratio", "fromhex", "is_integer"}) {
            bnt.update(m, this.numUrl(), (NType)this.newFunc(this.BaseNum), NBinding.Kind.METHOD);
        }
        bnt.update("__getnewargs__", this.numUrl(), (NType)this.newFunc(this.newTuple(this.BaseNum)), NBinding.Kind.METHOD);
        bnt.update("hex", this.numUrl(), (NType)this.newFunc(this.BaseStr), NBinding.Kind.METHOD);
        bnt.update("conjugate", this.numUrl(), (NType)this.newFunc(this.BaseComplex), NBinding.Kind.METHOD);
        Scope bct = this.BaseComplex.getTable();
        for (String c : complex_methods = new String[]{"__abs__", "__add__", "__div__", "__divmod__", "__float__", "__floordiv__", "__format__", "__getformat__", "__int__", "__long__", "__mod__", "__mul__", "__neg__", "__new__", "__pos__", "__pow__", "__radd__", "__rdiv__", "__rdivmod__", "__rfloordiv__", "__rmod__", "__rmul__", "__rpow__", "__rsub__", "__rtruediv__", "__sub__", "__truediv__", "conjugate"}) {
            bct.update(c, this.numUrl(), (NType)this.newFunc(this.BaseComplex), NBinding.Kind.METHOD);
        }
        for (String cn : complex_methods_num = new String[]{"__eq__", "__ge__", "__gt__", "__le__", "__lt__", "__ne__", "__nonzero__", "__coerce__"}) {
            bct.update(cn, this.numUrl(), (NType)this.newFunc(this.BaseNum), NBinding.Kind.METHOD);
        }
        bct.update("__getnewargs__", this.numUrl(), (NType)this.newFunc(this.newTuple(this.BaseComplex)), NBinding.Kind.METHOD);
        bct.update("imag", this.numUrl(), (NType)this.BaseNum, NBinding.Kind.ATTRIBUTE);
        bct.update("real", this.numUrl(), (NType)this.BaseNum, NBinding.Kind.ATTRIBUTE);
    }

    void buildStrType() {
        String[] str_methods_list;
        String[] str_methods_num;
        String[] str_methods_str;
        this.BaseStr.getTable().update("__getslice__", Builtins.newDataModelUrl("object.__getslice__"), (NType)this.newFunc(this.BaseStr), NBinding.Kind.METHOD);
        this.BaseStr.getTable().update("__getitem__", Builtins.newDataModelUrl("object.__getitem__"), (NType)this.newFunc(this.BaseStr), NBinding.Kind.METHOD);
        this.BaseStr.getTable().update("__iter__", Builtins.newDataModelUrl("object.__iter__"), (NType)this.newFunc(this.BaseStr), NBinding.Kind.METHOD);
        for (String m : str_methods_str = new String[]{"capitalize", "center", "decode", "encode", "expandtabs", "format", "index", "join", "ljust", "lower", "lstrip", "partition", "replace", "rfind", "rindex", "rjust", "rpartition", "rsplit", "rstrip", "strip", "swapcase", "title", "translate", "upper", "zfill"}) {
            this.BaseStr.getTable().update(m, Builtins.newLibUrl("stdtypes.html#str." + m), (NType)this.newFunc(this.BaseStr), NBinding.Kind.METHOD);
        }
        for (String m : str_methods_num = new String[]{"count", "isalnum", "isalpha", "isdigit", "islower", "isspace", "istitle", "isupper", "find", "startswith", "endswith"}) {
            this.BaseStr.getTable().update(m, Builtins.newLibUrl("stdtypes.html#str." + m), (NType)this.newFunc(this.BaseNum), NBinding.Kind.METHOD);
        }
        for (String m : str_methods_list = new String[]{"split", "splitlines"}) {
            this.BaseStr.getTable().update(m, Builtins.newLibUrl("stdtypes.html#str." + m), (NType)this.newFunc(this.newList(this.BaseStr)), NBinding.Kind.METHOD);
        }
        this.BaseStr.getTable().update("partition", Builtins.newLibUrl("stdtypes"), (NType)this.newFunc(this.newTuple(this.BaseStr)), NBinding.Kind.METHOD);
    }

    void buildModuleType() {
        String[] attrs;
        for (String m : attrs = new String[]{"__doc__", "__file__", "__name__", "__package__"}) {
            this.BaseModule.getTable().update(m, Builtins.newTutUrl("modules.html"), (NType)this.BaseStr, NBinding.Kind.ATTRIBUTE);
        }
        this.BaseModule.getTable().update("__dict__", Builtins.newLibUrl("stdtypes", "modules"), (NType)this.newDict(this.BaseStr, this.unknown()), NBinding.Kind.ATTRIBUTE);
    }

    void buildDictType() {
        String[] dict_method_num;
        String[] dict_method_unknown;
        String url = "datastructures.html#dictionaries";
        Scope bt = this.BaseDict.getTable();
        bt.update("__getitem__", Builtins.newTutUrl(url), (NType)this.newFunc(), NBinding.Kind.METHOD);
        bt.update("__iter__", Builtins.newTutUrl(url), (NType)this.newFunc(), NBinding.Kind.METHOD);
        bt.update("get", Builtins.newTutUrl(url), (NType)this.newFunc(), NBinding.Kind.METHOD);
        bt.update("items", Builtins.newTutUrl(url), (NType)this.newFunc(this.newList(this.newTuple(this.unknown(), this.unknown()))), NBinding.Kind.METHOD);
        bt.update("keys", Builtins.newTutUrl(url), (NType)this.newFunc(this.BaseList), NBinding.Kind.METHOD);
        bt.update("values", Builtins.newTutUrl(url), (NType)this.newFunc(this.BaseList), NBinding.Kind.METHOD);
        for (String m : dict_method_unknown = new String[]{"clear", "copy", "fromkeys", "get", "iteritems", "iterkeys", "itervalues", "pop", "popitem", "setdefault", "update"}) {
            bt.update(m, Builtins.newTutUrl(url), (NType)this.newFunc(), NBinding.Kind.METHOD);
        }
        for (String m : dict_method_num = new String[]{"has_key"}) {
            bt.update(m, Builtins.newTutUrl(url), (NType)this.newFunc(this.BaseNum), NBinding.Kind.METHOD);
        }
    }

    void buildFileType() {
        String[] methods_none;
        String[] num;
        String[] methods_str;
        String[] methods_unknown;
        String url = "stdtypes.html#bltin-file-objects";
        Scope table = this.BaseFile.getTable();
        for (String m : methods_unknown = new String[]{"__enter__", "__exit__", "__iter__", "flush", "readinto", "truncate"}) {
            table.update(m, Builtins.newLibUrl(url), (NType)this.newFunc(), NBinding.Kind.METHOD);
        }
        for (String m : methods_str = new String[]{"next", "read", "readline"}) {
            table.update(m, Builtins.newLibUrl(url), (NType)this.newFunc(this.BaseStr), NBinding.Kind.METHOD);
        }
        for (String m : num = new String[]{"fileno", "isatty", "tell"}) {
            table.update(m, Builtins.newLibUrl(url), (NType)this.newFunc(this.BaseNum), NBinding.Kind.METHOD);
        }
        for (String m : methods_none = new String[]{"close", "seek", "write", "writelines"}) {
            table.update(m, Builtins.newLibUrl(url), (NType)this.newFunc(this.None), NBinding.Kind.METHOD);
        }
        table.update("readlines", Builtins.newLibUrl(url), (NType)this.newFunc(this.newList(this.BaseStr)), NBinding.Kind.METHOD);
        table.update("xreadlines", Builtins.newLibUrl(url), (NType)this.newFunc(this.BaseFile), NBinding.Kind.METHOD);
        table.update("closed", Builtins.newLibUrl(url), (NType)this.BaseNum, NBinding.Kind.ATTRIBUTE);
        table.update("encoding", Builtins.newLibUrl(url), (NType)this.BaseStr, NBinding.Kind.ATTRIBUTE);
        table.update("errors", Builtins.newLibUrl(url), (NType)this.unknown(), NBinding.Kind.ATTRIBUTE);
        table.update("mode", Builtins.newLibUrl(url), (NType)this.BaseNum, NBinding.Kind.ATTRIBUTE);
        table.update("name", Builtins.newLibUrl(url), (NType)this.BaseStr, NBinding.Kind.ATTRIBUTE);
        table.update("softspace", Builtins.newLibUrl(url), (NType)this.BaseNum, NBinding.Kind.ATTRIBUTE);
        table.update("newlines", Builtins.newLibUrl(url), (NType)this.newUnion(this.BaseStr, this.newTuple(this.BaseStr)), NBinding.Kind.ATTRIBUTE);
    }

    private NBinding synthetic(Scope table, String n, NUrl url, NType type, NBinding.Kind k) {
        NBinding b = table.update(n, url, type, k);
        b.markSynthetic();
        return b;
    }

    void buildFunctionType() {
        Scope t = this.BaseFunction.getTable();
        for (String s : this.list("func_doc", "__doc__", "func_name", "__name__", "__module__")) {
            t.update(s, new NUrl(DATAMODEL_URL), (NType)this.BaseStr, NBinding.Kind.ATTRIBUTE);
        }
        NBinding b = this.synthetic(t, "func_closure", new NUrl(DATAMODEL_URL), this.newTuple(new NType[0]), NBinding.Kind.ATTRIBUTE);
        b.markReadOnly();
        this.synthetic(t, "func_code", new NUrl(DATAMODEL_URL), this.unknown(), NBinding.Kind.ATTRIBUTE);
        this.synthetic(t, "func_defaults", new NUrl(DATAMODEL_URL), this.newTuple(new NType[0]), NBinding.Kind.ATTRIBUTE);
        this.synthetic(t, "func_globals", new NUrl(DATAMODEL_URL), new NDictType(this.BaseStr, new NUnknownType()), NBinding.Kind.ATTRIBUTE);
        this.synthetic(t, "func_dict", new NUrl(DATAMODEL_URL), new NDictType(this.BaseStr, new NUnknownType()), NBinding.Kind.ATTRIBUTE);
        for (String s : this.list("__func__", "im_func")) {
            this.synthetic(t, s, new NUrl(DATAMODEL_URL), new NFuncType(), NBinding.Kind.METHOD);
        }
    }

    void buildClassType() {
        Scope t = this.BaseClass.getTable();
        for (String s : this.list("__name__", "__doc__", "__module__")) {
            this.synthetic(t, s, new NUrl(DATAMODEL_URL), this.BaseStr, NBinding.Kind.ATTRIBUTE);
        }
        this.synthetic(t, "__dict__", new NUrl(DATAMODEL_URL), new NDictType(this.BaseStr, this.unknown()), NBinding.Kind.ATTRIBUTE);
    }

    class ZlibModule
    extends NativeModule {
        public ZlibModule() {
            super("zlib");
        }

        public void initBindings() {
            NClassType Compress = Builtins.this.newClass("Compress", this.table, Builtins.this.Object, new NClassType[0]);
            for (String s : Builtins.this.list("compress", "flush")) {
                Compress.getTable().update(s, Builtins.newLibUrl("zlib"), (NType)Builtins.this.BaseStr, NBinding.Kind.METHOD);
            }
            Compress.getTable().update("copy", Builtins.newLibUrl("zlib"), (NType)Compress, NBinding.Kind.METHOD);
            this.addClass("Compress", this.liburl(), Compress);
            NClassType Decompress = Builtins.this.newClass("Decompress", this.table, Builtins.this.Object, new NClassType[0]);
            for (String s : Builtins.this.list("unused_data", "unconsumed_tail")) {
                Decompress.getTable().update(s, Builtins.newLibUrl("zlib"), (NType)Builtins.this.BaseStr, NBinding.Kind.ATTRIBUTE);
            }
            for (String s : Builtins.this.list("decompress", "flush")) {
                Decompress.getTable().update(s, Builtins.newLibUrl("zlib"), (NType)Builtins.this.BaseStr, NBinding.Kind.METHOD);
            }
            Decompress.getTable().update("copy", Builtins.newLibUrl("zlib"), (NType)Decompress, NBinding.Kind.METHOD);
            this.addClass("Decompress", this.liburl(), Decompress);
            this.addFunction("adler32", this.liburl(), Builtins.this.BaseNum);
            this.addFunction("compress", this.liburl(), Builtins.this.BaseStr);
            this.addFunction("compressobj", this.liburl(), Compress);
            this.addFunction("crc32", this.liburl(), Builtins.this.BaseNum);
            this.addFunction("decompress", this.liburl(), Builtins.this.BaseStr);
            this.addFunction("decompressobj", this.liburl(), Decompress);
        }
    }

    class ZipimportModule
    extends NativeModule {
        public ZipimportModule() {
            super("zipimport");
        }

        public void initBindings() {
            this.addClass("ZipImportError", this.liburl(), Builtins.this.newException("ZipImportError", this.table));
            NClassType zipimporter2 = Builtins.this.newClass("zipimporter", this.table, Builtins.this.Object, new NClassType[0]);
            Scope t = zipimporter2.getTable();
            t.update("find_module", this.liburl(), (NType)zipimporter2, NBinding.Kind.METHOD);
            t.update("get_code", this.liburl(), (NType)Builtins.this.unknown(), NBinding.Kind.METHOD);
            t.update("get_data", this.liburl(), (NType)Builtins.this.unknown(), NBinding.Kind.METHOD);
            t.update("get_source", this.liburl(), (NType)Builtins.this.BaseStr, NBinding.Kind.METHOD);
            t.update("is_package", this.liburl(), (NType)Builtins.this.BaseNum, NBinding.Kind.METHOD);
            t.update("load_module", this.liburl(), (NType)Builtins.this.newModule("<?>"), NBinding.Kind.METHOD);
            t.update("archive", this.liburl(), (NType)Builtins.this.BaseStr, NBinding.Kind.ATTRIBUTE);
            t.update("prefix", this.liburl(), (NType)Builtins.this.BaseStr, NBinding.Kind.ATTRIBUTE);
            this.addClass("zipimporter", this.liburl(), zipimporter2);
            this.addAttr("_zip_directory_cache", this.liburl(), Builtins.this.newDict(Builtins.this.BaseStr, Builtins.this.unknown()));
        }
    }

    class UnicodedataModule
    extends NativeModule {
        public UnicodedataModule() {
            super("unicodedata");
        }

        public void initBindings() {
            this.addNumFuncs("decimal", "digit", "numeric", "combining", "east_asian_width", "mirrored");
            this.addStrFuncs("lookup", "name", "category", "bidirectional", "decomposition", "normalize");
            this.addNumAttrs("unidata_version");
            this.addUnknownAttrs("ucd_3_2_0");
        }
    }

    class TimeModule
    extends NativeModule {
        public TimeModule() {
            super("time");
        }

        public void initBindings() {
            String[] struct_time_attrs;
            NClassType struct_time = Builtins.this.Time_struct_time = Builtins.this.newClass("datetime", this.table, Builtins.this.Object, new NClassType[0]);
            this.addAttr("struct_time", this.liburl(), struct_time);
            for (String s : struct_time_attrs = new String[]{"n_fields", "n_sequence_fields", "n_unnamed_fields", "tm_hour", "tm_isdst", "tm_mday", "tm_min", "tm_mon", "tm_wday", "tm_yday", "tm_year"}) {
                struct_time.getTable().update(s, this.liburl("struct_time"), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            }
            this.addNumAttrs("accept2dyear", "altzone", "daylight", "timezone");
            this.addAttr("tzname", this.liburl(), Builtins.this.newTuple(Builtins.this.BaseStr, Builtins.this.BaseStr));
            this.addNoneFuncs("sleep", "tzset");
            this.addNumFuncs("clock", "mktime", "time", "tzname");
            this.addStrFuncs("asctime", "ctime", "strftime");
            this.addFunctions_beCareful(struct_time, "gmtime", "localtime", "strptime");
        }
    }

    class ThreadModule
    extends NativeModule {
        public ThreadModule() {
            super("thread");
        }

        public void initBindings() {
            this.addClass("error", this.liburl(), Builtins.this.newException("error", this.table));
            NClassType lock = Builtins.this.newClass("lock", this.table, Builtins.this.Object, new NClassType[0]);
            lock.getTable().update("acquire", this.liburl(), (NType)Builtins.this.BaseNum, NBinding.Kind.METHOD);
            lock.getTable().update("locked", this.liburl(), (NType)Builtins.this.BaseNum, NBinding.Kind.METHOD);
            lock.getTable().update("release", this.liburl(), (NType)Builtins.this.None, NBinding.Kind.METHOD);
            this.addAttr("LockType", this.liburl(), Builtins.this.Type);
            this.addNoneFuncs("interrupt_main", "exit", "exit_thread");
            this.addNumFuncs("start_new", "start_new_thread", "get_ident", "stack_size");
            this.addFunction("allocate", this.liburl(), lock);
            this.addFunction("allocate_lock", this.liburl(), lock);
            this.addAttr("_local", this.liburl(), Builtins.this.Type);
        }
    }

    class TermiosModule
    extends NativeModule {
        public TermiosModule() {
            super("termios");
        }

        public void initBindings() {
            this.addFunction("tcgetattr", this.liburl(), Builtins.this.newList());
            this.addUnknownFuncs("tcsetattr", "tcsendbreak", "tcdrain", "tcflush", "tcflow");
        }
    }

    class SyslogModule
    extends NativeModule {
        public SyslogModule() {
            super("syslog");
        }

        public void initBindings() {
            this.addNoneFuncs("syslog", "openlog", "closelog", "setlogmask");
            this.addNumAttrs("LOG_ALERT", "LOG_AUTH", "LOG_CONS", "LOG_CRIT", "LOG_CRON", "LOG_DAEMON", "LOG_DEBUG", "LOG_EMERG", "LOG_ERR", "LOG_INFO", "LOG_KERN", "LOG_LOCAL0", "LOG_LOCAL1", "LOG_LOCAL2", "LOG_LOCAL3", "LOG_LOCAL4", "LOG_LOCAL5", "LOG_LOCAL6", "LOG_LOCAL7", "LOG_LPR", "LOG_MAIL", "LOG_MASK", "LOG_NDELAY", "LOG_NEWS", "LOG_NOTICE", "LOG_NOWAIT", "LOG_PERROR", "LOG_PID", "LOG_SYSLOG", "LOG_UPTO", "LOG_USER", "LOG_UUCP", "LOG_WARNING");
        }
    }

    class SysModule
    extends NativeModule {
        public SysModule() {
            super("sys");
        }

        public void initBindings() {
            this.addUnknownFuncs("_clear_type_cache", "call_tracing", "callstats", "_current_frames", "_getframe", "displayhook", "dont_write_bytecode", "exitfunc", "exc_clear", "exc_info", "excepthook", "exit", "last_traceback", "last_type", "last_value", "modules", "path_hooks", "path_importer_cache", "getprofile", "gettrace", "setcheckinterval", "setprofile", "setrecursionlimit", "settrace");
            this.addAttr("exc_type", this.liburl(), Builtins.this.None);
            this.addUnknownAttrs("__stderr__", "__stdin__", "__stdout__", "stderr", "stdin", "stdout", "version_info");
            this.addNumAttrs("api_version", "hexversion", "winver", "maxint", "maxsize", "maxunicode", "py3kwarning", "dllhandle");
            this.addStrAttrs("platform", "byteorder", "copyright", "prefix", "version", "exec_prefix", "executable");
            this.addNumFuncs("getrecursionlimit", "getwindowsversion", "getrefcount", "getsizeof", "getcheckinterval");
            this.addStrFuncs("getdefaultencoding", "getfilesystemencoding");
            for (String s : Builtins.this.list("argv", "builtin_module_names", "path", "meta_path", "subversion")) {
                this.addAttr(s, this.liburl(), Builtins.this.newList(Builtins.this.BaseStr));
            }
            for (String s : Builtins.this.list("flags", "warnoptions", "float_info")) {
                this.addAttr(s, this.liburl(), Builtins.this.newDict(Builtins.this.BaseStr, Builtins.this.BaseNum));
            }
        }
    }

    class StructModule
    extends NativeModule {
        public StructModule() {
            super("struct");
        }

        public void initBindings() {
            this.addClass("error", this.liburl(), Builtins.this.newException("error", this.table));
            this.addStrFuncs("pack");
            this.addUnknownFuncs("pack_into");
            this.addNumFuncs("calcsize");
            this.addFunction("unpack", this.liburl(), Builtins.this.newTuple(new NType[0]));
            this.addFunction("unpack_from", this.liburl(), Builtins.this.newTuple(new NType[0]));
            Builtins.this.BaseStruct = Builtins.this.newClass("Struct", this.table, Builtins.this.Object, new NClassType[0]);
            this.addClass("Struct", this.liburl("struct-objects"), Builtins.this.BaseStruct);
            Scope t = Builtins.this.BaseStruct.getTable();
            t.update("pack", this.liburl("struct-objects"), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.METHOD);
            t.update("pack_into", this.liburl("struct-objects"), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            t.update("unpack", this.liburl("struct-objects"), (NType)Builtins.this.newFunc(Builtins.this.newTuple(new NType[0])), NBinding.Kind.METHOD);
            t.update("unpack_from", this.liburl("struct-objects"), (NType)Builtins.this.newFunc(Builtins.this.newTuple(new NType[0])), NBinding.Kind.METHOD);
            t.update("format", this.liburl("struct-objects"), (NType)Builtins.this.BaseStr, NBinding.Kind.ATTRIBUTE);
            t.update("size", this.liburl("struct-objects"), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
        }
    }

    class StropModule
    extends NativeModule {
        public StropModule() {
            super("strop");
        }

        public void initBindings() {
            this.table.merge(Builtins.this.BaseStr.getTable());
        }
    }

    class SpwdModule
    extends NativeModule {
        public SpwdModule() {
            super("spwd");
        }

        public void initBindings() {
            NClassType struct_spwd = Builtins.this.newClass("struct_spwd", this.table, Builtins.this.Object, new NClassType[0]);
            for (String s : Builtins.this.list("sp_nam", "sp_pwd", "sp_lstchg", "sp_min", "sp_max", "sp_warn", "sp_inact", "sp_expire", "sp_flag")) {
                struct_spwd.getTable().update(s, this.liburl(), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            }
            this.addAttr("struct_spwd", this.liburl(), struct_spwd);
            this.addFunction("getspnam", this.liburl(), struct_spwd);
            this.addFunction("getspall", this.liburl(), Builtins.this.newList(struct_spwd));
        }
    }

    class ShaModule
    extends NativeModule {
        public ShaModule() {
            super("sha");
        }

        public void initBindings() {
            this.addNumAttrs("blocksize", "digest_size");
            NClassType sha = Builtins.this.newClass("sha", this.table, Builtins.this.Object, new NClassType[0]);
            sha.getTable().update("update", this.liburl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            sha.getTable().update("digest", this.liburl(), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.METHOD);
            sha.getTable().update("hexdigest", this.liburl(), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.METHOD);
            sha.getTable().update("copy", this.liburl(), (NType)Builtins.this.newFunc(sha), NBinding.Kind.METHOD);
            this.addClass("sha", this.liburl(), sha);
            this.update("new", this.liburl(), Builtins.this.newFunc(sha), NBinding.Kind.CONSTRUCTOR);
        }
    }

    class SignalModule
    extends NativeModule {
        public SignalModule() {
            super("signal");
        }

        public void initBindings() {
            this.addNumAttrs("NSIG", "SIGABRT", "SIGALRM", "SIGBUS", "SIGCHLD", "SIGCLD", "SIGCONT", "SIGFPE", "SIGHUP", "SIGILL", "SIGINT", "SIGIO", "SIGIOT", "SIGKILL", "SIGPIPE", "SIGPOLL", "SIGPROF", "SIGPWR", "SIGQUIT", "SIGRTMAX", "SIGRTMIN", "SIGSEGV", "SIGSTOP", "SIGSYS", "SIGTERM", "SIGTRAP", "SIGTSTP", "SIGTTIN", "SIGTTOU", "SIGURG", "SIGUSR1", "SIGUSR2", "SIGVTALRM", "SIGWINCH", "SIGXCPU", "SIGXFSZ", "SIG_DFL", "SIG_IGN");
            this.addUnknownFuncs("default_int_handler", "getsignal", "set_wakeup_fd", "signal");
        }
    }

    class SelectModule
    extends NativeModule {
        public SelectModule() {
            super("select");
        }

        public void initBindings() {
            this.addClass("error", this.liburl(), Builtins.this.newException("error", this.table));
            this.addFunction("select", this.liburl(), Builtins.this.newTuple(Builtins.this.newList(), Builtins.this.newList(), Builtins.this.newList()));
            String a = "edge-and-level-trigger-polling-epoll-objects";
            NClassType epoll = Builtins.this.newClass("epoll", this.table, Builtins.this.Object, new NClassType[0]);
            epoll.getTable().update("close", Builtins.newLibUrl("select", a), (NType)Builtins.this.newFunc(Builtins.this.None), NBinding.Kind.METHOD);
            epoll.getTable().update("fileno", Builtins.newLibUrl("select", a), (NType)Builtins.this.newFunc(Builtins.this.BaseNum), NBinding.Kind.METHOD);
            epoll.getTable().update("fromfd", Builtins.newLibUrl("select", a), (NType)Builtins.this.newFunc(epoll), NBinding.Kind.METHOD);
            for (String s : Builtins.this.list("register", "modify", "unregister", "poll")) {
                epoll.getTable().update(s, Builtins.newLibUrl("select", a), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            }
            this.addClass("epoll", this.liburl(a), epoll);
            for (String s : Builtins.this.list("EPOLLERR", "EPOLLET", "EPOLLHUP", "EPOLLIN", "EPOLLMSG", "EPOLLONESHOT", "EPOLLOUT", "EPOLLPRI", "EPOLLRDBAND", "EPOLLRDNORM", "EPOLLWRBAND", "EPOLLWRNORM")) {
                this.addAttr(s, this.liburl(a), Builtins.this.BaseNum);
            }
            a = "polling-objects";
            NClassType poll = Builtins.this.newClass("poll", this.table, Builtins.this.Object, new NClassType[0]);
            poll.getTable().update("register", Builtins.newLibUrl("select", a), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            poll.getTable().update("modify", Builtins.newLibUrl("select", a), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            poll.getTable().update("unregister", Builtins.newLibUrl("select", a), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            poll.getTable().update("poll", Builtins.newLibUrl("select", a), (NType)Builtins.this.newFunc(Builtins.this.newList(Builtins.this.newTuple(Builtins.this.BaseNum, Builtins.this.BaseNum))), NBinding.Kind.METHOD);
            this.addClass("poll", this.liburl(a), poll);
            for (String s : Builtins.this.list("POLLERR", "POLLHUP", "POLLIN", "POLLMSG", "POLLNVAL", "POLLOUT", "POLLPRI", "POLLRDBAND", "POLLRDNORM", "POLLWRBAND", "POLLWRNORM")) {
                this.addAttr(s, this.liburl(a), Builtins.this.BaseNum);
            }
            a = "kqueue-objects";
            NClassType kqueue = Builtins.this.newClass("kqueue", this.table, Builtins.this.Object, new NClassType[0]);
            kqueue.getTable().update("close", Builtins.newLibUrl("select", a), (NType)Builtins.this.newFunc(Builtins.this.None), NBinding.Kind.METHOD);
            kqueue.getTable().update("fileno", Builtins.newLibUrl("select", a), (NType)Builtins.this.newFunc(Builtins.this.BaseNum), NBinding.Kind.METHOD);
            kqueue.getTable().update("fromfd", Builtins.newLibUrl("select", a), (NType)Builtins.this.newFunc(kqueue), NBinding.Kind.METHOD);
            kqueue.getTable().update("control", Builtins.newLibUrl("select", a), (NType)Builtins.this.newFunc(Builtins.this.newList(Builtins.this.newTuple(Builtins.this.BaseNum, Builtins.this.BaseNum))), NBinding.Kind.METHOD);
            this.addClass("kqueue", this.liburl(a), kqueue);
            a = "kevent-objects";
            NClassType kevent = Builtins.this.newClass("kevent", this.table, Builtins.this.Object, new NClassType[0]);
            for (String s : Builtins.this.list("ident", "filter", "flags", "fflags", "data", "udata")) {
                kevent.getTable().update(s, Builtins.newLibUrl("select", a), (NType)Builtins.this.unknown(), NBinding.Kind.ATTRIBUTE);
            }
            this.addClass("kevent", this.liburl(a), kevent);
        }
    }

    class ResourceModule
    extends NativeModule {
        public ResourceModule() {
            super("resource");
        }

        public void initBindings() {
            String[] ru_fields;
            String[] constants;
            this.addFunction("getrlimit", this.liburl(), Builtins.this.newTuple(Builtins.this.BaseNum, Builtins.this.BaseNum));
            this.addFunction("getrlimit", this.liburl(), Builtins.this.unknown());
            for (String c : constants = new String[]{"RLIMIT_CORE", "RLIMIT_CPU", "RLIMIT_FSIZE", "RLIMIT_DATA", "RLIMIT_STACK", "RLIMIT_RSS", "RLIMIT_NPROC", "RLIMIT_NOFILE", "RLIMIT_OFILE", "RLIMIT_MEMLOCK", "RLIMIT_VMEM", "RLIMIT_AS"}) {
                this.addAttr(c, this.liburl("resource-limits"), Builtins.this.BaseNum);
            }
            NClassType ru = Builtins.this.newClass("struct_rusage", this.table, Builtins.this.Object, new NClassType[0]);
            for (String ruf : ru_fields = new String[]{"ru_utime", "ru_stime", "ru_maxrss", "ru_ixrss", "ru_idrss", "ru_isrss", "ru_minflt", "ru_majflt", "ru_nswap", "ru_inblock", "ru_oublock", "ru_msgsnd", "ru_msgrcv", "ru_nsignals", "ru_nvcsw", "ru_nivcsw"}) {
                ru.getTable().update(ruf, this.liburl("resource-usage"), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            }
            this.addFunction("getrusage", this.liburl("resource-usage"), ru);
            this.addFunction("getpagesize", this.liburl("resource-usage"), Builtins.this.BaseNum);
            for (String s : Builtins.this.list("RUSAGE_SELF", "RUSAGE_CHILDREN", "RUSAGE_BOTH")) {
                this.addAttr(s, this.liburl("resource-usage"), Builtins.this.BaseNum);
            }
        }
    }

    class ReadlineModule
    extends NativeModule {
        public ReadlineModule() {
            super("readline");
        }

        public void initBindings() {
            this.addNoneFuncs("parse_and_bind", "insert_text", "read_init_file", "read_history_file", "write_history_file", "clear_history", "set_history_length", "remove_history_item", "replace_history_item", "redisplay", "set_startup_hook", "set_pre_input_hook", "set_completer", "set_completer_delims", "set_completion_display_matches_hook", "add_history");
            this.addNumFuncs("get_history_length", "get_current_history_length", "get_begidx", "get_endidx");
            this.addStrFuncs("get_line_buffer", "get_history_item");
            this.addUnknownFuncs("get_completion_type");
            this.addFunction("get_completer", this.liburl(), Builtins.this.newFunc());
            this.addFunction("get_completer_delims", this.liburl(), Builtins.this.newList(Builtins.this.BaseStr));
        }
    }

    class PyexpatModule
    extends NativeModule {
        public PyexpatModule() {
            super("pyexpat");
        }

        public void initBindings() {
        }
    }

    class PwdModule
    extends NativeModule {
        public PwdModule() {
            super("pwd");
        }

        public void initBindings() {
            NClassType struct_pwd = Builtins.this.newClass("struct_pwd", this.table, Builtins.this.Object, new NClassType[0]);
            for (String s : Builtins.this.list("pw_nam", "pw_passwd", "pw_uid", "pw_gid", "pw_gecos", "pw_dir", "pw_shell")) {
                struct_pwd.getTable().update(s, this.liburl(), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            }
            this.addAttr("struct_pwd", this.liburl(), struct_pwd);
            this.addFunction("getpwuid", this.liburl(), struct_pwd);
            this.addFunction("getpwnam", this.liburl(), struct_pwd);
            this.addFunction("getpwall", this.liburl(), Builtins.this.newList(struct_pwd));
        }
    }

    class PosixModule
    extends NativeModule {
        public PosixModule() {
            super("posix");
        }

        public void initBindings() {
            this.addAttr("environ", this.liburl(), Builtins.this.newDict(Builtins.this.BaseStr, Builtins.this.BaseStr));
        }
    }

    class ParserModule
    extends NativeModule {
        public ParserModule() {
            super("parser");
        }

        public void initBindings() {
            NClassType st = Builtins.this.newClass("st", this.table, Builtins.this.Object, new NClassType[0]);
            st.getTable().update("compile", Builtins.newLibUrl("parser", "st-objects"), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            st.getTable().update("isexpr", Builtins.newLibUrl("parser", "st-objects"), (NType)Builtins.this.newFunc(Builtins.this.BaseNum), NBinding.Kind.METHOD);
            st.getTable().update("issuite", Builtins.newLibUrl("parser", "st-objects"), (NType)Builtins.this.newFunc(Builtins.this.BaseNum), NBinding.Kind.METHOD);
            st.getTable().update("tolist", Builtins.newLibUrl("parser", "st-objects"), (NType)Builtins.this.newFunc(Builtins.this.newList()), NBinding.Kind.METHOD);
            st.getTable().update("totuple", Builtins.newLibUrl("parser", "st-objects"), (NType)Builtins.this.newFunc(Builtins.this.newTuple(new NType[0])), NBinding.Kind.METHOD);
            this.addAttr("STType", this.liburl("st-objects"), Builtins.this.Type);
            for (String s : Builtins.this.list("expr", "suite", "sequence2st", "tuple2st")) {
                this.addFunction(s, this.liburl("creating-st-objects"), st);
            }
            this.addFunction("st2list", this.liburl("converting-st-objects"), Builtins.this.newList());
            this.addFunction("st2tuple", this.liburl("converting-st-objects"), Builtins.this.newTuple(new NType[0]));
            this.addFunction("compilest", this.liburl("converting-st-objects"), Builtins.this.unknown());
            this.addFunction("isexpr", this.liburl("queries-on-st-objects"), Builtins.this.BaseBool);
            this.addFunction("issuite", this.liburl("queries-on-st-objects"), Builtins.this.BaseBool);
            this.addClass("ParserError", this.liburl("exceptions-and-error-handling"), Builtins.this.newException("ParserError", this.table));
        }
    }

    class OperatorModule
    extends NativeModule {
        public OperatorModule() {
            super("operator");
        }

        public void initBindings() {
            this.addNumFuncs("__abs__", "__add__", "__and__", "__concat__", "__contains__", "__div__", "__doc__", "__eq__", "__floordiv__", "__ge__", "__getitem__", "__getslice__", "__gt__", "__iadd__", "__iand__", "__iconcat__", "__idiv__", "__ifloordiv__", "__ilshift__", "__imod__", "__imul__", "__index__", "__inv__", "__invert__", "__ior__", "__ipow__", "__irepeat__", "__irshift__", "__isub__", "__itruediv__", "__ixor__", "__le__", "__lshift__", "__lt__", "__mod__", "__mul__", "__name__", "__ne__", "__neg__", "__not__", "__or__", "__package__", "__pos__", "__pow__", "__repeat__", "__rshift__", "__setitem__", "__setslice__", "__sub__", "__truediv__", "__xor__", "abs", "add", "and_", "concat", "contains", "countOf", "div", "eq", "floordiv", "ge", "getitem", "getslice", "gt", "iadd", "iand", "iconcat", "idiv", "ifloordiv", "ilshift", "imod", "imul", "index", "indexOf", "inv", "invert", "ior", "ipow", "irepeat", "irshift", "isCallable", "isMappingType", "isNumberType", "isSequenceType", "is_", "is_not", "isub", "itruediv", "ixor", "le", "lshift", "lt", "mod", "mul", "ne", "neg", "not_", "or_", "pos", "pow", "repeat", "rshift", "sequenceIncludes", "setitem", "setslice", "sub", "truediv", "truth", "xor");
            this.addUnknownFuncs("attrgetter", "itemgetter", "methodcaller");
            this.addNoneFuncs("__delitem__", "__delslice__", "delitem", "delclice");
        }
    }

    class OsModule
    extends NativeModule {
        public OsModule() {
            super("os");
        }

        public void initBindings() {
            this.addAttr("name", this.liburl(), Builtins.this.BaseStr);
            this.addClass("error", this.liburl(), Builtins.this.newException("error", this.table));
            this.initProcBindings();
            this.initProcMgmtBindings();
            this.initFileBindings();
            this.initFileAndDirBindings();
            this.initMiscSystemInfo();
            this.initOsPathModule();
            this.addAttr("errno", this.liburl(), Builtins.this.newModule("errno"));
            this.addFunction("urandom", this.liburl("miscellaneous-functions"), Builtins.this.BaseStr);
            this.addAttr("NGROUPS_MAX", this.liburl(), Builtins.this.BaseNum);
            for (String s : Builtins.this.list("_Environ", "_copy_reg", "_execvpe", "_exists", "_get_exports_list", "_make_stat_result", "_make_statvfs_result", "_pickle_stat_result", "_pickle_statvfs_result", "_spawnvef")) {
                this.addFunction(s, this.liburl(), Builtins.this.unknown());
            }
        }

        private void initProcBindings() {
            String a = "process-parameters";
            this.addAttr("environ", this.liburl(a), Builtins.this.newDict(Builtins.this.BaseStr, Builtins.this.BaseStr));
            for (String s : Builtins.this.list("chdir", "fchdir", "putenv", "setegid", "seteuid", "setgid", "setgroups", "setpgrp", "setpgid", "setreuid", "setregid", "setuid", "unsetenv")) {
                this.addFunction(s, this.liburl(a), Builtins.this.None);
            }
            for (String s : Builtins.this.list("getegid", "getgid", "getpgid", "getpgrp", "getppid", "getuid", "getsid", "umask")) {
                this.addFunction(s, this.liburl(a), Builtins.this.BaseNum);
            }
            for (String s : Builtins.this.list("getcwd", "ctermid", "getlogin", "getenv", "strerror")) {
                this.addFunction(s, this.liburl(a), Builtins.this.BaseStr);
            }
            this.addFunction("getgroups", this.liburl(a), Builtins.this.newList(Builtins.this.BaseStr));
            this.addFunction("uname", this.liburl(a), Builtins.this.newTuple(Builtins.this.BaseStr, Builtins.this.BaseStr, Builtins.this.BaseStr, Builtins.this.BaseStr, Builtins.this.BaseStr));
        }

        private void initProcMgmtBindings() {
            String a = "process-management";
            for (String s : Builtins.this.list("EX_CANTCREAT", "EX_CONFIG", "EX_DATAERR", "EX_IOERR", "EX_NOHOST", "EX_NOINPUT", "EX_NOPERM", "EX_NOUSER", "EX_OK", "EX_OSERR", "EX_OSFILE", "EX_PROTOCOL", "EX_SOFTWARE", "EX_TEMPFAIL", "EX_UNAVAILABLE", "EX_USAGE", "P_NOWAIT", "P_NOWAITO", "P_WAIT", "P_DETACH", "P_OVERLAY", "WCONTINUED", "WCOREDUMP", "WEXITSTATUS", "WIFCONTINUED", "WIFEXITED", "WIFSIGNALED", "WIFSTOPPED", "WNOHANG", "WSTOPSIG", "WTERMSIG", "WUNTRACED")) {
                this.addAttr(s, this.liburl(a), Builtins.this.BaseNum);
            }
            for (String s : Builtins.this.list("abort", "execl", "execle", "execlp", "execlpe", "execv", "execve", "execvp", "execvpe", "_exit", "kill", "killpg", "plock", "startfile")) {
                this.addFunction(s, this.liburl(a), Builtins.this.None);
            }
            for (String s : Builtins.this.list("nice", "spawnl", "spawnle", "spawnlp", "spawnlpe", "spawnv", "spawnve", "spawnvp", "spawnvpe", "system")) {
                this.addFunction(s, this.liburl(a), Builtins.this.BaseNum);
            }
            this.addFunction("fork", this.liburl(a), Builtins.this.newUnion(Builtins.this.BaseFile, Builtins.this.BaseNum));
            this.addFunction("times", this.liburl(a), Builtins.this.newTuple(Builtins.this.BaseNum, Builtins.this.BaseNum, Builtins.this.BaseNum, Builtins.this.BaseNum, Builtins.this.BaseNum));
            for (String s : Builtins.this.list("forkpty", "wait", "waitpid")) {
                this.addFunction(s, this.liburl(a), Builtins.this.newTuple(Builtins.this.BaseNum, Builtins.this.BaseNum));
            }
            for (String s : Builtins.this.list("wait3", "wait4")) {
                this.addFunction(s, this.liburl(a), Builtins.this.newTuple(Builtins.this.BaseNum, Builtins.this.BaseNum, Builtins.this.BaseNum));
            }
        }

        private void initFileBindings() {
            String a = "file-object-creation";
            for (String s : Builtins.this.list("fdopen", "popen", "tmpfile")) {
                this.addFunction(s, this.liburl(a), Builtins.this.BaseFile);
            }
            this.addFunction("popen2", this.liburl(a), Builtins.this.newTuple(Builtins.this.BaseFile, Builtins.this.BaseFile));
            this.addFunction("popen3", this.liburl(a), Builtins.this.newTuple(Builtins.this.BaseFile, Builtins.this.BaseFile, Builtins.this.BaseFile));
            this.addFunction("popen4", this.liburl(a), Builtins.this.newTuple(Builtins.this.BaseFile, Builtins.this.BaseFile));
            a = "file-descriptor-operations";
            this.addFunction("open", this.liburl(a), Builtins.this.BaseFile);
            for (String s : Builtins.this.list("close", "closerange", "dup2", "fchmod", "fchown", "fdatasync", "fsync", "ftruncate", "lseek", "tcsetpgrp", "write")) {
                this.addFunction(s, this.liburl(a), Builtins.this.None);
            }
            for (String s : Builtins.this.list("dup2", "fpathconf", "fstat", "fstatvfs", "isatty", "tcgetpgrp")) {
                this.addFunction(s, this.liburl(a), Builtins.this.BaseNum);
            }
            for (String s : Builtins.this.list("read", "ttyname")) {
                this.addFunction(s, this.liburl(a), Builtins.this.BaseStr);
            }
            for (String s : Builtins.this.list("openpty", "pipe", "fstat", "fstatvfs", "isatty")) {
                this.addFunction(s, this.liburl(a), Builtins.this.newTuple(Builtins.this.BaseNum, Builtins.this.BaseNum));
            }
            for (String s : Builtins.this.list("O_APPEND", "O_CREAT", "O_DIRECT", "O_DIRECTORY", "O_DSYNC", "O_EXCL", "O_LARGEFILE", "O_NDELAY", "O_NOCTTY", "O_NOFOLLOW", "O_NONBLOCK", "O_RDONLY", "O_RDWR", "O_RSYNC", "O_SYNC", "O_TRUNC", "O_WRONLY", "SEEK_CUR", "SEEK_END", "SEEK_SET")) {
                this.addAttr(s, this.liburl(a), Builtins.this.BaseNum);
            }
        }

        private void initFileAndDirBindings() {
            String a = "files-and-directories";
            for (String s : Builtins.this.list("F_OK", "R_OK", "W_OK", "X_OK")) {
                this.addAttr(s, this.liburl(a), Builtins.this.BaseNum);
            }
            for (String s : Builtins.this.list("chflags", "chroot", "chmod", "chown", "lchflags", "lchmod", "lchown", "link", "mknod", "mkdir", "mkdirs", "remove", "removedirs", "rename", "renames", "rmdir", "symlink", "unlink", "utime")) {
                this.addAttr(s, this.liburl(a), Builtins.this.None);
            }
            for (String s : Builtins.this.list("access", "lstat", "major", "minor", "makedev", "pathconf", "stat_float_times")) {
                this.addFunction(s, this.liburl(a), Builtins.this.BaseNum);
            }
            for (String s : Builtins.this.list("getcwdu", "readlink", "tempnam", "tmpnam")) {
                this.addFunction(s, this.liburl(a), Builtins.this.BaseStr);
            }
            for (String s : Builtins.this.list("listdir")) {
                this.addFunction(s, this.liburl(a), Builtins.this.newList(Builtins.this.BaseStr));
            }
            this.addFunction("mkfifo", this.liburl(a), Builtins.this.BaseFile);
            this.addFunction("stat", this.liburl(a), Builtins.this.newList(Builtins.this.BaseNum));
            this.addFunction("statvfs", this.liburl(a), Builtins.this.newList(Builtins.this.BaseNum));
            this.addAttr("pathconf_names", this.liburl(a), Builtins.this.newDict(Builtins.this.BaseStr, Builtins.this.BaseNum));
            this.addAttr("TMP_MAX", this.liburl(a), Builtins.this.BaseNum);
            this.addFunction("walk", this.liburl(a), Builtins.this.newList(Builtins.this.newTuple(Builtins.this.BaseStr, Builtins.this.BaseStr, Builtins.this.BaseStr)));
        }

        private void initMiscSystemInfo() {
            String a = "miscellaneous-system-information";
            this.addAttr("confstr_names", this.liburl(a), Builtins.this.newDict(Builtins.this.BaseStr, Builtins.this.BaseNum));
            this.addAttr("sysconf_names", this.liburl(a), Builtins.this.newDict(Builtins.this.BaseStr, Builtins.this.BaseNum));
            for (String s : Builtins.this.list("curdir", "pardir", "sep", "altsep", "extsep", "pathsep", "defpath", "linesep", "devnull")) {
                this.addAttr(s, this.liburl(a), Builtins.this.BaseStr);
            }
            for (String s : Builtins.this.list("getloadavg", "sysconf")) {
                this.addFunction(s, this.liburl(a), Builtins.this.BaseNum);
            }
            this.addFunction("confstr", this.liburl(a), Builtins.this.BaseStr);
        }

        private void initOsPathModule() {
            String[] str_attrs;
            String[] num_funcs;
            String[] str_funcs;
            NModuleType m = Builtins.this.newModule("path");
            Scope ospath = m.getTable();
            ospath.setPath("os.path");
            this.update("path", Builtins.newLibUrl("os.path.html#module-os.path"), m, NBinding.Kind.MODULE);
            for (String s : str_funcs = new String[]{"_resolve_link", "abspath", "basename", "commonprefix", "dirname", "expanduser", "expandvars", "join", "normcase", "normpath", "realpath", "relpath"}) {
                ospath.update(s, Builtins.newLibUrl("os.path", s), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.FUNCTION);
            }
            for (String s : num_funcs = new String[]{"exists", "lexists", "getatime", "getctime", "getmtime", "getsize", "isabs", "isdir", "isfile", "islink", "ismount", "samefile", "sameopenfile", "samestat", "supports_unicode_filenames"}) {
                ospath.update(s, Builtins.newLibUrl("os.path", s), (NType)Builtins.this.newFunc(Builtins.this.BaseNum), NBinding.Kind.FUNCTION);
            }
            for (String s : Builtins.this.list("split", "splitdrive", "splitext", "splitunc")) {
                ospath.update(s, Builtins.newLibUrl("os.path", s), (NType)Builtins.this.newFunc(Builtins.this.newTuple(Builtins.this.BaseStr, Builtins.this.BaseStr)), NBinding.Kind.FUNCTION);
            }
            NBinding b = ospath.update("walk", Builtins.newLibUrl("os.path"), (NType)Builtins.this.newFunc(Builtins.this.None), NBinding.Kind.FUNCTION);
            b.markDeprecated();
            for (String s : str_attrs = new String[]{"altsep", "curdir", "devnull", "defpath", "pardir", "pathsep", "sep"}) {
                ospath.update(s, Builtins.newLibUrl("os.path", s), (NType)Builtins.this.BaseStr, NBinding.Kind.ATTRIBUTE);
            }
            ospath.update("os", this.liburl(), (NType)this.module, NBinding.Kind.ATTRIBUTE);
            ospath.update("stat", Builtins.newLibUrl("stat"), (NType)Builtins.this.newModule("<stat-fixme>"), NBinding.Kind.ATTRIBUTE);
            ospath.update("_varprog", Builtins.newLibUrl("os.path"), (NType)Builtins.this.unknown(), NBinding.Kind.ATTRIBUTE);
        }
    }

    class NisModule
    extends NativeModule {
        public NisModule() {
            super("nis");
        }

        public void initBindings() {
            this.addStrFuncs("match", "cat", "get_default_domain");
            this.addFunction("maps", this.liburl(), Builtins.this.newList(Builtins.this.BaseStr));
            this.addClass("error", this.liburl(), Builtins.this.newException("error", this.table));
        }
    }

    class MmapModule
    extends NativeModule {
        public MmapModule() {
            super("mmap");
        }

        public void initBindings() {
            NClassType mmap = Builtins.this.newClass("mmap", this.table, Builtins.this.Object, new NClassType[0]);
            for (String s : Builtins.this.list("ACCESS_COPY", "ACCESS_READ", "ACCESS_WRITE", "ALLOCATIONGRANULARITY", "MAP_ANON", "MAP_ANONYMOUS", "MAP_DENYWRITE", "MAP_EXECUTABLE", "MAP_PRIVATE", "MAP_SHARED", "PAGESIZE", "PROT_EXEC", "PROT_READ", "PROT_WRITE")) {
                mmap.getTable().update(s, this.liburl(), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            }
            for (String fstr : Builtins.this.list("read", "read_byte", "readline")) {
                mmap.getTable().update(fstr, this.liburl(), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.METHOD);
            }
            for (String fnum : Builtins.this.list("find", "rfind", "tell")) {
                mmap.getTable().update(fnum, this.liburl(), (NType)Builtins.this.newFunc(Builtins.this.BaseNum), NBinding.Kind.METHOD);
            }
            for (String fnone : Builtins.this.list("close", "flush", "move", "resize", "seek", "write", "write_byte")) {
                mmap.getTable().update(fnone, this.liburl(), (NType)Builtins.this.newFunc(Builtins.this.None), NBinding.Kind.METHOD);
            }
            this.addClass("mmap", this.liburl(), mmap);
        }
    }

    class Md5Module
    extends NativeModule {
        public Md5Module() {
            super("md5");
        }

        public void initBindings() {
            this.addNumAttrs("blocksize", "digest_size");
            NClassType md5 = Builtins.this.newClass("md5", this.table, Builtins.this.Object, new NClassType[0]);
            md5.getTable().update("update", this.liburl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            md5.getTable().update("digest", this.liburl(), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.METHOD);
            md5.getTable().update("hexdigest", this.liburl(), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.METHOD);
            md5.getTable().update("copy", this.liburl(), (NType)Builtins.this.newFunc(md5), NBinding.Kind.METHOD);
            this.update("new", this.liburl(), Builtins.this.newFunc(md5), NBinding.Kind.CONSTRUCTOR);
            this.update("md5", this.liburl(), Builtins.this.newFunc(md5), NBinding.Kind.CONSTRUCTOR);
        }
    }

    class MathModule
    extends NativeModule {
        public MathModule() {
            super("math");
        }

        public void initBindings() {
            this.addNumFuncs("acos", "acosh", "asin", "asinh", "atan", "atan2", "atanh", "ceil", "copysign", "cos", "cosh", "degrees", "exp", "fabs", "factorial", "floor", "fmod", "frexp", "fsum", "hypot", "isinf", "isnan", "ldexp", "log", "log10", "log1p", "modf", "pow", "radians", "sin", "sinh", "sqrt", "tan", "tanh", "trunc");
            this.addNumAttrs("pi", "e");
        }
    }

    class MarshalModule
    extends NativeModule {
        public MarshalModule() {
            super("marshal");
        }

        public void initBindings() {
            this.addNumAttrs("version");
            this.addStrFuncs("dumps");
            this.addUnknownFuncs("dump", "load", "loads");
        }
    }

    class ItertoolsModule
    extends NativeModule {
        public ItertoolsModule() {
            super("itertools");
        }

        public void initBindings() {
            NClassType iterator = Builtins.this.newClass("iterator", this.table, Builtins.this.Object, new NClassType[0]);
            iterator.getTable().update("from_iterable", this.liburl("itertool-functions"), (NType)Builtins.this.newFunc(iterator), NBinding.Kind.METHOD);
            iterator.getTable().update("next", this.liburl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            for (String s : Builtins.this.list("chain", "combinations", "count", "cycle", "dropwhile", "groupby", "ifilter", "ifilterfalse", "imap", "islice", "izip", "izip_longest", "permutations", "product", "repeat", "starmap", "takewhile", "tee")) {
                this.addClass(s, this.liburl("itertool-functions"), iterator);
            }
        }
    }

    class ImpModule
    extends NativeModule {
        public ImpModule() {
            super("imp");
        }

        public void initBindings() {
            String[] module_methods;
            this.addStrFuncs("get_magic");
            this.addFunction("get_suffixes", this.liburl(), Builtins.this.newList(Builtins.this.newTuple(Builtins.this.BaseStr, Builtins.this.BaseStr, Builtins.this.BaseNum)));
            this.addFunction("find_module", this.liburl(), Builtins.this.newTuple(Builtins.this.BaseStr, Builtins.this.BaseStr, Builtins.this.BaseNum));
            for (String mm : module_methods = new String[]{"load_module", "new_module", "init_builtin", "init_frozen", "load_compiled", "load_dynamic", "load_source"}) {
                this.addFunction(mm, this.liburl(), Builtins.this.newModule("<?>"));
            }
            this.addUnknownFuncs("acquire_lock", "release_lock");
            this.addNumAttrs("PY_SOURCE", "PY_COMPILED", "C_EXTENSION", "PKG_DIRECTORY", "C_BUILTIN", "PY_FROZEN", "SEARCH_ERROR");
            this.addNumFuncs("lock_held", "is_builtin", "is_frozen");
            NClassType impNullImporter = Builtins.this.newClass("NullImporter", this.table, Builtins.this.Object, new NClassType[0]);
            impNullImporter.getTable().update("find_module", this.liburl(), (NType)Builtins.this.newFunc(Builtins.this.None), NBinding.Kind.FUNCTION);
            this.addClass("NullImporter", this.liburl(), impNullImporter);
        }
    }

    class GrpModule
    extends NativeModule {
        public GrpModule() {
            super("grp");
        }

        public void initBindings() {
            Builtins.this.get("struct");
            NClassType struct_group = Builtins.this.newClass("struct_group", this.table, Builtins.this.BaseStruct, new NClassType[0]);
            struct_group.getTable().update("gr_name", this.liburl(), (NType)Builtins.this.BaseStr, NBinding.Kind.ATTRIBUTE);
            struct_group.getTable().update("gr_passwd", this.liburl(), (NType)Builtins.this.BaseStr, NBinding.Kind.ATTRIBUTE);
            struct_group.getTable().update("gr_gid", this.liburl(), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            struct_group.getTable().update("gr_mem", this.liburl(), (NType)Builtins.this.newList(Builtins.this.BaseStr), NBinding.Kind.ATTRIBUTE);
            this.addClass("struct_group", this.liburl(), struct_group);
            for (String s : Builtins.this.list("getgrgid", "getgrnam")) {
                this.addFunction(s, this.liburl(), struct_group);
            }
            this.addFunction("getgrall", this.liburl(), new NListType(struct_group));
        }
    }

    class GdbmModule
    extends NativeModule {
        public GdbmModule() {
            super("gdbm");
        }

        public void initBindings() {
            this.addClass("error", this.liburl(), Builtins.this.newException("error", this.table));
            NClassType gdbm = new NClassType("gdbm", this.table, Builtins.this.BaseDict);
            gdbm.getTable().update("firstkey", this.liburl(), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.METHOD);
            gdbm.getTable().update("nextkey", this.liburl(), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.METHOD);
            gdbm.getTable().update("reorganize", this.liburl(), (NType)Builtins.this.newFunc(Builtins.this.None), NBinding.Kind.METHOD);
            gdbm.getTable().update("sync", this.liburl(), (NType)Builtins.this.newFunc(Builtins.this.None), NBinding.Kind.METHOD);
            this.addFunction("open", this.liburl(), gdbm);
        }
    }

    class GcModule
    extends NativeModule {
        public GcModule() {
            super("gc");
        }

        public void initBindings() {
            this.addNoneFuncs("enable", "disable", "set_debug", "set_threshold");
            this.addNumFuncs("isenabled", "collect", "get_debug", "get_count", "get_threshold");
            for (String s : Builtins.this.list("get_objects", "get_referrers", "get_referents")) {
                this.addFunction(s, this.liburl(), Builtins.this.newList());
            }
            this.addAttr("garbage", this.liburl(), Builtins.this.newList());
            this.addNumAttrs("DEBUG_STATS", "DEBUG_COLLECTABLE", "DEBUG_UNCOLLECTABLE", "DEBUG_INSTANCES", "DEBUG_OBJECTS", "DEBUG_SAVEALL", "DEBUG_LEAK");
        }
    }

    class FpectlModule
    extends NativeModule {
        public FpectlModule() {
            super("fpectl");
        }

        public void initBindings() {
            this.addNoneFuncs("turnon_sigfpe", "turnoff_sigfpe");
            this.addClass("FloatingPointError", this.liburl(), Builtins.this.newException("FloatingPointError", this.table));
        }
    }

    class FcntlModule
    extends NativeModule {
        public FcntlModule() {
            super("fcntl");
        }

        public void initBindings() {
            for (String s : Builtins.this.list("fcntl", "ioctl")) {
                this.addFunction(s, this.liburl(), Builtins.this.newUnion(Builtins.this.BaseNum, Builtins.this.BaseStr));
            }
            this.addNumFuncs("flock");
            this.addUnknownFuncs("lockf");
            this.addNumAttrs("DN_ACCESS", "DN_ATTRIB", "DN_CREATE", "DN_DELETE", "DN_MODIFY", "DN_MULTISHOT", "DN_RENAME", "FASYNC", "FD_CLOEXEC", "F_DUPFD", "F_EXLCK", "F_GETFD", "F_GETFL", "F_GETLEASE", "F_GETLK", "F_GETLK64", "F_GETOWN", "F_GETSIG", "F_NOTIFY", "F_RDLCK", "F_SETFD", "F_SETFL", "F_SETLEASE", "F_SETLK", "F_SETLK64", "F_SETLKW", "F_SETLKW64", "F_SETOWN", "F_SETSIG", "F_SHLCK", "F_UNLCK", "F_WRLCK", "I_ATMARK", "I_CANPUT", "I_CKBAND", "I_FDINSERT", "I_FIND", "I_FLUSH", "I_FLUSHBAND", "I_GETBAND", "I_GETCLTIME", "I_GETSIG", "I_GRDOPT", "I_GWROPT", "I_LINK", "I_LIST", "I_LOOK", "I_NREAD", "I_PEEK", "I_PLINK", "I_POP", "I_PUNLINK", "I_PUSH", "I_RECVFD", "I_SENDFD", "I_SETCLTIME", "I_SETSIG", "I_SRDOPT", "I_STR", "I_SWROPT", "I_UNLINK", "LOCK_EX", "LOCK_MAND", "LOCK_NB", "LOCK_READ", "LOCK_RW", "LOCK_SH", "LOCK_UN", "LOCK_WRITE");
        }
    }

    class ExceptionsModule
    extends NativeModule {
        public ExceptionsModule() {
            super("exceptions");
        }

        public void initBindings() {
            NModuleType builtins = Builtins.this.get("__builtin__");
            for (String s : Builtins.this.builtin_exception_types) {
                NBinding b = builtins.getTable().lookup(s);
                this.table.update(b.getName(), b.getSignatureNode(), b.getType(), b.getKind());
            }
        }
    }

    class ErrnoModule
    extends NativeModule {
        public ErrnoModule() {
            super("errno");
        }

        public void initBindings() {
            this.addNumAttrs("E2BIG", "EACCES", "EADDRINUSE", "EADDRNOTAVAIL", "EAFNOSUPPORT", "EAGAIN", "EALREADY", "EBADF", "EBUSY", "ECHILD", "ECONNABORTED", "ECONNREFUSED", "ECONNRESET", "EDEADLK", "EDEADLOCK", "EDESTADDRREQ", "EDOM", "EDQUOT", "EEXIST", "EFAULT", "EFBIG", "EHOSTDOWN", "EHOSTUNREACH", "EILSEQ", "EINPROGRESS", "EINTR", "EINVAL", "EIO", "EISCONN", "EISDIR", "ELOOP", "EMFILE", "EMLINK", "EMSGSIZE", "ENAMETOOLONG", "ENETDOWN", "ENETRESET", "ENETUNREACH", "ENFILE", "ENOBUFS", "ENODEV", "ENOENT", "ENOEXEC", "ENOLCK", "ENOMEM", "ENOPROTOOPT", "ENOSPC", "ENOSYS", "ENOTCONN", "ENOTDIR", "ENOTEMPTY", "ENOTSOCK", "ENOTTY", "ENXIO", "EOPNOTSUPP", "EPERM", "EPFNOSUPPORT", "EPIPE", "EPROTONOSUPPORT", "EPROTOTYPE", "ERANGE", "EREMOTE", "EROFS", "ESHUTDOWN", "ESOCKTNOSUPPORT", "ESPIPE", "ESRCH", "ESTALE", "ETIMEDOUT", "ETOOMANYREFS", "EUSERS", "EWOULDBLOCK", "EXDEV", "WSABASEERR", "WSAEACCES", "WSAEADDRINUSE", "WSAEADDRNOTAVAIL", "WSAEAFNOSUPPORT", "WSAEALREADY", "WSAEBADF", "WSAECONNABORTED", "WSAECONNREFUSED", "WSAECONNRESET", "WSAEDESTADDRREQ", "WSAEDISCON", "WSAEDQUOT", "WSAEFAULT", "WSAEHOSTDOWN", "WSAEHOSTUNREACH", "WSAEINPROGRESS", "WSAEINTR", "WSAEINVAL", "WSAEISCONN", "WSAELOOP", "WSAEMFILE", "WSAEMSGSIZE", "WSAENAMETOOLONG", "WSAENETDOWN", "WSAENETRESET", "WSAENETUNREACH", "WSAENOBUFS", "WSAENOPROTOOPT", "WSAENOTCONN", "WSAENOTEMPTY", "WSAENOTSOCK", "WSAEOPNOTSUPP", "WSAEPFNOSUPPORT", "WSAEPROCLIM", "WSAEPROTONOSUPPORT", "WSAEPROTOTYPE", "WSAEREMOTE", "WSAESHUTDOWN", "WSAESOCKTNOSUPPORT", "WSAESTALE", "WSAETIMEDOUT", "WSAETOOMANYREFS", "WSAEUSERS", "WSAEWOULDBLOCK", "WSANOTINITIALISED", "WSASYSNOTREADY", "WSAVERNOTSUPPORTED");
            this.addAttr("errorcode", this.liburl("errorcode"), Builtins.this.newDict(Builtins.this.BaseNum, Builtins.this.BaseStr));
        }
    }

    class DbmModule
    extends NativeModule {
        public DbmModule() {
            super("dbm");
        }

        public void initBindings() {
            NClassType dbm = new NClassType("dbm", this.table, Builtins.this.BaseDict);
            this.addClass("dbm", this.liburl(), dbm);
            this.addClass("error", this.liburl(), Builtins.this.newException("error", this.table));
            this.addStrAttrs("library");
            this.addFunction("open", this.liburl(), dbm);
        }
    }

    class DatetimeModule
    extends NativeModule {
        public DatetimeModule() {
            super("datetime");
        }

        private NUrl dtUrl(String anchor) {
            return this.liburl("datetime." + anchor);
        }

        public void initBindings() {
            this.addNumAttrs("MINYEAR", "MAXYEAR");
            NClassType timedelta = Builtins.this.Datetime_timedelta = Builtins.this.newClass("timedelta", this.table, Builtins.this.Object, new NClassType[0]);
            this.addClass("timedelta", this.dtUrl("timedelta"), timedelta);
            Scope tdtable = Builtins.this.Datetime_timedelta.getTable();
            tdtable.update("min", this.dtUrl("timedelta"), (NType)timedelta, NBinding.Kind.ATTRIBUTE);
            tdtable.update("max", this.dtUrl("timedelta"), (NType)timedelta, NBinding.Kind.ATTRIBUTE);
            tdtable.update("resolution", this.dtUrl("timedelta"), (NType)timedelta, NBinding.Kind.ATTRIBUTE);
            tdtable.update("days", this.dtUrl("timedelta"), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            tdtable.update("seconds", this.dtUrl("timedelta"), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            tdtable.update("microseconds", this.dtUrl("timedelta"), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            NClassType tzinfo = Builtins.this.Datetime_tzinfo = Builtins.this.newClass("tzinfo", this.table, Builtins.this.Object, new NClassType[0]);
            this.addClass("tzinfo", this.dtUrl("tzinfo"), tzinfo);
            Scope tztable = Builtins.this.Datetime_tzinfo.getTable();
            tztable.update("utcoffset", this.dtUrl("tzinfo"), (NType)Builtins.this.newFunc(timedelta), NBinding.Kind.METHOD);
            tztable.update("dst", this.dtUrl("tzinfo"), (NType)Builtins.this.newFunc(timedelta), NBinding.Kind.METHOD);
            tztable.update("tzname", this.dtUrl("tzinfo"), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.METHOD);
            tztable.update("fromutc", this.dtUrl("tzinfo"), (NType)Builtins.this.newFunc(tzinfo), NBinding.Kind.METHOD);
            NClassType date = Builtins.this.Datetime_date = Builtins.this.newClass("date", this.table, Builtins.this.Object, new NClassType[0]);
            this.addClass("date", this.dtUrl("date"), date);
            Scope dtable = Builtins.this.Datetime_date.getTable();
            dtable.update("min", this.dtUrl("date"), (NType)date, NBinding.Kind.ATTRIBUTE);
            dtable.update("max", this.dtUrl("date"), (NType)date, NBinding.Kind.ATTRIBUTE);
            dtable.update("resolution", this.dtUrl("date"), (NType)timedelta, NBinding.Kind.ATTRIBUTE);
            dtable.update("today", this.dtUrl("date"), (NType)Builtins.this.newFunc(date), NBinding.Kind.METHOD);
            dtable.update("fromtimestamp", this.dtUrl("date"), (NType)Builtins.this.newFunc(date), NBinding.Kind.METHOD);
            dtable.update("fromordinal", this.dtUrl("date"), (NType)Builtins.this.newFunc(date), NBinding.Kind.METHOD);
            dtable.update("year", this.dtUrl("date"), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            dtable.update("month", this.dtUrl("date"), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            dtable.update("day", this.dtUrl("date"), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            dtable.update("replace", this.dtUrl("date"), (NType)Builtins.this.newFunc(date), NBinding.Kind.METHOD);
            dtable.update("timetuple", this.dtUrl("date"), (NType)Builtins.this.newFunc(Builtins.this.Time_struct_time), NBinding.Kind.METHOD);
            for (String n : Builtins.this.list("toordinal", "weekday", "isoweekday")) {
                dtable.update(n, this.dtUrl("date"), (NType)Builtins.this.newFunc(Builtins.this.BaseNum), NBinding.Kind.METHOD);
            }
            for (String r : Builtins.this.list("ctime", "strftime", "isoformat")) {
                dtable.update(r, this.dtUrl("date"), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.METHOD);
            }
            dtable.update("isocalendar", this.dtUrl("date"), (NType)Builtins.this.newFunc(Builtins.this.newTuple(Builtins.this.BaseNum, Builtins.this.BaseNum, Builtins.this.BaseNum)), NBinding.Kind.METHOD);
            NClassType time = Builtins.this.Datetime_time = Builtins.this.newClass("time", this.table, Builtins.this.Object, new NClassType[0]);
            this.addClass("time", this.dtUrl("time"), date);
            Scope ttable = Builtins.this.Datetime_time.getTable();
            ttable.update("min", this.dtUrl("time"), (NType)time, NBinding.Kind.ATTRIBUTE);
            ttable.update("max", this.dtUrl("time"), (NType)time, NBinding.Kind.ATTRIBUTE);
            ttable.update("resolution", this.dtUrl("time"), (NType)timedelta, NBinding.Kind.ATTRIBUTE);
            ttable.update("hour", this.dtUrl("time"), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            ttable.update("minute", this.dtUrl("time"), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            ttable.update("second", this.dtUrl("time"), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            ttable.update("microsecond", this.dtUrl("time"), (NType)Builtins.this.BaseNum, NBinding.Kind.ATTRIBUTE);
            ttable.update("tzinfo", this.dtUrl("time"), (NType)tzinfo, NBinding.Kind.ATTRIBUTE);
            ttable.update("replace", this.dtUrl("time"), (NType)Builtins.this.newFunc(time), NBinding.Kind.METHOD);
            for (String l : Builtins.this.list("isoformat", "strftime", "tzname")) {
                ttable.update(l, this.dtUrl("time"), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.METHOD);
            }
            for (String f : Builtins.this.list("utcoffset", "dst")) {
                ttable.update(f, this.dtUrl("time"), (NType)Builtins.this.newFunc(timedelta), NBinding.Kind.METHOD);
            }
            NClassType datetime = Builtins.this.Datetime_datetime = Builtins.this.newClass("datetime", this.table, date, time);
            this.addClass("datetime", this.dtUrl("datetime"), datetime);
            Scope dttable = Builtins.this.Datetime_datetime.getTable();
            for (String c : Builtins.this.list("combine", "fromordinal", "fromtimestamp", "now", "strptime", "today", "utcfromtimestamp", "utcnow")) {
                dttable.update(c, this.dtUrl("datetime"), (NType)Builtins.this.newFunc(datetime), NBinding.Kind.METHOD);
            }
            dttable.update("min", this.dtUrl("datetime"), (NType)datetime, NBinding.Kind.ATTRIBUTE);
            dttable.update("max", this.dtUrl("datetime"), (NType)datetime, NBinding.Kind.ATTRIBUTE);
            dttable.update("resolution", this.dtUrl("datetime"), (NType)timedelta, NBinding.Kind.ATTRIBUTE);
            dttable.update("date", this.dtUrl("datetime"), (NType)Builtins.this.newFunc(date), NBinding.Kind.METHOD);
            for (String x : Builtins.this.list("time", "timetz")) {
                dttable.update(x, this.dtUrl("datetime"), (NType)Builtins.this.newFunc(time), NBinding.Kind.METHOD);
            }
            for (String y : Builtins.this.list("replace", "astimezone")) {
                dttable.update(y, this.dtUrl("datetime"), (NType)Builtins.this.newFunc(datetime), NBinding.Kind.METHOD);
            }
            dttable.update("utctimetuple", this.dtUrl("datetime"), (NType)Builtins.this.newFunc(Builtins.this.Time_struct_time), NBinding.Kind.METHOD);
        }
    }

    class CryptModule
    extends NativeModule {
        public CryptModule() {
            super("crypt");
        }

        public void initBindings() {
            this.addStrFuncs("crypt");
        }
    }

    class CTypesModule
    extends NativeModule {
        public CTypesModule() {
            super("ctypes");
        }

        public void initBindings() {
            String[] ctypes_attrs;
            for (String attr : ctypes_attrs = new String[]{"ARRAY", "ArgumentError", "Array", "BigEndianStructure", "CDLL", "CFUNCTYPE", "DEFAULT_MODE", "DllCanUnloadNow", "DllGetClassObject", "FormatError", "GetLastError", "HRESULT", "LibraryLoader", "LittleEndianStructure", "OleDLL", "POINTER", "PYFUNCTYPE", "PyDLL", "RTLD_GLOBAL", "RTLD_LOCAL", "SetPointerType", "Structure", "Union", "WINFUNCTYPE", "WinDLL", "WinError", "_CFuncPtr", "_FUNCFLAG_CDECL", "_FUNCFLAG_PYTHONAPI", "_FUNCFLAG_STDCALL", "_FUNCFLAG_USE_ERRNO", "_FUNCFLAG_USE_LASTERROR", "_Pointer", "_SimpleCData", "_c_functype_cache", "_calcsize", "_cast", "_cast_addr", "_check_HRESULT", "_check_size", "_ctypes_version", "_dlopen", "_endian", "_memmove_addr", "_memset_addr", "_os", "_pointer_type_cache", "_string_at", "_string_at_addr", "_sys", "_win_functype_cache", "_wstring_at", "_wstring_at_addr", "addressof", "alignment", "byref", "c_bool", "c_buffer", "c_byte", "c_char", "c_char_p", "c_double", "c_float", "c_int", "c_int16", "c_int32", "c_int64", "c_int8", "c_long", "c_longdouble", "c_longlong", "c_short", "c_size_t", "c_ubyte", "c_uint", "c_uint16", "c_uint32", "c_uint64", "c_uint8", "c_ulong", "c_ulonglong", "c_ushort", "c_void_p", "c_voidp", "c_wchar", "c_wchar_p", "cast", "cdll", "create_string_buffer", "create_unicode_buffer", "get_errno", "get_last_error", "memmove", "memset", "oledll", "pointer", "py_object", "pydll", "pythonapi", "resize", "set_conversion_mode", "set_errno", "set_last_error", "sizeof", "string_at", "windll", "wstring_at"}) {
                this.addAttr(attr, this.liburl(attr), Builtins.this.unknown());
            }
        }
    }

    class CollectionsModule
    extends NativeModule {
        public CollectionsModule() {
            super("collections");
        }

        private NUrl abcUrl() {
            return this.liburl("abcs-abstract-base-classes");
        }

        private NUrl dequeUrl() {
            return this.liburl("deque-objects");
        }

        public void initBindings() {
            NClassType Callable2 = Builtins.this.newClass("Callable", this.table, Builtins.this.Object, new NClassType[0]);
            Callable2.getTable().update("__call__", this.abcUrl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            this.addClass("Callable", this.abcUrl(), Callable2);
            NClassType Iterable2 = Builtins.this.newClass("Iterable", this.table, Builtins.this.Object, new NClassType[0]);
            Iterable2.getTable().update("__next__", this.abcUrl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            Iterable2.getTable().update("__iter__", this.abcUrl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            this.addClass("Iterable", this.abcUrl(), Iterable2);
            NClassType Hashable = Builtins.this.newClass("Hashable", this.table, Builtins.this.Object, new NClassType[0]);
            Hashable.getTable().update("__hash__", this.abcUrl(), (NType)Builtins.this.newFunc(Builtins.this.BaseNum), NBinding.Kind.METHOD);
            this.addClass("Hashable", this.abcUrl(), Hashable);
            NClassType Sized = Builtins.this.newClass("Sized", this.table, Builtins.this.Object, new NClassType[0]);
            Sized.getTable().update("__len__", this.abcUrl(), (NType)Builtins.this.newFunc(Builtins.this.BaseNum), NBinding.Kind.METHOD);
            this.addClass("Sized", this.abcUrl(), Sized);
            NClassType Container2 = Builtins.this.newClass("Container", this.table, Builtins.this.Object, new NClassType[0]);
            Container2.getTable().update("__contains__", this.abcUrl(), (NType)Builtins.this.newFunc(Builtins.this.BaseNum), NBinding.Kind.METHOD);
            this.addClass("Container", this.abcUrl(), Container2);
            NClassType Iterator2 = Builtins.this.newClass("Iterator", this.table, Iterable2, new NClassType[0]);
            this.addClass("Iterator", this.abcUrl(), Iterator2);
            NClassType Sequence = Builtins.this.newClass("Sequence", this.table, Sized, Iterable2, Container2);
            Sequence.getTable().update("__getitem__", this.abcUrl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            Sequence.getTable().update("reversed", this.abcUrl(), (NType)Builtins.this.newFunc(Sequence), NBinding.Kind.METHOD);
            Sequence.getTable().update("index", this.abcUrl(), (NType)Builtins.this.newFunc(Builtins.this.BaseNum), NBinding.Kind.METHOD);
            Sequence.getTable().update("count", this.abcUrl(), (NType)Builtins.this.newFunc(Builtins.this.BaseNum), NBinding.Kind.METHOD);
            this.addClass("Sequence", this.abcUrl(), Sequence);
            NClassType MutableSequence = Builtins.this.newClass("MutableSequence", this.table, Sequence, new NClassType[0]);
            MutableSequence.getTable().update("__setitem__", this.abcUrl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            MutableSequence.getTable().update("__delitem__", this.abcUrl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            this.addClass("MutableSequence", this.abcUrl(), MutableSequence);
            NClassType Set2 = Builtins.this.newClass("Set", this.table, Sized, Iterable2, Container2);
            Set2.getTable().update("__getitem__", this.abcUrl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            this.addClass("Set", this.abcUrl(), Set2);
            NClassType MutableSet = Builtins.this.newClass("MutableSet", this.table, Set2, new NClassType[0]);
            MutableSet.getTable().update("add", this.abcUrl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            MutableSet.getTable().update("discard", this.abcUrl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            this.addClass("MutableSet", this.abcUrl(), MutableSet);
            NClassType Mapping = Builtins.this.newClass("Mapping", this.table, Sized, Iterable2, Container2);
            Mapping.getTable().update("__getitem__", this.abcUrl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            this.addClass("Mapping", this.abcUrl(), Mapping);
            NClassType MutableMapping = Builtins.this.newClass("MutableMapping", this.table, Mapping, new NClassType[0]);
            MutableMapping.getTable().update("__setitem__", this.abcUrl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            MutableMapping.getTable().update("__delitem__", this.abcUrl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            this.addClass("MutableMapping", this.abcUrl(), MutableMapping);
            NClassType MappingView = Builtins.this.newClass("MappingView", this.table, Sized, new NClassType[0]);
            this.addClass("MappingView", this.abcUrl(), MappingView);
            NClassType KeysView = Builtins.this.newClass("KeysView", this.table, Sized, new NClassType[0]);
            this.addClass("KeysView", this.abcUrl(), KeysView);
            NClassType ItemsView = Builtins.this.newClass("ItemsView", this.table, Sized, new NClassType[0]);
            this.addClass("ItemsView", this.abcUrl(), ItemsView);
            NClassType ValuesView2 = Builtins.this.newClass("ValuesView", this.table, Sized, new NClassType[0]);
            this.addClass("ValuesView", this.abcUrl(), ValuesView2);
            NClassType deque = Builtins.this.newClass("deque", this.table, Builtins.this.Object, new NClassType[0]);
            for (String n : Builtins.this.list("append", "appendLeft", "clear", "extend", "extendLeft", "rotate")) {
                deque.getTable().update(n, this.dequeUrl(), (NType)Builtins.this.newFunc(Builtins.this.None), NBinding.Kind.METHOD);
            }
            for (String u : Builtins.this.list("__getitem__", "__iter__", "pop", "popleft", "remove")) {
                deque.getTable().update(u, this.dequeUrl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            }
            this.addClass("deque", this.dequeUrl(), deque);
            NClassType defaultdict = Builtins.this.newClass("defaultdict", this.table, Builtins.this.Object, new NClassType[0]);
            defaultdict.getTable().update("__missing__", this.liburl("defaultdict-objects"), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            defaultdict.getTable().update("default_factory", this.liburl("defaultdict-objects"), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            this.addClass("defaultdict", this.liburl("defaultdict-objects"), defaultdict);
            String argh = "namedtuple-factory-function-for-tuples-with-named-fields";
            NClassType namedtuple = Builtins.this.newClass("(namedtuple)", this.table, Builtins.this.BaseTuple, new NClassType[0]);
            namedtuple.getTable().update("_fields", this.liburl(argh), (NType)new NListType(Builtins.this.BaseStr), NBinding.Kind.ATTRIBUTE);
            this.addFunction("namedtuple", this.liburl(argh), namedtuple);
        }
    }

    class CMathModule
    extends NativeModule {
        public CMathModule() {
            super("cmath");
        }

        public void initBindings() {
            this.addFunction("phase", this.liburl("conversions-to-and-from-polar-coordinates"), Builtins.this.BaseNum);
            this.addFunction("polar", this.liburl("conversions-to-and-from-polar-coordinates"), Builtins.this.newTuple(Builtins.this.BaseNum, Builtins.this.BaseNum));
            this.addFunction("rect", this.liburl("conversions-to-and-from-polar-coordinates"), Builtins.this.BaseComplex);
            for (String plf : Builtins.this.list("exp", "log", "log10", "sqrt")) {
                this.addFunction(plf, this.liburl("power-and-logarithmic-functions"), Builtins.this.BaseNum);
            }
            for (String tf : Builtins.this.list("acos", "asin", "atan", "cos", "sin", "tan")) {
                this.addFunction(tf, this.liburl("trigonometric-functions"), Builtins.this.BaseNum);
            }
            for (String hf : Builtins.this.list("acosh", "asinh", "atanh", "cosh", "sinh", "tanh")) {
                this.addFunction(hf, this.liburl("hyperbolic-functions"), Builtins.this.BaseComplex);
            }
            for (String cf : Builtins.this.list("isinf", "isnan")) {
                this.addFunction(cf, this.liburl("classification-functions"), Builtins.this.BaseBool);
            }
            for (String c : Builtins.this.list("pi", "e")) {
                this.addAttr(c, this.liburl("constants"), Builtins.this.BaseNum);
            }
        }
    }

    class CStringIOModule
    extends NativeModule {
        public CStringIOModule() {
            super("cStringIO");
        }

        protected NUrl liburl() {
            return Builtins.newLibUrl("stringio");
        }

        protected NUrl liburl(String anchor) {
            return Builtins.newLibUrl("stringio", anchor);
        }

        public void initBindings() {
            NClassType StringIO2 = Builtins.this.newClass("StringIO", this.table, Builtins.this.BaseFile, new NClassType[0]);
            this.addFunction("StringIO", this.liburl(), StringIO2);
            this.addAttr("InputType", this.liburl(), Builtins.this.Type);
            this.addAttr("OutputType", this.liburl(), Builtins.this.Type);
            this.addAttr("cStringIO_CAPI", this.liburl(), Builtins.this.unknown());
        }
    }

    class CPickleModule
    extends NativeModule {
        public CPickleModule() {
            super("cPickle");
        }

        protected NUrl liburl() {
            return Builtins.newLibUrl("pickle", "module-cPickle");
        }

        public void initBindings() {
            this.addUnknownFuncs("dump", "load", "dumps", "loads");
            this.addClass("PickleError", this.liburl(), Builtins.this.newException("PickleError", this.table));
            NClassType picklingError = Builtins.this.newException("PicklingError", this.table);
            this.addClass("PicklingError", this.liburl(), picklingError);
            this.update("UnpickleableError", this.liburl(), Builtins.this.newClass("UnpickleableError", this.table, picklingError, new NClassType[0]), NBinding.Kind.CLASS);
            NClassType unpicklingError = Builtins.this.newException("UnpicklingError", this.table);
            this.addClass("UnpicklingError", this.liburl(), unpicklingError);
            this.update("BadPickleGet", this.liburl(), Builtins.this.newClass("BadPickleGet", this.table, unpicklingError, new NClassType[0]), NBinding.Kind.CLASS);
            NClassType pickler = Builtins.this.newClass("Pickler", this.table, Builtins.this.Object, new NClassType[0]);
            pickler.getTable().update("dump", this.liburl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            pickler.getTable().update("clear_memo", this.liburl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            this.addClass("Pickler", this.liburl(), pickler);
            NClassType unpickler = Builtins.this.newClass("Unpickler", this.table, Builtins.this.Object, new NClassType[0]);
            unpickler.getTable().update("load", this.liburl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            unpickler.getTable().update("noload", this.liburl(), (NType)Builtins.this.newFunc(), NBinding.Kind.METHOD);
            this.addClass("Unpickler", this.liburl(), unpickler);
        }
    }

    class Bz2Module
    extends NativeModule {
        public Bz2Module() {
            super("bz2");
        }

        public void initBindings() {
            NClassType bz2 = Builtins.this.newClass("BZ2File", this.table, Builtins.this.BaseFile, new NClassType[0]);
            this.addClass("BZ2File", this.liburl(), bz2);
            NClassType bz2c = Builtins.this.newClass("BZ2Compressor", this.table, Builtins.this.Object, new NClassType[0]);
            bz2c.getTable().update("compress", Builtins.newLibUrl("bz2", "sequential-de-compression"), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.METHOD);
            bz2c.getTable().update("flush", Builtins.newLibUrl("bz2", "sequential-de-compression"), (NType)Builtins.this.newFunc(Builtins.this.None), NBinding.Kind.METHOD);
            this.addClass("BZ2Compressor", Builtins.newLibUrl("bz2", "sequential-de-compression"), bz2c);
            NClassType bz2d = Builtins.this.newClass("BZ2Decompressor", this.table, Builtins.this.Object, new NClassType[0]);
            bz2d.getTable().update("decompress", Builtins.newLibUrl("bz2", "sequential-de-compression"), (NType)Builtins.this.newFunc(Builtins.this.BaseStr), NBinding.Kind.METHOD);
            this.addClass("BZ2Decompressor", Builtins.newLibUrl("bz2", "sequential-de-compression"), bz2d);
            this.addFunction("compress", Builtins.newLibUrl("bz2", "one-shot-de-compression"), Builtins.this.BaseStr);
            this.addFunction("decompress", Builtins.newLibUrl("bz2", "one-shot-de-compression"), Builtins.this.BaseStr);
        }
    }

    class BinasciiModule
    extends NativeModule {
        public BinasciiModule() {
            super("binascii");
        }

        public void initBindings() {
            this.addStrFuncs("a2b_uu", "b2a_uu", "a2b_base64", "b2a_base64", "a2b_qp", "b2a_qp", "a2b_hqx", "rledecode_hqx", "rlecode_hqx", "b2a_hqx", "b2a_hex", "hexlify", "a2b_hex", "unhexlify");
            this.addNumFuncs("crc_hqx", "crc32");
            this.addClass("Error", this.liburl(), Builtins.this.newException("Error", this.table));
            this.addClass("Incomplete", this.liburl(), Builtins.this.newException("Incomplete", this.table));
        }
    }

    class AudioopModule
    extends NativeModule {
        public AudioopModule() {
            super("audioop");
        }

        public void initBindings() {
            this.addClass("error", this.liburl(), Builtins.this.newException("error", this.table));
            this.addStrFuncs("add", "adpcm2lin", "alaw2lin", "bias", "lin2alaw", "lin2lin", "lin2ulaw", "mul", "reverse", "tomono", "ulaw2lin");
            this.addNumFuncs("avg", "avgpp", "cross", "findfactor", "findmax", "getsample", "max", "maxpp", "rms");
            for (String s : Builtins.this.list("adpcm2lin", "findfit", "lin2adpcm", "minmax", "ratecv")) {
                this.addFunction(s, this.liburl(), Builtins.this.newTuple(new NType[0]));
            }
        }
    }

    class ArrayModule
    extends NativeModule {
        public ArrayModule() {
            super("array");
        }

        public void initBindings() {
            this.addClass("array", Builtins.newLibUrl("array", "array"), Builtins.this.BaseArray);
            this.addClass("ArrayType", Builtins.newLibUrl("array", "ArrayType"), Builtins.this.BaseArray);
        }
    }

    class BuiltinsModule
    extends NativeModule {
        public BuiltinsModule() {
            super("__builtin__");
            Builtins.this.Builtin = this.module = Builtins.this.newModule(this.name);
            this.table = this.module.getTable();
        }

        public void initBindings() {
            String[] builtin_func_num;
            String[] builtin_func_unknown;
            Builtins.this.moduleTable.put(this.name, this.liburl(), this.module, NBinding.Kind.MODULE);
            this.table.addSuper(Builtins.this.BaseModule.getTable());
            this.addClass("None", Builtins.newLibUrl("constants"), Builtins.this.None);
            this.addClass("bool", Builtins.newLibUrl("functions", "bool"), Builtins.this.BaseBool);
            this.addClass("complex", Builtins.newLibUrl("functions", "complex"), Builtins.this.BaseComplex);
            this.addClass("dict", Builtins.newLibUrl("stdtypes", "typesmapping"), Builtins.this.BaseDict);
            this.addClass("file", Builtins.newLibUrl("functions", "file"), Builtins.this.BaseFile);
            this.addClass("float", Builtins.newLibUrl("functions", "float"), Builtins.this.BaseNum);
            this.addClass("int", Builtins.newLibUrl("functions", "int"), Builtins.this.BaseNum);
            this.addClass("list", Builtins.newLibUrl("functions", "list"), Builtins.this.BaseList);
            this.addClass("long", Builtins.newLibUrl("functions", "long"), Builtins.this.BaseNum);
            this.addClass("object", Builtins.newLibUrl("functions", "object"), Builtins.this.Object);
            this.addClass("str", Builtins.newLibUrl("functions", "str"), Builtins.this.BaseStr);
            this.addClass("tuple", Builtins.newLibUrl("functions", "tuple"), Builtins.this.BaseTuple);
            this.addClass("type", Builtins.newLibUrl("functions", "type"), Builtins.this.Type);
            for (String f : builtin_func_unknown = new String[]{"apply", "basestring", "callable", "classmethod", "coerce", "compile", "copyright", "credits", "delattr", "enumerate", "eval", "execfile", "exit", "filter", "frozenset", "getattr", "help", "input", "int", "intern", "iter", "license", "long", "property", "quit", "raw_input", "reduce", "reload", "reversed", "set", "setattr", "slice", "sorted", "staticmethod", "super", "type", "unichr", "unicode"}) {
                this.addFunction(f, Builtins.newLibUrl("functions.html#" + f), Builtins.this.unknown());
            }
            for (String f : builtin_func_num = new String[]{"abs", "all", "any", "cmp", "coerce", "divmod", "hasattr", "hash", "id", "isinstance", "issubclass", "len", "max", "min", "ord", "pow", "round", "sum"}) {
                this.addFunction(f, Builtins.newLibUrl("functions.html#" + f), Builtins.this.BaseNum);
            }
            for (String f : Builtins.this.list("hex", "oct", "repr", "chr")) {
                this.addFunction(f, Builtins.newLibUrl("functions.html#" + f), Builtins.this.BaseStr);
            }
            this.addFunction("dir", Builtins.newLibUrl("functions", "dir"), Builtins.this.newList(Builtins.this.BaseStr));
            this.addFunction("map", Builtins.newLibUrl("functions", "map"), Builtins.this.newList(Builtins.this.unknown()));
            this.addFunction("range", Builtins.newLibUrl("functions", "range"), Builtins.this.newList(Builtins.this.BaseNum));
            this.addFunction("xrange", Builtins.newLibUrl("functions", "range"), Builtins.this.newList(Builtins.this.BaseNum));
            this.addFunction("buffer", Builtins.newLibUrl("functions", "buffer"), Builtins.this.newList(Builtins.this.unknown()));
            this.addFunction("zip", Builtins.newLibUrl("functions", "zip"), Builtins.this.newList(Builtins.this.newTuple(Builtins.this.unknown())));
            for (String f : Builtins.this.list("globals", "vars", "locals")) {
                this.addFunction(f, Builtins.newLibUrl("functions.html#" + f), Builtins.this.newDict(Builtins.this.BaseStr, Builtins.this.unknown()));
            }
            for (String f : Builtins.this.builtin_exception_types) {
                this.addClass(f, Builtins.newDataModelUrl("types"), Builtins.this.newClass(f, Builtins.this.globaltable, Builtins.this.Object, new NClassType[0]));
            }
            Builtins.this.BaseException = (NClassType)this.table.lookup("BaseException").getType();
            for (String f : Builtins.this.list("True", "False", "None", "Ellipsis")) {
                this.addAttr(f, Builtins.newDataModelUrl("types"), Builtins.this.unknown());
            }
            this.addFunction("open", Builtins.newTutUrl("inputoutput.html#reading-and-writing-files"), Builtins.this.BaseFile);
            this.addFunction("__import__", Builtins.newLibUrl("functions"), Builtins.this.newModule("<?>"));
            Builtins.this.globaltable.put("__builtins__", this.liburl(), this.module, NBinding.Kind.ATTRIBUTE);
            Builtins.this.globaltable.merge(this.table);
        }
    }

    private abstract class NativeModule {
        protected String name;
        protected NModuleType module;
        protected Scope table;

        NativeModule(String name) {
            this.name = name;
            Builtins.this.modules.put(name, this);
        }

        NModuleType getModule() {
            if (this.module == null) {
                this.createModuleType();
                this.initBindings();
            }
            return this.module;
        }

        protected abstract void initBindings();

        protected void createModuleType() {
            if (this.module == null) {
                this.module = Builtins.this.newModule(this.name);
                this.table = this.module.getTable();
                Builtins.this.moduleTable.put(this.name, this.liburl(), this.module, NBinding.Kind.MODULE);
            }
        }

        protected NBinding update(String name, NUrl url, NType type, NBinding.Kind kind) {
            return this.table.update(name, url, type, kind);
        }

        protected NBinding addClass(String name, NUrl url, NType type) {
            return this.table.update(name, url, type, NBinding.Kind.CLASS);
        }

        protected NBinding addMethod(String name, NUrl url, NType type) {
            return this.table.update(name, url, type, NBinding.Kind.METHOD);
        }

        protected NBinding addFunction(String name, NUrl url, NType type) {
            return this.table.update(name, url, (NType)Builtins.this.newFunc(type), NBinding.Kind.FUNCTION);
        }

        protected void addFunctions_beCareful(NType type, String ... names) {
            for (String name : names) {
                this.addFunction(name, this.liburl(), type);
            }
        }

        protected void addNoneFuncs(String ... names) {
            this.addFunctions_beCareful(Builtins.this.None, names);
        }

        protected void addNumFuncs(String ... names) {
            this.addFunctions_beCareful(Builtins.this.BaseNum, names);
        }

        protected void addStrFuncs(String ... names) {
            this.addFunctions_beCareful(Builtins.this.BaseStr, names);
        }

        protected void addUnknownFuncs(String ... names) {
            for (String name : names) {
                this.addFunction(name, this.liburl(), Builtins.this.unknown());
            }
        }

        protected NBinding addAttr(String name, NUrl url, NType type) {
            return this.table.update(name, url, type, NBinding.Kind.ATTRIBUTE);
        }

        protected void addAttributes_beCareful(NType type, String ... names) {
            for (String name : names) {
                this.addAttr(name, this.liburl(), type);
            }
        }

        protected void addNumAttrs(String ... names) {
            this.addAttributes_beCareful(Builtins.this.BaseNum, names);
        }

        protected void addStrAttrs(String ... names) {
            this.addAttributes_beCareful(Builtins.this.BaseStr, names);
        }

        protected void addUnknownAttrs(String ... names) {
            for (String name : names) {
                this.addAttr(name, this.liburl(), Builtins.this.unknown());
            }
        }

        protected NUrl liburl() {
            return Builtins.newLibUrl(this.name);
        }

        protected NUrl liburl(String anchor) {
            return Builtins.newLibUrl(this.name, anchor);
        }

        public String toString() {
            return this.module == null ? "<Non-loaded builtin module '" + this.name + "'>" : "<NativeModule:" + this.module + ">";
        }
    }
}

