/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Platform;
import net.sf.saxon.event.AllElementStripper;
import net.sf.saxon.event.IDFilter;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.URIQueryParameters;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.NonDelegatingURIResolver;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class StandardURIResolver
implements NonDelegatingURIResolver,
Serializable {
    private Configuration config = null;
    protected boolean recognizeQueryParameters = false;

    public StandardURIResolver() {
        this(null);
    }

    public StandardURIResolver(Configuration config) {
        this.config = config;
    }

    public void setRecognizeQueryParameters(boolean recognize) {
        this.recognizeQueryParameters = recognize;
    }

    public boolean queryParametersAreRecognized() {
        return this.recognizeQueryParameters;
    }

    protected Platform getPlatform() {
        return Configuration.getPlatform();
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public Source resolve(String href, String base) throws XPathException {
        Boolean xinclude;
        Integer validation;
        URI relative;
        if (this.config != null && this.config.isTiming()) {
            this.config.getStandardErrorOutput().println("URIResolver.resolve href=\"" + href + "\" base=\"" + base + "\"");
        }
        String relativeURI = href;
        String id = null;
        int hash = href.indexOf(35);
        if (hash >= 0) {
            relativeURI = href.substring(0, hash);
            id = href.substring(hash + 1);
        }
        URIQueryParameters params = null;
        try {
            relativeURI = ResolveURI.escapeSpaces(relativeURI);
            relative = new URI(relativeURI);
        }
        catch (URISyntaxException err) {
            throw new XPathException("Invalid relative URI " + Err.wrap(relativeURI), err);
        }
        String query = relative.getQuery();
        if (query != null && this.recognizeQueryParameters) {
            params = new URIQueryParameters(query, this.config);
            int q = relativeURI.indexOf(63);
            relativeURI = relativeURI.substring(0, q);
        }
        Source source = null;
        if (this.recognizeQueryParameters && relativeURI.endsWith(".ptree")) {
            source = this.getPTreeSource(relativeURI, base);
        }
        if (source == null) {
            XMLReader parser;
            URI uri;
            try {
                uri = ResolveURI.makeAbsolute(relativeURI, base);
            }
            catch (URISyntaxException err) {
                String expandedBase = ResolveURI.tryToExpand(base);
                if (!expandedBase.equals(base)) {
                    return this.resolve(href, expandedBase);
                }
                throw new XPathException("Invalid URI " + Err.wrap(relativeURI) + " - base " + Err.wrap(base), err);
            }
            String uriString = uri.toString();
            EscapeURI.checkPercentEncoding(uriString);
            source = new SAXSource();
            this.setSAXInputSource((SAXSource)source, uriString);
            if (params != null && (parser = params.getXMLReader()) != null) {
                ((SAXSource)source).setXMLReader(parser);
            }
            if (((SAXSource)source).getXMLReader() == null && this.config == null) {
                try {
                    ((SAXSource)source).setXMLReader(Configuration.getPlatform().loadParser());
                }
                catch (Exception err) {
                    throw new XPathException(err);
                }
            }
        }
        if (params != null) {
            int stripSpace = params.getStripSpace();
            switch (stripSpace) {
                case 2: {
                    source = AugmentedSource.makeAugmentedSource(source);
                    ((AugmentedSource)source).addFilter(new AllElementStripper());
                    break;
                }
                case 0: 
                case 1: {
                    source = AugmentedSource.makeAugmentedSource(source);
                    ((AugmentedSource)source).setStripSpace(stripSpace);
                }
            }
        }
        if (id != null) {
            IDFilter filter = new IDFilter(id);
            source = AugmentedSource.makeAugmentedSource(source);
            ((AugmentedSource)source).addFilter(filter);
        }
        if (params != null && (validation = params.getValidationMode()) != null) {
            source = AugmentedSource.makeAugmentedSource(source);
            ((AugmentedSource)source).setSchemaValidationMode(validation);
        }
        if (params != null && (xinclude = params.getXInclude()) != null) {
            source = AugmentedSource.makeAugmentedSource(source);
            ((AugmentedSource)source).setXIncludeAware(xinclude);
        }
        return source;
    }

    protected Source getPTreeSource(String href, String base) throws XPathException {
        throw new XPathException("PTree files can only be read using a Saxon-EE configuration");
    }

    protected void setSAXInputSource(SAXSource source, String uriString) {
        source.setInputSource(new InputSource(uriString));
        source.setSystemId(uriString);
    }
}

