// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{ffi, Buffer, View};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkSourcePrintCompositor")]
    pub struct PrintCompositor(Object<ffi::GtkSourcePrintCompositor, ffi::GtkSourcePrintCompositorClass>);

    match fn {
        type_ => || ffi::gtk_source_print_compositor_get_type(),
    }
}

impl PrintCompositor {
    pub const NONE: Option<&'static PrintCompositor> = None;

    #[doc(alias = "gtk_source_print_compositor_new")]
    pub fn new(buffer: &impl IsA<Buffer>) -> PrintCompositor {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::gtk_source_print_compositor_new(
                buffer.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_print_compositor_new_from_view")]
    #[doc(alias = "new_from_view")]
    pub fn from_view(view: &impl IsA<View>) -> PrintCompositor {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::gtk_source_print_compositor_new_from_view(
                view.as_ref().to_glib_none().0,
            ))
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`PrintCompositor`] objects.
    ///
    /// This method returns an instance of [`PrintCompositorBuilder`](crate::builders::PrintCompositorBuilder) which can be used to create [`PrintCompositor`] objects.
    pub fn builder() -> PrintCompositorBuilder {
        PrintCompositorBuilder::new()
    }
}

impl Default for PrintCompositor {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`PrintCompositor`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct PrintCompositorBuilder {
    builder: glib::object::ObjectBuilder<'static, PrintCompositor>,
}

impl PrintCompositorBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn body_font_name(self, body_font_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("body-font-name", body_font_name.into()),
        }
    }

    pub fn buffer(self, buffer: &impl IsA<Buffer>) -> Self {
        Self {
            builder: self.builder.property("buffer", buffer.clone().upcast()),
        }
    }

    pub fn footer_font_name(self, footer_font_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("footer-font-name", footer_font_name.into()),
        }
    }

    pub fn header_font_name(self, header_font_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("header-font-name", header_font_name.into()),
        }
    }

    pub fn highlight_syntax(self, highlight_syntax: bool) -> Self {
        Self {
            builder: self.builder.property("highlight-syntax", highlight_syntax),
        }
    }

    pub fn line_numbers_font_name(self, line_numbers_font_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("line-numbers-font-name", line_numbers_font_name.into()),
        }
    }

    pub fn print_footer(self, print_footer: bool) -> Self {
        Self {
            builder: self.builder.property("print-footer", print_footer),
        }
    }

    pub fn print_header(self, print_header: bool) -> Self {
        Self {
            builder: self.builder.property("print-header", print_header),
        }
    }

    pub fn print_line_numbers(self, print_line_numbers: u32) -> Self {
        Self {
            builder: self
                .builder
                .property("print-line-numbers", print_line_numbers),
        }
    }

    pub fn tab_width(self, tab_width: u32) -> Self {
        Self {
            builder: self.builder.property("tab-width", tab_width),
        }
    }

    pub fn wrap_mode(self, wrap_mode: gtk::WrapMode) -> Self {
        Self {
            builder: self.builder.property("wrap-mode", wrap_mode),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`PrintCompositor`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> PrintCompositor {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}

pub trait PrintCompositorExt: IsA<PrintCompositor> + 'static {
    #[doc(alias = "gtk_source_print_compositor_draw_page")]
    fn draw_page(&self, context: &gtk::PrintContext, page_nr: i32) {
        unsafe {
            ffi::gtk_source_print_compositor_draw_page(
                self.as_ref().to_glib_none().0,
                context.to_glib_none().0,
                page_nr,
            );
        }
    }

    #[doc(alias = "gtk_source_print_compositor_get_body_font_name")]
    #[doc(alias = "get_body_font_name")]
    #[doc(alias = "body-font-name")]
    fn body_font_name(&self) -> glib::GString {
        unsafe {
            from_glib_full(ffi::gtk_source_print_compositor_get_body_font_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_print_compositor_get_bottom_margin")]
    #[doc(alias = "get_bottom_margin")]
    fn bottom_margin(&self, unit: gtk::Unit) -> f64 {
        unsafe {
            ffi::gtk_source_print_compositor_get_bottom_margin(
                self.as_ref().to_glib_none().0,
                unit.into_glib(),
            )
        }
    }

    #[doc(alias = "gtk_source_print_compositor_get_buffer")]
    #[doc(alias = "get_buffer")]
    fn buffer(&self) -> Buffer {
        unsafe {
            from_glib_none(ffi::gtk_source_print_compositor_get_buffer(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_print_compositor_get_footer_font_name")]
    #[doc(alias = "get_footer_font_name")]
    #[doc(alias = "footer-font-name")]
    fn footer_font_name(&self) -> glib::GString {
        unsafe {
            from_glib_full(ffi::gtk_source_print_compositor_get_footer_font_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_print_compositor_get_header_font_name")]
    #[doc(alias = "get_header_font_name")]
    #[doc(alias = "header-font-name")]
    fn header_font_name(&self) -> glib::GString {
        unsafe {
            from_glib_full(ffi::gtk_source_print_compositor_get_header_font_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_print_compositor_get_highlight_syntax")]
    #[doc(alias = "get_highlight_syntax")]
    #[doc(alias = "highlight-syntax")]
    fn is_highlight_syntax(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_print_compositor_get_highlight_syntax(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_print_compositor_get_left_margin")]
    #[doc(alias = "get_left_margin")]
    fn left_margin(&self, unit: gtk::Unit) -> f64 {
        unsafe {
            ffi::gtk_source_print_compositor_get_left_margin(
                self.as_ref().to_glib_none().0,
                unit.into_glib(),
            )
        }
    }

    #[doc(alias = "gtk_source_print_compositor_get_line_numbers_font_name")]
    #[doc(alias = "get_line_numbers_font_name")]
    #[doc(alias = "line-numbers-font-name")]
    fn line_numbers_font_name(&self) -> glib::GString {
        unsafe {
            from_glib_full(ffi::gtk_source_print_compositor_get_line_numbers_font_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_print_compositor_get_n_pages")]
    #[doc(alias = "get_n_pages")]
    #[doc(alias = "n-pages")]
    fn n_pages(&self) -> i32 {
        unsafe { ffi::gtk_source_print_compositor_get_n_pages(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_source_print_compositor_get_pagination_progress")]
    #[doc(alias = "get_pagination_progress")]
    fn pagination_progress(&self) -> f64 {
        unsafe {
            ffi::gtk_source_print_compositor_get_pagination_progress(self.as_ref().to_glib_none().0)
        }
    }

    #[doc(alias = "gtk_source_print_compositor_get_print_footer")]
    #[doc(alias = "get_print_footer")]
    #[doc(alias = "print-footer")]
    fn is_print_footer(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_print_compositor_get_print_footer(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_print_compositor_get_print_header")]
    #[doc(alias = "get_print_header")]
    #[doc(alias = "print-header")]
    fn is_print_header(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_print_compositor_get_print_header(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_print_compositor_get_print_line_numbers")]
    #[doc(alias = "get_print_line_numbers")]
    #[doc(alias = "print-line-numbers")]
    fn print_line_numbers(&self) -> u32 {
        unsafe {
            ffi::gtk_source_print_compositor_get_print_line_numbers(self.as_ref().to_glib_none().0)
        }
    }

    #[doc(alias = "gtk_source_print_compositor_get_right_margin")]
    #[doc(alias = "get_right_margin")]
    fn right_margin(&self, unit: gtk::Unit) -> f64 {
        unsafe {
            ffi::gtk_source_print_compositor_get_right_margin(
                self.as_ref().to_glib_none().0,
                unit.into_glib(),
            )
        }
    }

    #[doc(alias = "gtk_source_print_compositor_get_tab_width")]
    #[doc(alias = "get_tab_width")]
    #[doc(alias = "tab-width")]
    fn tab_width(&self) -> u32 {
        unsafe { ffi::gtk_source_print_compositor_get_tab_width(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_source_print_compositor_get_top_margin")]
    #[doc(alias = "get_top_margin")]
    fn top_margin(&self, unit: gtk::Unit) -> f64 {
        unsafe {
            ffi::gtk_source_print_compositor_get_top_margin(
                self.as_ref().to_glib_none().0,
                unit.into_glib(),
            )
        }
    }

    #[doc(alias = "gtk_source_print_compositor_get_wrap_mode")]
    #[doc(alias = "get_wrap_mode")]
    #[doc(alias = "wrap-mode")]
    fn wrap_mode(&self) -> gtk::WrapMode {
        unsafe {
            from_glib(ffi::gtk_source_print_compositor_get_wrap_mode(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v5_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v5_2")))]
    #[doc(alias = "gtk_source_print_compositor_ignore_tag")]
    fn ignore_tag(&self, tag: &impl IsA<gtk::TextTag>) {
        unsafe {
            ffi::gtk_source_print_compositor_ignore_tag(
                self.as_ref().to_glib_none().0,
                tag.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_print_compositor_paginate")]
    fn paginate(&self, context: &gtk::PrintContext) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_print_compositor_paginate(
                self.as_ref().to_glib_none().0,
                context.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_print_compositor_set_body_font_name")]
    #[doc(alias = "body-font-name")]
    fn set_body_font_name(&self, font_name: &str) {
        unsafe {
            ffi::gtk_source_print_compositor_set_body_font_name(
                self.as_ref().to_glib_none().0,
                font_name.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_print_compositor_set_bottom_margin")]
    fn set_bottom_margin(&self, margin: f64, unit: gtk::Unit) {
        unsafe {
            ffi::gtk_source_print_compositor_set_bottom_margin(
                self.as_ref().to_glib_none().0,
                margin,
                unit.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_source_print_compositor_set_footer_font_name")]
    #[doc(alias = "footer-font-name")]
    fn set_footer_font_name(&self, font_name: Option<&str>) {
        unsafe {
            ffi::gtk_source_print_compositor_set_footer_font_name(
                self.as_ref().to_glib_none().0,
                font_name.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_print_compositor_set_footer_format")]
    fn set_footer_format(
        &self,
        separator: bool,
        left: Option<&str>,
        center: Option<&str>,
        right: Option<&str>,
    ) {
        unsafe {
            ffi::gtk_source_print_compositor_set_footer_format(
                self.as_ref().to_glib_none().0,
                separator.into_glib(),
                left.to_glib_none().0,
                center.to_glib_none().0,
                right.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_print_compositor_set_header_font_name")]
    #[doc(alias = "header-font-name")]
    fn set_header_font_name(&self, font_name: Option<&str>) {
        unsafe {
            ffi::gtk_source_print_compositor_set_header_font_name(
                self.as_ref().to_glib_none().0,
                font_name.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_print_compositor_set_header_format")]
    fn set_header_format(
        &self,
        separator: bool,
        left: Option<&str>,
        center: Option<&str>,
        right: Option<&str>,
    ) {
        unsafe {
            ffi::gtk_source_print_compositor_set_header_format(
                self.as_ref().to_glib_none().0,
                separator.into_glib(),
                left.to_glib_none().0,
                center.to_glib_none().0,
                right.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_print_compositor_set_highlight_syntax")]
    #[doc(alias = "highlight-syntax")]
    fn set_highlight_syntax(&self, highlight: bool) {
        unsafe {
            ffi::gtk_source_print_compositor_set_highlight_syntax(
                self.as_ref().to_glib_none().0,
                highlight.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_source_print_compositor_set_left_margin")]
    fn set_left_margin(&self, margin: f64, unit: gtk::Unit) {
        unsafe {
            ffi::gtk_source_print_compositor_set_left_margin(
                self.as_ref().to_glib_none().0,
                margin,
                unit.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_source_print_compositor_set_line_numbers_font_name")]
    #[doc(alias = "line-numbers-font-name")]
    fn set_line_numbers_font_name(&self, font_name: Option<&str>) {
        unsafe {
            ffi::gtk_source_print_compositor_set_line_numbers_font_name(
                self.as_ref().to_glib_none().0,
                font_name.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_print_compositor_set_print_footer")]
    #[doc(alias = "print-footer")]
    fn set_print_footer(&self, print: bool) {
        unsafe {
            ffi::gtk_source_print_compositor_set_print_footer(
                self.as_ref().to_glib_none().0,
                print.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_source_print_compositor_set_print_header")]
    #[doc(alias = "print-header")]
    fn set_print_header(&self, print: bool) {
        unsafe {
            ffi::gtk_source_print_compositor_set_print_header(
                self.as_ref().to_glib_none().0,
                print.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_source_print_compositor_set_print_line_numbers")]
    #[doc(alias = "print-line-numbers")]
    fn set_print_line_numbers(&self, interval: u32) {
        unsafe {
            ffi::gtk_source_print_compositor_set_print_line_numbers(
                self.as_ref().to_glib_none().0,
                interval,
            );
        }
    }

    #[doc(alias = "gtk_source_print_compositor_set_right_margin")]
    fn set_right_margin(&self, margin: f64, unit: gtk::Unit) {
        unsafe {
            ffi::gtk_source_print_compositor_set_right_margin(
                self.as_ref().to_glib_none().0,
                margin,
                unit.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_source_print_compositor_set_tab_width")]
    #[doc(alias = "tab-width")]
    fn set_tab_width(&self, width: u32) {
        unsafe {
            ffi::gtk_source_print_compositor_set_tab_width(self.as_ref().to_glib_none().0, width);
        }
    }

    #[doc(alias = "gtk_source_print_compositor_set_top_margin")]
    fn set_top_margin(&self, margin: f64, unit: gtk::Unit) {
        unsafe {
            ffi::gtk_source_print_compositor_set_top_margin(
                self.as_ref().to_glib_none().0,
                margin,
                unit.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_source_print_compositor_set_wrap_mode")]
    #[doc(alias = "wrap-mode")]
    fn set_wrap_mode(&self, wrap_mode: gtk::WrapMode) {
        unsafe {
            ffi::gtk_source_print_compositor_set_wrap_mode(
                self.as_ref().to_glib_none().0,
                wrap_mode.into_glib(),
            );
        }
    }

    #[doc(alias = "body-font-name")]
    fn connect_body_font_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_body_font_name_trampoline<
            P: IsA<PrintCompositor>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourcePrintCompositor,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintCompositor::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::body-font-name".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_body_font_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "footer-font-name")]
    fn connect_footer_font_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_footer_font_name_trampoline<
            P: IsA<PrintCompositor>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourcePrintCompositor,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintCompositor::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::footer-font-name".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_footer_font_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "header-font-name")]
    fn connect_header_font_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_header_font_name_trampoline<
            P: IsA<PrintCompositor>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourcePrintCompositor,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintCompositor::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::header-font-name".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_header_font_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "highlight-syntax")]
    fn connect_highlight_syntax_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_highlight_syntax_trampoline<
            P: IsA<PrintCompositor>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourcePrintCompositor,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintCompositor::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::highlight-syntax".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_highlight_syntax_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "line-numbers-font-name")]
    fn connect_line_numbers_font_name_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_line_numbers_font_name_trampoline<
            P: IsA<PrintCompositor>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourcePrintCompositor,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintCompositor::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::line-numbers-font-name".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_line_numbers_font_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "n-pages")]
    fn connect_n_pages_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_n_pages_trampoline<
            P: IsA<PrintCompositor>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourcePrintCompositor,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintCompositor::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::n-pages".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_n_pages_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "print-footer")]
    fn connect_print_footer_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_print_footer_trampoline<
            P: IsA<PrintCompositor>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourcePrintCompositor,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintCompositor::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::print-footer".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_print_footer_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "print-header")]
    fn connect_print_header_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_print_header_trampoline<
            P: IsA<PrintCompositor>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourcePrintCompositor,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintCompositor::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::print-header".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_print_header_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "print-line-numbers")]
    fn connect_print_line_numbers_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_print_line_numbers_trampoline<
            P: IsA<PrintCompositor>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourcePrintCompositor,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintCompositor::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::print-line-numbers".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_print_line_numbers_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tab-width")]
    fn connect_tab_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tab_width_trampoline<
            P: IsA<PrintCompositor>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourcePrintCompositor,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintCompositor::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::tab-width".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_tab_width_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "wrap-mode")]
    fn connect_wrap_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_wrap_mode_trampoline<
            P: IsA<PrintCompositor>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourcePrintCompositor,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PrintCompositor::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::wrap-mode".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_wrap_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<PrintCompositor>> PrintCompositorExt for O {}
