﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/autoscaling/model/MetricCollectionType.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/core/utils/xml/XmlSerializer.h>

#include <utility>

using namespace Aws::Utils::Xml;
using namespace Aws::Utils;

namespace Aws {
namespace AutoScaling {
namespace Model {

MetricCollectionType::MetricCollectionType(const XmlNode& xmlNode) { *this = xmlNode; }

MetricCollectionType& MetricCollectionType::operator=(const XmlNode& xmlNode) {
  XmlNode resultNode = xmlNode;

  if (!resultNode.IsNull()) {
    XmlNode metricNode = resultNode.FirstChild("Metric");
    if (!metricNode.IsNull()) {
      m_metric = Aws::Utils::Xml::DecodeEscapedXmlText(metricNode.GetText());
      m_metricHasBeenSet = true;
    }
  }

  return *this;
}

void MetricCollectionType::OutputToStream(Aws::OStream& oStream, const char* location, unsigned index, const char* locationValue) const {
  if (m_metricHasBeenSet) {
    oStream << location << index << locationValue << ".Metric=" << StringUtils::URLEncode(m_metric.c_str()) << "&";
  }
}

void MetricCollectionType::OutputToStream(Aws::OStream& oStream, const char* location) const {
  if (m_metricHasBeenSet) {
    oStream << location << ".Metric=" << StringUtils::URLEncode(m_metric.c_str()) << "&";
  }
}

}  // namespace Model
}  // namespace AutoScaling
}  // namespace Aws
