\page ExampleConcentricSpheres Example ConcentricSpheres

In this example, the particle fluence is evaluated for a set-up made
of one target solid sphere, at the center of which a particle is shot
(by default along the z-axis), followed by two outer, target solid sphere
shells, with space in between filled up with G4_Galactic material - i.e.
very low density gas.
The three targets mimic a very simplified collider detector, with the
first (inner) target as a proxy for a Tracker, the second (middle) target
as a proxy for an electromagnetic (homogeneous) calorimeter, and the
third and last (outer) target as a proxy for a hadronic (homogeneous)
calorimeter.

The particle fluence is computed in six places: immediately outside
each of the three targets (inner, middle and outer targets), and for
each of them, in the "forward" and "backward" hemispheres (i.e. immediately
after and before, respectively, of the target with respect to the direction
of the primary particle).

The particle fluence is estimated by summing the track length in a
"scoring volume" - i.e. a thin hemisphere shell filled up with G4_Galactic
(very low density gas) material, immediately outside one of the targets -
and then dividing for the cubic volume of such scoring volume.

Complementary information on average multiplicity, average kinetic energy,
and average total energy flow (i.e. sum of kinetic energies) for the
particles produced in the three targets are also computed.

The particle fluence is evaluated for the following 11 particle types:
-  all
-  electron + positron 
-  gamma
-  muon- + muon+
-  neutrino (any flavour and including anti-neutrino)
-  charged pions
-  neutron + anti_neutron
-  proton + anti_proton
-  ion (and anti-ions)
-  otherMeson (e.g. kaons, etc.)
-  otherBaryon (e.g. hyperons, etc.)

The particle fluence is evaluated for the following 3 kinematical ranges:
-  any kinetic energy
-  kinetic energy < 20 MeV
-  kinetic energy > 20 MeV

Look for the string "***LOOKHERE***" for those parameters/options that
are either hardwired in the code (i.e. not available via UI command),
or default values of UI commands.

This example uses the physics list factory, therefore you can specify
the reference physics list you want to use via the PHYSLIST
environmental variable (by default, if you don't set it, the FTFP_BERT
physics list is used).

To build this example:

```
mkdir Build; cd Build
cmake -DCMAKE_BUILD_TYPE=RelWithDebInfo \
      -DGeant4_DIR=/path-to-geant4-libraries ../.
make
```

To run it:

```
./ConcentricSpheres all_together.in
```

which shoots 50 GeV pion- on three different configurations
(Scintillator-PbWO4-Copper, LiquidArgon-Lead-Iron, Silicon-Tungsten-Tungsten),
with 100 events in each run, and print out some information on the
particle fluence at the end of each run.
Other macros exist for each of these specific configurations:
lar_pb_fe.in, sci_pbwo4_cu.in, si_w_w.in .
