package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UploadMedia invokes the cloudcallcenter.UploadMedia API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/uploadmedia.html
func (client *Client) UploadMedia(request *UploadMediaRequest) (response *UploadMediaResponse, err error) {
	response = CreateUploadMediaResponse()
	err = client.DoAction(request, response)
	return
}

// UploadMediaWithChan invokes the cloudcallcenter.UploadMedia API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/uploadmedia.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UploadMediaWithChan(request *UploadMediaRequest) (<-chan *UploadMediaResponse, <-chan error) {
	responseChan := make(chan *UploadMediaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UploadMedia(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UploadMediaWithCallback invokes the cloudcallcenter.UploadMedia API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/uploadmedia.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UploadMediaWithCallback(request *UploadMediaRequest, callback func(response *UploadMediaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UploadMediaResponse
		var err error
		defer close(result)
		response, err = client.UploadMedia(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UploadMediaRequest is the request struct for api UploadMedia
type UploadMediaRequest struct {
	*requests.RpcRequest
	Instance     string           `position:"Query" name:"Instance"`
	FileName     string           `position:"Query" name:"FileName"`
	CallbackHost string           `position:"Query" name:"CallbackHost"`
	Media        requests.Integer `position:"Query" name:"Media"`
	CallbackUrl  string           `position:"Query" name:"CallbackUrl"`
}

// UploadMediaResponse is the response struct for api UploadMedia
type UploadMediaResponse struct {
	*responses.BaseResponse
	RequestId      string                    `json:"RequestId" xml:"RequestId"`
	Success        bool                      `json:"Success" xml:"Success"`
	Code           string                    `json:"Code" xml:"Code"`
	Message        string                    `json:"Message" xml:"Message"`
	HttpStatusCode int                       `json:"HttpStatusCode" xml:"HttpStatusCode"`
	UploadParams   UploadParamsInUploadMedia `json:"UploadParams" xml:"UploadParams"`
}

// CreateUploadMediaRequest creates a request to invoke UploadMedia API
func CreateUploadMediaRequest() (request *UploadMediaRequest) {
	request = &UploadMediaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "UploadMedia", "", "")
	request.Method = requests.POST
	return
}

// CreateUploadMediaResponse creates a response to parse from UploadMedia response
func CreateUploadMediaResponse() (response *UploadMediaResponse) {
	response = &UploadMediaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
