/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.select;

import java.io.Serializable;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Function;

public class LateralView
implements Serializable {
    private boolean isUsingOuter = false;
    private Function generatorFunction;
    private Alias tableAlias = null;
    private Alias columnAlias;

    public LateralView(boolean useOuter, Function generatorFunction, Alias tableAlias, Alias columnAlias) {
        this.isUsingOuter = useOuter;
        this.generatorFunction = generatorFunction;
        this.tableAlias = tableAlias;
        this.columnAlias = columnAlias;
    }

    public boolean isUsingOuter() {
        return this.isUsingOuter;
    }

    public void setUsingOuter(boolean useOuter) {
        this.isUsingOuter = useOuter;
    }

    public LateralView withOuter(boolean useOuter) {
        this.setUsingOuter(useOuter);
        return this;
    }

    public Function getGeneratorFunction() {
        return this.generatorFunction;
    }

    public void setGeneratorFunction(Function generatorFunction) {
        this.generatorFunction = generatorFunction;
    }

    public LateralView withGeneratorFunction(Function generatorFunction) {
        this.setGeneratorFunction(generatorFunction);
        return this;
    }

    public Alias getTableAlias() {
        return this.tableAlias;
    }

    public void setTableAlias(Alias tableAlias) {
        this.tableAlias = tableAlias;
    }

    public LateralView withTableAlias(Alias tableAlias) {
        this.setTableAlias(tableAlias != null ? tableAlias.withUseAs(false) : null);
        return this;
    }

    public Alias getColumnAlias() {
        return this.columnAlias;
    }

    public void setColumnAlias(Alias columnAlias) {
        this.columnAlias = columnAlias;
    }

    public LateralView withColumnAlias(Alias columnAlias) {
        this.setColumnAlias(columnAlias.withUseAs(true));
        return this;
    }

    public StringBuilder appendTo(StringBuilder builder) {
        builder.append("LATERAL VIEW");
        if (this.isUsingOuter) {
            builder.append(" OUTER");
        }
        builder.append(" ").append(this.generatorFunction);
        if (this.tableAlias != null) {
            builder.append(" ").append(this.tableAlias);
        }
        builder.append(" ").append(this.columnAlias);
        return builder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }
}

