/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.ui.views;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.mssql.auth.SQLServerAuthModelNTLM;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.DatabaseNativeAuthModelConfigurator;
import org.jkiss.utils.CommonUtils;

public class SQLServerAuthConfigurator
extends DatabaseNativeAuthModelConfigurator {
    private Button isCheck;

    public void createControl(@NotNull Composite parent, DBAAuthModel<?> object, @NotNull Runnable propertyChangeListener) {
        super.createControl(parent, object, propertyChangeListener);
        if (object instanceof SQLServerAuthModelNTLM) {
            this.isCheck = UIUtils.createCheckbox((Composite)parent, (String)"Use integrated security", (String)"Enable integrated security (by default it is required for NTLM)", (boolean)true, (int)2);
        }
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.loadSettings(dataSource);
        if (this.isCheck != null) {
            this.isCheck.setSelection(CommonUtils.getBoolean((String)dataSource.getConnectionConfiguration().getProperty("integratedSecurity"), (boolean)true));
        }
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        if (this.isCheck != null) {
            dataSource.getConnectionConfiguration().setProperty("integratedSecurity", String.valueOf(this.isCheck.getSelection()));
        }
    }

    public void resetSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.resetSettings(dataSource);
        if (this.isCheck != null) {
            dataSource.getConnectionConfiguration().removeProperty("integratedSecurity");
        }
    }
}

