/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.Animator;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RoutingListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;

public class RoutingAnimator
extends Animator
implements RoutingListener {
    static final RoutingAnimator INSTANCE = new RoutingAnimator();

    protected RoutingAnimator() {
    }

    @Override
    public void playbackStarting(IFigure connection) {
        this.reconcileStates((Connection)connection);
    }

    @Override
    protected Object getCurrentState(IFigure connection) {
        return ((Connection)connection).getPoints().getCopy();
    }

    public static RoutingAnimator getDefault() {
        return INSTANCE;
    }

    @Override
    public final void invalidate(Connection conn) {
        if (Animation.isInitialRecording()) {
            Animation.hookAnimator(conn, this);
        }
    }

    @Override
    protected boolean playback(IFigure figure) {
        Connection conn = (Connection)figure;
        PointList list1 = (PointList)Animation.getInitialState(this, conn);
        PointList list2 = (PointList)Animation.getFinalState(this, conn);
        if (list1 == null) {
            conn.setVisible(false);
            return true;
        }
        float progress = Animation.getProgress();
        if (list1.size() == list2.size()) {
            Point pt1 = new Point();
            Point pt2 = new Point();
            PointList points = conn.getPoints();
            points.removeAllPoints();
            int i = 0;
            while (i < list1.size()) {
                list1.getPoint(pt2, i);
                list2.getPoint(pt1, i);
                pt1.x = Math.round((float)pt1.x * progress + (1.0f - progress) * (float)pt2.x);
                pt1.y = Math.round((float)pt1.y * progress + (1.0f - progress) * (float)pt2.y);
                points.addPoint(pt1);
                ++i;
            }
            conn.setPoints(points);
        }
        return true;
    }

    @Override
    public final void postRoute(Connection connection) {
        if (Animation.isFinalRecording()) {
            Animation.hookNeedsCapture(connection, this);
        }
    }

    private void reconcileStates(Connection conn) {
        PointList points1 = (PointList)Animation.getInitialState(this, conn);
        PointList points2 = (PointList)Animation.getFinalState(this, conn);
        if (points1 != null && points1.size() != points2.size()) {
            Point p = new Point();
            Point q = new Point();
            int size1 = points1.size() - 1;
            int size2 = points2.size() - 1;
            int i1 = size1;
            int i2 = size2;
            double current1 = 1.0;
            double current2 = 1.0;
            double prev1 = 1.0;
            double prev2 = 1.0;
            while (i1 > 0 || i2 > 0) {
                if (Math.abs(current1 - current2) < 0.1 && i1 > 0 && i2 > 0) {
                    prev1 = current1;
                    prev2 = current2;
                    current1 = (double)(--i1) / (double)size1;
                    current2 = (double)(--i2) / (double)size2;
                    continue;
                }
                if (current1 < current2) {
                    points1.getPoint(p, i1);
                    points1.getPoint(q, i1 + 1);
                    p.x = (int)(((double)q.x * (current2 - current1) + (double)p.x * (prev1 - current2)) / (prev1 - current1));
                    p.y = (int)(((double)q.y * (current2 - current1) + (double)p.y * (prev1 - current2)) / (prev1 - current1));
                    points1.insertPoint(p, i1 + 1);
                    prev1 = prev2 = current2;
                    current2 = (double)(--i2) / (double)size2;
                    continue;
                }
                points2.getPoint(p, i2);
                points2.getPoint(q, i2 + 1);
                p.x = (int)(((double)q.x * (current1 - current2) + (double)p.x * (prev2 - current1)) / (prev2 - current2));
                p.y = (int)(((double)q.y * (current1 - current2) + (double)p.y * (prev2 - current1)) / (prev2 - current2));
                points2.insertPoint(p, i2 + 1);
                prev2 = prev1 = current1;
                current1 = (double)(--i1) / (double)size1;
            }
        }
    }

    @Override
    public final void remove(Connection connection) {
    }

    @Override
    public final boolean route(Connection conn) {
        return Animation.isAnimating() && Animation.hookPlayback(conn, this);
    }

    @Override
    public final void setConstraint(Connection connection, Object constraint) {
    }
}

