---
title: "rclone config string"
description: "Print connection string for a single remote."
versionIntroduced: v1.72
# autogenerated - DO NOT EDIT, instead edit the source code in cmd/config/string/ and as part of making a release run "make commanddocs"
---
# rclone config string

Print connection string for a single remote.

## Synopsis

Print a connection string for a single remote.

The [connection strings](/docs/#connection-strings) can be used
wherever a remote is needed and can be more convenient than using the
config file, especially if using the RC API.

Backend parameters may be provided to the command also.

Example:

```sh
$ rclone config string s3:rclone --s3-no-check-bucket
:s3,access_key_id=XXX,no_check_bucket,provider=AWS,region=eu-west-2,secret_access_key=YYY:rclone
```

**NB** the strings are not quoted for use in shells (eg bash,
powershell, windows cmd). Most will work if enclosed in "double
quotes", however connection strings that contain double quotes will
require further quoting which is very shell dependent.



```
rclone config string <remote> [flags]
```

## Options

```
  -h, --help   help for string
```

See the [global flags page](/flags/) for global options not listed here.

## See Also

<!-- markdownlint-capture -->
<!-- markdownlint-disable ul-style line-length -->

* [rclone config](/commands/rclone_config/)	 - Enter an interactive configuration session.


<!-- markdownlint-restore -->
