/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.persistence.internal;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.NamedThreadFactory;
import org.openhab.core.common.SafeCaller;
import org.openhab.core.common.registry.RegistryChangeListener;
import org.openhab.core.items.GenericItem;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.ItemRegistryChangeListener;
import org.openhab.core.items.StateChangeListener;
import org.openhab.core.items.TimeSeriesListener;
import org.openhab.core.persistence.FilterCriteria;
import org.openhab.core.persistence.HistoricItem;
import org.openhab.core.persistence.ModifiablePersistenceService;
import org.openhab.core.persistence.PersistedItem;
import org.openhab.core.persistence.PersistenceItemConfiguration;
import org.openhab.core.persistence.PersistenceManager;
import org.openhab.core.persistence.PersistenceService;
import org.openhab.core.persistence.QueryablePersistenceService;
import org.openhab.core.persistence.config.PersistenceAllConfig;
import org.openhab.core.persistence.config.PersistenceConfig;
import org.openhab.core.persistence.config.PersistenceGroupConfig;
import org.openhab.core.persistence.config.PersistenceGroupExcludeConfig;
import org.openhab.core.persistence.config.PersistenceItemConfig;
import org.openhab.core.persistence.config.PersistenceItemExcludeConfig;
import org.openhab.core.persistence.registry.PersistenceServiceConfiguration;
import org.openhab.core.persistence.registry.PersistenceServiceConfigurationRegistry;
import org.openhab.core.persistence.registry.PersistenceServiceConfigurationRegistryChangeListener;
import org.openhab.core.persistence.strategy.PersistenceCronStrategy;
import org.openhab.core.persistence.strategy.PersistenceStrategy;
import org.openhab.core.scheduler.CronScheduler;
import org.openhab.core.scheduler.ScheduledCompletableFuture;
import org.openhab.core.scheduler.Scheduler;
import org.openhab.core.service.ReadyMarker;
import org.openhab.core.service.ReadyMarkerFilter;
import org.openhab.core.service.ReadyService;
import org.openhab.core.types.State;
import org.openhab.core.types.TimeSeries;
import org.openhab.core.types.UnDefType;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={PersistenceManager.class})
@NonNullByDefault
public class PersistenceManagerImpl
implements ItemRegistryChangeListener,
StateChangeListener,
ReadyService.ReadyTracker,
PersistenceServiceConfigurationRegistryChangeListener,
TimeSeriesListener,
PersistenceManager {
    private static final String PERSISTENCE_SOURCE = "org.openhab.core.persistence";
    private final Logger logger = LoggerFactory.getLogger(PersistenceManagerImpl.class);
    private final ReadyMarker marker = new ReadyMarker("persistence", "restore");
    private final CronScheduler cronScheduler;
    private final Scheduler scheduler;
    private final ItemRegistry itemRegistry;
    private final SafeCaller safeCaller;
    private final ReadyService readyService;
    private final PersistenceServiceConfigurationRegistry persistenceServiceConfigurationRegistry;
    private volatile boolean started = false;
    private final Map<String, PersistenceServiceContainer> persistenceServiceContainers = new ConcurrentHashMap<String, PersistenceServiceContainer>();

    @Activate
    public PersistenceManagerImpl(@Reference CronScheduler cronScheduler, @Reference Scheduler scheduler, @Reference ItemRegistry itemRegistry, @Reference SafeCaller safeCaller, @Reference ReadyService readyService, @Reference PersistenceServiceConfigurationRegistry persistenceServiceConfigurationRegistry) {
        this.cronScheduler = cronScheduler;
        this.scheduler = scheduler;
        this.itemRegistry = itemRegistry;
        this.safeCaller = safeCaller;
        this.readyService = readyService;
        this.persistenceServiceConfigurationRegistry = persistenceServiceConfigurationRegistry;
        persistenceServiceConfigurationRegistry.addRegistryChangeListener(this);
        readyService.registerTracker((ReadyService.ReadyTracker)this, new ReadyMarkerFilter().withType("startlevel").withIdentifier(Integer.toString(20)));
    }

    @Deactivate
    protected void deactivate() {
        this.itemRegistry.removeRegistryChangeListener((RegistryChangeListener)this);
        this.persistenceServiceConfigurationRegistry.removeRegistryChangeListener(this);
        this.started = false;
        this.persistenceServiceContainers.values().forEach(PersistenceServiceContainer::cancelPersistJobs);
        this.persistenceServiceContainers.values().forEach(PersistenceServiceContainer::cancelForecastJobs);
        this.itemRegistry.stream().filter(GenericItem.class::isInstance).forEach(item -> ((GenericItem)item).removeStateChangeListener((StateChangeListener)this));
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addPersistenceService(PersistenceService persistenceService) {
        String serviceId = persistenceService.getId();
        this.logger.debug("Initializing {} persistence service.", (Object)serviceId);
        PersistenceServiceContainer container = new PersistenceServiceContainer(persistenceService, (PersistenceServiceConfiguration)this.persistenceServiceConfigurationRegistry.get(serviceId));
        PersistenceServiceContainer oldContainer = this.persistenceServiceContainers.put(serviceId, container);
        if (oldContainer != null) {
            oldContainer.cancelPersistJobs();
            oldContainer.cancelForecastJobs();
        }
        if (this.started) {
            this.startEventHandling(container);
        }
    }

    protected void removePersistenceService(PersistenceService persistenceService) {
        PersistenceServiceContainer container = this.persistenceServiceContainers.remove(persistenceService.getId());
        if (container != null) {
            container.cancelPersistJobs();
            container.cancelForecastJobs();
        }
    }

    private void handleStateEvent(Item item, boolean changed) {
        PersistenceStrategy changeStrategy = changed ? PersistenceStrategy.Globals.CHANGE : PersistenceStrategy.Globals.UPDATE;
        this.persistenceServiceContainers.values().forEach(container -> container.getMatchingConfigurations(changeStrategy).filter(itemConfig -> this.appliesToItem((PersistenceItemConfiguration)itemConfig, item)).filter(itemConfig -> itemConfig.filters().stream().allMatch(filter -> filter.apply(item))).forEach(itemConfig -> {
            itemConfig.filters().forEach(filter -> filter.persisted(item));
            container.getPersistenceService().store(item, container.getAlias(item));
        }));
    }

    private boolean appliesToItem(PersistenceItemConfiguration itemConfig, Item item) {
        boolean applies = false;
        for (PersistenceConfig itemCfg : itemConfig.items()) {
            if (itemCfg instanceof PersistenceAllConfig) {
                applies = true;
                continue;
            }
            if (itemCfg instanceof PersistenceItemConfig) {
                PersistenceItemConfig persistenceItemConfig = (PersistenceItemConfig)itemCfg;
                if (!item.getName().equals(persistenceItemConfig.getItem())) continue;
                applies = true;
                continue;
            }
            if (itemCfg instanceof PersistenceItemExcludeConfig) {
                PersistenceItemExcludeConfig persistenceItemExcludeConfig = (PersistenceItemExcludeConfig)itemCfg;
                if (!item.getName().equals(persistenceItemExcludeConfig.getItem())) continue;
                return false;
            }
            if (itemCfg instanceof PersistenceGroupConfig) {
                PersistenceGroupConfig persistenceGroupConfig = (PersistenceGroupConfig)itemCfg;
                try {
                    GroupItem gItem2;
                    Item gItem = this.itemRegistry.getItem(persistenceGroupConfig.getGroup());
                    if (!(gItem instanceof GroupItem) || !(gItem2 = (GroupItem)gItem).getAllStateMembers().contains(item)) continue;
                    applies = true;
                }
                catch (ItemNotFoundException gItem) {}
                continue;
            }
            if (!(itemCfg instanceof PersistenceGroupExcludeConfig)) continue;
            PersistenceGroupExcludeConfig persistenceGroupExcludeConfig = (PersistenceGroupExcludeConfig)itemCfg;
            try {
                GroupItem gItem2;
                Item gItem = this.itemRegistry.getItem(persistenceGroupExcludeConfig.getGroup());
                if (!(gItem instanceof GroupItem) || !(gItem2 = (GroupItem)gItem).getAllMembers().contains(item)) continue;
                return false;
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        }
        return applies;
    }

    private Iterable<Item> getAllItems(PersistenceItemConfiguration config) {
        HashSet<Item> items = new HashSet<Item>();
        HashSet<Item> excludeItems = new HashSet<Item>();
        for (PersistenceConfig itemCfg : config.items()) {
            if (itemCfg instanceof PersistenceAllConfig) {
                items.addAll(this.itemRegistry.getItems());
                continue;
            }
            if (itemCfg instanceof PersistenceItemConfig) {
                PersistenceItemConfig persistenceItemConfig = (PersistenceItemConfig)itemCfg;
                String itemName = persistenceItemConfig.getItem();
                try {
                    items.add(this.itemRegistry.getItem(itemName));
                }
                catch (ItemNotFoundException e) {
                    this.logger.debug("Item '{}' does not exist.", (Object)itemName);
                }
                continue;
            }
            if (itemCfg instanceof PersistenceGroupConfig) {
                PersistenceGroupConfig persistenceGroupConfig = (PersistenceGroupConfig)itemCfg;
                String groupName = persistenceGroupConfig.getGroup();
                try {
                    Item gItem = this.itemRegistry.getItem(groupName);
                    if (!(gItem instanceof GroupItem)) continue;
                    GroupItem groupItem = (GroupItem)gItem;
                    items.addAll(groupItem.getAllStateMembers());
                }
                catch (ItemNotFoundException e) {
                    this.logger.debug("Item group '{}' does not exist.", (Object)groupName);
                }
                continue;
            }
            if (itemCfg instanceof PersistenceItemExcludeConfig) {
                PersistenceItemExcludeConfig persistenceItemConfig = (PersistenceItemExcludeConfig)itemCfg;
                String itemName = persistenceItemConfig.getItem();
                try {
                    excludeItems.add(this.itemRegistry.getItem(itemName));
                }
                catch (ItemNotFoundException e) {
                    this.logger.debug("Item '{}' does not exist.", (Object)itemName);
                }
                continue;
            }
            if (!(itemCfg instanceof PersistenceGroupExcludeConfig)) continue;
            PersistenceGroupExcludeConfig persistenceGroupConfig = (PersistenceGroupExcludeConfig)itemCfg;
            String groupName = persistenceGroupConfig.getGroup();
            try {
                Item gItem = this.itemRegistry.getItem(groupName);
                if (!(gItem instanceof GroupItem)) continue;
                GroupItem groupItem = (GroupItem)gItem;
                excludeItems.addAll(groupItem.getAllMembers());
            }
            catch (ItemNotFoundException e) {
                this.logger.debug("Item group '{}' does not exist.", (Object)groupName);
            }
        }
        items.removeAll(excludeItems);
        return items;
    }

    private void startEventHandling(PersistenceServiceContainer serviceContainer) {
        serviceContainer.restoreStatesAndScheduleForecastJobs();
        serviceContainer.schedulePersistJobs();
    }

    public void allItemsChanged(Collection<String> oldItemNames) {
        this.addPersistenceListeners(oldItemNames);
        this.addToPersistenceServiceContainer(oldItemNames);
    }

    public void addPersistenceListeners(Collection<String> oldItemNames) {
        this.itemRegistry.getItems().forEach(this::addItemToPersistenceListeners);
    }

    public void addToPersistenceServiceContainer(Collection<String> oldItemNames) {
        this.itemRegistry.getItems().forEach(this::addItemToPersistenceServiceContainer);
    }

    public void added(Item item) {
        this.addItemToPersistenceListeners(item);
        this.addItemToPersistenceServiceContainer(item);
    }

    public void addItemToPersistenceServiceContainer(Item item) {
        this.persistenceServiceContainers.values().forEach(container -> container.addItem(item));
    }

    public void addItemToPersistenceListeners(Item item) {
        if (item instanceof GenericItem) {
            GenericItem genericItem = (GenericItem)item;
            genericItem.addStateChangeListener((StateChangeListener)this);
            genericItem.addTimeSeriesListener((TimeSeriesListener)this);
        }
    }

    public void removed(Item item) {
        this.persistenceServiceContainers.values().forEach(container -> container.removeItem(item.getName()));
        if (item instanceof GenericItem) {
            GenericItem genericItem = (GenericItem)item;
            genericItem.removeStateChangeListener((StateChangeListener)this);
            genericItem.removeTimeSeriesListener((TimeSeriesListener)this);
        }
    }

    public void updated(Item oldItem, Item item) {
        this.removed(oldItem);
        this.added(item);
    }

    public void stateChanged(Item item, State oldState, State newState) {
        this.handleStateEvent(item, true);
    }

    public void stateUpdated(Item item, State state) {
        this.handleStateEvent(item, false);
    }

    public void timeSeriesUpdated(Item item, TimeSeries timeSeries) {
        if (timeSeries.size() == 0) {
            return;
        }
        this.persistenceServiceContainers.values().stream().filter(psc -> psc.persistenceService instanceof ModifiablePersistenceService).forEach(container -> Stream.concat(container.getMatchingConfigurations(PersistenceStrategy.Globals.UPDATE), container.getMatchingConfigurations(PersistenceStrategy.Globals.FORECAST)).distinct().filter(itemConfig -> this.appliesToItem((PersistenceItemConfiguration)itemConfig, item)).forEach(itemConfig -> {
            ModifiablePersistenceService service = (ModifiablePersistenceService)container.getPersistenceService();
            if (timeSeries.getPolicy() == TimeSeries.Policy.REPLACE) {
                ZonedDateTime begin = timeSeries.getBegin().atZone(ZoneId.systemDefault());
                ZonedDateTime end = timeSeries.getEnd().atZone(ZoneId.systemDefault());
                FilterCriteria removeFilter = new FilterCriteria().setItemName(item.getName()).setBeginDate(begin).setEndDate(end);
                service.remove(removeFilter, container.getAlias(item));
                ScheduledCompletableFuture<?> forecastJob = persistenceServiceContainer.forecastJobs.get(item.getName());
                if (forecastJob != null && forecastJob.getScheduledTime().isAfter(begin) && forecastJob.getScheduledTime().isBefore(end)) {
                    forecastJob.cancel(true);
                    persistenceServiceContainer.forecastJobs.remove(item.getName());
                }
            }
            timeSeries.getStates().forEach(e -> service.store(item, e.timestamp().atZone(ZoneId.systemDefault()), e.state()));
            timeSeries.getStates().filter(s -> s.timestamp().isAfter(Instant.now())).findFirst().ifPresent(s -> {
                ScheduledCompletableFuture<?> forecastJob = persistenceServiceContainer.forecastJobs.get(item.getName());
                if (forecastJob == null || forecastJob.getScheduledTime().isAfter(s.timestamp().atZone(ZoneId.systemDefault()))) {
                    container.scheduleNextForecastForItem(item.getName(), s.timestamp(), s.state());
                }
            });
        }));
    }

    public void onReadyMarkerAdded(ReadyMarker readyMarker) {
        ExecutorService scheduler = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("persistenceManager"));
        scheduler.submit(() -> {
            this.allItemsChanged(Set.of());
            this.persistenceServiceContainers.values().forEach(this::startEventHandling);
            this.started = true;
            this.readyService.markReady(this.marker);
            this.itemRegistry.addRegistryChangeListener((RegistryChangeListener)this);
        });
        scheduler.shutdown();
    }

    public void onReadyMarkerRemoved(ReadyMarker readyMarker) {
        this.readyService.unmarkReady(this.marker);
    }

    @Override
    public void added(PersistenceServiceConfiguration element) {
        PersistenceServiceContainer container = this.persistenceServiceContainers.get(element.getUID());
        if (container != null) {
            container.setConfiguration(element);
            if (this.started) {
                this.startEventHandling(container);
            }
        }
    }

    @Override
    public void removed(PersistenceServiceConfiguration element) {
        PersistenceServiceContainer container = this.persistenceServiceContainers.get(element.getUID());
        if (container != null) {
            container.setConfiguration(null);
            if (this.started) {
                this.startEventHandling(container);
            }
        }
    }

    @Override
    public void updated(PersistenceServiceConfiguration oldElement, PersistenceServiceConfiguration element) {
        this.added(element);
    }

    @Override
    public void handleExternalPersistenceDataChange(PersistenceService persistenceService, Item item) {
        this.persistenceServiceContainers.values().stream().filter(container -> container.persistenceService.equals(persistenceService) && container.getMatchingConfigurations(PersistenceStrategy.Globals.FORECAST).anyMatch(itemConf -> this.appliesToItem((PersistenceItemConfiguration)itemConf, item))).forEach(container -> container.scheduleNextPersistedForecastForItem(item.getName()));
    }

    private class PersistenceServiceContainer {
        private final PersistenceService persistenceService;
        private final Set<ScheduledCompletableFuture<?>> persistJobs = new HashSet();
        private final Map<String, ScheduledCompletableFuture<?>> forecastJobs = new ConcurrentHashMap();
        private final Map<PersistenceStrategy, Collection<PersistenceItemConfiguration>> strategyCache = new ConcurrentHashMap<PersistenceStrategy, Collection<PersistenceItemConfiguration>>();
        private PersistenceServiceConfiguration configuration;

        public PersistenceServiceContainer(@Nullable PersistenceService persistenceService, PersistenceServiceConfiguration configuration) {
            this.persistenceService = persistenceService;
            this.configuration = Objects.requireNonNullElseGet(configuration, this::getEmptyConfig);
        }

        public PersistenceService getPersistenceService() {
            return this.persistenceService;
        }

        public void setConfiguration(@Nullable PersistenceServiceConfiguration configuration) {
            this.cancelPersistJobs();
            this.cancelForecastJobs();
            this.configuration = Objects.requireNonNullElseGet(configuration, this::getEmptyConfig);
            this.strategyCache.clear();
        }

        public Stream<PersistenceItemConfiguration> getMatchingConfigurations(PersistenceStrategy strategy) {
            return Objects.requireNonNull(this.strategyCache.computeIfAbsent(strategy, s -> this.configuration.getConfigs().stream().filter(itemConfig -> itemConfig.strategies().contains(strategy)).toList())).stream();
        }

        public @Nullable String getAlias(Item item) {
            return this.configuration.getAliases().get(item.getName());
        }

        private PersistenceServiceConfiguration getEmptyConfig() {
            return new PersistenceServiceConfiguration(this.persistenceService.getId(), List.of(), Map.of(), List.of(), List.of());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelPersistJobs() {
            Set<ScheduledCompletableFuture<?>> set = this.persistJobs;
            synchronized (set) {
                this.persistJobs.forEach(job -> {
                    boolean bl = job.cancel(true);
                });
                this.persistJobs.clear();
            }
            PersistenceManagerImpl.this.logger.debug("Removed scheduled cron jobs for persistence service '{}'", (Object)this.configuration.getUID());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelForecastJobs() {
            Map<String, ScheduledCompletableFuture<?>> map = this.forecastJobs;
            synchronized (map) {
                this.forecastJobs.values().forEach(job -> {
                    boolean bl = job.cancel(true);
                });
                this.forecastJobs.clear();
            }
            PersistenceManagerImpl.this.logger.debug("Removed scheduled forecast jobs for persistence service '{}'", (Object)this.configuration.getUID());
        }

        public void schedulePersistJobs() {
            this.configuration.getStrategies().stream().filter(PersistenceCronStrategy.class::isInstance).forEach(strategy -> {
                PersistenceCronStrategy cronStrategy = (PersistenceCronStrategy)strategy;
                String cronExpression = cronStrategy.getCronExpression();
                List<PersistenceItemConfiguration> itemConfigs = this.getMatchingConfigurations((PersistenceStrategy)strategy).toList();
                this.persistJobs.add(PersistenceManagerImpl.this.cronScheduler.schedule(() -> this.persistJob(itemConfigs), cronExpression));
                PersistenceManagerImpl.this.logger.debug("Scheduled strategy {} with cron expression {} for service {}", new Object[]{cronStrategy.getName(), cronExpression, this.configuration.getUID()});
            });
        }

        public void restoreStatesAndScheduleForecastJobs() {
            PersistenceManagerImpl.this.itemRegistry.getItems().forEach(this::addItem);
        }

        public void addItem(Item item) {
            if (this.persistenceService instanceof QueryablePersistenceService) {
                if (UnDefType.NULL.equals((Object)item.getState()) && this.getMatchingConfigurations(PersistenceStrategy.Globals.RESTORE).anyMatch(configuration -> PersistenceManagerImpl.this.appliesToItem((PersistenceItemConfiguration)configuration, item)) || this.getMatchingConfigurations(PersistenceStrategy.Globals.FORECAST).anyMatch(configuration -> PersistenceManagerImpl.this.appliesToItem((PersistenceItemConfiguration)configuration, item))) {
                    this.restoreItemStateIfPossible(item);
                }
                if (this.getMatchingConfigurations(PersistenceStrategy.Globals.FORECAST).anyMatch(configuration -> PersistenceManagerImpl.this.appliesToItem((PersistenceItemConfiguration)configuration, item))) {
                    this.scheduleNextPersistedForecastForItem(item.getName());
                }
            }
        }

        public void removeItem(String itemName) {
            ScheduledCompletableFuture<?> job = this.forecastJobs.remove(itemName);
            if (job != null) {
                job.cancel(true);
            }
        }

        private void restoreItemStateIfPossible(Item item) {
            QueryablePersistenceService queryService = (QueryablePersistenceService)this.persistenceService;
            String alias = this.getAlias(item);
            PersistedItem persistedItem = ((QueryablePersistenceService)PersistenceManagerImpl.this.safeCaller.create((Object)queryService, QueryablePersistenceService.class).onTimeout(() -> PersistenceManagerImpl.this.logger.warn("Querying persistence service '{}' to restore '{}' takes more than {}ms.", new Object[]{queryService.getId(), item.getName(), SafeCaller.DEFAULT_TIMEOUT})).onException(e -> PersistenceManagerImpl.this.logger.error("Exception occurred while querying persistence service '{}' to restore '{}': {}", new Object[]{queryService.getId(), item.getName(), e.getMessage(), e})).build()).persistedItem(item.getName(), alias);
            if (persistedItem == null) {
                return;
            }
            GenericItem genericItem = (GenericItem)item;
            State state = item.getState();
            State lastState = null;
            ZonedDateTime lastStateUpdate = null;
            ZonedDateTime lastStateChange = null;
            if (UnDefType.NULL.equals((Object)state)) {
                state = persistedItem.getState();
                lastState = persistedItem.getLastState();
                lastStateUpdate = persistedItem.getTimestamp();
                lastStateChange = persistedItem.getLastStateChange();
            } else {
                if (item.getLastState() != null && item.getLastState() != UnDefType.NULL) {
                    return;
                }
                lastStateUpdate = item.getLastStateUpdate();
                if (state.equals(persistedItem.getState())) {
                    lastState = persistedItem.getLastState();
                    lastStateChange = persistedItem.getLastStateChange();
                } else {
                    lastState = persistedItem.getState();
                    lastStateChange = item.getLastStateChange();
                }
            }
            genericItem.removeStateChangeListener((StateChangeListener)PersistenceManagerImpl.this);
            genericItem.setState(state, lastState, lastStateUpdate, lastStateChange, PersistenceManagerImpl.PERSISTENCE_SOURCE);
            genericItem.addStateChangeListener((StateChangeListener)PersistenceManagerImpl.this);
            if (PersistenceManagerImpl.this.logger.isDebugEnabled()) {
                PersistenceManagerImpl.this.logger.debug("Restored item state from '{}' for item '{}' -> '{}'", new Object[]{DateTimeFormatter.ISO_ZONED_DATE_TIME.format(persistedItem.getTimestamp()), item.getName(), persistedItem.getState()});
            }
        }

        public void scheduleNextForecastForItem(String itemName, Instant time, State state) {
            ScheduledFuture oldJob = (ScheduledFuture)this.forecastJobs.remove(itemName);
            if (oldJob != null) {
                oldJob.cancel(true);
            }
            this.forecastJobs.put(itemName, PersistenceManagerImpl.this.scheduler.at(() -> this.restoreItemState(itemName, state), time));
            PersistenceManagerImpl.this.logger.trace("Scheduled forecasted value for {} at {}", (Object)itemName, (Object)time);
        }

        public void scheduleNextPersistedForecastForItem(String itemName) {
            Item item = (Item)PersistenceManagerImpl.this.itemRegistry.get((Object)itemName);
            if (item instanceof GenericItem) {
                String alias = this.getAlias(item);
                QueryablePersistenceService queryService = (QueryablePersistenceService)this.persistenceService;
                FilterCriteria filter = new FilterCriteria().setItemName(itemName).setBeginDate(ZonedDateTime.now()).setOrdering(FilterCriteria.Ordering.ASCENDING);
                for (HistoricItem next : ((QueryablePersistenceService)PersistenceManagerImpl.this.safeCaller.create((Object)queryService, QueryablePersistenceService.class).onTimeout(() -> PersistenceManagerImpl.this.logger.warn("Querying persistence service '{}' takes more than {}ms.", (Object)queryService.getId(), (Object)SafeCaller.DEFAULT_TIMEOUT)).onException(e -> PersistenceManagerImpl.this.logger.error("Exception occurred while querying persistence service '{}': {}", new Object[]{queryService.getId(), e.getMessage(), e})).build()).query(filter, alias)) {
                    Instant timestamp = next.getInstant();
                    if (!timestamp.isAfter(Instant.now())) continue;
                    this.scheduleNextForecastForItem(itemName, timestamp, next.getState());
                    break;
                }
            }
        }

        private void restoreItemState(String itemName, State state) {
            Item item = (Item)PersistenceManagerImpl.this.itemRegistry.get((Object)itemName);
            if (item != null) {
                ((GenericItem)item).setState(state, PersistenceManagerImpl.PERSISTENCE_SOURCE);
            }
            this.scheduleNextPersistedForecastForItem(itemName);
        }

        private void persistJob(List<PersistenceItemConfiguration> itemConfigs) {
            itemConfigs.forEach(itemConfig -> {
                for (Item item : PersistenceManagerImpl.this.getAllItems((PersistenceItemConfiguration)itemConfig)) {
                    if (!itemConfig.filters().stream().allMatch(filter -> filter.apply(item))) continue;
                    long startTime = System.nanoTime();
                    itemConfig.filters().forEach(filter -> filter.persisted(item));
                    this.persistenceService.store(item, this.getAlias(item));
                    PersistenceManagerImpl.this.logger.trace("Storing item '{}' with persistence service '{}' took {}ms", new Object[]{item.getName(), this.configuration.getUID(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime)});
                }
            });
        }
    }
}

