/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.common;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class WrappedScheduledExecutorService
extends ScheduledThreadPoolExecutor {
    final Logger logger = LoggerFactory.getLogger(WrappedScheduledExecutorService.class);
    private static final Duration DEFAULT_TIMEOUT = Duration.ofMillis(5000L);
    private final Set<TimedAbstractTask> runningTasks;

    public WrappedScheduledExecutorService(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
        this.runningTasks = ConcurrentHashMap.newKeySet(corePoolSize);
    }

    @Override
    protected void afterExecute(@Nullable Runnable r, @Nullable Throwable t) {
        Future f;
        super.afterExecute(r, t);
        Throwable actualThrowable = t;
        if (actualThrowable == null && r instanceof Future && (f = (Future)((Object)r)).isDone()) {
            try {
                f.get();
            }
            catch (CancellationException cancellationException) {
            }
            catch (ExecutionException ee) {
                actualThrowable = ee.getCause();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        if (actualThrowable != null) {
            this.logger.warn("Scheduled runnable ended with an exception: ", actualThrowable);
        }
    }

    @Override
    public ScheduledFuture<?> schedule(@Nullable Runnable runnable, long delay, @Nullable TimeUnit unit) {
        Runnable r = this.logger.isDebugEnabled() ? new TimedRunnable(runnable) : runnable;
        return super.schedule(r, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(@Nullable Runnable runnable, long initialDelay, long period, @Nullable TimeUnit unit) {
        Runnable r = this.logger.isDebugEnabled() ? new TimedRunnable(runnable) : runnable;
        return super.scheduleAtFixedRate(r, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(@Nullable Runnable runnable, long initialDelay, long delay, @Nullable TimeUnit unit) {
        Runnable r = this.logger.isDebugEnabled() ? new TimedRunnable(runnable) : runnable;
        return super.scheduleWithFixedDelay(r, initialDelay, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(@Nullable Callable<V> callable, long delay, @Nullable TimeUnit unit) {
        TimedCallable c = this.logger.isDebugEnabled() ? new TimedCallable(callable) : callable;
        return super.schedule(c, delay, unit);
    }

    @Override
    public void close() {
        this.runningTasks.forEach(t -> this.logger.debug("Scheduled task is still running during shutdown; it was created here: ", (Throwable)t.stackTraceHolder));
        this.runningTasks.clear();
        super.close();
    }

    private synchronized void logLongRunningTasks() {
        this.runningTasks.stream().filter(t -> Instant.now().isAfter(t.timeout)).forEach(t -> {
            this.logger.debug("Scheduled task is taking more than {}; it was created here: ", (Object)DEFAULT_TIMEOUT, (Object)t.stackTraceHolder);
            t.extendTimeout();
        });
    }

    private abstract class TimedAbstractTask {
        private final Exception stackTraceHolder = new Exception();
        private Instant timeout = Instant.MAX;

        protected TimedAbstractTask() {
            WrappedScheduledExecutorService.this.logLongRunningTasks();
        }

        protected void clockStart() {
            this.extendTimeout();
            WrappedScheduledExecutorService.this.logLongRunningTasks();
            WrappedScheduledExecutorService.this.runningTasks.add(this);
        }

        protected void clockStop() {
            if (Instant.now().isAfter(this.timeout)) {
                WrappedScheduledExecutorService.this.logger.debug("Scheduled task took more than {}; it was created here: ", (Object)DEFAULT_TIMEOUT, (Object)this.stackTraceHolder);
            }
            WrappedScheduledExecutorService.this.runningTasks.remove(this);
        }

        protected void extendTimeout() {
            this.timeout = Instant.now().plus(DEFAULT_TIMEOUT);
        }
    }

    private class TimedCallable<V>
    extends TimedAbstractTask
    implements Callable<V> {
        private final Callable<V> callable;

        protected TimedCallable(Callable<V> callable) {
            this.callable = Objects.requireNonNull(callable);
        }

        @Override
        public V call() throws Exception {
            try {
                this.clockStart();
                V v = this.callable.call();
                return v;
            }
            finally {
                this.clockStop();
            }
        }
    }

    private class TimedRunnable
    extends TimedAbstractTask
    implements Runnable {
        private final Runnable runnable;

        protected TimedRunnable(Runnable runnable) {
            this.runnable = Objects.requireNonNull(runnable);
        }

        @Override
        public void run() {
            try {
                this.clockStart();
                this.runnable.run();
            }
            finally {
                this.clockStop();
            }
        }
    }
}

