/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.record;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Locale;
import org.minidns.constants.DnssecConstants;
import org.minidns.record.Data;

public abstract class DelegatingDnssecRR
extends Data {
    public final int keyTag;
    public final DnssecConstants.SignatureAlgorithm algorithm;
    public final byte algorithmByte;
    public final DnssecConstants.DigestAlgorithm digestType;
    public final byte digestTypeByte;
    protected final byte[] digest;
    private transient BigInteger digestBigIntCache;
    private transient String digestHexCache;

    protected static SharedData parseSharedData(DataInputStream dis, int length) throws IOException {
        int keyTag = dis.readUnsignedShort();
        byte algorithm = dis.readByte();
        byte digestType = dis.readByte();
        byte[] digest = new byte[length - 4];
        if (dis.read(digest) != digest.length) {
            throw new IOException();
        }
        return new SharedData(keyTag, algorithm, digestType, digest);
    }

    protected DelegatingDnssecRR(int keyTag, DnssecConstants.SignatureAlgorithm algorithm, byte algorithmByte, DnssecConstants.DigestAlgorithm digestType, byte digestTypeByte, byte[] digest) {
        this.keyTag = keyTag;
        assert (algorithmByte == (algorithm != null ? algorithm.number : algorithmByte));
        this.algorithmByte = algorithmByte;
        DnssecConstants.SignatureAlgorithm signatureAlgorithm = this.algorithm = algorithm != null ? algorithm : DnssecConstants.SignatureAlgorithm.forByte(algorithmByte);
        assert (digestTypeByte == (digestType != null ? digestType.value : digestTypeByte));
        this.digestTypeByte = digestTypeByte;
        DnssecConstants.DigestAlgorithm digestAlgorithm = this.digestType = digestType != null ? digestType : DnssecConstants.DigestAlgorithm.forByte(digestTypeByte);
        assert (digest != null);
        this.digest = digest;
    }

    protected DelegatingDnssecRR(int keyTag, byte algorithm, byte digestType, byte[] digest) {
        this(keyTag, null, algorithm, null, digestType, digest);
    }

    protected DelegatingDnssecRR(int keyTag, DnssecConstants.SignatureAlgorithm algorithm, DnssecConstants.DigestAlgorithm digestType, byte[] digest) {
        this(keyTag, algorithm, algorithm.number, digestType, digestType.value, digest);
    }

    protected DelegatingDnssecRR(int keyTag, DnssecConstants.SignatureAlgorithm algorithm, byte digestType, byte[] digest) {
        this(keyTag, algorithm, algorithm.number, null, digestType, digest);
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        dos.writeShort(this.keyTag);
        dos.writeByte(this.algorithmByte);
        dos.writeByte(this.digestTypeByte);
        dos.write(this.digest);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.keyTag).append(' ').append((Object)this.algorithm).append(' ').append((Object)this.digestType).append(' ').append(new BigInteger(1, this.digest).toString(16).toUpperCase(Locale.ROOT));
        return sb.toString();
    }

    public BigInteger getDigestBigInteger() {
        if (this.digestBigIntCache == null) {
            this.digestBigIntCache = new BigInteger(1, this.digest);
        }
        return this.digestBigIntCache;
    }

    public String getDigestHex() {
        if (this.digestHexCache == null) {
            this.digestHexCache = this.getDigestBigInteger().toString(16).toUpperCase(Locale.ROOT);
        }
        return this.digestHexCache;
    }

    public boolean digestEquals(byte[] otherDigest) {
        return Arrays.equals(this.digest, otherDigest);
    }

    protected static final class SharedData {
        final int keyTag;
        final byte algorithm;
        final byte digestType;
        final byte[] digest;

        private SharedData(int keyTag, byte algorithm, byte digestType, byte[] digest) {
            this.keyTag = keyTag;
            this.algorithm = algorithm;
            this.digestType = digestType;
            this.digest = digest;
        }
    }
}

