/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gfm.strikethrough.internal;

import com.vladsch.flexmark.ext.gfm.strikethrough.Strikethrough;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughSubscriptExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.Subscript;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class StrikethroughNodeRenderer
implements NodeRenderer {
    private final String strikethroughStyleHtmlOpen;
    private final String strikethroughStyleHtmlClose;
    private final String subscriptStyleHtmlOpen;
    private final String subscriptStyleHtmlClose;

    public StrikethroughNodeRenderer(DataHolder options) {
        this.strikethroughStyleHtmlOpen = (String)StrikethroughSubscriptExtension.STRIKETHROUGH_STYLE_HTML_OPEN.get(options);
        this.strikethroughStyleHtmlClose = (String)StrikethroughSubscriptExtension.STRIKETHROUGH_STYLE_HTML_CLOSE.get(options);
        this.subscriptStyleHtmlOpen = (String)StrikethroughSubscriptExtension.SUBSCRIPT_STYLE_HTML_OPEN.get(options);
        this.subscriptStyleHtmlClose = (String)StrikethroughSubscriptExtension.SUBSCRIPT_STYLE_HTML_CLOSE.get(options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(Strikethrough.class, this::render));
        set.add(new NodeRenderingHandler(Subscript.class, this::render));
        return set;
    }

    private void render(Strikethrough node, NodeRendererContext context, HtmlWriter html) {
        if (this.strikethroughStyleHtmlOpen == null || this.strikethroughStyleHtmlClose == null) {
            if (context.getHtmlOptions().sourcePositionParagraphLines) {
                html.withAttr().tag((CharSequence)"del");
            } else {
                html.srcPos(node.getText()).withAttr().tag((CharSequence)"del");
            }
            context.renderChildren((Node)node);
            html.tag((CharSequence)"/del");
        } else {
            html.raw((CharSequence)this.strikethroughStyleHtmlOpen);
            context.renderChildren((Node)node);
            html.raw((CharSequence)this.strikethroughStyleHtmlClose);
        }
    }

    private void render(Subscript node, NodeRendererContext context, HtmlWriter html) {
        if (this.subscriptStyleHtmlOpen == null || this.subscriptStyleHtmlClose == null) {
            if (context.getHtmlOptions().sourcePositionParagraphLines) {
                html.withAttr().tag((CharSequence)"sub");
            } else {
                html.srcPos(node.getText()).withAttr().tag((CharSequence)"sub");
            }
            context.renderChildren((Node)node);
            html.tag((CharSequence)"/sub");
        } else {
            html.raw((CharSequence)this.subscriptStyleHtmlOpen);
            context.renderChildren((Node)node);
            html.raw((CharSequence)this.subscriptStyleHtmlClose);
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new StrikethroughNodeRenderer(options);
        }
    }
}

