/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.select;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsCteSubqueryModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.utils.Pair;

public class SQLQueryRowsCteModel
extends SQLQueryRowsSourceModel {
    @NotNull
    private final List<SQLQueryRowsCteSubqueryModel> subqueries;
    @NotNull
    private final SQLQueryRowsSourceModel resultQuery;

    public SQLQueryRowsCteModel(@NotNull STMTreeNode syntaxNode, @NotNull List<SQLQueryRowsCteSubqueryModel> subqueries, @NotNull SQLQueryRowsSourceModel resultQuery) {
        super(syntaxNode, resultQuery);
        this.resultQuery = resultQuery;
        this.subqueries = List.copyOf(subqueries);
        this.subqueries.forEach(sQLQueryNodeModel -> super.registerSubnode((SQLQueryNodeModel)sQLQueryNodeModel));
    }

    @NotNull
    public List<SQLQueryRowsSourceModel> getAllQueries() {
        ArrayList<SQLQueryRowsSourceModel> queries = new ArrayList<SQLQueryRowsSourceModel>(this.subqueries.size() + 1);
        queries.addAll(this.subqueries);
        queries.add(this.resultQuery);
        return queries;
    }

    @Override
    protected SQLQueryRowsSourceContext resolveRowSourcesImpl(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryRowsSourceContext cteContext = context.appendCteSources(this.subqueries.stream().map(q -> Pair.of((Object)q.subqueryName, (Object)q)).toList());
        this.subqueries.forEach(q -> {
            SQLQueryRowsSourceContext sQLQueryRowsSourceContext2 = q.resolveRowSources(cteContext, statistics);
        });
        this.resultQuery.resolveRowSources(cteContext, statistics);
        return context.reset();
    }

    @Override
    protected SQLQueryRowsDataContext resolveRowDataImpl(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        return this.resultQuery.getRowsDataContext();
    }

    @Override
    @Nullable
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitRowsCte(this, arg);
    }
}

