/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.maven;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.registry.maven.IMavenIdentifier;
import org.jkiss.utils.CommonUtils;

public class MavenArtifactReference
implements IMavenIdentifier {
    public static final String VERSION_PATTERN_RELEASE = "RELEASE";
    public static final String VERSION_PATTERN_LATEST = "LATEST";
    public static final String VERSION_PATTERN_SNAPSHOT = "SNAPSHOT";
    private static final String DEFAULT_MAVEN_VERSION = "RELEASE";
    @NotNull
    private final String groupId;
    @NotNull
    private final String artifactId;
    @Nullable
    private final String classifier;
    @NotNull
    private final String version;
    @NotNull
    private final String id;
    @Nullable
    private final String fallbackVersion;
    private boolean resolveOptionalDependencies;

    public MavenArtifactReference(@NotNull String groupId, @NotNull String artifactId, @Nullable String classifier, @Nullable String fallbackVersion, @NotNull String version) {
        this.groupId = CommonUtils.trim((String)groupId);
        this.artifactId = CommonUtils.trim((String)artifactId);
        this.classifier = CommonUtils.trim((String)classifier);
        this.version = CommonUtils.trim((String)version);
        this.fallbackVersion = CommonUtils.trim((String)fallbackVersion);
        this.id = MavenArtifactReference.makeId(this);
    }

    public MavenArtifactReference(String ref) {
        String mavenUri = ref;
        int divPos = mavenUri.indexOf(47);
        if (divPos >= 0) {
            mavenUri = mavenUri.substring(divPos + 1);
        }
        this.version = "RELEASE";
        String[] parts = mavenUri.split(":");
        if (parts.length == 1) {
            this.groupId = mavenUri;
            this.artifactId = mavenUri;
            this.classifier = null;
            this.fallbackVersion = null;
        } else {
            this.groupId = parts[0];
            this.artifactId = parts[1];
            if (parts.length == 2) {
                this.classifier = null;
                this.fallbackVersion = null;
            } else if (parts.length == 3) {
                this.classifier = null;
                this.fallbackVersion = parts[2];
            } else {
                this.classifier = parts[2];
                this.fallbackVersion = parts[3];
            }
        }
        this.id = MavenArtifactReference.makeId(this);
    }

    @Override
    @NotNull
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @NotNull
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    @Nullable
    public String getFallbackVersion() {
        return this.fallbackVersion;
    }

    @Override
    @NotNull
    public String getVersion() {
        return this.version;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    public String getPath() {
        return this.id;
    }

    public boolean isResolveOptionalDependencies() {
        return this.resolveOptionalDependencies;
    }

    public void setResolveOptionalDependencies(boolean resolveOptionalDependencies) {
        this.resolveOptionalDependencies = resolveOptionalDependencies;
    }

    public String toString() {
        return this.getPath();
    }

    public int hashCode() {
        return this.groupId.hashCode() + this.artifactId.hashCode() + this.version.hashCode();
    }

    static String makeId(IMavenIdentifier identifier) {
        StringBuilder id = new StringBuilder();
        id.append(identifier.getGroupId()).append(":").append(identifier.getArtifactId());
        if (identifier.getClassifier() != null) {
            id.append(":").append(identifier.getClassifier());
        }
        if (identifier.getFallbackVersion() != null) {
            id.append(":").append(identifier.getFallbackVersion() != null ? identifier.getFallbackVersion() : identifier.getVersion());
        }
        return id.toString();
    }
}

