/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.ResourceVariantCache;
import org.eclipse.team.internal.core.mapping.IStreamMergerDelegate;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public final class TeamPlugin
extends Plugin {
    public static final String ID = "org.eclipse.team.core";
    public static final String PROVIDER_EXTENSION = "repository-provider-type";
    public static final String FILE_TYPES_EXTENSION = "fileTypes";
    public static final String IGNORE_EXTENSION = "ignore";
    public static final String PROJECT_SET_EXTENSION = "projectSets";
    public static final String REPOSITORY_EXTENSION = "repository";
    public static final String DEFAULT_FILE_MODIFICATION_VALIDATOR_EXTENSION = "defaultFileModificationValidator";
    public static final QualifiedName PROVIDER_PROP_KEY = new QualifiedName("org.eclipse.team.core", "repository");
    public static final String EXTENSION_POINT_BUNDLE_IMPORTERS = "org.eclipse.team.core.bundleImporters";
    private static TeamPlugin plugin;
    private ServiceRegistration debugRegistration;
    private IStreamMergerDelegate mergerDelegate;

    public TeamPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        properties.put("listener.symbolic.name", ID);
        this.debugRegistration = context.registerService(DebugOptionsListener.class, (Object)Policy.DEBUG_OPTIONS_LISTENER, properties);
        Team.startup();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.debugRegistration.unregister();
            this.debugRegistration = null;
            Team.shutdown();
            ResourceVariantCache.shutdown();
        }
        finally {
            super.stop(context);
        }
    }

    public static TeamPlugin getPlugin() {
        return plugin;
    }

    public static void log(int severity, String message, Throwable e) {
        plugin.getLog().log((IStatus)new Status(severity, ID, 0, message, e));
    }

    public static void log(CoreException e) {
        TeamPlugin.log(e.getStatus().getSeverity(), e.getMessage(), e);
    }

    public static TeamException wrapException(CoreException e) {
        IStatus status = e.getStatus();
        return new TeamException((IStatus)new Status(status.getSeverity(), ID, status.getCode(), status.getMessage(), (Throwable)e));
    }

    public static String getCharset(String name, InputStream stream) throws IOException {
        IContentDescription description = TeamPlugin.getContentDescription(name, stream);
        return description == null ? null : description.getCharset();
    }

    public static IContentDescription getContentDescription(String name, InputStream stream) throws IOException {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        try {
            IContentDescription iContentDescription = contentTypeManager.getDescriptionFor(stream, name, IContentDescription.ALL);
            return iContentDescription;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static RepositoryProviderType getAliasType(String id) {
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(ID, REPOSITORY_EXTENSION);
        if (extension != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = ext.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    String extensionId;
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    String aliasId = configElement.getAttribute("canImportId");
                    if (aliasId != null && aliasId.equals(id) && (extensionId = configElement.getAttribute("id")) != null) {
                        return RepositoryProviderType.getProviderType(extensionId);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    public static IPath[] getMetaFilePaths(String id) {
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(ID, REPOSITORY_EXTENSION);
        if (extension != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = ext.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    String extensionId = configElement.getAttribute("id");
                    String metaFilePaths = configElement.getAttribute("metaFilePaths");
                    if (extensionId != null && extensionId.equals(id) && metaFilePaths != null) {
                        return TeamPlugin.getPaths(metaFilePaths);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    private static IPath[] getPaths(String metaFilePaths) {
        ArrayList<Path> result = new ArrayList<Path>();
        StringTokenizer t = new StringTokenizer(metaFilePaths, ",");
        while (t.hasMoreTokens()) {
            String next = t.nextToken();
            Path path = new Path(null, next);
            result.add(path);
        }
        return result.toArray(new IPath[result.size()]);
    }

    public void setMergerDelegate(IStreamMergerDelegate merger) {
        this.mergerDelegate = merger;
    }

    public IStreamMergerDelegate getMergerDelegate() {
        return this.mergerDelegate;
    }
}

