/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Cursor;
import com.healthmarketscience.jackcess.CursorBuilder;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.Table;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.asta.AbstractDatabaseReader;
import net.sf.mpxj.asta.AstaDatabaseException;
import net.sf.mpxj.asta.JackcessResultSetRow;
import net.sf.mpxj.asta.Row;

public final class AstaMdbReader
extends AbstractDatabaseReader {
    private File m_databaseFile;
    private Database m_database;

    @Override
    protected List<Row> getRows(String tableName, Map<String, Integer> keys) throws AstaDatabaseException {
        try {
            if (this.m_database == null) {
                this.m_database = DatabaseBuilder.open(this.m_databaseFile);
            }
            ArrayList<Row> result = new ArrayList<Row>();
            Table table = this.m_database.getTable(tableName);
            List<? extends Column> columns = table.getColumns();
            if (keys.isEmpty()) {
                for (com.healthmarketscience.jackcess.Row row : table) {
                    result.add(new JackcessResultSetRow(row, columns));
                }
            } else {
                Cursor cursor = CursorBuilder.createCursor(table);
                if (cursor.findFirstRow(keys)) {
                    result.add(new JackcessResultSetRow(cursor.getCurrentRow(), columns));
                    while (cursor.findNextRow(keys)) {
                        result.add(new JackcessResultSetRow(cursor.getCurrentRow(), columns));
                    }
                }
            }
            return result;
        }
        catch (IOException ex) {
            throw new AstaDatabaseException(ex);
        }
    }

    @Override
    protected void allocateResources(File file) {
        this.m_databaseFile = file;
    }

    @Override
    protected void releaseResources() {
        try {
            if (this.m_database != null) {
                this.m_database.close();
                this.m_database = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

